/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.graphics.Dimensions2D;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ListPlot
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (Config.USE_MANIPULATE_JS) {
            IExpr temp = S.Manipulate.of(engine, ast);
            if (temp.headID() == 696) {
                return temp;
            }
            return F.NIL;
        }
        if (ast.size() == 2 && ast.arg1().isList()) {
            try {
                double xMinD = Double.MAX_VALUE;
                double xMaxD = Double.MIN_VALUE;
                double yMinD = Double.MAX_VALUE;
                double yMaxD = Double.MIN_VALUE;
                IASTAppendable graphics = F.Graphics();
                Dimensions2D dim = new Dimensions2D();
                IASTAppendable points = F.NIL;
                if (ast.arg1().isVector() > 0) {
                    double[] allPoints = ast.arg1().toDoubleVector();
                    if (allPoints != null && allPoints.length > 0) {
                        xMaxD = 1.0;
                        xMaxD = allPoints.length;
                        points = F.ast((IExpr)S.List, allPoints.length);
                        for (int i = 0; i < allPoints.length; ++i) {
                            if (allPoints[i] > yMaxD) {
                                yMaxD = allPoints[i];
                            } else if (allPoints[i] < yMinD) {
                                yMinD = allPoints[i];
                            }
                            points.append(F.list(F.num(i), F.num(allPoints[i])));
                        }
                    }
                } else {
                    double[][] allPoints;
                    int[] matrixDim = ast.arg1().isMatrix();
                    if (matrixDim != null && matrixDim[1] == 2 && (allPoints = ast.arg1().toDoubleMatrix()) != null && allPoints.length > 0) {
                        xMaxD = allPoints.length;
                        points = F.ast((IExpr)S.List, allPoints.length);
                        for (int i = 0; i < allPoints.length; ++i) {
                            for (int j = 0; j < allPoints[i].length; ++j) {
                                if (allPoints[i][j] > xMaxD) {
                                    xMaxD = allPoints[i][0];
                                } else if (allPoints[i][j] < xMinD) {
                                    xMinD = allPoints[i][0];
                                }
                                if (allPoints[i][j] > yMaxD) {
                                    yMaxD = allPoints[i][1];
                                    continue;
                                }
                                if (!(allPoints[i][j] < yMinD)) continue;
                                yMinD = allPoints[i][1];
                            }
                            points.append(F.list(F.num(allPoints[i][0]), F.num(allPoints[i][1])));
                        }
                    }
                }
                if (points.isPresent()) {
                    graphics.append(F.Point(points));
                    IAST plotRange = dim.isValidRange() ? F.Rule((IExpr)S.PlotRange, (IExpr)F.list(F.List(dim.xMin, dim.xMax), F.List(dim.yMin, dim.yMax))) : F.Rule((IExpr)S.PlotRange, (IExpr)S.Automatic);
                    IExpr[] options = new IExpr[]{plotRange, F.Rule((IExpr)S.AxesStyle, (IExpr)S.Automatic), F.Rule((IExpr)S.AxesOrigin, (IExpr)F.List(F.C0, F.C0)), F.Rule((IExpr)S.Axes, (IExpr)S.True), F.Rule((IExpr)S.Background, (IExpr)S.White)};
                    graphics.appendAll(F.function(S.List, options), 1, options.length);
                    return F.Show(graphics);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("ListPlot.evaluate() failed", (Throwable)rex);
            }
        }
        return F.NIL;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

