/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.GraphicsFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ListLinePlot3D
extends AbstractEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IOFunctions.printExperimental(S.ListLinePlot3D);
        if (ast.argSize() > 0) {
            IASTAppendable result;
            int[] dimension;
            IAST plotStyle = F.NIL;
            if (ast.argSize() > 1) {
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                if (options.isInvalidPosition(1)) {
                    return options.printNonopt(ast, 1, engine);
                }
                IExpr temp = options.getOption(S.PlotStyle);
                if (temp.isAST()) {
                    plotStyle = (IAST)temp;
                }
            }
            if (ast.arg1().isASTSizeGE(S.List, 2)) {
                try {
                    double d = ((IAST)ast.arg1()).arg1().evalDouble();
                    IExpr heightLinePlot = this.heightLinePlot(F.list(ast.arg1()), plotStyle, engine);
                    if (heightLinePlot.isPresent()) {
                        IASTAppendable result2 = F.Graphics3D(heightLinePlot);
                        if (ast.argSize() > 1) {
                            result2.appendAll(ast, 2, ast.size());
                        }
                        return result2;
                    }
                    return F.NIL;
                }
                catch (ArgumentTypeException d) {
                    // empty catch block
                }
            }
            if ((dimension = ast.arg1().isMatrix(false)) != null && dimension.length == 2 && dimension[1] == 3) {
                result = F.Graphics3D(this.coordinateLinePlot(F.list(ast.arg1()), plotStyle, engine));
                if (ast.argSize() > 1) {
                    result.appendAll(ast, 2, ast.size());
                }
                return result;
            }
            if (ast.arg1().isASTSizeGE(S.List, 2) && ((IAST)ast.arg1()).arg1().isASTSizeGE(S.List, 2)) {
                try {
                    double d = ((IAST)((IAST)ast.arg1()).arg1()).arg1().evalDouble();
                    IExpr heightLinePlot = this.heightLinePlot((IAST)ast.arg1(), plotStyle, engine);
                    if (heightLinePlot.isPresent()) {
                        IASTAppendable result3 = F.Graphics3D(heightLinePlot);
                        if (ast.argSize() > 1) {
                            result3.appendAll(ast, 2, ast.size());
                        }
                        return result3;
                    }
                }
                catch (ArgumentTypeException d) {
                    // empty catch block
                }
            }
            if (ast.arg1().isASTSizeGE(S.List, 2) && (dimension = ((IAST)ast.arg1()).arg1().isMatrix(false)) != null && dimension.length == 2 && dimension[1] == 3) {
                result = F.Graphics3D(this.coordinateLinePlot((IAST)ast.arg1(), plotStyle, engine));
                if (ast.argSize() > 1) {
                    result.appendAll(ast, 2, ast.size());
                }
                return result;
            }
        }
        return IOFunctions.printMessage(ast.topHead(), "ldata", F.list(ast.arg1()), engine);
    }

    private IExpr heightLinePlot(IAST heights, IAST plotStyle, EvalEngine engine) {
        int valuesSize = heights.size();
        IASTAppendable resultList = F.NIL;
        IExpr flattenHeights = engine.evaluate(F.Flatten(heights));
        double deltaHeight = engine.evaluate(F.Max(flattenHeights).subtract(F.Min(flattenHeights))).evalDouble();
        if (F.isZero(deltaHeight)) {
            throw new ArgumentTypeException("zzdivzero", F.List("- delta height is 0"));
        }
        int lineColorNumber = 1;
        for (int i = 1; i < valuesSize; ++i) {
            if (!heights.get(i).isAST()) continue;
            IAST rowList = (IAST)heights.get(i);
            int rowListSize = rowList.size();
            IASTAppendable lineList = F.ListAlloc(rowListSize);
            for (int j = 1; j < rowListSize; ++j) {
                lineList.append(F.List(F.num((double)i * 2.5 / (double)valuesSize), F.num((double)j * 2.5 / (double)rowListSize), rowList.get(j).divide(deltaHeight)));
            }
            IAST color = GraphicsFunctions.plotStyleColorExpr(lineColorNumber++, plotStyle);
            if (!resultList.isPresent()) {
                resultList = F.ListAlloc(valuesSize);
            }
            resultList.append(color);
            resultList.append(F.Line(lineList));
        }
        return resultList;
    }

    private IExpr coordinateLinePlot(IAST coordinates, IAST plotStyle, EvalEngine engine) {
        double minZ;
        double minY;
        double minX;
        double maxX = minX = ((IAST)((IAST)coordinates.arg1()).arg1()).arg1().evalDouble();
        double maxY = minY = ((IAST)((IAST)coordinates.arg1()).arg1()).arg2().evalDouble();
        double maxZ = minZ = ((IAST)((IAST)coordinates.arg1()).arg1()).arg3().evalDouble();
        for (int i = 1; i <= coordinates.argSize(); ++i) {
            IAST line = (IAST)coordinates.get(i);
            for (int j = 1; j <= line.argSize(); ++j) {
                try {
                    double z;
                    double y;
                    IAST coordinate = (IAST)line.get(j);
                    double x = coordinate.arg1().evalDouble();
                    if (x < minX) {
                        minX = x;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if ((y = coordinate.arg2().evalDouble()) < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    if ((z = coordinate.arg3().evalDouble()) < minZ) {
                        minZ = z;
                    }
                    if (!(z > maxZ)) continue;
                    maxZ = z;
                    continue;
                }
                catch (ArgumentTypeException coordinate) {
                    // empty catch block
                }
            }
        }
        IASTMutable deltaXYZ = F.List((maxX - minX) / 2.5, (maxY - minY) / 2.5, maxZ - minZ);
        int lineColorNumber = 1;
        IASTAppendable lineList = F.ListAlloc(coordinates.size() * 2);
        for (int i = 1; i <= coordinates.argSize(); ++i) {
            IAST color = GraphicsFunctions.plotStyleColorExpr(lineColorNumber++, plotStyle);
            lineList.append(color);
            lineList.append(F.Line(S.Map.of(engine, F.Function(F.Divide(F.Slot1, deltaXYZ)), coordinates.get(i))));
        }
        return lineList;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

