/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.PointValuePair;
import org.hipparchus.optim.linear.LinearConstraint;
import org.hipparchus.optim.linear.LinearConstraintSet;
import org.hipparchus.optim.linear.LinearObjectiveFunction;
import org.hipparchus.optim.linear.NonNegativeConstraint;
import org.hipparchus.optim.linear.PivotSelectionRule;
import org.hipparchus.optim.linear.Relationship;
import org.hipparchus.optim.linear.SimplexSolver;
import org.hipparchus.optim.nonlinear.scalar.GoalType;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class LinearProgramming
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        return this.numericEval(ast, engine);
    }

    @Override
    public IExpr numericEval(IAST ast, EvalEngine engine) {
        try {
            double[] arg1D;
            if (ast.arg1().isList() && ast.arg2().isList() && ast.arg3().isList() && (arg1D = ast.arg1().toDoubleVector()) != null) {
                LinearObjectiveFunction f = new LinearObjectiveFunction(arg1D, 0.0);
                ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
                IAST arg2 = (IAST)ast.arg2();
                IAST arg3 = (IAST)ast.arg3();
                if (arg2.size() != arg3.size()) {
                    return F.NIL;
                }
                for (int i = 1; i < arg2.size(); ++i) {
                    if (arg2.get(i).isList()) {
                        double[] arg2D = arg2.get(i).toDoubleVector();
                        if (arg2D == null) {
                            return F.NIL;
                        }
                        if (arg3.get(i).isList()) {
                            double[] arg3D = arg3.get(i).toDoubleVector();
                            if (arg3D == null) {
                                return F.NIL;
                            }
                            if (arg3D.length >= 2) {
                                double val = arg3D[1];
                                if (val == 0.0) {
                                    constraints.add(new LinearConstraint(arg2D, Relationship.EQ, arg3D[0]));
                                    continue;
                                }
                                if (val < 0.0) {
                                    constraints.add(new LinearConstraint(arg2D, Relationship.LEQ, arg3D[0]));
                                    continue;
                                }
                                if (!(val > 0.0)) continue;
                                constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                                continue;
                            }
                            if (arg3D.length != 1) continue;
                            constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                            continue;
                        }
                        ISignedNumber sn = arg3.get(i).evalReal();
                        if (sn != null) {
                            constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, sn.doubleValue()));
                            continue;
                        }
                        LOGGER.log(engine.getLogLevel(), "Numeric vector or number expected!");
                        return F.NIL;
                    }
                    LOGGER.log(engine.getLogLevel(), "Numeric vector expected!");
                    return F.NIL;
                }
                SimplexSolver solver = new SimplexSolver();
                PointValuePair solution = solver.optimize(new OptimizationData[]{f, new LinearConstraintSet(constraints), GoalType.MINIMIZE, new NonNegativeConstraint(true), PivotSelectionRule.BLAND});
                double[] values = solution.getPointRef();
                return F.List(values);
            }
        }
        catch (MathIllegalArgumentException miae) {
            return IOFunctions.printMessage(ast.topHead(), "error", F.list(F.$str(miae.getMessage())), engine);
        }
        catch (MathRuntimeException mre) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }
}

