/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.rules.LaplaceTransformRules;

public class LaplaceTransform
extends AbstractFunctionEvaluator
implements LaplaceTransformRules {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr a1 = ast.arg1();
        IExpr t = ast.arg2();
        IExpr s = ast.arg3();
        if (!(t.isList() || s.isList() || t.equals(s))) {
            if (a1.isFree(t)) {
                return F.Divide(a1, s);
            }
            if (a1.equals(t) && a1.isFree(s)) {
                return F.Power(s, F.CN2);
            }
            if (ast.arg1().isAST()) {
                IAST arg1 = (IAST)ast.arg1();
                if (arg1.isTimes()) {
                    IASTAppendable result = F.TimesAlloc(arg1.size());
                    IASTAppendable rest = F.TimesAlloc(arg1.size());
                    arg1.filter(result, rest, x -> x.isFree(t));
                    if (result.size() > 1) {
                        return F.Times(result.oneIdentity1(), (IExpr)F.LaplaceTransform(rest, t, s));
                    }
                } else if (arg1.isPower() && arg1.base().equals(t)) {
                    IExpr n = arg1.exponent();
                    if (n.isAtom() && !n.isMinusOne()) {
                        return F.Divide(F.Gamma(F.Plus((IExpr)F.C1, n)), F.Power(s, F.Plus((IExpr)F.C1, n)));
                    }
                } else if (arg1.isPlus()) {
                    return arg1.mapThread(F.LaplaceTransform(F.Slot1, t, s), 1);
                }
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }

    @Override
    public IAST getRuleAST() {
        return RULES;
    }
}

