/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.rules.InverseLaplaceTransformRules;

public class InverseLaplaceTransform
extends AbstractFunctionEvaluator
implements InverseLaplaceTransformRules {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr a1 = ast.arg1();
        IExpr s = ast.arg2();
        IExpr t = ast.arg3();
        if (!(s.isList() || t.isList() || s.equals(t))) {
            if (a1.isFree(s)) {
                return F.Times(a1, (IExpr)F.DiracDelta(t));
            }
            if (ast.arg1().isAST()) {
                IExpr temp;
                IExpr[] parts;
                IAST arg1 = (IAST)ast.arg1();
                if (arg1.isTimes()) {
                    IASTAppendable result = F.TimesAlloc(arg1.size());
                    IASTAppendable rest = F.TimesAlloc(arg1.size());
                    arg1.filter(result, rest, x -> x.isFree(s));
                    if (result.size() > 1) {
                        return F.Times(result.oneIdentity1(), (IExpr)F.InverseLaplaceTransform(rest, s, t));
                    }
                }
                if ((arg1.isTimes() || arg1.isPower()) && (parts = Algebra.fractionalParts(arg1, false)) != null && (temp = Algebra.partsApart(parts, s, engine)).isPlus()) {
                    return ((IAST)temp).mapThread(F.InverseLaplaceTransform(F.Slot1, s, t), 1);
                }
                if (arg1.isPlus()) {
                    return arg1.mapThread(F.InverseLaplaceTransform(F.Slot1, s, t), 1);
                }
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }

    @Override
    public IAST getRuleAST() {
        return RULES;
    }
}

