/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Eliminate;

public class InverseFunction
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IAST composition;
        IExpr arg1 = ast.arg1();
        if (arg1.isFunction()) {
            IAST[] arr;
            IExpr xFunction = arg1.first();
            ISymbol dummy = F.Dummy();
            if (xFunction.isAST() && (arr = InverseFunction.eliminateSlotInverseFunction(xFunction, dummy, engine)) != null) {
                return F.Function(F.subst(arr[1].second(), F.Rule((IExpr)dummy, (IExpr)F.Slot1)));
            }
        } else if (arg1.isBuiltInSymbol()) {
            IExpr temp;
            if (arg1.equals(S.Abs)) {
                LOGGER.log(engine.getLogLevel(), "InverseFunction: using of inverse functions may omit some values.");
            }
            if ((temp = InverseFunction.getUnaryInverseFunction((ISymbol)arg1)) != null) {
                return temp;
            }
        } else if ((arg1.isASTSizeGE(S.Composition, 2) || arg1.isASTSizeGE(S.RightComposition, 2)) && (composition = (IAST)arg1).forAll(x -> x.isSymbol())) {
            IASTAppendable result = F.ast(composition.head(), composition.size());
            for (int i = composition.size() - 1; i >= 1; --i) {
                result.append(F.InverseFunction(composition.get(i)));
            }
            return result;
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    public static IExpr getUnaryInverseFunction(ISymbol headSymbol) {
        return F.getUnaryInverseFunction(headSymbol);
    }

    public static IASTAppendable getUnaryInverseFunction(IAST ast, boolean realAbs) {
        IExpr expr = ast.head();
        if (expr.isSymbol()) {
            IExpr inverseSymbol = F.getUnaryInverseFunction(expr);
            if (inverseSymbol != null) {
                return F.ast(inverseSymbol);
            }
            if (realAbs && ast.isAST(S.RealAbs, 2)) {
                return F.ast(F.Function(F.Times((IExpr)F.CN1, (IExpr)F.Slot1)));
            }
        }
        return F.NIL;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(24576);
    }

    public static IAST[] eliminateSlotInverseFunction(IExpr xFunction, ISymbol dummy, EvalEngine engine) {
        IAST equalAST = F.Equal(xFunction, (IExpr)dummy);
        ArrayList<Eliminate.VariableCounterVisitor> analyzerList = new ArrayList<Eliminate.VariableCounterVisitor>();
        Eliminate.VariableCounterVisitor exprAnalyzer = new Eliminate.VariableCounterVisitor(equalAST, F.Slot1);
        equalAST.accept(exprAnalyzer);
        analyzerList.add(exprAnalyzer);
        Collections.sort(analyzerList);
        IAST[] slotEliminated = Eliminate.eliminateOneVariable(analyzerList, (IExpr)F.Slot1, false, engine);
        if (slotEliminated != null && slotEliminated[1].isList()) {
            return null;
        }
        return slotEliminated;
    }
}

