/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.hipparchus.complex.Complex;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class InverseFourier
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr expr = ast.arg1();
        try {
            if (expr.isVector() >= 0) {
                int n = ((IAST)expr).argSize();
                if (n == 0 || 0 != (n & n - 1)) {
                    return IOFunctions.printMessage(S.InverseFourier, "vpow2", F.list(expr), engine);
                }
                IAST result = InverseFourier.fourier((IAST)expr, -1);
                if (result.isPresent()) {
                    return result;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return IOFunctions.printMessage(S.InverseFourier, "fftl", F.list(expr), engine);
    }

    private static IAST fourier(IAST vector, int b) {
        int n = vector.argSize();
        Complex[] array = Convert.list2Complex(vector);
        if (array == null) {
            return F.NIL;
        }
        int j = 0;
        for (int i = 0; i < n; ++i) {
            int m;
            if (j > i) {
                Complex val = array[i];
                array[i] = array[j];
                array[j] = val;
            }
            for (m = n >> 1; m > 0 && j >= m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 1;
        while (n > mmax) {
            int istep = mmax << 1;
            double thalf = (double)b * Math.PI / (double)istep;
            double wtemp = Math.sin(thalf);
            Complex wp = new Complex(-2.0 * wtemp * wtemp, Math.sin(thalf + thalf));
            Complex w = Complex.ONE;
            for (int m = 0; m < mmax; ++m) {
                for (int i = m; i < n; i += istep) {
                    j = i + mmax;
                    Complex temp = array[j].multiply(w);
                    array[j] = array[i].subtract(temp);
                    array[i] = array[i].add(temp);
                }
                w = w.add(w.multiply(wp));
            }
            mmax = istep;
        }
        return F.Divide(Convert.toVector(array), F.Sqrt(n));
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

