/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.InterpolatingFunctionExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class Interpolation
extends AbstractEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        int[] dims = ast.arg1().isMatrix();
        if (dims != null && dims[0] > 2 && dims[1] >= 2) {
            String method = "";
            OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
            IExpr option = options.getOption(S.Method);
            if (option.isPresent()) {
                method = option.toString();
            }
            if (!method.isEmpty()) {
                if ("Hermite".equals(method)) {
                    return this.hermiteInterpolate((IAST)ast.arg1(), dims, engine);
                }
                return IOFunctions.printMessage(ast.topHead(), "optx", F.list(S.Method, ast), engine);
            }
            if (ast.isAST1()) {
                int rowsSize;
                if (dims[1] >= 2 && (rowsSize = dims[0]) >= 4) {
                    return this.piecewisePolynomialInterpolate(ast, rowsSize, engine);
                }
                return F.NIL;
            }
        }
        return F.NIL;
    }

    public IExpr piecewisePolynomialInterpolate(IAST ast, int rowsSize, EvalEngine engine) {
        IAST function = ast;
        if (function.isAST1() && rowsSize >= 4) {
            IAST matrix = (IAST)function.arg1();
            IASTAppendable list1 = F.ListAlloc(rowsSize);
            IASTAppendable minMaxList = F.ListAlloc(rowsSize);
            for (int j = 1; j < matrix.size(); ++j) {
                IExpr arg1 = matrix.get(j).first();
                minMaxList.append(arg1);
            }
            double min = engine.evaluate(minMaxList.apply((IExpr)S.Min, 1)).evalDouble();
            double max = engine.evaluate(minMaxList.apply((IExpr)S.Max, 1)).evalDouble();
            if (rowsSize <= 5) {
                IAST interpolator = F.Function(F.InterpolatingPolynomial(matrix, F.Slot1));
                return InterpolatingFunctionExpr.newInstance(interpolator, min, max);
            }
            int i = 1;
            for (int j = i + 3; j <= rowsSize; ++j) {
                IAST compare = this.createComparator(matrix, i, j, rowsSize);
                IASTAppendable data = F.ListAlloc(4);
                for (int k = i; k <= j; ++k) {
                    data.append(matrix.get(k));
                }
                IAST list = F.list(F.InterpolatingPolynomial(data, F.Slot1), compare);
                list1.append(list);
                ++i;
            }
            IAST interpolator = F.Function(F.Piecewise(list1));
            return InterpolatingFunctionExpr.newInstance(interpolator, min, max);
        }
        return F.NIL;
    }

    private IAST createComparator(IAST matrix, int i, int j, int size) {
        if (i == 1) {
            return F.Less((IExpr)F.Slot1, matrix.getPart(i + 2, 1));
        }
        if (j < size) {
            return F.And((IExpr)F.LessEqual(matrix.getPart(i + 1, 1), F.Slot1), (IExpr)F.Less((IExpr)F.Slot1, matrix.getPart(i + 2, 1)));
        }
        return F.GreaterEqual((IExpr)F.Slot1, matrix.getPart(i + 1, 1));
    }

    private InterpolatingFunctionExpr hermiteInterpolate(IAST matrixAST, int[] dims, EvalEngine engine) {
        int colDim = dims[1];
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        IASTAppendable minMaxList = F.ListAlloc(matrixAST.size());
        for (int i = 1; i < matrixAST.size(); ++i) {
            IAST row = (IAST)matrixAST.get(i);
            IExpr[] arr = new IExpr[colDim - 1];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = row.get(j + 2);
            }
            IExpr arg1 = row.first();
            minMaxList.append(arg1);
            interpolator.addSamplePoint((FieldElement)arg1, (FieldElement[][])new IExpr[][]{arr});
        }
        double min = engine.evaluate(minMaxList.apply((IExpr)S.Min, 1)).evalDouble();
        double max = engine.evaluate(minMaxList.apply((IExpr)S.Max, 1)).evalDouble();
        return InterpolatingFunctionExpr.newInstance((FieldHermiteInterpolator<IExpr>)interpolator, min, max);
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_5;
    }
}

