/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.MathArrays;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class InterpolatingPolynomial
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean checkPartialRealOrder(IExpr[] val, MathArrays.OrderDirection dir, boolean strict, boolean abort) throws MathIllegalArgumentException {
        int index;
        int max;
        ISignedNumber previous = F.C0;
        int start = max = val.length;
        for (int i = 0; i < val.length; ++i) {
            if (!(val[i] instanceof ISignedNumber)) continue;
            previous = (ISignedNumber)val[i];
            start = i + 1;
            break;
        }
        block5: for (index = start; index < max; ++index) {
            if (!(val[index] instanceof ISignedNumber)) continue;
            switch (dir) {
                case INCREASING: {
                    if (!(strict ? ((ISignedNumber)val[index]).isLE(previous) : ((ISignedNumber)val[index]).isLT(previous))) break;
                    break block5;
                }
                case DECREASING: {
                    if (!(strict ? ((ISignedNumber)val[index]).isGE(previous) : ((ISignedNumber)val[index]).isGT(previous))) break;
                    break block5;
                }
                default: {
                    throw MathRuntimeException.createInternalError();
                }
            }
            previous = (ISignedNumber)val[index];
        }
        if (index == max) {
            return true;
        }
        if (abort) {
            throw new MathIllegalArgumentException((Localizable)(dir == MathArrays.OrderDirection.INCREASING ? (strict ? LocalizedCoreFormats.NOT_STRICTLY_INCREASING_SEQUENCE : LocalizedCoreFormats.NOT_INCREASING_SEQUENCE) : (strict ? LocalizedCoreFormats.NOT_STRICTLY_DECREASING_SEQUENCE : LocalizedCoreFormats.NOT_DECREASING_SEQUENCE)), new Object[]{val[index], previous, index, index - 1});
        }
        return false;
    }

    public static boolean verifyInterpolationArray(IExpr[] x, IExpr[] y, boolean abort) throws MathIllegalArgumentException {
        if (x.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.WRONG_NUMBER_OF_POINTS, new Object[]{2, x.length, true});
        }
        return InterpolatingPolynomial.checkPartialRealOrder(x, MathArrays.OrderDirection.INCREASING, true, abort);
    }

    protected static IExpr[] computeDividedDifference(IExpr[] x, IExpr[] y, EvalEngine engine) {
        InterpolatingPolynomial.verifyInterpolationArray(x, y, true);
        IExpr[] divdiff = (IExpr[])y.clone();
        int n = x.length;
        IExpr[] a = new IExpr[n];
        a[0] = divdiff[0];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                IExpr denominator = engine.evaluate(F.Subtract(x[j + i], x[j]));
                divdiff[j] = engine.evaluate(F.Divide(F.Subtract(divdiff[j + 1], divdiff[j]), denominator));
            }
            a[i] = divdiff[0];
        }
        return a;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.arg1().isList()) {
            IAST list = (IAST)ast.arg1();
            IExpr z = ast.arg2();
            int size = list.size();
            if (size > 1) {
                int i;
                int n = size - 1;
                IExpr[] xv = new IExpr[n];
                IExpr[] yv = new IExpr[n];
                int[] dim = list.isMatrix();
                if (dim != null && dim[1] == 2) {
                    if (dim[1] != 2) {
                        return F.NIL;
                    }
                    for (i = 0; i < n; ++i) {
                        IAST row = list.getAST(i + 1);
                        xv[i] = row.arg1();
                        yv[i] = row.arg2();
                    }
                } else {
                    for (i = 0; i < n; ++i) {
                        xv[i] = F.ZZ(i + 1);
                        yv[i] = list.get(i + 1);
                    }
                }
                try {
                    IExpr[] c = new IExpr[n - 1];
                    System.arraycopy(xv, 0, c, 0, c.length);
                    IExpr[] a = InterpolatingPolynomial.computeDividedDifference(xv, yv, engine);
                    IASTAppendable polynomial = F.PlusAlloc(16);
                    n = c.length;
                    IExpr value = a[n];
                    for (int i2 = n - 1; i2 >= 0; --i2) {
                        value = F.Plus(a[i2], (IExpr)F.Times((IExpr)F.Subtract(z, c[i2]), value));
                    }
                    return value;
                }
                catch (MathRuntimeException mrex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mrex);
                }
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_2;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

