/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.exception.FailedException;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.integrate.rubi.UtilityFunctionCtors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.RulesData;

public class Integrate
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Thread INIT_THREAD = null;
    private static final CountDownLatch COUNT_DOWN_LATCH = new CountDownLatch(1);
    public static RulesData INTEGRATE_RULES_DATA;
    public static final Integrate CONST;
    public static final Set<ISymbol> INT_RUBI_FUNCTIONS;
    public static final Set<IExpr> DEBUG_EXPR;
    public static final AtomicBoolean INTEGRATE_RULES_READ;

    @Override
    public final void await() throws InterruptedException {
        COUNT_DOWN_LATCH.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST holdallAST, EvalEngine engine) {
        if (Config.JAS_NO_THREADS) {
            new IntegrateInitializer().run();
        }
        try {
            this.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        IAssumptions oldAssumptions = engine.getAssumptions();
        boolean numericMode = engine.isNumericMode();
        try {
            IAssumptions assumptions;
            IExpr assumptionExpr;
            OptionArgs options = null;
            if (holdallAST.size() > 3 && !(options = new OptionArgs(S.Integrate, holdallAST, holdallAST.size() - 1, engine)).isInvalidPosition()) {
                holdallAST = holdallAST.most();
            }
            if ((assumptionExpr = OptionArgs.determineAssumptions(holdallAST, -1, options)).isPresent() && assumptionExpr.isAST() && (assumptions = Assumptions.getInstance(assumptionExpr)) != null) {
                engine.setAssumptions(assumptions);
            }
            boolean evaled = false;
            engine.setNumericMode(false);
            if (holdallAST.size() < 3 || holdallAST.isEvalFlagOn(262144)) {
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            IExpr arg1Holdall = holdallAST.arg1();
            IExpr a1 = NumberTheory.rationalize(arg1Holdall, false).orElse(arg1Holdall);
            IExpr arg1 = engine.evaluateNIL(a1);
            if (arg1.isPresent()) {
                evaled = true;
            } else {
                arg1 = a1;
            }
            if (arg1.isIndeterminate()) {
                IBuiltInSymbol iBuiltInSymbol = S.Indeterminate;
                return iBuiltInSymbol;
            }
            if (holdallAST.size() > 3) {
                IExpr iExpr = holdallAST.foldRight((x, y) -> engine.evaluateNIL(F.Integrate(x, y)), arg1, 2);
                return iExpr;
            }
            IExpr arg2 = engine.evaluateNIL(holdallAST.arg2());
            if (arg2.isPresent()) {
                evaled = true;
            } else {
                arg2 = holdallAST.arg2();
            }
            if (arg2.isList()) {
                IASTMutable copy;
                IExpr temp;
                IAST xList = (IAST)arg2;
                if (xList.isVector() == 3 && (temp = engine.evaluate(copy = holdallAST.setAtCopy(2, xList.arg1()))).isFreeAST(S.Integrate)) {
                    IExpr iExpr = Integrate.definiteIntegral(temp, xList, engine);
                    return iExpr;
                }
                copy = F.NIL;
                return copy;
            }
            if (arg1.isList() && arg2.isSymbol()) {
                IExpr xList = Integrate.mapIntegrate((IAST)arg1, arg2);
                return xList;
            }
            IASTAppendable ast = holdallAST.setAtClone(1, arg1);
            ast.set(2, arg2);
            IExpr x2 = ast.arg2();
            if (!x2.isVariable()) {
                IAST temp = IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
                return temp;
            }
            if (arg1.isNumber()) {
                IASTMutable temp = F.Times(arg1, x2);
                return temp;
            }
            if (arg1 instanceof ASTSeriesData) {
                IASTMutable temp;
                ASTSeriesData series = (ASTSeriesData)arg1;
                if (series.getX().equals(x2) && (temp = ((ASTSeriesData)arg1).integrate(x2)) != null) {
                    IASTMutable iASTMutable = temp;
                    return iASTMutable;
                }
                temp = F.NIL;
                return temp;
            }
            if (arg1.isFree(x2, true)) {
                IASTMutable series = F.Times(arg1, x2);
                return series;
            }
            if (arg1.equals(x2)) {
                IASTMutable series = F.Times((IExpr)F.C1D2, (IExpr)F.Power(arg1, F.C2));
                return series;
            }
            boolean showSteps = false;
            if (showSteps) {
                LOGGER.info((Object)arg1);
                if (DEBUG_EXPR.contains(arg1)) {
                    // empty if block
                }
                DEBUG_EXPR.add(arg1);
            }
            if (arg1.isAST()) {
                IAST[] temp;
                IExpr free;
                IAST fx = (IAST)arg1;
                if (fx.topHead().equals(x2)) {
                    IAssociation iAssociation = F.NIL;
                    return iAssociation;
                }
                int[] dim = fx.isPiecewise();
                if (dim != null) {
                    IExpr iExpr = Integrate.integratePiecewise(dim, fx, ast);
                    return iExpr;
                }
                IExpr result = Integrate.integrateAbs(fx, x2);
                if (result.isPresent()) {
                    if (result == S.Undefined) {
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                    IExpr iExpr = result;
                    return iExpr;
                }
                result = Integrate.integrateByRubiRules(fx, x2, ast, engine);
                if (result.isPresent()) {
                    IExpr temp2 = result.replaceAll(f -> {
                        if (f.isAST(UtilityFunctionCtors.Unintegrable, 3)) {
                            IAST integrate = F.Integrate(f.first(), f.second());
                            integrate.addEvalFlags(262144);
                            return integrate;
                        }
                        if (f.isAST(F.$rubi("CannotIntegrate"), 3)) {
                            IAST integrate = F.Integrate(f.first(), f.second());
                            integrate.addEvalFlags(262144);
                            return integrate;
                        }
                        return F.NIL;
                    });
                    IExpr iExpr = temp2.orElse(result);
                    return iExpr;
                }
                if (fx.isTimes() && !(free = (temp = fx.filter(arg -> arg.isFree(x2)))[0].oneIdentity1()).isOne()) {
                    IExpr rest = temp[1].oneIdentity1();
                    IASTMutable iASTMutable = F.Times(free, (IExpr)F.Integrate(rest, x2));
                    return iASTMutable;
                }
                if (fx.isPower()) {
                    IExpr base = fx.base();
                    IExpr exponent = fx.exponent();
                    if (base.equals(x2) && exponent.isFree(x2)) {
                        if (exponent.isMinusOne()) {
                            IAST rest = F.Log(x2);
                            return rest;
                        }
                        IAST temp3 = F.Plus((IExpr)F.C1, exponent);
                        IAST iAST = F.Divide(F.Power(x2, temp3), temp3);
                        return iAST;
                    }
                    if (exponent.equals(x2) && base.isFree(x2)) {
                        if (base.isE()) {
                            IAST iAST = fx;
                            return iAST;
                        }
                        IAST iAST = F.Divide(fx, F.Log(base));
                        return iAST;
                    }
                }
                if ((result = Integrate.callRestIntegrate(fx, x2, engine)).isPresent()) {
                    IExpr iExpr = result;
                    return iExpr;
                }
            }
            IASTAppendable iASTAppendable = evaled ? ast : F.NIL;
            return iASTAppendable;
        }
        finally {
            engine.setAssumptions(oldAssumptions);
            engine.setNumericMode(numericMode);
        }
    }

    private static IExpr integratePiecewise(int[] dim, IAST piecewiseFunction, IAST integrateFunction) {
        IAST list = (IAST)piecewiseFunction.arg1();
        if (list.size() > 1) {
            IASTMutable integrate;
            IASTAppendable pwResult = F.ListAlloc(list.size());
            for (int i = 1; i < list.size(); ++i) {
                integrate = integrateFunction.copy();
                integrate.set(1, list.get(i).first());
                pwResult.append(F.list(integrate, list.get(i).second()));
            }
            IASTMutable piecewise = piecewiseFunction.copy();
            piecewise.set(1, pwResult);
            if (piecewiseFunction.size() > 2) {
                integrate = integrateFunction.copy();
                integrate.set(1, piecewiseFunction.arg2());
                piecewise.set(2, integrate);
            }
            return piecewise;
        }
        return F.NIL;
    }

    private static IExpr integrateAbs(IExpr function, IExpr x) {
        IExpr constant = F.C0;
        if (function.isAST1() && function.first().equals(x)) {
            IAST f1 = (IAST)function;
            IExpr head = f1.head();
            if (head.equals(S.RealAbs)) {
                return F.Times((IExpr)F.C1D2, x, (IExpr)F.RealAbs(x));
            }
            if (head.equals(S.RealSign)) {
                return F.RealAbs(x);
            }
        }
        if (x.isRealResult()) {
            IAST power;
            IAST abs;
            IExpr[] lin;
            if (function.isAbs()) {
                IAST abs2 = (IAST)function;
                IExpr[] lin2 = abs2.arg1().linearPower(x);
                if (lin2 != null && !lin2[1].isZero() && lin2[0].isRealResult() && lin2[1].isRealResult() && lin2[2].isInteger()) {
                    IExpr l0 = lin2[0];
                    IExpr l1 = lin2[1];
                    IInteger exp = (IInteger)lin2[2];
                    constant = F.Divide(F.Negate(l0), l1);
                    if (exp.isOne()) {
                        return F.Piecewise(F.list(F.list(F.Plus((IExpr)F.Times((IExpr)F.CN1, l0, (IExpr)S.x), (IExpr)F.Times((IExpr)F.CN1D2, l1, (IExpr)F.Sqr(S.x))), F.LessEqual((IExpr)S.x, constant))), F.Plus((IExpr)F.Times((IExpr)F.Sqr(l0), (IExpr)F.Power((IExpr)S.Pi, F.CN1)), (IExpr)F.Times(l0, (IExpr)S.x), (IExpr)F.Times((IExpr)F.C1D2, l1, (IExpr)F.Sqr(S.x))));
                    }
                    if (exp.isMinusOne()) {
                        if (!l0.isZero()) {
                            return F.Piecewise(F.list(F.list(F.Plus((IExpr)F.Times(l0, (IExpr)S.x), (IExpr)F.Times(l1, (IExpr)F.Log(S.x))), F.LessEqual((IExpr)S.x, F.Times((IExpr)F.CN1, (IExpr)F.Power(l0, F.CN1), l1))), F.list(F.Plus((IExpr)F.Times((IExpr)F.CN1, l0, (IExpr)S.x), (IExpr)F.Times((IExpr)F.C2, l1, (IExpr)F.Plus((IExpr)F.CN2, (IExpr)F.Times((IExpr)F.CI, l1), (IExpr)F.Log(l1))), (IExpr)F.Times((IExpr)F.CN1, l1, (IExpr)F.Log(S.x))), F.And((IExpr)F.Less((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(l0, F.CN1), l1), S.x), (IExpr)F.LessEqual((IExpr)S.x, F.C0)))), F.Plus((IExpr)F.Times(l0, (IExpr)S.x), (IExpr)F.Times(l1, (IExpr)F.Log(S.x))));
                        }
                    } else if (exp.isPositive()) {
                        IInteger expP1 = exp.inc();
                        if (exp.isEven()) {
                            return F.Plus((IExpr)F.Times(l0, (IExpr)S.x), (IExpr)F.Times((IExpr)expP1.inverse(), l1, (IExpr)F.Power((IExpr)S.x, expP1)));
                        }
                    } else if (exp.isNegative()) {
                        IInteger expP1 = exp.inc();
                        if (exp.isEven()) {
                            return F.Plus((IExpr)F.Times(l0, (IExpr)S.x), (IExpr)F.Times(F.CN1, F.Power((IExpr)expP1, F.CN1), l1, F.Power((IExpr)S.x, F.Negate(expP1))));
                        }
                    }
                }
            } else if (function.isPower() && function.base().isAbs() && function.exponent().isInteger() && (lin = (abs = (IAST)(power = (IAST)function).base()).arg1().linear(x)) != null && !lin[1].isZero() && lin[0].isRealResult() && lin[1].isRealResult()) {
                IExpr l0 = lin[0];
                IExpr l1 = lin[1];
                constant = F.Divide(F.Negate(l0), l1);
                IInteger exp = (IInteger)power.exponent();
                IInteger expP1 = exp.inc();
                if (exp.isNegative()) {
                    if (exp.isMinusOne()) {
                        return F.Piecewise(F.list(F.list(F.Negate(F.Log(x)), F.LessEqual(x, constant))), F.Log(x));
                    }
                    if (exp.isEven()) {
                        return F.Times((IExpr)expP1.inverse().negate(), (IExpr)F.Power(x, expP1));
                    }
                    return F.Piecewise(F.list(F.list(F.Times((IExpr)expP1.inverse().negate(), (IExpr)F.Power(x, expP1)), F.LessEqual(x, constant))), F.Times((IExpr)expP1.inverse(), (IExpr)F.Power(x, expP1)));
                }
                if (exp.isEven()) {
                    return F.Divide(F.Power(x, expP1), expP1);
                }
                return F.Piecewise(F.list(F.list(F.Divide(F.Power(x, expP1), expP1.negate()), F.LessEqual(x, constant))), F.Divide(F.Power(x, expP1), expP1));
            }
        }
        if (function.isAbs() || function.isPower() && function.base().isAbs()) {
            return S.Undefined;
        }
        return F.NIL;
    }

    private static IExpr definiteIntegral(IExpr function, IAST xValueList, EvalEngine engine) {
        IExpr aDenominator;
        IExpr bDenominator;
        IAST upperDirection;
        IAST lowerDirection;
        IExpr x = xValueList.arg1();
        IExpr lower = xValueList.arg2();
        IExpr upper = xValueList.arg3();
        IExpr diff = engine.evaluate(F.Subtract(upper, lower));
        if (S.PossibleZeroQ.ofQ(engine, diff)) {
            return F.C0;
        }
        if (diff.isNegativeResult()) {
            lowerDirection = F.Rule((IExpr)F.Direction, (IExpr)F.C1);
            upperDirection = F.Rule((IExpr)F.Direction, (IExpr)F.CN1);
        } else {
            lowerDirection = F.Rule((IExpr)F.Direction, (IExpr)F.CN1);
            upperDirection = F.Rule((IExpr)F.Direction, (IExpr)F.C1);
        }
        IExpr lowerLimit = F.Limit.of(engine, function, F.Rule(x, lower), lowerDirection);
        if (!lowerLimit.isFree(S.DirectedInfinity, true) || !lowerLimit.isFree(S.Indeterminate, true)) {
            LOGGER.log(engine.getLogLevel(), "Not integrable: {} for limit {} -> {}", (Object)function, (Object)x, (Object)lower);
            return F.NIL;
        }
        IExpr upperLimit = F.Limit.of(engine, function, F.Rule(x, upper), upperDirection);
        if (!upperLimit.isFree(S.DirectedInfinity, true) || !upperLimit.isFree(S.Indeterminate, true)) {
            LOGGER.log(engine.getLogLevel(), "Not integrable: {} for limit {} -> {}", (Object)function, (Object)x, (Object)upper);
            return F.NIL;
        }
        if (upperLimit.isAST() && lowerLimit.isAST() && (bDenominator = S.Denominator.of(engine, upperLimit)).equals(aDenominator = S.Denominator.of(engine, lowerLimit))) {
            return F.Divide(F.Subtract(F.Numerator(upperLimit), F.Numerator(lowerLimit)), bDenominator);
        }
        return F.Subtract(upperLimit, lowerLimit);
    }

    private static IExpr callRestIntegrate(IAST arg1, final IExpr x, EvalEngine engine) {
        IExpr fxExpanded = F.expand(arg1, false, false, false);
        if (fxExpanded.isAST()) {
            IExpr temp;
            IExpr[] parts;
            if (fxExpanded.isPlus()) {
                return Integrate.mapIntegrate((IAST)fxExpanded, x);
            }
            IAST arg1AST = (IAST)fxExpanded;
            if (arg1AST.isTimes()) {
                IASTAppendable filterCollector = F.TimesAlloc(arg1AST.size());
                IASTAppendable restCollector = F.TimesAlloc(arg1AST.size());
                arg1AST.filter(filterCollector, restCollector, (Predicate<? super IExpr>)new Predicate<IExpr>(){

                    @Override
                    public boolean test(IExpr input) {
                        return input.isFree(x, true);
                    }
                });
                if (filterCollector.size() > 1) {
                    if (restCollector.size() > 1) {
                        filterCollector.append(F.Integrate(restCollector.oneIdentity0(), x));
                    }
                    return filterCollector;
                }
            }
            if (arg1AST.size() >= 3 && arg1AST.isFree(S.Integrate) && arg1AST.isPlusTimesPower() && !arg1AST.isEvalFlagOn(128) && x.isSymbol() && (parts = Algebra.fractionalParts(arg1, true)) != null && (temp = Algebra.partsApart(parts, x, engine)).isPresent() && !temp.equals(arg1) && temp.isPlus()) {
                return Integrate.mapIntegrate((IAST)temp, x);
            }
        }
        if (arg1.isTrigFunction() || arg1.isHyperbolicFunction()) {
            IExpr temp = engine.evaluate(F.TrigToExp(arg1));
            return engine.evaluate(F.Integrate(temp, x));
        }
        return F.NIL;
    }

    private static IExpr mapIntegrate(IAST ast, IExpr x) {
        return ast.mapThread(F.Integrate(F.Slot1, x), 1);
    }

    private static IExpr integratePolynomialByParts(IAST ast, IAST arg1, IExpr symbol, EvalEngine engine) {
        IASTAppendable fTimes = F.TimesAlloc(arg1.size());
        IASTAppendable gTimes = F.TimesAlloc(arg1.size());
        Integrate.collectPolynomialTerms(arg1, symbol, gTimes, fTimes);
        IExpr g = gTimes.oneIdentity1();
        IExpr f = fTimes.oneIdentity1();
        if (f.isOne() || g.isOne()) {
            return F.NIL;
        }
        return Integrate.integrateByParts(f, g, symbol, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr integrateByRubiRules(IAST arg1, IExpr x, IAST ast, EvalEngine engine) {
        block25: {
            if (arg1.isFreeAST(s -> s.isSymbol() && ((ISymbol)s).isContext(Context.RUBI))) {
                int limit = engine.getRecursionLimit();
                boolean quietMode = engine.isQuietMode();
                ISymbol head = arg1.topHead();
                if (head.isNumericFunctionAttribute() || INT_RUBI_FUNCTIONS.contains(head) || head.getSymbolName().startsWith("\u00a7")) {
                    boolean newCache = false;
                    try {
                        IExpr temp;
                        block26: {
                            if (engine.rubiASTCache != null) {
                                IExpr result = (IExpr)engine.rubiASTCache.getIfPresent((Object)ast);
                                if (result != null) {
                                    if (result.isPresent()) {
                                        IExpr iExpr = result;
                                        return iExpr;
                                    }
                                    IExpr iExpr = Integrate.callRestIntegrate(arg1, x, engine);
                                    return iExpr;
                                }
                            } else {
                                newCache = true;
                                engine.rubiASTCache = CacheBuilder.newBuilder().maximumSize(50L).build();
                            }
                            try {
                                engine.setQuietMode(true);
                                if (limit <= 0 || limit > Config.INTEGRATE_RUBI_RULES_RECURSION_LIMIT) {
                                    engine.setRecursionLimit(Config.INTEGRATE_RUBI_RULES_RECURSION_LIMIT);
                                }
                                engine.rubiASTCache.put((Object)ast, (Object)F.NIL);
                                temp = S.Integrate.evalDownRule(EvalEngine.get(), ast);
                                if (!temp.isPresent()) break block25;
                                if (!temp.equals(ast)) break block26;
                                if (LOGGER.isDebugEnabled()) {
                                    engine.setQuietMode(false);
                                    IOFunctions.printMessage(S.Integrate, "rubiendless", F.list(temp), engine);
                                }
                                IAssociation iAssociation = F.NIL;
                                return iAssociation;
                            }
                            catch (RecursionLimitExceeded rle) {
                                engine.setRecursionLimit(limit);
                                LOGGER.log(engine.getLogLevel(), "Integrate(Rubi recursion)", (Throwable)((Object)rle));
                                IAssociation iAssociation = F.NIL;
                                return iAssociation;
                            }
                            catch (RuntimeException rex) {
                                engine.setRecursionLimit(limit);
                                LOGGER.log(engine.getLogLevel(), "Integrate Rubi recursion limit {} RuntimeException: {}", (Object)Config.INTEGRATE_RUBI_RULES_RECURSION_LIMIT, (Object)ast, (Object)rex);
                                IAssociation iAssociation = F.NIL;
                                return iAssociation;
                            }
                        }
                        if (temp.isAST()) {
                            engine.rubiASTCache.put((Object)ast, (Object)temp);
                        }
                        IExpr iExpr = temp;
                        return iExpr;
                    }
                    catch (AbortException ae) {
                        LOGGER.debug("Integrate.integrateByRubiRules() aborted", (Throwable)((Object)ae));
                    }
                    catch (FailedException fe) {
                        LOGGER.debug("Integrate.integrateByRubiRules() failed", (Throwable)((Object)fe));
                    }
                    finally {
                        engine.setRecursionLimit(limit);
                        if (newCache) {
                            engine.rubiASTCache = null;
                        }
                        engine.setQuietMode(quietMode);
                    }
                }
            }
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr integrateByParts(IExpr f, IExpr g, IExpr x, EvalEngine engine) {
        int limit = engine.getRecursionLimit();
        try {
            IExpr firstIntegrate;
            if (limit <= 0 || limit > Config.INTEGRATE_BY_PARTS_RECURSION_LIMIT) {
                engine.setRecursionLimit(Config.INTEGRATE_BY_PARTS_RECURSION_LIMIT);
            }
            if (!(firstIntegrate = engine.evaluate(F.Integrate(f, x))).isFreeAST(F.Integrate)) {
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            IExpr gDerived = F.eval(F.D(g, x));
            IExpr second2Integrate = F.eval(F.Integrate(F.Times(gDerived, firstIntegrate), x));
            if (!second2Integrate.isFreeAST(F.Integrate)) {
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            IExpr iExpr = F.eval(F.Subtract(F.Times(g, firstIntegrate), second2Integrate));
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(limit);
        }
        finally {
            engine.setRecursionLimit(limit);
        }
        return F.NIL;
    }

    private static void collectPolynomialTerms(IAST timesAST, IExpr symbol, IASTAppendable polyTimes, IASTAppendable restTimes) {
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr temp = timesAST.get(i);
            if (temp.isFree(symbol, true)) {
                polyTimes.append(temp);
                continue;
            }
            if (temp.equals(symbol)) {
                polyTimes.append(temp);
                continue;
            }
            if (temp.isPolynomial(F.list(symbol))) {
                polyTimes.append(temp);
                continue;
            }
            restTimes.append(temp);
        }
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
        super.setUp(newSymbol);
        INIT_THREAD = Config.THREAD_FACTORY != null ? Config.THREAD_FACTORY.newThread(new IntegrateInitializer()) : new Thread((Runnable)new IntegrateInitializer(), "IntegrateInitializer");
        if (!Config.JAS_NO_THREADS) {
            INIT_THREAD.start();
        }
        this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions)));
    }

    static {
        CONST = new Integrate();
        INT_RUBI_FUNCTIONS = new HashSet<ISymbol>();
        DEBUG_EXPR = new HashSet<IExpr>(64);
        INTEGRATE_RULES_READ = new AtomicBoolean(false);
    }

    public static class IntegrateInitializer
    implements Runnable {
        @Override
        public void run() {
            if (!INTEGRATE_RULES_READ.get()) {
                INTEGRATE_RULES_READ.set(true);
                EvalEngine engine = EvalEngine.get();
                ContextPath path = engine.getContextPath();
                try {
                    engine.getContextPath().add(Context.RUBI);
                    UtilityFunctionCtors.getUtilityFunctionsRuleASTRubi45();
                    IntegrateInitializer.getRuleASTStatic();
                }
                finally {
                    engine.setContextPath(path);
                }
                engine.setPackageMode(false);
                F.ISet(F.$s("\u00a7simplifyflag"), S.False);
                F.ISet(F.$s("\u00a7$timelimit"), F.ZZ(Config.INTEGRATE_RUBI_TIMELIMIT));
                F.ISet(F.$s("\u00a7$showsteps"), S.False);
                UtilityFunctionCtors.ReapList.setAttributes(32);
                F.ISet(F.$s("\u00a7$trigfunctions"), F.List(S.Sin, S.Cos, S.Tan, S.Cot, S.Sec, S.Csc));
                F.ISet(F.$s("\u00a7$hyperbolicfunctions"), F.List(S.Sinh, S.Cosh, S.Tanh, S.Coth, S.Sech, S.Csch));
                F.ISet(F.$s("\u00a7$inversetrigfunctions"), F.List(S.ArcSin, S.ArcCos, S.ArcTan, S.ArcCot, S.ArcSec, S.ArcCsc));
                F.ISet(F.$s("\u00a7$inversehyperbolicfunctions"), F.List(S.ArcSinh, S.ArcCosh, S.ArcTanh, S.ArcCoth, S.ArcSech, S.ArcCsch));
                F.ISet(F.$s("\u00a7$calculusfunctions"), F.List(S.D, S.Sum, S.Product, S.Integrate, F.$rubi("Unintegrable"), F.$rubi("CannotIntegrate"), F.$rubi("Dif"), F.$rubi("Subst")));
                F.ISet(F.$s("\u00a7$stopfunctions"), F.List(S.Hold, S.HoldForm, S.Defer, S.Pattern, S.If, S.Integrate, UtilityFunctionCtors.Unintegrable, F.$rubi("CannotIntegrate")));
                F.ISet(F.$s("\u00a7$heldfunctions"), F.List(S.Hold, S.HoldForm, S.Defer, S.Pattern));
                F.ISet(UtilityFunctionCtors.IntegerPowerQ, F.Function(F.And((IExpr)F.SameQ((IExpr)F.Head(F.Slot1), S.Power), (IExpr)F.IntegerQ(F.Part((IExpr)F.Slot1, (IExpr)F.C2)))));
                F.ISet(UtilityFunctionCtors.FractionalPowerQ, F.Function(F.And((IExpr)F.SameQ((IExpr)F.Head(F.Slot1), S.Power), (IExpr)F.SameQ((IExpr)F.Head(F.Part((IExpr)F.Slot1, (IExpr)F.C2)), S.Rational))));
                COUNT_DOWN_LATCH.countDown();
            }
        }

        private static void getRuleASTStatic() {
            INTEGRATE_RULES_DATA = S.Integrate.createRulesData(new int[]{0, 7000});
            UtilityFunctionCtors.getRuleASTRubi45();
            ISymbol[] rubiSymbols = new ISymbol[]{S.Derivative, S.D};
            for (int i = 0; i < rubiSymbols.length; ++i) {
                INT_RUBI_FUNCTIONS.add(rubiSymbols[i]);
            }
        }
    }
}

