/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.convert.ExpressionJSONConvert;
import org.matheclipse.core.convert.JSONConvert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.io.Extension;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public class ImportString
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (!(ast.arg1() instanceof IStringX)) {
            return F.NIL;
        }
        String str1 = ((IStringX)ast.arg1()).toString();
        Extension format = Extension.TXT;
        if (ast.size() > 2) {
            if (!(ast.arg2() instanceof IStringX)) {
                return F.NIL;
            }
            format = Extension.importExtension(((IStringX)ast.arg2()).toString());
        }
        try {
            switch (format) {
                case JSON: {
                    return JSONConvert.importJSON(str1);
                }
                case EXPRESSIONJSON: {
                    return ExpressionJSONConvert.importExpressionJSON(str1);
                }
                case TABLE: {
                    AST2Expr ast2Expr = new AST2Expr(engine.isRelaxedSyntax(), engine);
                    Parser parser = new Parser(engine.isRelaxedSyntax(), true);
                    CSVFormat csvFormat = CSVFormat.RFC4180.withDelimiter(',');
                    CSVParser records = csvFormat.parse((Reader)new StringReader(str1));
                    IASTAppendable rowList = F.ListAlloc(256);
                    for (CSVRecord record : records) {
                        IASTAppendable columnList = F.ListAlloc(record.size());
                        for (String string : record) {
                            ASTNode node = parser.parse(string);
                            IExpr temp = ast2Expr.convert(node);
                            columnList.append(temp);
                        }
                        rowList.append(columnList);
                    }
                    return rowList;
                }
                case STRING: {
                    return ImportString.ofString(str1, engine);
                }
                case TXT: {
                    return ImportString.ofText(str1, engine);
                }
            }
        }
        catch (SyntaxError se) {
            LOGGER.log(engine.getLogLevel(), "ImportString: syntax error!", (Throwable)se);
        }
        catch (Exception ex) {
            LOGGER.log(engine.getLogLevel(), "ImportString", (Throwable)ex);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    public static IExpr ofString(String str, EvalEngine engine) {
        AST2Expr ast2Expr = new AST2Expr(engine.isRelaxedSyntax(), engine);
        Parser parser = new Parser(engine.isRelaxedSyntax(), true);
        ASTNode node = parser.parse(str);
        return ast2Expr.convert(node);
    }

    public static IExpr ofText(String str, EvalEngine engine) {
        return F.stringx(str);
    }
}

