/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.matheclipse.core.builtin.WindowFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.Matcher;
import org.matheclipse.core.polynomials.QuarticSolver;
import org.matheclipse.core.reflection.system.rules.FunctionExpandRules;

public class FunctionExpand
extends AbstractEvaluator
implements FunctionExpandRules {
    private static Supplier<Matcher> LAZY_MATCHER;

    private static IExpr beforeRules(IAST ast) {
        if (ast.isSqrt() && ast.base().isAST(S.Plus, 3)) {
            IAST plus = (IAST)ast.base();
            IExpr arg1 = plus.arg1();
            IExpr arg2 = plus.arg2();
            if (arg1.isRational()) {
                return FunctionExpand.sqrtDenest((IRational)arg1, arg2);
            }
        } else if ((ast.isCos() || ast.isSin()) && ast.first().isTimes2()) {
            IAST times = (IAST)ast.first();
            return FunctionExpand.cosSinTrivial(times, ast);
        }
        return F.NIL;
    }

    public static IAST cosSinTrivial(IAST timesAST, IAST ast) {
        int exponent;
        IInteger base;
        IASTAppendable factors;
        IFraction fraction;
        if (timesAST.second().isPi() && timesAST.first().isFraction() && (fraction = (IFraction)timesAST.first()).numerator().isOne() && (factors = fraction.denominator().factorInteger()).size() == 2 && (base = (IInteger)factors.arg1().first()).equalsInt(2) && (exponent = factors.arg1().second().toIntDefault()) > 3) {
            if (ast.isCos()) {
                return F.Times((IExpr)F.C1D2, F.Sqrt(F.C2).nest(F.Function(F.Sqrt(F.Plus((IExpr)F.C2, (IExpr)F.Slot1))), exponent - 2));
            }
            if (ast.isSin()) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Subtract(F.C2, F.Sqrt(F.C2).nest(F.Function(F.Sqrt(F.Plus((IExpr)F.C2, (IExpr)F.Slot1))), exponent - 3))));
            }
        }
        return F.NIL;
    }

    public static IExpr sqrtDenest(IRational arg1, IExpr arg2) {
        IExpr b;
        IExpr a;
        IASTAppendable list;
        IExpr squared;
        if (arg1.isNegative()) {
            return FunctionExpand.sqrtDenest(arg1.negate(), arg2.negate()).mapExpr(x -> F.Times((IExpr)F.CI, x));
        }
        EvalEngine engine = EvalEngine.get();
        boolean arg2IsNegative = false;
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg2);
        if (negExpr.isPresent()) {
            arg2 = negExpr;
            arg2IsNegative = true;
        }
        if ((squared = engine.evaluate(F.Sqr(F.Divide(arg2, F.C2)))).isRealResult() && (list = QuarticSolver.quadraticSolve(F.C1, arg1.negate(), squared)).isAST2() && (a = engine.evaluate(list.arg1())).isRational() && (b = engine.evaluate(list.arg2())).isRational()) {
            if (arg2IsNegative) {
                return F.Plus((IExpr)F.Sqrt(a), F.Negate(F.Sqrt(b)));
            }
            return F.Plus((IExpr)F.Sqrt(a), (IExpr)F.Sqrt(b));
        }
        return F.NIL;
    }

    private static Matcher getMatcher() {
        return LAZY_MATCHER.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr result = engine.getCache(ast);
        if (result != null) {
            return result;
        }
        IExpr arg1 = ast.arg1();
        IExpr assumptionExpr = F.NIL;
        if (ast.size() > 2) {
            IExpr arg2 = ast.arg2();
            if (!arg2.isRule()) {
                assumptionExpr = arg2;
            }
            OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
            assumptionExpr = options.getOption(S.Assumptions).orElse(assumptionExpr);
        }
        if (assumptionExpr.isPresent() && assumptionExpr.isAST()) {
            IAssumptions assumptions;
            IAssumptions oldAssumptions = engine.getAssumptions();
            if (oldAssumptions == null) {
                assumptions = Assumptions.getInstance(assumptionExpr);
            } else {
                assumptions = oldAssumptions.copy();
                assumptions = assumptions.addAssumption(assumptionExpr);
            }
            if (assumptions != null) {
                try {
                    engine.setAssumptions(assumptions);
                    IExpr iExpr = FunctionExpand.callMatcher(ast, arg1, engine);
                    return iExpr;
                }
                finally {
                    engine.setAssumptions(oldAssumptions);
                }
            }
        }
        return FunctionExpand.callMatcher(ast, arg1, engine);
    }

    public static IExpr callMatcher(IAST ast, IExpr arg1, EvalEngine engine) {
        IExpr temp = FunctionExpand.getMatcher().replaceAll(arg1, FunctionExpand::beforeRules).orElse(arg1);
        engine.putCache(ast, temp);
        return temp;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        LAZY_MATCHER = Suppliers.memoize(() -> Initializer.init());
    }

    private static class Initializer {
        private Initializer() {
        }

        private static Matcher init() {
            Matcher MATCHER = new Matcher();
            MATCHER.caseOf((IExpr)F.Beta(F.z_, F.a_, F.b_), F.Condition(F.Times((IExpr)F.Beta(S.a, S.b), (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Subtract(F.C1, S.z), S.b), (IExpr)F.Sum(F.Times((IExpr)F.Power((IExpr)S.z, S.k), (IExpr)F.Power((IExpr)F.Factorial(S.k), F.CN1), (IExpr)F.Pochhammer(S.b, S.k)), F.list(S.k, F.C0, F.Plus((IExpr)F.CN1, (IExpr)S.a)))))), F.And((IExpr)F.IntegerQ(S.a), (IExpr)F.Greater((IExpr)S.a, F.C0))));
            MATCHER.caseOf((IExpr)F.Beta(F.a_, F.b_), F.Condition(F.Times((IExpr)F.Factorial(F.Plus((IExpr)F.CN1, (IExpr)S.a)), (IExpr)F.Product(F.Power((IExpr)F.Plus((IExpr)S.k, (IExpr)S.b), F.CN1), F.list(S.k, F.C0, F.Plus((IExpr)F.CN1, (IExpr)S.a)))), F.And((IExpr)F.IntegerQ(S.a), (IExpr)F.Greater((IExpr)S.a, F.C0))));
            MATCHER.caseOf((IExpr)F.BetaRegularized(F.z_, F.a_, F.b_), F.Times((IExpr)F.Beta(S.z, S.a, S.b), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Gamma(S.a), (IExpr)F.Gamma(S.b)), F.CN1), (IExpr)F.Gamma(F.Plus((IExpr)S.a, (IExpr)S.b))));
            MATCHER.caseOf((IExpr)F.Binomial(F.a_, F.b_), F.If(F.And((IExpr)F.IntegerQ(S.b), (IExpr)F.Positive(S.b)), F.Times((IExpr)F.Power((IExpr)F.Factorial(S.b), F.CN1), (IExpr)F.Product(F.Subtract(S.a, S.c), F.list(S.c, F.C0, F.Plus((IExpr)F.CN1, (IExpr)S.b)))), F.If(F.And((IExpr)F.IntegerQ(S.a), (IExpr)F.Positive(S.a)), F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Product(F.Subtract(S.b, S.c), F.list(S.c, F.C0, S.a)), (IExpr)F.Pi), F.CN1), (IExpr)F.Factorial(S.a), (IExpr)F.Sin(F.Times((IExpr)S.b, (IExpr)F.Pi))), F.Times((IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)S.a)), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)S.b)), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, F.Negate(S.b), (IExpr)S.a))), F.CN1)))));
            MATCHER.caseOf((IExpr)F.Cos(F.Sqrt(F.Sqr(F.x_))), F.Cos(S.x));
            MATCHER.caseOf((IExpr)F.Sin(F.Sqrt(F.Sqr(F.x_))), F.Times((IExpr)F.Power((IExpr)S.x, F.CN1), (IExpr)F.Sqrt(F.Sqr(S.x)), (IExpr)F.Sin(S.x)));
            MATCHER.caseOf((IExpr)F.CosIntegral(F.Times((IExpr)F.CN1, (IExpr)F.x_)), F.Plus((IExpr)F.CosIntegral(S.x), F.Negate(F.Log(S.x)), (IExpr)F.Log(S.x)));
            MATCHER.caseOf((IExpr)F.CosIntegral(F.Times((IExpr)F.CI, (IExpr)F.x_)), F.Plus((IExpr)F.CoshIntegral(S.x), F.Negate(F.Log(S.x)), (IExpr)F.Log(F.Times((IExpr)F.CI, (IExpr)S.x))));
            MATCHER.caseOf((IExpr)F.CosIntegral(F.Times((IExpr)F.CNI, (IExpr)F.x_)), F.Plus((IExpr)F.CoshIntegral(S.x), F.Negate(F.Log(S.x)), (IExpr)F.Log(F.Times((IExpr)F.CNI, (IExpr)S.x))));
            MATCHER.caseOf((IExpr)F.CosIntegral(F.Power((IExpr)F.Power((IExpr)F.x_, F.C2), F.C1D2)), F.Plus((IExpr)F.CosIntegral(S.x), F.Negate(F.Log(S.x)), (IExpr)F.Log(F.Sqrt(F.Sqr(S.x)))));
            MATCHER.caseOf((IExpr)F.SinIntegral(F.Power((IExpr)F.Power((IExpr)F.x_, F.C2), F.C1D2)), F.Times((IExpr)F.Power((IExpr)S.x, F.CN1), (IExpr)F.Sqrt(F.Sqr(S.x)), (IExpr)F.SinIntegral(S.x)));
            MATCHER.caseOf((IExpr)F.Factorial(F.x_), F.Gamma(F.Plus((IExpr)F.C1, (IExpr)S.x)));
            MATCHER.caseOf((IExpr)F.Haversine(F.x_), F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.C1, F.Cos(S.x))));
            MATCHER.caseOf((IExpr)F.InverseHaversine(F.x_), F.Times((IExpr)F.C2, (IExpr)F.ArcSin(F.Sqrt(S.x))));
            MATCHER.caseOf((IExpr)F.Pochhammer(F.x_, F.y_), F.Times((IExpr)F.Power((IExpr)F.Gamma(S.x), F.CN1), (IExpr)F.Gamma(F.Plus((IExpr)S.x, (IExpr)S.y))));
            MATCHER.caseOf((IExpr)F.PolyGamma(F.CN2, F.C1), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Log(F.C2), (IExpr)F.Log(F.Pi))));
            MATCHER.caseOf((IExpr)F.PolyGamma(F.CN3, F.C1), F.Plus((IExpr)F.Log(F.Glaisher), (IExpr)F.Times((IExpr)F.C1D4, (IExpr)F.Plus((IExpr)F.Log(F.C2), (IExpr)F.Log(F.Pi)))));
            MATCHER.caseOf((IExpr)S.Degree, F.Times((IExpr)F.QQ(1L, 180L), (IExpr)F.Pi));
            MATCHER.caseOf((IExpr)S.GoldenAngle, F.Times((IExpr)F.Subtract(F.C3, F.CSqrt5), (IExpr)F.Pi));
            MATCHER.caseOf((IExpr)S.GoldenRatio, F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.CSqrt5)));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcSinh(F.x_)), F.Plus((IExpr)S.x, (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Sqr(S.x)))));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcCosh(F.x_)), F.Plus((IExpr)S.x, (IExpr)F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)S.x)), (IExpr)F.Sqrt(F.Plus((IExpr)S.x, (IExpr)F.C1)))));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcTanh(F.x_)), F.Times((IExpr)F.Plus((IExpr)S.x, (IExpr)F.C1), (IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Sqr(S.x)), F.CN1D2)));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcCsch(F.x_)), F.Plus((IExpr)F.Power((IExpr)S.x, F.CN1), (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)S.x, F.CN2)))));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcSech(F.x_)), F.Plus((IExpr)F.Power((IExpr)S.x, F.CN1), (IExpr)F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)S.x, F.CN1))), (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)S.x, F.CN1), (IExpr)F.C1)))));
            MATCHER.caseOf((IExpr)F.Power((IExpr)S.E, F.ArcCoth(F.x_)), F.Power((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)S.x, (IExpr)F.C1), F.CN1), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)S.x)), F.CN1D2));
            MATCHER.caseOf((IExpr)F.Log(F.Times((IExpr)F.m_, (IExpr)F.n_)), F.Condition(F.Plus((IExpr)F.Log(S.m), (IExpr)F.Log(S.n)), F.Positive(S.m)));
            MATCHER.caseOf((IExpr)F.Log(F.Power((IExpr)F.x_, F.PatternTest(F.y_, F.Function(F.And((IExpr)F.RealNumberQ(F.Slot1), (IExpr)F.Greater((IExpr)F.Slot1, F.CN1), (IExpr)F.Less((IExpr)F.Slot1, F.C1)))))), F.Times((IExpr)S.y, (IExpr)F.Log(S.x)));
            MATCHER.caseOf(S.BartlettWindow.of(F.x_), WindowFunctions.bartlettWindow(S.x));
            MATCHER.caseOf(S.BlackmanHarrisWindow.of(F.x_), WindowFunctions.blackmanHarrisWindow(S.x));
            MATCHER.caseOf(S.BlackmanNuttallWindow.of(F.x_), WindowFunctions.blackmanNuttallWindow(S.x));
            MATCHER.caseOf(S.BlackmanWindow.of(F.x_), WindowFunctions.blackmanWindow(S.x));
            MATCHER.caseOf(S.DirichletWindow.of(F.x_), WindowFunctions.dirichletWindow(S.x));
            MATCHER.caseOf(S.HannWindow.of(F.x_), WindowFunctions.hannWindow(S.x));
            MATCHER.caseOf(S.FlatTopWindow.of(F.x_), WindowFunctions.flatTopWindow(S.x));
            MATCHER.caseOf(S.GaussianWindow.of(F.x_), WindowFunctions.gaussianWindow(S.x));
            MATCHER.caseOf(S.HammingWindow.of(F.x_), WindowFunctions.hammingWindow(S.x));
            MATCHER.caseOf(S.NuttallWindow.of(F.x_), WindowFunctions.nuttallWindow(S.x));
            MATCHER.caseOf(S.ParzenWindow.of(F.x_), WindowFunctions.parzenWindow(S.x));
            MATCHER.caseOf(S.TukeyWindow.of(F.x_), WindowFunctions.tukeyWindow(S.x));
            IAST list = FunctionExpandRules.RULES;
            for (int i = 1; i < list.size(); ++i) {
                IExpr arg = list.get(i);
                if (arg.isAST(S.SetDelayed, 3)) {
                    MATCHER.caseOf(arg.first(), arg.second());
                    continue;
                }
                if (!arg.isAST(S.Set, 3)) continue;
                MATCHER.caseOf(arg.first(), arg.second());
            }
            return MATCHER;
        }
    }
}

