/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.frobenius.FrobeniusSolver;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class FrobeniusSolve
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.arg1().isList() && ast.arg2().isInteger()) {
            IAST list = ast.getAST(1);
            try {
                int[] listInt = Validate.checkListOfInts(ast, (IExpr)list, true, false, engine);
                if (listInt != null) {
                    IExpr[] solution;
                    for (int i = 0; i < listInt.length; ++i) {
                        if (listInt[i] < 0 && ast.size() >= 4) continue;
                    }
                    IASTAppendable result = F.ListAlloc(8);
                    FrobeniusSolver solver = FrobeniusSolve.getSolver(listInt, (IInteger)ast.arg2());
                    int numberOfSolutions = -1;
                    if (ast.size() == 4) {
                        numberOfSolutions = ast.arg3().toIntDefault(-1);
                    }
                    while ((solution = solver.take()) != null) {
                        if (result.size() >= Config.MAX_AST_SIZE) {
                            throw new ASTElementLimitExceeded(result.size());
                        }
                        result.append(F.List(solution));
                    }
                    return result;
                }
            }
            catch (LimitException le) {
                throw le;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FrobeniusSolve.evaluate() failed", (Throwable)rex);
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_3;
    }

    public static FrobeniusSolver getSolver(int[] listInt, IInteger number) {
        IInteger[][] equations = new IInteger[1][listInt.length + 1];
        for (int j = 0; j < listInt.length; ++j) {
            equations[0][j] = F.ZZ(listInt[j]);
        }
        equations[0][listInt.length] = number;
        return new FrobeniusSolver(equations);
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

