/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.function.Supplier;
import org.hipparchus.analysis.MultivariateFunction;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.InitialGuess;
import org.hipparchus.optim.MaxEval;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.PointValuePair;
import org.hipparchus.optim.SimpleValueChecker;
import org.hipparchus.optim.nonlinear.scalar.GoalType;
import org.hipparchus.optim.nonlinear.scalar.MultiStartMultivariateOptimizer;
import org.hipparchus.optim.nonlinear.scalar.MultivariateOptimizer;
import org.hipparchus.optim.nonlinear.scalar.ObjectiveFunction;
import org.hipparchus.optim.nonlinear.scalar.ObjectiveFunctionGradient;
import org.hipparchus.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer;
import org.hipparchus.optim.nonlinear.scalar.noderiv.PowellOptimizer;
import org.hipparchus.random.GaussianRandomGenerator;
import org.hipparchus.random.JDKRandomGenerator;
import org.hipparchus.random.NormalizedRandomGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.RandomVectorGenerator;
import org.hipparchus.random.UncorrelatedRandomVectorGenerator;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.MultiVariateFunction;
import org.matheclipse.core.generic.MultiVariateVectorGradient;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class FindMinimum
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        GoalType goalType = GoalType.MINIMIZE;
        try {
            return FindMinimum.findExtremum(ast, engine, goalType);
        }
        catch (MathIllegalStateException miae) {
            return IOFunctions.printMessage(ast.topHead(), "error", F.list(F.$str(miae.getMessage())), engine);
        }
        catch (MathRuntimeException mre) {
            IOFunctions.printMessage(ast.topHead(), "error", F.list(F.$str(mre.getMessage())), engine);
            return F.CEmptyList;
        }
    }

    protected static IExpr findExtremum(IAST ast, EvalEngine engine, GoalType goalType) {
        IExpr function = ast.arg1();
        IExpr arg2 = ast.arg2();
        if (!arg2.isList()) {
            arg2 = engine.evaluate(arg2);
        }
        if (arg2.isList() && arg2.argSize() >= 2) {
            String method = "Powell";
            int maxIterations = 100;
            if (ast.size() >= 4) {
                IExpr optionMethod;
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 3, engine);
                maxIterations = options.getOptionMaxIterations(S.MaxIterations);
                if (maxIterations == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                if (maxIterations < 0) {
                    maxIterations = 100;
                }
                if ((optionMethod = options.getOption(S.Method)).isSymbol() || optionMethod.isString()) {
                    method = optionMethod.toString();
                } else if (ast.arg3().isSymbol()) {
                    method = ast.arg3().toString();
                }
            }
            return FindMinimum.optimizeGoal(method, maxIterations, goalType, function, (IAST)arg2, engine);
        }
        return F.NIL;
    }

    private static IExpr optimizeGoal(String method, int maxIterations, GoalType goalType, IExpr function, IAST list, EvalEngine engine) {
        double[] initialValues = null;
        IAST variableList = null;
        int[] dimension = list.isMatrix();
        if (dimension == null) {
            if (list.argSize() == 1) {
                initialValues = new double[]{1.0};
                variableList = F.list(list.arg1());
            } else if (list.argSize() == 2 && !list.arg2().isSymbol()) {
                initialValues = new double[]{list.arg2().evalDouble()};
                variableList = F.list(list.arg1());
            } else {
                initialValues = new double[list.argSize()];
                variableList = list;
                for (int i = 0; i < initialValues.length; ++i) {
                    initialValues[i] = 1.0;
                }
            }
        } else if (dimension[0] == list.argSize()) {
            IASTAppendable vars = F.ListAlloc();
            if (dimension[1] == 1) {
                initialValues = new double[list.argSize()];
                for (int i = 0; i < list.argSize(); ++i) {
                    IAST row = (IAST)list.get(i + 1);
                    initialValues[i] = list.getPart(i + 1, 2).evalDouble();
                    vars.append(row.arg1());
                }
                variableList = vars;
            } else if (dimension[1] == 2) {
                initialValues = new double[list.argSize()];
                for (int i = 0; i < list.argSize(); ++i) {
                    IAST row = (IAST)list.get(i + 1);
                    initialValues[i] = row.arg2().evalDouble();
                    vars.append(row.arg1());
                }
                variableList = vars;
            }
        }
        if (initialValues != null) {
            OptimizeSupplier optimizeSupplier = new OptimizeSupplier(goalType, function, variableList, initialValues, method, engine);
            return engine.evalBlock(optimizeSupplier, variableList);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_INFINITY;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
    }

    private static class OptimizeSupplier
    implements Supplier<IExpr> {
        final GoalType goalType;
        final IExpr originalFunction;
        final IAST variableList;
        final double[] initialValues;
        final String method;
        final EvalEngine engine;

        public OptimizeSupplier(GoalType goalType, IExpr function, IAST variableList, double[] initialValues, String method, EvalEngine engine) {
            this.goalType = goalType;
            this.originalFunction = function;
            this.variableList = variableList;
            this.initialValues = initialValues;
            this.method = method;
            this.engine = engine;
        }

        @Override
        public IExpr get() {
            PointValuePair optimum = null;
            InitialGuess initialGuess = new InitialGuess(this.initialValues);
            IExpr function = this.engine.evaluate(this.originalFunction);
            if (this.method.equals("Powell")) {
                PowellOptimizer optim = new PowellOptimizer(1.0E-10, Math.ulp(1.0), 1.0E-10, Math.ulp(1.0));
                optimum = optim.optimize(new OptimizationData[]{new MaxEval(1000), new ObjectiveFunction((MultivariateFunction)new MultiVariateFunction(function, this.variableList)), this.goalType, initialGuess});
            } else if (this.method.equals("ConjugateGradient")) {
                NonLinearConjugateGradientOptimizer underlying = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-10, 1.0E-10));
                JDKRandomGenerator g = new JDKRandomGenerator();
                g.setSeed(753289573253L);
                double[] mean = new double[this.initialValues.length];
                for (int i = 0; i < mean.length; ++i) {
                    mean[i] = 0.0;
                }
                double[] standardDeviation = new double[this.initialValues.length];
                for (int i = 0; i < mean.length; ++i) {
                    standardDeviation[i] = 1.0;
                }
                UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(mean, standardDeviation, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
                int nbStarts = 10;
                MultiStartMultivariateOptimizer optimizer = new MultiStartMultivariateOptimizer((MultivariateOptimizer)underlying, nbStarts, (RandomVectorGenerator)generator);
                optimum = (PointValuePair)optimizer.optimize(new OptimizationData[]{new MaxEval(1000), new ObjectiveFunction((MultivariateFunction)new MultiVariateFunction(function, this.variableList)), new ObjectiveFunctionGradient((MultivariateVectorFunction)new MultiVariateVectorGradient(function, this.variableList)), this.goalType, initialGuess});
            }
            if (optimum != null) {
                double[] point = optimum.getPointRef();
                double value = (Double)optimum.getValue();
                IASTAppendable ruleList = F.ListAlloc(this.variableList.size());
                for (int j = 1; j < this.variableList.size(); ++j) {
                    ruleList.append(F.Rule(this.variableList.get(j), (IExpr)F.num(point[j - 1])));
                }
                return F.list(F.num(value), ruleList);
            }
            return F.NIL;
        }
    }
}

