/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.ExportException;
import org.jgrapht.nio.csv.CSVExporter;
import org.jgrapht.nio.csv.CSVFormat;
import org.jgrapht.nio.dot.DOTExporter;
import org.jgrapht.nio.graphml.GraphMLExporter;
import org.matheclipse.core.convert.ExpressionJSONConvert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.io.Extension;

public class ExportString
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Function<IExpr, String> nameProvider = v -> String.valueOf(v);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        if (!(ast.arg2() instanceof IStringX)) {
            return F.NIL;
        }
        Extension format = Extension.exportExtension(((IStringX)ast.arg2()).toString());
        try {
            int[] dims;
            StringWriter writer;
            block25: {
                writer = new StringWriter();
                if (format.equals((Object)Extension.EXPRESSIONJSON)) {
                    if (arg1.isNumber() || arg1.isSymbol()) {
                        IStringX iStringX = F.stringx(arg1.toString());
                        return iStringX;
                    }
                    if (arg1.isString()) {
                        IStringX iStringX = F.stringx("'" + arg1.toString() + "'");
                        return iStringX;
                    }
                    IStringX iStringX = ExpressionJSONConvert.exportExpressionJSONIStringX(arg1);
                    return iStringX;
                }
                if (arg1 instanceof GraphExpr) {
                    this.graphExport((Graph<IExpr, DefaultEdge>)((Graph)((GraphExpr)arg1).toData()), writer, format);
                    IStringX iStringX = F.stringx(writer.toString());
                    return iStringX;
                }
                if (format.equals((Object)Extension.CSV) || format.equals((Object)Extension.TSV)) {
                    if (!arg1.isDataset()) return F.NIL;
                    ((IASTDataset)arg1).csv(writer);
                    IStringX iStringX = F.stringx(writer.toString());
                    return iStringX;
                }
                if (!format.equals((Object)Extension.TABLE)) return F.NIL;
                dims = arg1.isMatrix();
                if (dims == null) {
                    if (!arg1.isList()) return F.NIL;
                    return F.NIL;
                }
                break block25;
                finally {
                    writer.close();
                }
            }
            int j = 0;
            while (true) {
                if (j >= dims[0]) {
                    IStringX iStringX = F.stringx(writer.toString());
                    return iStringX;
                }
                IAST rowList = (IAST)arg1.getAt(j + 1);
                for (int i = 1; i <= dims[1]; ++i) {
                    if (rowList.get(i).isReal()) {
                        writer.append(rowList.get(i).toString());
                    } else {
                        writer.append("\"");
                        writer.append(rowList.get(i).toString());
                        writer.append("\"");
                    }
                    if (i >= dims[1]) continue;
                    writer.append(" ");
                }
                writer.append("\n");
                ++j;
            }
        }
        catch (Exception ex) {
            LOGGER.log(engine.getLogLevel(), "format: {}", (Object)arg1, (Object)ex);
            return F.NIL;
        }
    }

    void graphExport(Graph<IExpr, DefaultEdge> g, Writer writer, Extension format) throws ExportException {
        switch (format) {
            case DOT: {
                DOTExporter dotExporter = new DOTExporter();
                dotExporter.setGraphAttributeProvider(() -> {
                    LinkedHashMap<String, Attribute> map = new LinkedHashMap<String, Attribute>();
                    map.put("overlap", DefaultAttribute.createAttribute((String)"false"));
                    map.put("splines", DefaultAttribute.createAttribute((String)"true"));
                    return map;
                });
                return;
            }
            case GRAPHML: {
                GraphMLExporter graphMLExporter = new GraphMLExporter();
                graphMLExporter.exportGraph(g, writer);
                return;
            }
        }
        CSVExporter exporter = new CSVExporter(nameProvider, CSVFormat.EDGE_LIST, ';');
        exporter.exportGraph(g, writer);
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_2;
    }
}

