/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.ExportException;
import org.jgrapht.nio.csv.CSVExporter;
import org.jgrapht.nio.csv.CSVFormat;
import org.jgrapht.nio.dot.DOTExporter;
import org.jgrapht.nio.graphml.GraphMLExporter;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.WL;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.io.Extension;

public class Export
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Function<IExpr, String> nameProvider = v -> String.valueOf(v);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (!Config.isFileSystemEnabled(engine)) return F.NIL;
        if (!(ast.arg1() instanceof IStringX)) {
            return F.NIL;
        }
        IStringX arg1 = (IStringX)ast.arg1();
        Extension format = Extension.exportFilename(arg1.toString());
        if (ast.size() == 4) {
            if (!(ast.arg3() instanceof IStringX)) {
                return F.NIL;
            }
            format = Extension.exportExtension(((IStringX)ast.arg3()).toString());
        }
        IExpr arg2 = ast.arg2();
        try {
            int[] dims;
            FileWriter writer;
            block26: {
                writer = new FileWriter(arg1.toString());
                if (arg2 instanceof GraphExpr) {
                    this.graphExport((Graph<IExpr, DefaultEdge>)((Graph)((GraphExpr)arg2).toData()), writer, format);
                    IStringX iStringX = arg1;
                    return iStringX;
                }
                if (format.equals((Object)Extension.CSV) || format.equals((Object)Extension.TSV)) {
                    if (!arg2.isDataset()) return F.NIL;
                    ((IASTDataset)arg2).csv(writer);
                    IStringX iStringX = arg1;
                    return iStringX;
                }
                if (format.equals((Object)Extension.TABLE)) {
                    dims = arg2.isMatrix();
                    if (dims == null) {
                        if (!arg2.isList()) return F.NIL;
                        return F.NIL;
                    }
                    break block26;
                } else {
                    if (format.equals((Object)Extension.DAT)) {
                        File file = new File(arg1.toString());
                        Files.write((CharSequence)arg2.toString(), (File)file, (Charset)Charset.defaultCharset());
                        IStringX j2 = arg1;
                        return j2;
                    }
                    if (!format.equals((Object)Extension.WXF)) return F.NIL;
                    File file = new File(arg1.toString());
                    byte[] bArray = WL.serialize(arg2);
                    Files.write((byte[])bArray, (File)file);
                    IStringX iStringX = arg1;
                    return iStringX;
                }
                finally {
                    writer.close();
                }
            }
            int j2 = 0;
            while (true) {
                if (j2 >= dims[0]) {
                    IStringX j2 = arg1;
                    return j2;
                }
                IAST rowList = (IAST)arg2.getAt(j2 + 1);
                for (int i = 1; i <= dims[1]; ++i) {
                    if (rowList.get(i).isReal()) {
                        writer.append(rowList.get(i).toString());
                    } else {
                        writer.append("\"");
                        writer.append(rowList.get(i).toString());
                        writer.append("\"");
                    }
                    if (i >= dims[1]) continue;
                    writer.append(" ");
                }
                writer.append("\n");
                ++j2;
            }
        }
        catch (IOException ioe) {
            LOGGER.log(engine.getLogLevel(), "Export: file {} not found!", (Object)arg1, (Object)ioe);
            return F.NIL;
        }
        catch (Exception ex) {
            LOGGER.log(engine.getLogLevel(), "Export: file {}", (Object)arg1, (Object)ex);
        }
        return F.NIL;
    }

    void graphExport(Graph<IExpr, DefaultEdge> g, Writer writer, Extension format) throws ExportException {
        switch (format) {
            case DOT: {
                DOTExporter dotExporter = new DOTExporter();
                dotExporter.setGraphAttributeProvider(() -> {
                    LinkedHashMap<String, Attribute> map = new LinkedHashMap<String, Attribute>();
                    map.put("overlap", DefaultAttribute.createAttribute((String)"false"));
                    map.put("splines", DefaultAttribute.createAttribute((String)"true"));
                    return map;
                });
                dotExporter.exportGraph(g, writer);
                return;
            }
            case GRAPHML: {
                GraphMLExporter graphMLExporter = new GraphMLExporter();
                graphMLExporter.exportGraph(g, writer);
                return;
            }
        }
        CSVExporter exporter = new CSVExporter(nameProvider, CSVFormat.EDGE_LIST, ';');
        exporter.exportGraph(g, writer);
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_3;
    }
}

