/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.function.Consumer;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorReplaceAll;

public class ExpToTrig
extends AbstractEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr temp = StructureFunctions.threadLogicEquationOperators(ast.arg1(), ast, 1);
        if (temp.isPresent()) {
            return temp;
        }
        IExpr arg1 = ast.arg1();
        VisitorReplaceAll visitor = new VisitorReplaceAll(x -> {
            if (x.isPower()) {
                IExpr exponent = F.NIL;
                IExpr base = x.base();
                if (base.equals(S.E)) {
                    exponent = x.exponent();
                } else if (base.isNumber()) {
                    exponent = S.Expand.of(engine, F.Times(x.exponent(), (IExpr)F.Log(base)));
                }
                if (exponent.isPresent()) {
                    if (exponent.isPlus()) {
                        IASTAppendable result = F.TimesAlloc(exponent.size());
                        ((IAST)exponent).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)arg -> result.append(F.Plus((IExpr)F.Cosh(arg), (IExpr)F.Sinh(arg)))));
                        return result;
                    }
                    return F.Plus((IExpr)F.Cosh(exponent), (IExpr)F.Sinh(exponent));
                }
            }
            return F.NIL;
        });
        visitor.setPostProcessing(x -> {
            if (x.isTimes() && x.arg1().isNumber() && x.arg2().isPlus()) {
                return F.Expand(x);
            }
            return x;
        });
        temp = arg1.accept(visitor);
        if (temp.isPresent()) {
            return temp;
        }
        return arg1;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(512);
    }
}

