/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.BooleanFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.RootsFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.Matcher;
import org.matheclipse.core.reflection.system.InverseFunction;
import org.matheclipse.core.reflection.system.rulesets.EliminateRules;
import org.matheclipse.core.visit.AbstractVisitorBoolean;

public class Eliminate
extends AbstractFunctionEvaluator
implements EliminateRules {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supplier<Matcher> INVERSE_MATCHER;
    private static Supplier<Matcher> ZERO_PLUS_MATCHER;

    private static Matcher inverseMatcher() {
        return INVERSE_MATCHER.get();
    }

    private static Matcher zeroPlusMatcher() {
        return ZERO_PLUS_MATCHER.get();
    }

    private static IAST checkEquations(IAST ast, int position, EvalEngine engine) {
        IExpr arg = ast.get(position);
        if (arg.isList()) {
            IAST list = (IAST)arg;
            IASTAppendable equalList = F.ListAlloc(list.size());
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(i).isEqual()) {
                    return IOFunctions.printMessage(ast.topHead(), "eqf", F.list(list.get(i)), engine);
                }
                IAST equalAST = (IAST)list.get(i);
                equalList.append(BooleanFunctions.equals(equalAST));
            }
            return equalList;
        }
        if (arg.isEqual()) {
            IAST equalAST = (IAST)arg;
            return F.list(F.Equal(F.evalExpandAll(equalAST.arg1(), engine), F.evalExpandAll(equalAST.arg2(), engine)));
        }
        return IOFunctions.printMessage(ast.topHead(), "eqf", F.list(arg), engine);
    }

    private static IExpr eliminateAnalyze(IAST equalAST, IExpr variable, boolean multipleValues, EvalEngine engine) {
        if (equalAST.isEqual()) {
            IExpr arg1 = equalAST.arg1();
            IExpr arg2 = equalAST.arg2();
            Predicate<IExpr> predicate = Predicates.in(variable);
            boolean boolArg1 = arg1.isFree(predicate, true);
            boolean boolArg2 = arg2.isFree(predicate, true);
            IExpr result = F.NIL;
            if (!boolArg1 && boolArg2) {
                result = Eliminate.extractVariableRecursive(arg1, arg2, predicate, variable, multipleValues, engine);
            } else if (boolArg1 && !boolArg2) {
                result = Eliminate.extractVariableRecursive(arg2, arg1, predicate, variable, multipleValues, engine);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr extractVariable(IExpr expr, IExpr variable, boolean multipleValues, EvalEngine engine) {
        Predicate<IExpr> predicate = Predicates.in(variable);
        IExpr result = F.NIL;
        if (!expr.isFree(predicate, true)) {
            result = Eliminate.extractVariableRecursive(expr, F.C0, predicate, variable, multipleValues, engine);
        }
        return result;
    }

    private static IExpr extractVariableRecursive(IExpr exprWithVariable, IExpr exprWithoutVariable, Predicate<IExpr> predicate, IExpr variable, boolean multipleValues, EvalEngine engine) {
        if (exprWithVariable.equals(variable)) {
            return exprWithoutVariable;
        }
        if (exprWithVariable.isAST()) {
            IAST ast = (IAST)exprWithVariable;
            if (ast.isAST1()) {
                IASTAppendable inverseFunction = InverseFunction.getUnaryInverseFunction(ast, true);
                if (inverseFunction.isPresent()) {
                    if (exprWithVariable.isAbs()) {
                        if (exprWithoutVariable.isNonNegativeResult()) {
                            inverseFunction.append(exprWithoutVariable);
                            return Eliminate.extractVariableRecursive(ast.arg1(), inverseFunction, predicate, variable, multipleValues, engine);
                        }
                        return S.True;
                    }
                    inverseFunction.append(exprWithoutVariable);
                    return Eliminate.extractVariableRecursive(ast.arg1(), inverseFunction, predicate, variable, multipleValues, engine);
                }
            } else {
                int size = ast.size();
                if (size > 2) {
                    IExpr result;
                    if (exprWithoutVariable.isZero() && ast.isPlus()) {
                        IASTMutable elimZeroPlus = F.binaryAST2((IExpr)elimzeroplus, ast, variable);
                        result = Eliminate.zeroPlusMatcher().apply(elimZeroPlus);
                        if (result.isPresent()) {
                            return Eliminate.resultWithIfunMessage(result, variable, exprWithoutVariable, multipleValues, engine);
                        }
                    }
                    IASTMutable elimInverse = F.binaryAST2((IExpr)eliminv, ast, variable);
                    result = Eliminate.inverseMatcher().apply(elimInverse);
                    if (result.isPresent()) {
                        return Eliminate.resultWithIfunMessage(result, variable, exprWithoutVariable, multipleValues, engine);
                    }
                }
                if (ast.isPlus()) {
                    IAST temp;
                    if (exprWithoutVariable.isNumericFunction() && ast.isPolynomial(variable) && ast.isNumericFunction(variable) && (temp = RootsFunctions.rootsOfVariable(F.Subtract.of(ast, exprWithoutVariable), F.C1, F.list(variable), engine.isNumericMode(), engine)).isList() && temp.size() > 1) {
                        if (!multipleValues || temp.size() == 2) {
                            return temp.first();
                        }
                        return temp;
                    }
                    IAST[] plusFilter = ast.filter(x -> x.isFree(predicate, true));
                    IAST plusWithoutVariable = plusFilter[0];
                    IAST plusWithVariable = plusFilter[1];
                    if (plusWithoutVariable.isAST0()) {
                        IExpr factor = engine.evaluateNIL(F.Factor(ast));
                        if (factor.isPresent() && factor.isTimes()) {
                            IAST times = (IAST)factor;
                            IAST[] timesFilter = times.filter(x -> x.isFree(predicate, true));
                            IAST timesWithoutVariable = timesFilter[0];
                            IAST timesWithVariable = timesFilter[1];
                            if (timesWithoutVariable.isAST0()) {
                                return F.NIL;
                            }
                            IExpr rhsWithoutVariable = engine.evaluate(F.Divide(exprWithoutVariable, timesWithoutVariable));
                            return Eliminate.extractVariableRecursive(timesWithVariable.oneIdentity1(), rhsWithoutVariable, predicate, variable, multipleValues, engine);
                        }
                        return F.NIL;
                    }
                    IExpr rhsWithoutVariable = engine.evaluate(F.Subtract(exprWithoutVariable, plusWithoutVariable));
                    return Eliminate.extractVariableRecursive(plusWithVariable.oneIdentity0(), rhsWithoutVariable, predicate, variable, multipleValues, engine);
                }
                if (ast.isTimes()) {
                    IAST[] timesFilter = ast.filter(x -> x.isFree(predicate, true));
                    IAST timesWithoutVariable = timesFilter[0];
                    IAST timesWithVariable = timesFilter[1];
                    if (timesWithoutVariable.isAST0()) {
                        IExpr temp;
                        IExpr[] denomLinear;
                        IExpr[] numerLinear;
                        IExpr[] numerDenom = Algebra.getNumeratorDenominator(ast, EvalEngine.get());
                        if (!numerDenom[1].isOne() && (numerLinear = numerDenom[0].linear(variable)) != null && (denomLinear = numerDenom[1].linear(variable)) != null && !(temp = EvalEngine.get().evaluate(numerLinear[1].subtract(denomLinear[1].times(exprWithoutVariable)))).isZero()) {
                            return numerLinear[0].negate().plus(denomLinear[0].times(exprWithoutVariable)).times(temp.power(-1L));
                        }
                        return F.NIL;
                    }
                    IAST value = F.Divide(exprWithoutVariable, timesWithoutVariable);
                    return Eliminate.extractVariableRecursive(timesWithVariable.oneIdentity1(), value, predicate, variable, multipleValues, engine);
                }
                if (ast.isPower()) {
                    IExpr base = ast.base();
                    IExpr exponent = ast.exponent();
                    if (exponent.isFree(predicate, true)) {
                        Eliminate.printIfunMessage(engine);
                        IExpr value = engine.evaluate(F.Power(exprWithoutVariable, F.Divide(F.C1, exponent)));
                        return Eliminate.extractVariableRecursive(base, value, predicate, variable, multipleValues, engine);
                    }
                    if (base.isFree(predicate, true)) {
                        if (base.isE()) {
                            if (exponent.isRealResult()) {
                                return Eliminate.extractVariableRecursive(exponent, F.Log(exprWithoutVariable), predicate, variable, multipleValues, engine);
                            }
                            IAST c1 = F.C(1);
                            IExpr exprwovar = exprWithoutVariable;
                            IAST temp = F.ConditionalExpression(F.Plus((IExpr)F.Times(F.C2, F.CI, S.Pi, c1), (IExpr)F.Log(exprwovar)), F.Element(c1, S.Integers));
                            return Eliminate.extractVariableRecursive(exponent, temp, predicate, variable, multipleValues, engine);
                        }
                        IAST value = F.Divide(F.Log(exprWithoutVariable), F.Log(base));
                        return Eliminate.extractVariableRecursive(exponent, value, predicate, variable, multipleValues, engine);
                    }
                }
            }
        }
        return F.NIL;
    }

    private static IExpr listOfRulesToValues(IExpr listOfRules, IExpr variable, boolean multipleValues) {
        if (multipleValues) {
            IASTAppendable solveValues = F.ListAlloc(listOfRules.size());
            ((IAST)listOfRules).map(a -> {
                if (a.isList1() && a.first().isRuleAST() && a.first().first().equals(variable)) {
                    solveValues.append(a.first().second());
                }
                return F.NIL;
            });
            if (solveValues.size() > 1) {
                return solveValues;
            }
        } else if (listOfRules.first().isRuleAST() && listOfRules.first().equals(variable)) {
            return listOfRules.first().second();
        }
        return F.NIL;
    }

    private static IExpr resultWithIfunMessage(IExpr result, IExpr subExpr, IExpr replacementExpr, boolean multipleValues, EvalEngine engine) {
        Eliminate.printIfunMessage(engine);
        IExpr expr = F.subst(result, subExpr, replacementExpr);
        if (!multipleValues && expr.isList() && expr.size() > 1) {
            return expr.first();
        }
        return expr;
    }

    private static void printIfunMessage(EvalEngine engine) {
        IOFunctions.printMessage(S.InverseFunction, "ifun", F.CEmptyList, engine);
    }

    protected static IAST[] eliminateOneVariable(ArrayList<VariableCounterVisitor> analyzerList, IExpr variable, boolean multipleValues, EvalEngine engine) {
        IASTAppendable eliminatedResultEquations = F.ListAlloc(analyzerList.size());
        for (int i = 0; i < analyzerList.size(); ++i) {
            IExpr variableValues = Eliminate.eliminateAnalyze(analyzerList.get(i).getExpr(), variable, multipleValues, engine);
            if (!variableValues.isPresent()) continue;
            analyzerList.remove(i);
            IAST[] result = new IAST[2];
            if (variableValues.isList()) {
                IAST listOfRules = ((IAST)variableValues).map(x -> Eliminate.applyRuleToAnalyzer(variable, x, eliminatedResultEquations, analyzerList, engine));
                result[0] = eliminatedResultEquations;
                result[1] = listOfRules;
            } else {
                IAST rule = Eliminate.applyRuleToAnalyzer(variable, variableValues, eliminatedResultEquations, analyzerList, engine);
                result[0] = eliminatedResultEquations;
                result[1] = rule;
            }
            return result;
        }
        return null;
    }

    private static IAST applyRuleToAnalyzer(IExpr variable, IExpr variableValue, IASTAppendable eliminatedResultEquations, ArrayList<VariableCounterVisitor> analyzerList, EvalEngine engine) {
        variableValue = engine.evalQuiet(variableValue);
        IAST rule = F.Rule(variable, variableValue);
        for (int j = 0; j < analyzerList.size(); ++j) {
            IAST expr = analyzerList.get(j).getExpr();
            IExpr temp = expr.replaceAll(rule);
            if (temp.isPresent()) {
                if ((temp = F.expandAll(temp, true, true)).isEqual() && temp.size() == 3) {
                    temp = F.Equal(F.Subtract.of(temp.first(), temp.second()), (IExpr)F.C0);
                }
                eliminatedResultEquations.append(temp);
                continue;
            }
            eliminatedResultEquations.append(expr);
        }
        return rule;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        try {
            IAST termsEqualZeroList = Eliminate.checkEquations(ast, 1, engine);
            if (!termsEqualZeroList.isPresent()) {
                return F.NIL;
            }
            IAST vars = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
            if (!vars.isPresent()) {
                return F.NIL;
            }
            IAST result = termsEqualZeroList;
            for (int i = 1; i < vars.size(); ++i) {
                ISymbol variable = (ISymbol)vars.get(i);
                IAST[] temp = Eliminate.eliminateOneVariable(result, (IExpr)variable, false, engine);
                if (temp == null) {
                    return Eliminate.resultAsAndEquations(result);
                }
                result = temp[0];
            }
            return Eliminate.resultAsAndEquations(result);
        }
        catch (Exception ex) {
            LOGGER.error("QuantityParser.of() failed", (Throwable)ex);
            return F.NIL;
        }
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_2;
    }

    private static IExpr resultAsAndEquations(IAST result) {
        if (result.isList()) {
            if (result.equals(F.CEmptyList)) {
                return S.True;
            }
            return result.apply((IExpr)S.And);
        }
        return result;
    }

    public static IAST[] eliminateOneVariable(IAST ast, IExpr variable, boolean multipleValues, EvalEngine engine) {
        ArrayList<VariableCounterVisitor> analyzerList = new ArrayList<VariableCounterVisitor>();
        for (int j = 1; j < ast.size(); ++j) {
            IAST equalAST = ast.getAST(j);
            VariableCounterVisitor exprAnalyzer = new VariableCounterVisitor(equalAST, variable);
            equalAST.accept(exprAnalyzer);
            analyzerList.add(exprAnalyzer);
        }
        Collections.sort(analyzerList);
        return Eliminate.eliminateOneVariable(analyzerList, variable, multipleValues, engine);
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        INVERSE_MATCHER = Suppliers.memoize(EliminateRules::init1);
        ZERO_PLUS_MATCHER = Suppliers.memoize(EliminateRules::init2);
    }

    static class VariableCounterVisitor
    extends AbstractVisitorBoolean
    implements Comparable<VariableCounterVisitor> {
        int fVariableCounter;
        int fNodeCounter;
        int fMaxVariableDepth;
        int fCurrentDepth;
        final IExpr fVariable;
        final IAST fExpr;

        public VariableCounterVisitor(IAST expr, IExpr variable) {
            this.fVariable = variable;
            this.fExpr = expr;
            this.fVariableCounter = 0;
            this.fNodeCounter = 0;
            this.fMaxVariableDepth = 0;
            this.fCurrentDepth = 0;
        }

        @Override
        public int compareTo(VariableCounterVisitor other) {
            if (this.fVariableCounter < other.fVariableCounter) {
                return -1;
            }
            if (this.fVariableCounter > other.fVariableCounter) {
                return 1;
            }
            if (this.fMaxVariableDepth < other.fMaxVariableDepth) {
                return -1;
            }
            if (this.fMaxVariableDepth > other.fMaxVariableDepth) {
                return 1;
            }
            if (this.fNodeCounter < other.fNodeCounter) {
                return -1;
            }
            if (this.fNodeCounter > other.fNodeCounter) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableCounterVisitor other = (VariableCounterVisitor)obj;
            if (this.fCurrentDepth != other.fCurrentDepth) {
                return false;
            }
            if (this.fExpr == null ? other.fExpr != null : !this.fExpr.equals(other.fExpr)) {
                return false;
            }
            if (this.fMaxVariableDepth != other.fMaxVariableDepth) {
                return false;
            }
            if (this.fNodeCounter != other.fNodeCounter) {
                return false;
            }
            if (this.fVariable == null ? other.fVariable != null : !this.fVariable.equals(other.fVariable)) {
                return false;
            }
            return this.fVariableCounter == other.fVariableCounter;
        }

        public IAST getExpr() {
            return this.fExpr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fCurrentDepth;
            result = 31 * result + (this.fExpr == null ? 0 : this.fExpr.hashCode());
            result = 31 * result + this.fMaxVariableDepth;
            result = 31 * result + this.fNodeCounter;
            result = 31 * result + (this.fVariable == null ? 0 : this.fVariable.hashCode());
            result = 31 * result + this.fVariableCounter;
            return result;
        }

        @Override
        public boolean visit(IAST ast) {
            ++this.fNodeCounter;
            if (ast.equals(this.fVariable)) {
                ++this.fVariableCounter;
                if (this.fMaxVariableDepth < this.fCurrentDepth) {
                    this.fMaxVariableDepth = this.fCurrentDepth;
                }
                return true;
            }
            try {
                ++this.fCurrentDepth;
                ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> x.accept(this)));
            }
            finally {
                --this.fCurrentDepth;
            }
            return false;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            ++this.fNodeCounter;
            if (symbol.equals(this.fVariable)) {
                ++this.fVariableCounter;
                if (this.fMaxVariableDepth < this.fCurrentDepth) {
                    this.fMaxVariableDepth = this.fCurrentDepth;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(IInteger element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IFraction element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IComplex element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(INum element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IComplexNum element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IPattern element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IPatternSequence element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IStringX element) {
            ++this.fNodeCounter;
            return false;
        }
    }
}

