/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.DerivativeRules;

public class Derivative
extends AbstractFunctionEvaluator
implements DerivativeRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IAST[] derivativeAST = ast.isDerivative();
        if (derivativeAST != null) {
            IAST derivativeHead = derivativeAST[0];
            IAST functions = derivativeAST[1];
            if (functions.size() == 2 && functions.arg1().isNumber()) {
                return F.Function(F.C0);
            }
            boolean isZero = true;
            for (int i = 1; i < derivativeHead.size(); ++i) {
                if (derivativeHead.get(i).isZero()) continue;
                isZero = false;
                break;
            }
            if (isZero && derivativeAST[2] == null) {
                if (derivativeAST[1].size() > 1) {
                    return derivativeAST[1].arg1();
                }
                return F.NIL;
            }
            if (derivativeHead.size() >= 2) {
                IAST result = F.NIL;
                for (int i = 1; i < derivativeHead.size(); ++i) {
                    IExpr nTimes = derivativeHead.get(i);
                    if (!result.isPresent()) {
                        result = functions;
                    }
                    if (result.size() < 2) continue;
                    int n = nTimes.toIntDefault();
                    if (n >= 0 || nTimes.isFree(num -> num.isNumber(), false)) {
                        IAST fullDerivative = derivativeAST[2];
                        return Derivative.evaluateDIfPossible(derivativeHead, functions, fullDerivative, engine);
                    }
                    return IOFunctions.printMessage(ast.topHead(), "dvar", F.list(F.list(F.Slot1, nTimes)), engine);
                }
                if (result.isPresent()) {
                    return result;
                }
            }
            if (ast.head().isAST(S.Derivative, 2)) {
                IAST head = (IAST)ast.head();
                if (head.arg1().isInteger()) {
                    try {
                        int n = ((IInteger)head.arg1()).toInt();
                        IExpr arg1 = ast.arg1();
                        if (n >= 0) {
                            if (arg1.isSymbol()) {
                                ISymbol iSymbol = (ISymbol)arg1;
                            } else if (arg1.isFunction()) {
                                return Derivative.derivative(n, (IAST)arg1, engine);
                            }
                        }
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
                return F.NIL;
            }
        }
        return F.NIL;
    }

    private static IExpr evaluateDArg1IfPossible(IExpr n, IAST head, IAST headDerivative, IAST fullDerivative, EvalEngine engine) {
        IAST dExpr;
        IExpr symbol = F.Slot1;
        if (fullDerivative != null) {
            if (fullDerivative.size() != 2) {
                return F.NIL;
            }
            symbol = fullDerivative.arg1();
            if (!symbol.isVariable()) {
                return F.NIL;
            }
        }
        IExpr newFunction = engine.evaluate(F.unaryAST1(headDerivative.arg1(), symbol));
        if (n.isOne()) {
            dExpr = F.D(newFunction, symbol);
        } else {
            int iterationLimit;
            int ni = n.toIntDefault();
            if (ni > 0 && (iterationLimit = engine.getIterationLimit()) > 0 && iterationLimit < ni) {
                return IOFunctions.printMessage(S.Derivative, "itlim", F.list(F.ZZ(iterationLimit)), engine);
            }
            dExpr = F.D(newFunction, F.list(symbol, n));
        }
        dExpr.setEvalFlags(32768);
        IExpr dResult = engine.evalRules(S.D, dExpr);
        if (dResult.isPresent()) {
            dResult = engine.evaluate(dResult);
            return F.Function(dResult);
        }
        if (!n.isOne()) {
            if (!symbol.isVariable()) {
                return F.NIL;
            }
            int length = n.toIntDefault();
            if (length > 1) {
                for (int i = 0; i < length; ++i) {
                    dExpr = F.D(newFunction, symbol);
                    dExpr.setEvalFlags(32768);
                    dResult = engine.evalRules(S.D, dExpr);
                    if (!dResult.isPresent()) {
                        return F.NIL;
                    }
                    newFunction = engine.evaluate(dResult);
                }
                return F.Function(newFunction);
            }
        }
        return F.NIL;
    }

    private static IExpr evaluateDIfPossible(IAST head, IAST headDerivative, IAST fullDerivative, EvalEngine engine) {
        IASTAppendable newFunction = F.ast(headDerivative.arg1());
        IASTAppendable list = F.ListAlloc(headDerivative.size());
        for (int i = 1; i < head.size(); ++i) {
            IExpr n = head.get(i);
            IExpr symbol = F.Slot(i);
            if (fullDerivative != null) {
                if (fullDerivative.size() != headDerivative.size()) {
                    return F.NIL;
                }
                symbol = fullDerivative.get(i);
                if (!symbol.isVariable()) {
                    return F.NIL;
                }
            }
            newFunction.append(symbol);
            if (n.isOne()) {
                list.append(symbol);
                continue;
            }
            int ni = n.toIntDefault();
            if (ni < 0) {
                if (ni == Integer.MIN_VALUE) {
                    list.append(F.list(symbol, n));
                    continue;
                }
                return F.NIL;
            }
            if (ni <= 0) continue;
            int iterationLimit = engine.getIterationLimit();
            if (iterationLimit > 0 && iterationLimit < ni) {
                return IOFunctions.printMessage(S.Derivative, "itlim", F.list(F.ZZ(iterationLimit)), engine);
            }
            list.append(F.list(symbol, n));
        }
        boolean doEval = false;
        IExpr temp = newFunction;
        if (headDerivative.arg1().isBuiltInSymbol()) {
            IBuiltInSymbol builtin = (IBuiltInSymbol)headDerivative.arg1();
            if (builtin.isNumericFunctionAttribute()) {
                if (head.isAST1()) {
                    IExpr dResult;
                    int n = head.first().toIntDefault();
                    if (n > 0 && (dResult = S.Derivative.evalDownRule(engine, n == 1 ? headDerivative : headDerivative.setAtCopy(0, head.setAtCopy(1, F.C1)))).isPresent()) {
                        doEval = true;
                    }
                } else {
                    IExpr dResult = S.Derivative.evalDownRule(engine, headDerivative);
                    if (dResult.isPresent()) {
                        doEval = true;
                    }
                }
            }
        } else {
            temp = engine.evaluateNIL(newFunction);
            if (temp.isPresent()) {
                doEval = true;
            }
        }
        if (doEval) {
            IASTAppendable dExpr = F.ast((IExpr)S.D, list.size() + 1);
            dExpr.append(temp);
            dExpr.appendArgs(list);
            return F.Function(engine.evaluate(dExpr));
        }
        return F.NIL;
    }

    private static IExpr derivative(int n, IAST function, EvalEngine engine) {
        IExpr arg1;
        if (n == 0) {
            return function;
        }
        if (n >= 1 && function.isAST1() && (arg1 = function.arg1()).isPower()) {
            IExpr exponent = arg1.exponent();
            if (arg1.base().equals(F.Slot1) && exponent.isFree(F.Slot1)) {
                return F.Times(exponent, (IExpr)Derivative.createDerivative(n - 1, F.unaryAST1(S.Function, engine.evaluate(F.Power((IExpr)F.Slot1, exponent.dec())))));
            }
        }
        return F.NIL;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(24576);
        super.setUp(newSymbol);
    }

    public static IAST createDerivative(int n, IExpr header, IExpr arg1) {
        IAST deriv = F.Derivative(F.ZZ(n));
        IASTAppendable fDeriv = F.ast(deriv);
        fDeriv.append(header);
        IASTAppendable fDerivParam = F.ast(fDeriv);
        fDerivParam.append(arg1);
        return fDerivParam;
    }

    public static IAST createDerivative(int n, IExpr header) {
        IAST deriv = F.Derivative(F.ZZ(n));
        IASTAppendable fDeriv = F.ast(deriv);
        fDeriv.append(header);
        return fDeriv;
    }
}

