/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.reflection.system.Eliminate;

public class DSolve
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (!ToggleFeature.DSOLVE) {
            return F.NIL;
        }
        IAST uFunction1Arg = F.NIL;
        IExpr arg1 = ast.arg1();
        IExpr arg2 = ast.arg2();
        IExpr xVar = ast.arg3();
        if (arg2.isAST1() && arg2.first().equals(xVar)) {
            uFunction1Arg = (IAST)arg2;
            if (arg1.isFree(arg2.head()) || arg1.isFree(xVar)) {
                return F.NIL;
            }
        } else if (arg2.isSymbol() && xVar.isSymbol()) {
            if (arg1.isFree(arg2) || arg1.isFree(xVar)) {
                return F.NIL;
            }
            uFunction1Arg = F.unaryAST1(arg2, xVar);
        }
        if (uFunction1Arg.isPresent()) {
            IASTAppendable listOfEquations = Validate.checkEquations(ast, 1).copyAppendable();
            IExpr[] boundaryCondition = null;
            for (int i = 1; i < listOfEquations.size(); ++i) {
                IExpr equation = listOfEquations.get(i);
                if (!equation.isFree(xVar) || (boundaryCondition = this.solveSingleBoundary(equation, uFunction1Arg, xVar, engine)) == null) continue;
                listOfEquations.remove(i);
                break;
            }
            if (uFunction1Arg.isAST1() && uFunction1Arg.arg1().equals(xVar)) {
                return this.unaryODE(uFunction1Arg, arg2, xVar, listOfEquations, boundaryCondition, engine);
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }

    private IExpr unaryODE(IAST uFunction1Arg, IExpr arg2, IExpr xVar, IASTAppendable listOfEquations, IExpr[] boundaryCondition, EvalEngine engine) {
        IAST listOfVariables = F.list(uFunction1Arg);
        if (listOfEquations.size() == 2) {
            IASTMutable C_1 = F.unaryAST1(S.C, F.C1);
            IExpr equation = listOfEquations.arg1();
            IExpr temp = this.solveSingleODE(equation, xVar, listOfVariables, C_1, engine);
            if (!temp.isPresent()) {
                temp = DSolve.odeSolve(engine, equation, xVar, uFunction1Arg, C_1);
            }
            if (temp.isPresent()) {
                IExpr res;
                IExpr C1;
                if (boundaryCondition != null && (C1 = S.Roots.of(engine, F.Equal(res = F.subst(temp, F.list(F.Rule(xVar, boundaryCondition[0]))), boundaryCondition[1]), C_1)).isAST((IExpr)S.Equal, 3, C_1)) {
                    temp = res = F.subst(temp, F.list(F.Rule((IExpr)C_1, C1.second())));
                }
                if (arg2.isSymbol() && xVar.isSymbol()) {
                    return F.list(F.list(F.Rule(arg2, (IExpr)F.Function(F.list(xVar), temp))));
                }
                return F.list(F.list(F.Rule(arg2, temp)));
            }
        }
        return F.NIL;
    }

    private IExpr solveSingleODE(IExpr equation, IExpr xVar, IAST listOfVariables, IExpr C_1, EvalEngine engine) {
        ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, listOfVariables);
        if (equation.isAST()) {
            IASTAppendable eq = ((IAST)equation).copyAppendable();
            if (!eq.isPlus()) {
                eq = F.Plus((IExpr)eq);
            }
            int j = 1;
            IAST[] deriveExpr = null;
            while (j < eq.size()) {
                IAST[] temp = eq.get(j).isDerivativeAST1();
                if (temp != null) {
                    if (deriveExpr != null) {
                        return F.NIL;
                    }
                    deriveExpr = temp;
                    eq.remove(j);
                    continue;
                }
                ++j;
            }
            if (deriveExpr != null) {
                int order = DSolve.derivativeOrder(deriveExpr);
                if (order < 0) {
                    return F.NIL;
                }
                try {
                    ExprPolynomial poly = ring.create(eq.oneIdentity0(), false, true, false);
                    if (order == 1 && poly.degree() <= 1L) {
                        IAST coeffs = poly.coefficientList();
                        IExpr q = coeffs.arg1();
                        IExpr p = F.C0;
                        if (poly.degree() == 1L) {
                            p = coeffs.arg2();
                        }
                        return this.linearODE(p, q, xVar, C_1, engine);
                    }
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("DSolve.solveSingleODE() failed", (Throwable)rex);
                }
            }
        }
        return F.NIL;
    }

    public static int derivativeOrder(IAST[] deriveExpr) {
        int order = -1;
        try {
            if (deriveExpr.length == 3 && deriveExpr[0].isAST1() && deriveExpr[0].arg1().isInteger()) {
                order = ((IInteger)deriveExpr[0].arg1()).toInt();
            }
        }
        catch (RuntimeException rex) {
            LOGGER.debug("DSolve.derivativeOrder() failed", (Throwable)rex);
        }
        return order;
    }

    private IExpr[] solveSingleBoundary(IExpr equation, IAST uFunction1Arg, IExpr xVar, EvalEngine engine) {
        if (equation.isAST()) {
            IASTAppendable eq = ((IAST)equation).copyAppendable();
            if (!eq.isPlus()) {
                eq = F.Plus((IExpr)eq);
            }
            int j = 1;
            IExpr uArg1 = null;
            IExpr head = uFunction1Arg.head();
            while (j < eq.size()) {
                if (eq.get(j).isAST(head, uFunction1Arg.size())) {
                    uArg1 = eq.get(j).first();
                    eq.remove(j);
                    continue;
                }
                ++j;
            }
            if (uArg1 != null) {
                IExpr[] result = new IExpr[]{uArg1, engine.evaluate(eq.oneIdentity0().negate())};
                return result;
            }
        }
        return null;
    }

    private IExpr linearODE(IExpr p, IExpr q, IExpr xVar, IExpr C_1, EvalEngine engine) {
        IExpr pInt = engine.evaluate(F.Exp(F.Integrate(p, xVar)));
        if (q.isZero()) {
            return engine.evaluate(F.Divide(C_1, pInt));
        }
        IExpr qInt = engine.evaluate(F.Plus(C_1, (IExpr)F.Expand(F.Integrate(F.Times((IExpr)F.CN1, q, pInt), xVar))));
        return engine.evaluate(F.Expand(F.Divide(qInt, pInt)));
    }

    private static IExpr odeSolve(EvalEngine engine, IExpr w, IExpr x, IExpr y, IExpr C_1) {
        IExpr n;
        IExpr m;
        IExpr f;
        IExpr[] p = DSolve.odeTransform(engine, w, x, y);
        if (p != null && (f = DSolve.odeSeparable(engine, m = p[0], n = p[1], x, y, C_1)).isPresent()) {
            return f;
        }
        return F.NIL;
    }

    private static IExpr[] odeTransform(EvalEngine engine, IExpr w, IExpr x, IExpr y) {
        IExpr v = S.Together.of(engine, w);
        IExpr numerator = S.Numerator.of(engine, v);
        IExpr dyx = S.D.of(engine, y, x);
        IExpr m = S.Coefficient.of(engine, numerator, dyx, F.C0);
        IExpr n = S.Coefficient.of(engine, numerator, dyx, F.C1);
        return new IExpr[]{m, n};
    }

    private static IExpr odeSeparable(EvalEngine engine, IExpr m, IExpr n, IExpr x, IExpr y, IExpr C_1) {
        if (n.isOne()) {
            IExpr yEquation;
            IExpr result;
            IExpr fxExpr = F.NIL;
            IExpr gyExpr = F.NIL;
            if (m.isFree(y)) {
                gyExpr = F.C1;
                fxExpr = m;
            } else if (m.isTimes()) {
                IAST timesAST = (IAST)m;
                IASTAppendable fx = F.TimesAlloc(timesAST.size());
                IASTAppendable gy = F.TimesAlloc(timesAST.size());
                timesAST.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
                    if (expr.isFree(y)) {
                        fx.append((IExpr)expr);
                    } else {
                        gy.append((IExpr)expr);
                    }
                }));
                fxExpr = engine.evaluate(fx);
                gyExpr = engine.evaluate(gy);
            }
            if (fxExpr.isPresent() && gyExpr.isPresent() && (result = Eliminate.extractVariable(yEquation = S.Subtract.of(engine, gyExpr = S.Integrate.of(engine, F.Divide(F.C1, gyExpr), y), fxExpr = S.Plus.of(engine, F.Integrate(F.Times((IExpr)F.CN1, fxExpr), x), C_1)), y, false, engine)).isPresent()) {
                return engine.evaluate(result);
            }
        }
        return F.NIL;
    }

    private static IExpr exactSolve(EvalEngine engine, IExpr m, IExpr n, IExpr x, IExpr y) {
        if (n.isZero()) {
            return F.NIL;
        }
        if (m.isZero()) {
            return F.Equal(y, (IExpr)S.CSymbol);
        }
        IExpr my = engine.evaluate(F.D(m, y));
        IExpr nx = engine.evaluate(F.D(n, x));
        IExpr d = engine.evaluate(F.Subtract(my, nx));
        IExpr u = F.NIL;
        if (d.isZero()) {
            u = F.C1;
        } else {
            IExpr f = engine.evaluate(F.Together(F.Divide(d, n)));
            if (f.isFree(y)) {
                u = engine.evaluate(F.Exp(F.Integrate(f, x)));
                d = F.C0;
            } else {
                IExpr g = engine.evaluate(F.Simplify(F.Divide(d.negate(), m)));
                if (g.isFree(x)) {
                    u = engine.evaluate(F.Exp(F.Integrate(g, y)));
                    d = F.C0;
                }
            }
        }
        if (d.isZero()) {
            IExpr g = engine.evaluate(F.Integrate(F.Times(u, m), x));
            IExpr hp = engine.evaluate(F.Subtract(F.Times(u, n), F.D(g, y)));
            IExpr h = engine.evaluate(F.Integrate(hp, y));
            return F.Equal(engine.evaluate(F.Plus(g, h)), (IExpr)S.CSymbol);
        }
        return F.NIL;
    }
}

