/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.BinaryBindIth1st;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Derivative;
import org.matheclipse.core.reflection.system.rules.DRules;

public class D
extends AbstractFunctionEvaluator
implements DRules {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    private static IExpr getDerivativeArg1(IExpr x, IExpr a1, IExpr head, EvalEngine engine) {
        if (head.isSymbol()) {
            ISymbol header = (ISymbol)head;
            IAST fDerivParam = Derivative.createDerivative(1, header, a1);
            if (x.equals(a1)) {
                return fDerivParam;
            }
            return F.Times((IExpr)F.D(a1, x), (IExpr)fDerivParam);
        }
        return F.NIL;
    }

    private static IExpr getDerivativeArgN(IExpr x, IAST ast, IExpr head) {
        IAST[] deriv = ast.isDerivative();
        int size = ast.size();
        if (deriv != null) {
            IASTAppendable plus = F.PlusAlloc(size);
            ast.forEach(size, (expr, i) -> plus.append(F.Times((IExpr)F.D(expr, x), (IExpr)D.addDerivative(i, deriv[0], deriv[1].arg1(), ast))));
            return plus;
        }
        if (head.isSymbol()) {
            IASTAppendable plus = F.PlusAlloc(size);
            ast.forEach(size, (expr, i) -> plus.append(F.Times((IExpr)F.D(expr, x), (IExpr)D.createDerivative(i, head, ast))));
            return plus;
        }
        return F.NIL;
    }

    private static IAST createDerivative(int pos, IExpr header, IAST args) {
        int size = args.size();
        IASTAppendable derivativeHead1 = F.ast((IExpr)S.Derivative, size);
        for (int i = 1; i < size; ++i) {
            derivativeHead1.append(i == pos ? F.C1 : F.C0);
        }
        IASTAppendable derivativeHead2 = F.ast(derivativeHead1);
        derivativeHead2.append(header);
        IASTAppendable derivativeAST = F.ast((IExpr)derivativeHead2, size);
        derivativeAST.appendArgs(args);
        return derivativeAST;
    }

    private static IAST addDerivative(int pos, IAST deriveHead, IExpr header, IAST args) {
        IASTAppendable derivativeHead1 = deriveHead.copyAppendable();
        for (int i2 = 1; i2 < derivativeHead1.size(); ++i2) {
            if (i2 != pos) continue;
            derivativeHead1.set(i2, derivativeHead1.get(i2).inc());
        }
        IASTAppendable derivativeHead2 = F.ast(derivativeHead1);
        derivativeHead2.append(header);
        IASTAppendable derivativeAST = F.ast((IExpr)derivativeHead2, args.size());
        derivativeAST.appendArgs(args.size(), i -> args.get(i));
        return derivativeAST;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.isAST1()) {
            return ast.arg1();
        }
        try {
            IExpr fx = ast.arg1();
            if (fx.isIndeterminate()) {
                return S.Indeterminate;
            }
            if (ast.size() > 3) {
                return ast.foldLeft((x, y) -> engine.evaluateNIL(F.D(x, y)), fx, 2);
            }
            IExpr x2 = ast.arg2();
            if (!x2.isVariable() && !x2.isList()) {
                return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
            }
            if (fx.isList()) {
                IAST list = (IAST)fx;
                return list.mapThreadEvaled(engine, F.ListAlloc(list.size()), ast, 1);
            }
            if (x2.isList()) {
                IAST xList = (IAST)x2;
                if (xList.isAST1() && xList.arg1().isListOfLists()) {
                    IAST subList = (IAST)xList.arg1();
                    IASTAppendable result = F.ListAlloc(subList.size());
                    result.appendArgs(subList.size(), i -> F.D(fx, F.list(subList.get(i))));
                    return result;
                }
                if (xList.isAST1() && xList.arg1().isList()) {
                    IAST subList = (IAST)xList.arg1();
                    return subList.mapLeft(F.ListAlloc(), (a, b) -> engine.evaluateNIL(F.D(a, b)), fx);
                }
                if (xList.isAST2()) {
                    if (ast.isEvalFlagOn(32768)) {
                        return F.NIL;
                    }
                    x2 = xList.arg1().isList() ? F.list(xList.arg1()) : xList.arg1();
                    IExpr arg2 = xList.arg2();
                    int n = arg2.toIntDefault();
                    if (n >= 0) {
                        IExpr temp = fx;
                        for (int i2 = 0; i2 < n; ++i2) {
                            if ((temp = S.D.ofNIL(engine, temp, x2)).isPresent()) continue;
                            return F.NIL;
                        }
                        return temp;
                    }
                    if (arg2.isFree(num -> num.isNumber(), false)) {
                        IAST function;
                        if (fx instanceof ASTSeriesData) {
                            return F.NIL;
                        }
                        if (fx.isFree(x2, true)) {
                            return F.Piecewise(F.list(F.list(fx, F.Equal(arg2, (IExpr)F.C0))), F.C0);
                        }
                        if (fx.equals(x2)) {
                            return F.Piecewise(F.list(F.list(fx, F.Equal(arg2, (IExpr)F.C0)), F.list(F.C1, F.Equal(arg2, (IExpr)F.C1))), F.C0);
                        }
                        if (fx.isAST() && (function = (IAST)fx).isPlus()) {
                            return function.mapThread(F.D(F.Slot1, xList), 1);
                        }
                        return F.NIL;
                    }
                    if (!x2.isVariable()) {
                        return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
                    }
                    if (arg2.isAST()) {
                        return F.NIL;
                    }
                    return IOFunctions.printMessage(ast.topHead(), "dvar", F.list(xList), engine);
                }
                return F.NIL;
            }
            if (!x2.isVariable()) {
                return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
            }
            return D.binaryD(fx, x2, ast, engine);
        }
        catch (ValidateException ve) {
            LOGGER.log(engine.getLogLevel(), ve.getMessage(ast.topHead()), (Throwable)((Object)ve));
            return F.NIL;
        }
    }

    private static IExpr binaryD(IExpr functionOfX, IExpr x, IAST ast, EvalEngine engine) {
        int[] dim = functionOfX.isPiecewise();
        if (dim != null) {
            return D.dPiecewise(dim, (IAST)functionOfX, ast, engine);
        }
        if (functionOfX instanceof ASTSeriesData) {
            ASTSeriesData series = (ASTSeriesData)functionOfX;
            if (series.getX().equals(x)) {
                ASTSeriesData temp = ((ASTSeriesData)functionOfX).derive(x);
                if (temp != null) {
                    return temp;
                }
                return F.NIL;
            }
            return F.C0;
        }
        if (functionOfX.isFree(x, true)) {
            return F.C0;
        }
        if (functionOfX.isNumber()) {
            return F.C0;
        }
        if (functionOfX.equals(x)) {
            return F.C1;
        }
        if (functionOfX.isAST()) {
            IAST function = (IAST)functionOfX;
            IExpr header = function.head();
            if (function.isPlus()) {
                IASTMutable result = function.mapThread(F.D(F.Slot1, x), 1);
                return engine.evaluate(result);
            }
            if (function.isTimes()) {
                return function.map(F.PlusAlloc(16), new BinaryBindIth1st(function, F.D(S.Null, x)));
            }
            if (function.isPower()) {
                IExpr f = function.base();
                IExpr g = function.exponent();
                if (g.isFree(x)) {
                    return F.Times(g, (IExpr)F.D(f, x), (IExpr)F.Power(f, g.dec()));
                }
                if (f.isFree(x)) {
                    if (f.isE()) {
                        return F.Times((IExpr)F.D(g, x), (IExpr)F.Exp(g));
                    }
                    return F.Times((IExpr)F.D(g, x), (IExpr)F.Log(f), (IExpr)F.Power(f, g));
                }
                IASTAppendable resultList = F.TimesAlloc(2);
                resultList.append(F.Power(f, g));
                resultList.append(F.Plus((IExpr)F.Times(g, (IExpr)F.D(f, x), (IExpr)F.Power(f, F.CN1)), (IExpr)F.Times((IExpr)F.Log(f), (IExpr)F.D(g, x))));
                return resultList;
            }
            if (function.isAST(S.Surd, 3)) {
                IExpr f = function.base();
                if (function.exponent().isInteger()) {
                    IInteger g = (IInteger)function.exponent();
                    if (g.isMinusOne()) {
                        return F.Times((IExpr)F.CN1, (IExpr)F.D(f, x), (IExpr)F.Power(f, F.CN2));
                    }
                    IRational gInverse = g.inverse();
                    if (g.isNegative()) {
                        if (g.isEven()) {
                            return F.Times((IExpr)gInverse, (IExpr)F.D(f, x), (IExpr)F.Power((IExpr)F.Surd(f, g.negate()), g.dec()));
                        }
                        return F.Times(gInverse, F.D(f, x), F.Power(f, F.CN1), F.Power((IExpr)F.Surd(f, g.negate()), F.CN1));
                    }
                    return F.Times((IExpr)gInverse, (IExpr)F.D(f, x), (IExpr)F.Power((IExpr)F.Surd(f, g), g.dec().negate()));
                }
            } else if (header == S.Log && function.isAST2()) {
                if (function.isFreeAt(1, x)) {
                    return F.Times((IExpr)F.Power((IExpr)F.Times(function.arg2(), (IExpr)F.Log(function.arg1())), F.CN1), (IExpr)F.D(function.arg2(), x));
                }
            } else {
                if (function.isAST1() && ast.isEvalFlagOff(32768)) {
                    IAST[] derivStruct = function.isDerivativeAST1();
                    if (derivStruct != null && derivStruct[2] != null) {
                        IAST headAST = derivStruct[1];
                        IAST a1Head = derivStruct[0];
                        if (a1Head.isAST1() && a1Head.arg1().isInteger()) {
                            try {
                                int n = ((IInteger)a1Head.arg1()).toInt();
                                IExpr arg1 = function.arg1();
                                if (n > 0) {
                                    IAST fDerivParam = Derivative.createDerivative(n + 1, headAST.arg1(), arg1);
                                    if (x.equals(arg1)) {
                                        return fDerivParam;
                                    }
                                    return F.Times((IExpr)F.D(arg1, x), (IExpr)fDerivParam);
                                }
                            }
                            catch (ArithmeticException arithmeticException) {
                                // empty catch block
                            }
                        }
                        return F.NIL;
                    }
                    return D.getDerivativeArg1(x, function.arg1(), header, engine);
                }
                if (function.isAST() && ast.isEvalFlagOff(32768)) {
                    return D.getDerivativeArgN(x, function, header);
                }
            }
        }
        return F.NIL;
    }

    private static IExpr dPiecewise(int[] dim, IAST piecewiseFunction, IAST ast, EvalEngine engine) {
        IAST list = (IAST)piecewiseFunction.arg1();
        if (list.size() > 1) {
            IASTAppendable pwResult = F.ListAlloc(list.size());
            for (int i = 1; i < list.size(); ++i) {
                IASTMutable piecewiseD = ast.copy();
                piecewiseD.set(1, list.get(i).first());
                pwResult.append(F.list(piecewiseD, list.get(i).second()));
            }
            if (piecewiseFunction.size() > 2) {
                IASTMutable piecewiseD = ast.copy();
                piecewiseD.set(1, piecewiseFunction.arg2());
                pwResult.append(F.list(engine.evaluate(piecewiseD), S.True));
            }
            IASTMutable piecewise = piecewiseFunction.copy();
            piecewise.set(1, pwResult);
            if (piecewise.size() > 2) {
                piecewise.set(2, S.Indeterminate);
            }
            return piecewise;
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return ARGS_1_INFINITY;
    }
}

