/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.List;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorExpr;

public class ComplexExpand
extends AbstractEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IAST temp = StructureFunctions.threadLogicEquationOperators(ast.arg1(), ast, 1);
        if (temp.isPresent()) {
            return temp;
        }
        IAssumptions oldAssumptions = engine.getAssumptions();
        try {
            IAssumptions assumptions;
            IExpr arg1 = ast.arg1();
            IAST arg2 = F.NIL;
            if (ast.isAST2()) {
                arg2 = ast.arg2().isList() ? (IAST)ast.arg2() : F.list(ast.arg2());
            }
            VariablesSet eVar = new VariablesSet(arg1);
            List<IExpr> varList = eVar.getVarList().copyTo();
            IASTAppendable assumptionExpr = F.ListAlloc(varList.size() + 1);
            for (int i = 0; i < varList.size(); ++i) {
                IExpr variable = varList.get(i);
                if (arg2.isPresent()) {
                    boolean hasMatched = false;
                    for (int j = 1; j < arg2.size(); ++j) {
                        if (!S.MatchQ.ofQ(variable, arg2.get(j))) continue;
                        hasMatched = true;
                        break;
                    }
                    if (hasMatched) continue;
                }
                assumptionExpr.append(F.Element(variable, S.Reals));
            }
            if (oldAssumptions == null) {
                assumptions = Assumptions.getInstance(assumptionExpr);
            } else {
                assumptions = oldAssumptions.copy();
                assumptions = assumptions.addAssumption(assumptionExpr);
            }
            engine.setAssumptions(assumptions);
            ComplexExpandVisitor tteVisitor = new ComplexExpandVisitor(engine);
            IExpr result = arg1.accept(tteVisitor);
            if (result.isPresent()) {
                IExpr iExpr = result;
                return iExpr;
            }
            IExpr iExpr = arg1;
            return iExpr;
        }
        finally {
            engine.setAssumptions(oldAssumptions);
        }
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    static class ComplexExpandVisitor
    extends VisitorExpr {
        final EvalEngine fEngine;

        public ComplexExpandVisitor(EvalEngine engine) {
            this.fEngine = engine;
        }

        @Override
        public IExpr visit(IASTMutable ast) {
            IExpr base;
            IExpr expanded;
            if (ast.isTimes() && (expanded = F.evalExpand(ast)).isPlus()) {
                return S.ComplexExpand.of(this.fEngine, expanded);
            }
            if (ast.isPower() && ast.exponent().isRational() && (base = ast.base()).isInteger() && ast.base().isNegative()) {
                IExpr exponent = ast.exponent();
                IAST coeff = F.Power((IExpr)F.Power(base, F.C2), F.C1D2.times(exponent));
                IExpr inner = exponent.times(F.Arg(base));
                IExpr temp = S.Expand.of(this.fEngine, F.Plus((IExpr)F.Times((IExpr)coeff, (IExpr)F.Cos(inner)), (IExpr)F.Times((IExpr)F.CI, (IExpr)coeff, (IExpr)F.Sin(inner))));
                return temp;
            }
            return super.visit(ast);
        }

        @Override
        public IExpr visit2(IExpr head, IExpr arg1) {
            IExpr x = arg1;
            IExpr result = arg1.accept(this);
            if (result.isPresent()) {
                x = result;
            }
            IExpr reX = S.Re.of(this.fEngine, x);
            IExpr imX = S.Im.of(this.fEngine, x);
            IAST z = F.Plus(reX, (IExpr)F.Times((IExpr)F.CI, imX));
            if (head.equals(S.Abs)) {
                return F.Sqrt(F.Plus((IExpr)F.Power(reX, F.C2), (IExpr)F.Power(imX, F.C2)));
            }
            if (head.equals(S.Cos)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Cos(reX), (IExpr)F.Cosh(imX)), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sin(reX), (IExpr)F.Sinh(imX)));
            }
            if (head.equals(S.Cot)) {
                return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sin(F.Times((IExpr)F.C2, reX)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), F.Negate(F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sinh(F.Times((IExpr)F.C2, imX)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), F.Negate(F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)));
            }
            if (head.equals(S.Csc)) {
                return F.Plus((IExpr)F.Times(F.CN2, F.Cosh(imX), F.Sin(reX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)), (IExpr)F.Times(F.C2, F.CI, F.Cos(reX), F.Sinh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)));
            }
            if (head.equals(S.Sec)) {
                return F.Plus((IExpr)F.Times(F.C2, F.Cos(reX), F.Cosh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)), (IExpr)F.Times(F.C2, F.CI, F.Sin(reX), F.Sinh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)));
            }
            if (head.equals(S.ProductLog)) {
                IAST productLog = F.ProductLog(F.Plus(reX, (IExpr)F.Times((IExpr)F.CI, imX)));
                return F.Plus((IExpr)F.Times((IExpr)F.CI, F.Im(productLog)), F.Re(productLog));
            }
            if (head.equals(S.Sin)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Cosh(imX), (IExpr)F.Sin(reX)), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sinh(imX), (IExpr)F.Cos(reX)));
            }
            if (head.equals(S.ArcTan)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.Arg(F.Subtract(F.C1, F.Distribute(F.Times((IExpr)F.CI, (IExpr)z)))))), (IExpr)F.Times((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Arg(F.Plus((IExpr)F.C1, (IExpr)F.Distribute(F.Times((IExpr)F.CI, (IExpr)z)))))), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.Times((IExpr)F.CN1D4, (IExpr)F.Log(F.Plus((IExpr)F.Sqr(reX), (IExpr)F.Power((IExpr)F.Subtract(F.C1, imX), F.C2))))), (IExpr)F.Times((IExpr)F.Times((IExpr)F.C1D4, (IExpr)F.Log(F.Plus((IExpr)F.Sqr(reX), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, imX), F.C2))))))));
            }
            if (head.equals(S.Tan)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Sin(F.Times((IExpr)F.C2, reX)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sinh(F.Times((IExpr)F.C2, imX)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)));
            }
            if (result.isPresent()) {
                return F.unaryAST1(head, result);
            }
            return F.NIL;
        }
    }
}

