/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.symbolicexponent;

import edu.jas.kern.Scripting;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.symbolicexponent.ExpVectorSymbolic;

public final class SymbolicTermOrder
implements Serializable {
    private static final long serialVersionUID = 360644493672021694L;
    private final boolean debug = false;
    public static final int LEX = 1;
    public static final int MIN_EVORD = 1;
    public static final int INVLEX = 2;
    public static final int GRLEX = 3;
    public static final int IGRLEX = 4;
    public static final int REVLEX = 5;
    public static final int REVILEX = 6;
    public static final int REVTDEG = 7;
    public static final int REVITDG = 8;
    public static final int ITDEGLEX = 9;
    public static final int REVITDEG = 10;
    public static final int MAX_EVORD = 10;
    public static final int DEFAULT_EVORD = 4;
    private final int evord;
    private final int evord2;
    private final int evbeg1;
    private final int evend1;
    private final int evbeg2;
    private final int evend2;
    private final IExpr[][] weight;
    private final EVComparator horder;
    private final EVComparator lorder;
    private final EVComparator sugar;

    public SymbolicTermOrder() {
        this(4);
    }

    public SymbolicTermOrder(int evord) {
        if (evord < 1 || 10 < evord) {
            throw new IllegalArgumentException("invalid term order: " + evord);
        }
        this.evord = evord;
        this.evord2 = 0;
        this.weight = null;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = Integer.MAX_VALUE;
        this.evend2 = this.evend1;
        switch (evord) {
            case 1: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return ExpVectorSymbolic.EVILCP(e1, e2);
                    }
                };
                break;
            }
            case 2: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return -ExpVectorSymbolic.EVILCP(e1, e2);
                    }
                };
                break;
            }
            case 3: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return ExpVectorSymbolic.EVIGLC(e1, e2);
                    }
                };
                break;
            }
            case 4: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return -ExpVectorSymbolic.EVIGLC(e1, e2);
                    }
                };
                break;
            }
            case 5: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return ExpVectorSymbolic.EVRILCP(e1, e2);
                    }
                };
                break;
            }
            case 6: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return -ExpVectorSymbolic.EVRILCP(e1, e2);
                    }
                };
                break;
            }
            case 7: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return ExpVectorSymbolic.EVRIGLC(e1, e2);
                    }
                };
                break;
            }
            case 8: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return -ExpVectorSymbolic.EVRIGLC(e1, e2);
                    }
                };
                break;
            }
            case 9: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return -ExpVectorSymbolic.EVITDEGLC(e1, e2);
                    }
                };
                break;
            }
            case 10: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                        return ExpVectorSymbolic.EVRLITDEGC(e1, e2);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid term order: " + evord);
            }
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return -SymbolicTermOrder.this.horder.compare(e1, e2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return ExpVectorSymbolic.EVIGLC(e1, e2);
            }
        };
    }

    public SymbolicTermOrder(IExpr[] w) {
        this(new IExpr[][]{w});
    }

    public SymbolicTermOrder(IExpr[][] w) {
        if (w == null || w.length == 0) {
            throw new IllegalArgumentException("invalid term order weight");
        }
        this.weight = (IExpr[][])Arrays.copyOf(w, w.length);
        this.evord = 0;
        this.evord2 = 0;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = this.weight[0].length;
        this.evend2 = this.evend1;
        this.horder = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return -ExpVectorSymbolic.EVIWLC(SymbolicTermOrder.this.weight, e1, e2);
            }
        };
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return ExpVectorSymbolic.EVIWLC(SymbolicTermOrder.this.weight, e1, e2);
            }
        };
        this.sugar = this.horder;
    }

    public SymbolicTermOrder(int ev1, int ev2, int r, int split) {
        if (ev1 < 1 || 8 < ev1) {
            throw new IllegalArgumentException("invalid split term order 1: " + ev1);
        }
        if (ev2 < 1 || 8 < ev2) {
            throw new IllegalArgumentException("invalid split term order 2: " + ev2);
        }
        this.evord = ev1;
        this.evord2 = ev2;
        this.weight = null;
        this.evbeg1 = 0;
        this.evend1 = split;
        this.evbeg2 = split;
        this.evend2 = r;
        if (this.evbeg2 < 0 || this.evbeg2 > this.evend2) {
            throw new IllegalArgumentException("invalid term order split, r = " + r + ", split = " + split);
        }
        block0 : switch (this.evord) {
            case 1: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 2: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 3: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 4: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 5: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 6: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 7: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 8: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRILCP(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                                int t = -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg1, SymbolicTermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVectorSymbolic.EVRIGLC(e1, e2, SymbolicTermOrder.this.evbeg2, SymbolicTermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + this.evord + " 2 " + this.evord2);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return -SymbolicTermOrder.this.horder.compare(e1, e2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVectorSymbolic e1, ExpVectorSymbolic e2) {
                return ExpVectorSymbolic.EVIGLC(e1, e2);
            }
        };
    }

    public SymbolicTermOrder blockOrder(int s) {
        return this.blockOrder(s, Integer.MAX_VALUE);
    }

    public SymbolicTermOrder blockOrder(int s, int len) {
        return new SymbolicTermOrder(this.evord, this.evord, len, s);
    }

    public SymbolicTermOrder blockOrder(int s, SymbolicTermOrder t) {
        return this.blockOrder(s, t, Integer.MAX_VALUE);
    }

    public SymbolicTermOrder blockOrder(int s, SymbolicTermOrder t, int len) {
        return new SymbolicTermOrder(this.evord, t.evord, len, s);
    }

    public int getEvord() {
        return this.evord;
    }

    public int getEvord2() {
        return this.evord2;
    }

    public int getSplit() {
        return this.evend1;
    }

    public IExpr[][] getWeight() {
        if (this.weight == null) {
            return null;
        }
        return (IExpr[][])Arrays.copyOf(this.weight, this.weight.length);
    }

    public EVComparator getDescendComparator() {
        return this.horder;
    }

    public EVComparator getAscendComparator() {
        return this.lorder;
    }

    public EVComparator getSugarComparator() {
        return this.sugar;
    }

    public boolean equals(Object B) {
        boolean t;
        if (!(B instanceof SymbolicTermOrder)) {
            return false;
        }
        SymbolicTermOrder b = (SymbolicTermOrder)B;
        boolean bl = t = this.evord == b.getEvord() && this.evord2 == b.evord2 && this.evbeg1 == b.evbeg1 && this.evend1 == b.evend1 && this.evbeg2 == b.evbeg2 && this.evend2 == b.evend2;
        if (!t) {
            return t;
        }
        return Arrays.deepEquals((Object[])this.weight, (Object[])b.weight);
    }

    public int hashCode() {
        int h = this.evord;
        h = (h << 3) + this.evord2;
        h = (h << 4) + this.evbeg1;
        h = (h << 4) + this.evend1;
        h = (h << 4) + this.evbeg2;
        h = (h << 4) + this.evend2;
        if (this.weight == null) {
            return h;
        }
        h = h * 7 + Arrays.deepHashCode((Object[])this.weight);
        return h;
    }

    public String weightToString() {
        StringBuilder erg = new StringBuilder();
        if (this.weight != null) {
            erg.append("(");
            for (int j = 0; j < this.weight.length; ++j) {
                if (j > 0) {
                    erg.append(",");
                }
                IExpr[] wj = this.weight[j];
                erg.append("(");
                for (int i = 0; i < wj.length; ++i) {
                    if (i > 0) {
                        erg.append(",");
                    }
                    erg.append(String.valueOf(wj[wj.length - 1 - i]));
                }
                erg.append(")");
            }
            erg.append(")");
        }
        return erg.toString();
    }

    public String weightToScript() {
        StringBuilder erg = new StringBuilder();
        if (this.weight != null) {
            erg.append("[");
            for (int j = 0; j < this.weight.length; ++j) {
                if (j > 0) {
                    erg.append(",");
                }
                IExpr[] wj = this.weight[j];
                erg.append("[");
                for (int i = 0; i < wj.length; ++i) {
                    if (i > 0) {
                        erg.append(",");
                    }
                    erg.append(String.valueOf(wj[wj.length - 1 - i]));
                }
                erg.append("]");
            }
            erg.append("]");
        }
        return erg.toString();
    }

    public String toScript() {
        if (this.weight != null) {
            StringBuilder erg = new StringBuilder();
            erg.append(this.weightToScript());
            if (this.evend1 == this.evend2) {
                return erg.toString();
            }
            erg.append("[" + this.evbeg1 + "," + this.evend1 + "]");
            erg.append("[" + this.evbeg2 + "," + this.evend2 + "]");
            return erg.toString();
        }
        return this.toScriptPlain();
    }

    public String toString() {
        if (this.weight != null) {
            StringBuilder erg = new StringBuilder();
            erg.append("W( ");
            erg.append(this.weightToString());
            if (this.evend1 == this.evend2) {
                erg.append(" )");
                return erg.toString();
            }
            erg.append("[" + this.evbeg1 + "," + this.evend1 + "]");
            erg.append("[" + this.evbeg2 + "," + this.evend2 + "]");
            erg.append(" )");
            return erg.toString();
        }
        return this.toStringPlain();
    }

    public String toStringPlain() {
        StringBuilder erg = new StringBuilder();
        if (this.weight != null) {
            return erg.toString();
        }
        erg.append(this.toScriptOrder(this.evord));
        if (this.evord2 <= 0) {
            return erg.toString();
        }
        erg.append("[" + this.evbeg1 + "," + this.evend1 + "]");
        erg.append(this.toScriptOrder(this.evord2));
        erg.append("[" + this.evbeg2 + "," + this.evend2 + "]");
        return erg.toString();
    }

    public String toScriptPlain() {
        StringBuilder erg = new StringBuilder();
        if (this.weight != null) {
            return this.toScript();
        }
        erg.append("Order");
        switch (Scripting.getLang()) {
            case Ruby: {
                erg.append("::");
                break;
            }
            default: {
                erg.append(".");
            }
        }
        erg.append(this.toScriptOrder(this.evord));
        if (this.evord2 <= 0) {
            return erg.toString();
        }
        if (this.evord == this.evord2) {
            erg.append(".blockOrder(" + this.evend1 + ")");
            return erg.toString();
        }
        erg.append(".blockOrder(");
        erg.append(this.evend1 + ",");
        erg.append("Order");
        switch (Scripting.getLang()) {
            case Ruby: {
                erg.append("::");
                break;
            }
            default: {
                erg.append(".");
            }
        }
        erg.append(this.toScriptOrder(this.evord2));
        erg.append(")");
        return erg.toString();
    }

    public String toScriptOrder(int ev) {
        switch (Scripting.getCAS()) {
            case Math: {
                switch (ev) {
                    case 1: {
                        return "NegativeReverseLexicographic";
                    }
                    case 2: {
                        return "ReverseLexicographic";
                    }
                    case 3: {
                        return "NegativeDegreeReverseLexicographic";
                    }
                    case 9: {
                        return "DegreeReverseLexicographic";
                    }
                    case 5: {
                        return "NegativeLexicographic";
                    }
                    case 6: {
                        return "Lexicographic";
                    }
                    case 10: {
                        return "NegativeDegreeLexicographic";
                    }
                    case 8: {
                        return "DegreeLexicographic";
                    }
                }
                return "invalid(" + ev + ")";
            }
            case Sage: {
                switch (ev) {
                    case 1: {
                        return "negrevlex";
                    }
                    case 2: {
                        return "invlex";
                    }
                    case 3: {
                        return "negdegrevlex";
                    }
                    case 9: {
                        return "degrevlex";
                    }
                    case 5: {
                        return "neglex";
                    }
                    case 6: {
                        return "lex";
                    }
                    case 10: {
                        return "negdeglex";
                    }
                    case 8: {
                        return "deglex";
                    }
                }
                return "invalid(" + ev + ")";
            }
            case Singular: {
                switch (ev) {
                    case 2: {
                        return "rp";
                    }
                    case 3: {
                        return "ds";
                    }
                    case 9: {
                        return "dp";
                    }
                    case 5: {
                        return "ls";
                    }
                    case 6: {
                        return "lp";
                    }
                    case 10: {
                        return "Ds";
                    }
                    case 8: {
                        return "Dp";
                    }
                }
                return "invalid(" + ev + ")";
            }
        }
        switch (ev) {
            case 1: {
                return "LEX";
            }
            case 2: {
                return "INVLEX";
            }
            case 3: {
                return "GRLEX";
            }
            case 4: {
                return "IGRLEX";
            }
            case 5: {
                return "REVLEX";
            }
            case 6: {
                return "REVILEX";
            }
            case 7: {
                return "REVTDEG";
            }
            case 8: {
                return "REVITDG";
            }
            case 9: {
                return "ITDEGLEX";
            }
            case 10: {
                return "REVITDEG";
            }
        }
        return "invalid(" + ev + ")";
    }

    public SymbolicTermOrder extend(int r, int k) {
        if (this.weight != null) {
            IExpr[][] w = new IExpr[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                IExpr[] wi = this.weight[i];
                IExpr max = F.C0;
                for (int j = 0; j < wi.length; ++j) {
                    if (!S.Greater.ofQ(wi[j], max)) continue;
                    max = wi[j];
                }
                max = max.inc();
                IExpr[] wj = new IExpr[wi.length + k];
                for (int j = 0; j < i; ++j) {
                    wj[j] = max;
                }
                System.arraycopy(wi, 0, wj, i, wi.length);
                w[i] = wj;
            }
            return new SymbolicTermOrder(w);
        }
        if (this.evord2 != 0) {
            return new SymbolicTermOrder(this.evord, this.evord2, r + k, this.evend1 + k);
        }
        return new SymbolicTermOrder(4, this.evord, r + k, k);
    }

    public SymbolicTermOrder extendLower(int r, int k) {
        if (this.weight != null) {
            IExpr[][] w = new IExpr[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                IExpr[] wi = this.weight[i];
                IExpr min = F.CInfinity;
                for (int j = 0; j < wi.length; ++j) {
                    if (!S.Less.ofQ(wi[j], min)) continue;
                    min = wi[j];
                }
                IExpr[] wj = new IExpr[wi.length + k];
                for (int j = 0; j < i; ++j) {
                    wj[wi.length + j] = min;
                }
                System.arraycopy(wi, 0, wj, 0, wi.length);
                w[i] = wj;
            }
            return new SymbolicTermOrder(w);
        }
        if (this.evord2 != 0) {
            return new SymbolicTermOrder(this.evord, this.evord2, r + k, this.evend1 + k);
        }
        return new SymbolicTermOrder(this.evord);
    }

    public SymbolicTermOrder contract(int k, int len) {
        if (this.weight != null) {
            IExpr[][] w = new IExpr[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                IExpr[] wi = this.weight[i];
                IExpr[] wj = new IExpr[len];
                System.arraycopy(wi, k, wj, 0, len);
                w[i] = wj;
            }
            return new SymbolicTermOrder(w);
        }
        if (this.evord2 == 0) {
            return new SymbolicTermOrder(this.evord);
        }
        if (this.evend1 > k) {
            int el;
            for (el = this.evend1 - k; el > len; el -= len) {
            }
            if ((long)el == 0L) {
                return new SymbolicTermOrder(this.evord);
            }
            if (el == len) {
                return new SymbolicTermOrder(this.evord);
            }
            return new SymbolicTermOrder(this.evord, this.evord2, len, el);
        }
        return new SymbolicTermOrder(this.evord2);
    }

    public SymbolicTermOrder reverse() {
        return this.reverse(false);
    }

    public SymbolicTermOrder reverse(boolean partial) {
        if (this.weight != null) {
            if (partial) {
                // empty if block
            }
            IExpr[][] w = new IExpr[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                IExpr[] wi = this.weight[i];
                IExpr[] wj = new IExpr[wi.length];
                for (int j = 0; j < wj.length; ++j) {
                    wj[j] = wi[wj.length - 1 - j];
                }
                w[i] = wj;
            }
            SymbolicTermOrder t = new SymbolicTermOrder(w);
            return t;
        }
        if (this.evord2 == 0) {
            SymbolicTermOrder t = new SymbolicTermOrder(SymbolicTermOrder.revert(this.evord));
            return t;
        }
        SymbolicTermOrder t = partial ? new SymbolicTermOrder(SymbolicTermOrder.revert(this.evord), SymbolicTermOrder.revert(this.evord2), this.evend2, this.evend1) : new SymbolicTermOrder(SymbolicTermOrder.revert(this.evord2), SymbolicTermOrder.revert(this.evord), this.evend2, this.evend2 - this.evbeg2);
        return t;
    }

    public static int revert(int evord) {
        int i = evord;
        switch (evord) {
            case 1: {
                i = 5;
                break;
            }
            case 2: {
                i = 6;
                break;
            }
            case 3: {
                i = 7;
                break;
            }
            case 4: {
                i = 8;
                break;
            }
            case 5: {
                i = 1;
                break;
            }
            case 6: {
                i = 2;
                break;
            }
            case 7: {
                i = 3;
                break;
            }
            case 8: {
                i = 4;
                break;
            }
        }
        return i;
    }

    public static IExpr[] longArrayPermutation(List<Integer> P, IExpr[] a) {
        if (a == null || a.length <= 1) {
            return a;
        }
        IExpr[] b = new IExpr[a.length];
        int j = 0;
        for (Integer i : P) {
            b[j] = a[i];
            ++j;
        }
        return b;
    }

    public SymbolicTermOrder permutation(List<Integer> P) {
        IExpr[][] weight;
        SymbolicTermOrder tord = this;
        if (this.getEvord2() != 0) {
            tord = new SymbolicTermOrder(this.getEvord2());
        }
        if ((weight = this.getWeight()) != null) {
            IExpr[][] w = new IExpr[weight.length][];
            for (int i = 0; i < weight.length; ++i) {
                w[i] = SymbolicTermOrder.longArrayPermutation(P, weight[i]);
            }
            tord = new SymbolicTermOrder(w);
        }
        return tord;
    }

    public static SymbolicTermOrder reverseWeight(IExpr[][] w) {
        if (w == null) {
            return new SymbolicTermOrder();
        }
        IExpr[][] wr = new IExpr[w.length][];
        for (int j = 0; j < w.length; ++j) {
            IExpr[] wj = w[j];
            IExpr[] wrj = new IExpr[wj.length];
            for (int i = 0; i < wj.length; ++i) {
                wrj[i] = wj[wj.length - 1 - i];
            }
            wr[j] = wrj;
        }
        return new SymbolicTermOrder(wr);
    }

    public static abstract class EVComparator
    implements Comparator<ExpVectorSymbolic> {
        @Override
        public abstract int compare(ExpVectorSymbolic var1, ExpVectorSymbolic var2);
    }
}

