/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.symbolicexponent;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.LongIterable;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.longexponent.ExpVectorLong;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.polynomials.symbolicexponent.ExpVectorSymbolic;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicPolynomial;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicTermOrder;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicTermOrderByName;

public class SymbolicPolynomialRing
implements RingFactory<SymbolicPolynomial> {
    private static final long serialVersionUID = -6136386786501333693L;
    public final ExprRingFactory coFac;
    public final int nvar;
    public final SymbolicTermOrder tord;
    protected boolean partial;
    protected IAST vars;
    public final SymbolicPolynomial ZERO;
    public final SymbolicPolynomial ONE;
    public final ExpVectorSymbolic evzero;
    protected static final ThreadLocalRandom random = ThreadLocalRandom.current();
    protected int isField = -1;
    final boolean numericFunction;

    public SymbolicPolynomialRing(IAST listOfVariables) {
        this(ExprRingFactory.CONST, listOfVariables, listOfVariables.argSize(), SymbolicTermOrderByName.Lexicographic);
    }

    public SymbolicPolynomialRing(IAST listOfVariables, SymbolicTermOrder t) {
        this(ExprRingFactory.CONST, listOfVariables, listOfVariables.argSize(), t);
    }

    public SymbolicPolynomialRing(ISymbol symbol) {
        this(ExprRingFactory.CONST, F.list(symbol), 1, SymbolicTermOrderByName.Lexicographic);
    }

    public SymbolicPolynomialRing(ISymbol symbol, SymbolicTermOrder t) {
        this(ExprRingFactory.CONST, F.list(symbol), 1, t);
    }

    public SymbolicPolynomialRing(ExprRingFactory cf, IAST listOfVariables) {
        this(cf, listOfVariables, listOfVariables.argSize(), SymbolicTermOrderByName.Lexicographic);
    }

    public SymbolicPolynomialRing(ExprRingFactory cf, IAST listOfVariables, SymbolicTermOrder t) {
        this(cf, listOfVariables, listOfVariables.argSize(), t);
    }

    private SymbolicPolynomialRing(ExprRingFactory cf, IAST listOfVariables, int n, SymbolicTermOrder t) {
        this(cf, listOfVariables, n, t, false);
    }

    public SymbolicPolynomialRing(ExprRingFactory cf, IAST listOfVariables, int n, SymbolicTermOrder t, boolean numericFunction) {
        this.coFac = cf;
        this.nvar = n;
        this.tord = t;
        this.partial = false;
        this.vars = listOfVariables.copyAppendable();
        this.ZERO = new SymbolicPolynomial(this);
        IExpr coeff = this.coFac.getONE();
        this.evzero = new ExpVectorSymbolic(this.nvar);
        this.numericFunction = numericFunction;
        this.ONE = new SymbolicPolynomial(this, coeff, this.evzero);
        if (this.vars.argSize() != this.nvar) {
            throw new IllegalArgumentException("incompatible variable size " + this.vars.size() + ", " + this.nvar);
        }
    }

    public SymbolicPolynomialRing(ExprRingFactory cf, SymbolicPolynomialRing o) {
        this(cf, o.vars, o.nvar, o.tord);
    }

    public SymbolicPolynomialRing(SymbolicPolynomialRing o, SymbolicTermOrder to) {
        this(o.coFac, o.vars, o.nvar, to);
    }

    public SymbolicPolynomialRing copy() {
        return new SymbolicPolynomialRing(this.coFac, this);
    }

    public SymbolicPolynomial create(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        return this.create(exprPoly, false, true, false);
    }

    public SymbolicPolynomial create(IExpr exprPoly, boolean coefficient, boolean checkNegativeExponents, boolean coefficientListMode) throws ArithmeticException, ClassCastException {
        int ix = ExpVectorSymbolic.indexVar(exprPoly, this.getVars());
        if (ix >= 0) {
            ExpVectorSymbolic e = new ExpVectorSymbolic(this.vars.argSize(), ix, F.C1);
            return this.getOne().multiply(e);
        }
        if (exprPoly instanceof IAST) {
            IExpr base;
            IAST ast = (IAST)exprPoly;
            SymbolicPolynomial result = this.getZero();
            SymbolicPolynomial p = this.getZero();
            if (ast.isPlus()) {
                IExpr expr = ast.arg1();
                result = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = ast.arg1();
                result = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower() && (ix = ExpVectorSymbolic.indexVar(base = ast.base(), this.getVars())) >= 0) {
                IExpr exponent = ast.exponent();
                if (checkNegativeExponents && (!exponent.isInteger() || exponent.isNegative())) {
                    throw new ArithmeticException("SymbolicPolynomialRing - invalid exponent: " + ast.arg2().toString());
                }
                if (exponent.isNegative() && coefficientListMode) {
                    return new SymbolicPolynomial(this, ast);
                }
                ExpVectorSymbolic e = new ExpVectorSymbolic(this.vars.argSize(), ix, exponent);
                return this.getOne().multiply(e);
            }
            if (coefficient) {
                return new SymbolicPolynomial(this, ast);
            }
            if (this.numericFunction && ast.isNumericFunction(true)) {
                return new SymbolicPolynomial(this, ast);
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                if (coefficient) {
                    return new SymbolicPolynomial(this, exprPoly);
                }
                if (this.numericFunction) {
                    if (exprPoly.isNumericFunction(true)) {
                        return new SymbolicPolynomial(this, exprPoly);
                    }
                    throw new ClassCastException(exprPoly.toString());
                }
                return new SymbolicPolynomial(this, exprPoly);
            }
            if (exprPoly.isNumber()) {
                return new SymbolicPolynomial(this, exprPoly);
            }
        }
        if (exprPoly.isFree(Predicates.in(this.vars), true)) {
            return new SymbolicPolynomial(this, exprPoly);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public static Map<IExpr, IExpr> create(IExpr exprPoly, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) throws ArithmeticException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr expr = ast.get(i);
                    coefficientMap = SymbolicPolynomialRing.create(expr, x, coefficientMap, restList);
                }
                return coefficientMap;
            }
            if (ast.isTimes()) {
                return SymbolicPolynomialRing.createTimesSub(ast, x, coefficientMap, restList);
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                IExpr exponent = ast.exponent();
                if (exponent.isFree(x)) {
                    if (base.equals(x)) {
                        return SymbolicPolynomialRing.addCoefficient(coefficientMap, exponent, F.C1);
                    }
                    if (base.isFree(x)) {
                        return SymbolicPolynomialRing.addCoefficient(coefficientMap, F.C0, ast);
                    }
                }
                restList.append(ast);
                return coefficientMap;
            }
        } else {
            if (exprPoly.equals(x)) {
                return SymbolicPolynomialRing.addCoefficient(coefficientMap, F.C1, F.C1);
            }
            if (exprPoly.isNumber()) {
                return SymbolicPolynomialRing.addCoefficient(coefficientMap, F.C0, exprPoly);
            }
        }
        if (exprPoly.isFree(x, true)) {
            return SymbolicPolynomialRing.addCoefficient(coefficientMap, F.C0, exprPoly);
        }
        restList.append(exprPoly);
        return coefficientMap;
    }

    private static Map<IExpr, IExpr> createTimesSub(IAST ast, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) {
        IExpr mainExponent = F.NIL;
        IASTAppendable times = F.TimesAlloc(ast.size());
        for (int i = 1; i < ast.size(); ++i) {
            IExpr exponent;
            IExpr expr = ast.get(i);
            if (expr.isFree(x, true)) {
                times.append(expr);
                continue;
            }
            if (expr.equals(x)) {
                exponent = F.C1;
                if (!mainExponent.isPresent()) {
                    mainExponent = exponent;
                    continue;
                }
            } else if (expr.isPower() && (exponent = expr.exponent()).isFree(x) && expr.base().equals(x) && !mainExponent.isPresent()) {
                mainExponent = exponent;
                continue;
            }
            restList.append(ast);
            return coefficientMap;
        }
        return SymbolicPolynomialRing.addCoefficient(coefficientMap, mainExponent, times.oneIdentity1());
    }

    public static Map<IExpr, IExpr> createTimes(IAST ast, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) {
        IExpr mainExponent = F.NIL;
        IASTAppendable times = F.TimesAlloc(ast.size());
        for (int i = 1; i < ast.size(); ++i) {
            IExpr expr = ast.get(i);
            if (expr.isFree(x, true)) {
                times.append(expr);
                continue;
            }
            if (expr.equals(x)) {
                if (!mainExponent.isPresent()) {
                    mainExponent = F.C1;
                    continue;
                }
            } else if (expr.isPower()) {
                IExpr base = expr.base();
                IExpr exponent = expr.exponent();
                if (exponent.isFree(x) && base.equals(x) && exponent.isInteger() && !mainExponent.isPresent()) {
                    mainExponent = exponent;
                    continue;
                }
            }
            restList.append(expr);
        }
        return SymbolicPolynomialRing.addCoefficient(coefficientMap, mainExponent, times.oneIdentity1());
    }

    private static Map<IExpr, IExpr> addCoefficient(Map<IExpr, IExpr> coefficientMap, IExpr exponent, IExpr coefficient) {
        if (exponent.isPresent()) {
            IExpr oldCoefficient = coefficientMap.get(exponent);
            if (oldCoefficient != null) {
                if (oldCoefficient.isTimes()) {
                    ((IASTAppendable)oldCoefficient).append(coefficient);
                } else {
                    IASTAppendable times = F.TimesAlloc(4);
                    times.append(oldCoefficient);
                    times.append(coefficient);
                    coefficientMap.put(exponent, times);
                }
            } else {
                coefficientMap.put(exponent, coefficient);
            }
        }
        return coefficientMap;
    }

    public boolean isPolynomial(IExpr expression) throws ArithmeticException, ClassCastException {
        return this.isPolynomial(expression, false);
    }

    public boolean isPolynomial(IExpr expression, boolean coefficient) throws ArithmeticException, ClassCastException {
        for (int i = 1; i < this.vars.size(); ++i) {
            IExpr expr;
            IExpr variable = this.vars.get(i);
            if (variable.equals(expression)) {
                return true;
            }
            if (!variable.isPower() || !variable.base().equals(expression) || !variable.exponent().isRational() || (expr = variable.exponent().reciprocal()).isZero()) continue;
            return expr.isInteger();
        }
        if (expression instanceof IAST) {
            IAST ast = (IAST)expression;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (this.isPolynomial(ast.get(i), coefficient)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (this.isPolynomial(ast.get(i), coefficient)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                for (int i = 1; i < this.vars.size(); ++i) {
                    IExpr expr;
                    IExpr variable = this.vars.get(i);
                    if (variable.equals(base)) {
                        int exponent = ast.exponent().toIntDefault();
                        return exponent >= 0;
                    }
                    if (!variable.isPower() || !variable.base().equals(ast.base()) || !variable.exponent().isRational() || (expr = variable.exponent().reciprocal().times(ast.exponent())).isZero()) continue;
                    return expr.isInteger();
                }
            }
            if (coefficient) {
                return true;
            }
            if (this.numericFunction && ast.isNumericFunction(true)) {
                return true;
            }
        } else {
            if (expression instanceof ISymbol) {
                if (coefficient) {
                    return true;
                }
                if (this.numericFunction) {
                    return expression.isNumericFunction(true);
                }
                return true;
            }
            if (expression.isNumber()) {
                return true;
            }
        }
        return expression.isFree(Predicates.in(this.vars), true);
    }

    public String toString() {
        Object res = null;
        if (PrettyPrint.isTrue()) {
            String scf = this.coFac.getClass().getSimpleName();
            res = this.coFac.toString();
            if (((String)res).matches("[0-9].*")) {
                res = scf;
            }
            res = (String)res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ";
        } else {
            res = this.getClass().getSimpleName() + "[ " + this.coFac.toString() + " ";
            res = (String)res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ]";
        }
        return res;
    }

    public String toScript() {
        StringBuilder s = new StringBuilder();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("PolyRing.new(");
                break;
            }
            default: {
                s.append("PolyRing(");
            }
        }
        s.append(this.coFac.toScript().trim());
        s.append(",\"" + this.varsToString() + "\"");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = ",PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = ",PolyRing.grad";
        }
        s.append(to);
        s.append(")");
        return s.toString();
    }

    public String toScript(ExpVectorSymbolic e) {
        if (this.vars != null) {
            return e.toScript(this.vars);
        }
        return e.toScript();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SymbolicPolynomialRing)) {
            return false;
        }
        SymbolicPolynomialRing oring = (SymbolicPolynomialRing)other;
        if (this.nvar != oring.nvar) {
            return false;
        }
        if (!this.coFac.equals(oring.coFac)) {
            return false;
        }
        if (!this.tord.equals(oring.tord)) {
            return false;
        }
        return this.vars.equals(oring.vars);
    }

    public int hashCode() {
        int h = this.nvar << 27;
        h += this.coFac.hashCode() << 11;
        return h += this.tord.hashCode();
    }

    public IAST getVars() {
        return this.vars;
    }

    public IAST setVars(IAST v) {
        if (v.argSize() != this.nvar) {
            throw new IllegalArgumentException("v not matching number of variables: " + v.toString() + ", nvar " + this.nvar);
        }
        IAST t = this.vars;
        this.vars = v.copyAppendable();
        return t;
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVectorLong.varsToString(this.vars);
    }

    public IExpr getZEROCoefficient() {
        return this.coFac.getZERO();
    }

    public IExpr getONECoefficient() {
        return this.coFac.getONE();
    }

    public SymbolicPolynomial getZero() {
        return this.ZERO;
    }

    public SymbolicPolynomial getOne() {
        return this.ONE;
    }

    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.nvar == 0) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public SymbolicPolynomial valueOf(IExpr a) {
        return new SymbolicPolynomial(this, a);
    }

    public SymbolicPolynomial valueOf(ExpVectorSymbolic e) {
        return new SymbolicPolynomial(this, this.coFac.getONE(), e);
    }

    public SymbolicPolynomial valueOf(IExpr a, ExpVectorSymbolic e) {
        return new SymbolicPolynomial(this, a, e);
    }

    public SymbolicPolynomial fromInteger(long a) {
        return new SymbolicPolynomial(this, this.coFac.fromInteger(a), this.evzero);
    }

    public SymbolicPolynomial fromInteger(BigInteger a) {
        return new SymbolicPolynomial(this, this.coFac.fromInteger(a), this.evzero);
    }

    public SymbolicPolynomial copy(SymbolicPolynomial c) {
        return new SymbolicPolynomial(this, c.val);
    }

    public SymbolicPolynomial univariate(int i) {
        return this.univariate(0, i, F.C1);
    }

    public SymbolicPolynomial univariate(int i, IExpr e) {
        return this.univariate(0, i, e);
    }

    public SymbolicPolynomial univariate(int modv, int i, IExpr e) {
        SymbolicPolynomial p = this.getZero();
        int r = this.nvar - modv;
        if (0 <= i && i < r) {
            IExpr one = this.coFac.getONE();
            ExpVectorSymbolic f = new ExpVectorSymbolic(r, i, e);
            if (modv > 0) {
                f = f.extend(modv, 0, F.C0);
            }
            p = p.sum(one, f);
        }
        return p;
    }

    public List<SymbolicPolynomial> getGenerators() {
        List<? extends SymbolicPolynomial> univs = this.univariateList();
        ArrayList<SymbolicPolynomial> gens = new ArrayList<SymbolicPolynomial>(univs.size() + 1);
        gens.add(this.getOne());
        gens.addAll(univs);
        return gens;
    }

    public List<SymbolicPolynomial> generators() {
        List<IExpr> cogens = this.coFac.generators();
        List<? extends SymbolicPolynomial> univs = this.univariateList();
        ArrayList<SymbolicPolynomial> gens = new ArrayList<SymbolicPolynomial>(univs.size() + cogens.size());
        for (IExpr c : cogens) {
            gens.add(this.getOne().multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    public List<SymbolicPolynomial> generators(int modv) {
        List<IExpr> cogens = this.coFac.generators();
        List<? extends SymbolicPolynomial> univs = this.univariateList(modv);
        ArrayList<SymbolicPolynomial> gens = new ArrayList<SymbolicPolynomial>(univs.size() + cogens.size());
        for (IExpr c : cogens) {
            gens.add(this.getOne().multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    public boolean isFinite() {
        return this.nvar == 0 && this.coFac.isFinite();
    }

    public List<? extends SymbolicPolynomial> univariateList() {
        return this.univariateList(0, F.C1);
    }

    public List<? extends SymbolicPolynomial> univariateList(int modv) {
        return this.univariateList(modv, F.C1);
    }

    public List<? extends SymbolicPolynomial> univariateList(int modv, IExpr e) {
        ArrayList<SymbolicPolynomial> pols = new ArrayList<SymbolicPolynomial>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            SymbolicPolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add(p);
        }
        return pols;
    }

    public SymbolicPolynomialRing extend(IAST vn) {
        if (vn == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int i = vn.argSize();
        IASTAppendable v = this.vars.copyAppendable();
        v.appendArgs(vn);
        SymbolicTermOrder to = this.tord.extend(this.nvar, i);
        SymbolicPolynomialRing pfac = new SymbolicPolynomialRing(this.coFac, v, this.nvar + i, to);
        return pfac;
    }

    public SymbolicPolynomialComparator getComparator() {
        return new SymbolicPolynomialComparator(this.tord, false);
    }

    public SymbolicPolynomialComparator getComparator(boolean rev) {
        return new SymbolicPolynomialComparator(this.tord, rev);
    }

    public static String[] permuteVars(List<Integer> P, String[] vars) {
        if (vars == null || vars.length <= 1) {
            return vars;
        }
        String[] b = new String[vars.length];
        int j = 0;
        for (Integer i : P) {
            b[j++] = vars[i];
        }
        return b;
    }

    public Iterator<SymbolicPolynomial> iterator() {
        if (this.coFac.isFinite()) {
            return new GenPolynomialIterator(this);
        }
        return new GenPolynomialMonomialIterator(this);
    }

    public SymbolicPolynomial getZERO() {
        return this.getZero();
    }

    public SymbolicPolynomial random(int n) {
        return null;
    }

    public SymbolicPolynomial random(int n, Random random) {
        return null;
    }

    public SymbolicPolynomial parse(String s) {
        return null;
    }

    public SymbolicPolynomial parse(Reader r) {
        return null;
    }

    public SymbolicPolynomial getONE() {
        return this.getOne();
    }

    private static class GenPolynomialMonomialIterator
    implements Iterator<SymbolicPolynomial> {
        final SymbolicPolynomialRing ring;
        final Iterator<List<IExpr>> iter;
        SymbolicPolynomial current;

        public GenPolynomialMonomialIterator(SymbolicPolynomialRing fac) {
            Iterable cfi;
            this.ring = fac;
            LongIterable li = new LongIterable();
            li.setNonNegativeIterator();
            ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(this.ring.nvar);
            for (int i = 0; i < this.ring.nvar; ++i) {
                tlist.add(li);
            }
            CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
            ExprRingFactory cf = this.ring.coFac;
            if (!(cf instanceof Iterable) || cf.isFinite()) {
                throw new IllegalArgumentException("only for infinite iterable coefficients implemented");
            }
            Iterable coeffiter = cfi = (Iterable)((Object)cf);
            ArrayList<Object> eci = new ArrayList<Object>(2);
            eci.add(ei);
            eci.add(coeffiter);
            CartesianProductInfinite ecp = new CartesianProductInfinite(eci);
            this.iter = ecp.iterator();
            List<IExpr> ec = this.iter.next();
            List ecl = (List)((Object)ec.get(0));
            IExpr c = ec.get(1);
            ExpVectorSymbolic e = ExpVectorSymbolic.create(ecl);
            this.current = new SymbolicPolynomial(this.ring, c, e);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public synchronized SymbolicPolynomial next() {
            SymbolicPolynomial res = this.current;
            List<IExpr> ec = this.iter.next();
            IExpr c = ec.get(1);
            while (c.isZERO()) {
                ec = this.iter.next();
                c = ec.get(1);
            }
            List ecl = (List)((Object)ec.get(0));
            ExpVectorSymbolic e = ExpVectorSymbolic.create(ecl);
            this.current = new SymbolicPolynomial(this.ring, c, e);
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannnot remove elements");
        }
    }

    private static class GenPolynomialIterator
    implements Iterator<SymbolicPolynomial> {
        final SymbolicPolynomialRing ring;
        final Iterator<List<IExpr>> eviter;
        final List<ExpVectorSymbolic> powers;
        final List<Iterable<IExpr>> coeffiter;
        Iterator<List<IExpr>> itercoeff;
        SymbolicPolynomial current;

        public GenPolynomialIterator(SymbolicPolynomialRing fac) {
            this.ring = fac;
            IExprIterable li = new IExprIterable();
            li.setNonNegativeIterator();
            ArrayList<IExprIterable> tlist = new ArrayList<IExprIterable>(this.ring.nvar);
            for (int i = 0; i < this.ring.nvar; ++i) {
                tlist.add(li);
            }
            CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
            this.eviter = ei.iterator();
            ExprRingFactory cf = this.ring.coFac;
            this.coeffiter = new ArrayList<Iterable<IExpr>>();
            if (!(cf instanceof Iterable) || !cf.isFinite()) {
                throw new IllegalArgumentException("only for finite iterable coefficients implemented");
            }
            Iterable cfi = (Iterable)((Object)cf);
            this.coeffiter.add(cfi);
            CartesianProduct tuples = new CartesianProduct(this.coeffiter);
            this.itercoeff = tuples.iterator();
            this.powers = new ArrayList<ExpVectorSymbolic>();
            ExpVectorSymbolic e = ExpVectorSymbolic.create((Collection<IExpr>)this.eviter.next());
            this.powers.add(e);
            List<IExpr> c = this.itercoeff.next();
            this.current = new SymbolicPolynomial(this.ring, c.get(0), e);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public synchronized SymbolicPolynomial next() {
            SymbolicPolynomial res = this.current;
            if (!this.itercoeff.hasNext()) {
                ExpVectorSymbolic e = ExpVectorSymbolic.create((Collection<IExpr>)this.eviter.next());
                this.powers.add(0, e);
                if (this.coeffiter.size() == 1) {
                    this.coeffiter.add(this.coeffiter.get(0));
                    Iterable<IExpr> it = this.coeffiter.get(0);
                    ArrayList<IExpr> elms = new ArrayList<IExpr>();
                    for (IExpr elm : it) {
                        elms.add(elm);
                    }
                    elms.remove(0);
                    this.coeffiter.set(0, elms);
                } else {
                    this.coeffiter.add(this.coeffiter.get(1));
                }
                CartesianProduct tuples = new CartesianProduct(this.coeffiter);
                this.itercoeff = tuples.iterator();
            }
            List<IExpr> coeffs = this.itercoeff.next();
            SymbolicPolynomial pol = this.ring.getZero().copy();
            int i = 0;
            for (ExpVectorSymbolic f : this.powers) {
                IExpr c;
                if ((c = coeffs.get(i++)).isZERO()) continue;
                if (pol.val.get(f) != null) {
                    throw new RuntimeException("error in iterator");
                }
                pol.doPutToMap(f, c);
            }
            this.current = pol;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannnot remove elements");
        }
    }

    private static class IExprIterable
    implements Iterable<IExpr> {
        private boolean nonNegative = true;
        private IExpr upperBound = F.CInfinity;

        public IExprIterable() {
        }

        public IExprIterable(IExpr ub) {
            this.upperBound = ub;
        }

        public void setUpperBound(IExpr ub) {
            this.upperBound = ub;
        }

        public IExpr getUpperBound() {
            return this.upperBound;
        }

        public void setAllIterator() {
            this.nonNegative = false;
        }

        public void setNonNegativeIterator() {
            this.nonNegative = true;
        }

        @Override
        public Iterator<IExpr> iterator() {
            return new IExprIterator(this.nonNegative, this.upperBound);
        }

        class IExprIterator
        implements Iterator<IExpr> {
            IExpr current = F.C0;
            boolean empty = false;
            final boolean nonNegative;
            protected IExpr upperBound;

            public void setUpperBound(IExpr ub) {
                this.upperBound = ub;
            }

            public IExpr getUpperBound() {
                return this.upperBound;
            }

            public IExprIterator() {
                this(false, F.CInfinity);
            }

            public IExprIterator(boolean nn, IExpr ub) {
                this.nonNegative = nn;
                this.upperBound = ub;
            }

            @Override
            public synchronized boolean hasNext() {
                return !this.empty;
            }

            @Override
            public synchronized IExpr next() {
                if (this.empty) {
                    throw new NoSuchElementException("invalid call of next()");
                }
                IExpr res = this.current;
                if (this.nonNegative) {
                    this.current = this.current.inc();
                } else if (this.current.isPositiveResult()) {
                    this.current = this.current.negate();
                } else {
                    this.current = this.current.negate();
                    this.current = this.current.inc();
                }
                if (S.Greater.ofQ(this.current, this.upperBound)) {
                    this.empty = true;
                }
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("cannnot remove elements");
            }
        }
    }

    private static class SymbolicPolynomialComparator
    implements Serializable,
    Comparator<SymbolicPolynomial> {
        private static final long serialVersionUID = -2427163728878196089L;
        public final SymbolicTermOrder tord;
        public final boolean reverse;

        public SymbolicPolynomialComparator(SymbolicTermOrder t, boolean reverse) {
            this.tord = t;
            this.reverse = reverse;
        }

        @Override
        public int compare(SymbolicPolynomial p1, SymbolicPolynomial p2) {
            int s = p1.compareTo(p2);
            if (this.reverse) {
                return -s;
            }
            return s;
        }

        @Override
        public boolean equals(Object o) {
            SymbolicPolynomialComparator pc = null;
            try {
                pc = (SymbolicPolynomialComparator)o;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            if (pc == null) {
                return false;
            }
            return this.tord.equals(pc.tord);
        }

        public int hashCode() {
            return this.tord.hashCode();
        }

        public String toString() {
            return "PolynomialComparator(" + this.tord + ")";
        }
    }
}

