/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.symbolicexponent;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.symbolicexponent.ExpVectorSymbolic;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicAlgebraicNotInvertibleException;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicMonomial;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicPolynomialRing;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicTermOrder;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicTermOrderByName;

public class SymbolicPolynomial
implements RingElem<SymbolicPolynomial>,
Iterable<SymbolicMonomial> {
    private static final long serialVersionUID = -3069278103478903325L;
    public final SymbolicPolynomialRing ring;
    protected final SortedMap<ExpVectorSymbolic, IExpr> val;
    private final boolean debug = false;

    private SymbolicPolynomial(SymbolicPolynomialRing r, TreeMap<ExpVectorSymbolic, IExpr> t) {
        this.ring = r;
        this.val = t;
    }

    public SymbolicPolynomial(SymbolicPolynomialRing r) {
        this(r, new TreeMap<ExpVectorSymbolic, IExpr>(r.tord.getDescendComparator()));
    }

    public SymbolicPolynomial(SymbolicPolynomialRing r, IExpr c, ExpVectorSymbolic e) {
        this(r);
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public SymbolicPolynomial(SymbolicPolynomialRing r, IExpr c) {
        this(r, c, r.evzero);
    }

    public SymbolicPolynomial(SymbolicPolynomialRing r, ExpVectorSymbolic e) {
        this(r, r.coFac.getONE(), e);
    }

    protected SymbolicPolynomial(SymbolicPolynomialRing r, SortedMap<ExpVectorSymbolic, IExpr> v) {
        this(r);
        if (v.size() > 0) {
            this.val.putAll(v);
        }
    }

    public SymbolicPolynomialRing factory() {
        return this.ring;
    }

    public SymbolicPolynomial copy() {
        return new SymbolicPolynomial(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<ExpVectorSymbolic, IExpr> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(ExpVectorSymbolic e, IExpr c) {
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public void doRemoveFromMap(ExpVectorSymbolic e, IExpr c) {
        IExpr b = (IExpr)this.val.remove(e);
    }

    public void doPutToMap(SortedMap<ExpVectorSymbolic, IExpr> vals) {
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : vals.entrySet()) {
            ExpVectorSymbolic e = me.getKey();
            IExpr c = me.getValue();
            if (c.isZERO()) continue;
            this.val.put(e, c);
        }
    }

    public String toString() {
        if (this.ring.vars != null) {
            return this.toString(this.ring.vars);
        }
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName() + ":");
        s.append(this.ring.coFac.getClass().getSimpleName());
        if (this.ring.coFac.characteristic().signum() != 0) {
            s.append("(" + this.ring.coFac.characteristic() + ")");
        }
        s.append("[ ");
        boolean first = true;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(m.getValue().toString());
            s.append(" ");
            s.append(m.getKey().toString());
        }
        s.append(" ] ");
        return s.toString();
    }

    public String toString(IAST v) {
        StringBuilder s = new StringBuilder();
        if (PrettyPrint.isTrue()) {
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
                    IExpr c = m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVectorSymbolic e = m.getKey();
                    if (!c.isOne() || e.isZERO()) {
                        String cs = c.toString();
                        if (cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0) {
                            s.append("( ");
                            s.append(cs);
                            s.append(" )");
                        } else {
                            s.append(cs);
                        }
                        s.append(" ");
                    }
                    if (v != null) {
                        s.append(e.toString(v));
                        continue;
                    }
                    s.append(e);
                }
            }
        } else {
            s.append(this.getClass().getSimpleName() + "[ ");
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
                    IExpr c = m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVectorSymbolic e = m.getKey();
                    if (!c.isOne() || e.isZERO()) {
                        s.append(c.toString());
                        s.append(" ");
                    }
                    s.append(e.toString(v));
                }
            }
            s.append(" ] ");
        }
        return s.toString();
    }

    public String toScript() {
        if (this.isZERO()) {
            return "0";
        }
        StringBuilder s = new StringBuilder();
        if (this.val.size() > 1) {
            s.append("( ");
        }
        IAST v = this.ring.vars;
        boolean first = true;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            boolean parenthesis;
            IExpr c = m.getValue();
            if (first) {
                first = false;
            } else if (c.signum() < 0) {
                s.append(" - ");
                c = c.negate();
            } else {
                s.append(" + ");
            }
            ExpVectorSymbolic e = m.getKey();
            String cs = c.toScript();
            boolean bl = parenthesis = cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0;
            if (!c.isOne() || e.isZERO()) {
                if (parenthesis) {
                    s.append("( ");
                }
                s.append(cs);
                if (parenthesis) {
                    s.append(" )");
                }
                if (!e.isZERO()) {
                    s.append(" * ");
                }
            }
            s.append(e.toScript(v));
        }
        if (this.val.size() > 1) {
            s.append(" )");
        }
        return s.toString();
    }

    public String toScriptFactory() {
        return this.factory().toScript();
    }

    public boolean isZero() {
        return this.val.size() == 0;
    }

    public boolean isZERO() {
        return this.isZero();
    }

    public boolean isOne() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isOne();
    }

    public boolean isONE() {
        return this.isOne();
    }

    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        return c != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        IExpr deg = F.CN1;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            if (deg.isNegative()) {
                deg = e.totalDeg();
                continue;
            }
            if (deg.equals(e.totalDeg())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object B) {
        if (B == null) {
            return false;
        }
        if (!(B instanceof SymbolicPolynomial)) {
            return false;
        }
        SymbolicPolynomial a = (SymbolicPolynomial)B;
        return this.compareTo(a) == 0;
    }

    public int hashCode() {
        int h = this.ring.hashCode() << 27;
        return h += this.val.hashCode();
    }

    public int compareTo(SymbolicPolynomial b) {
        if (b == null) {
            return 1;
        }
        SortedMap<ExpVectorSymbolic, IExpr> av = this.val;
        SortedMap<ExpVectorSymbolic, IExpr> bv = b.val;
        Iterator<Map.Entry<ExpVectorSymbolic, IExpr>> ai = av.entrySet().iterator();
        Iterator<Map.Entry<ExpVectorSymbolic, IExpr>> bi = bv.entrySet().iterator();
        int s = 0;
        int c = 0;
        while (ai.hasNext() && bi.hasNext()) {
            ExpVectorSymbolic be;
            Map.Entry<ExpVectorSymbolic, IExpr> aie = ai.next();
            Map.Entry<ExpVectorSymbolic, IExpr> bie = bi.next();
            ExpVectorSymbolic ae = aie.getKey();
            s = ae.compareTo(be = bie.getKey());
            if (s != 0) {
                return s;
            }
            if (c != 0) continue;
            IExpr ac = aie.getValue();
            IExpr bc = bie.getValue();
            c = ac.compareTo(bc);
        }
        if (ai.hasNext()) {
            return 1;
        }
        if (bi.hasNext()) {
            return -1;
        }
        return c;
    }

    @Deprecated
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        ExpVectorSymbolic t = this.val.firstKey();
        IExpr c = (IExpr)this.val.get(t);
        return c.signum();
    }

    public int numberOfVariables() {
        return this.ring.nvar;
    }

    public Map.Entry<ExpVectorSymbolic, IExpr> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<ExpVectorSymbolic, IExpr>> ai = this.val.entrySet().iterator();
        return ai.next();
    }

    public ExpVectorSymbolic leadingExpVectorLong() {
        if (this.val.size() == 0) {
            return null;
        }
        return this.val.firstKey();
    }

    public ExpVectorSymbolic trailingExpVectorLong() {
        if (this.val.size() == 0) {
            return this.ring.evzero;
        }
        return this.val.lastKey();
    }

    public IExpr leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return this.ring.coFac.getZERO();
        }
        return (IExpr)this.val.get(this.val.firstKey());
    }

    @Deprecated
    private IExpr trailingBaseCoefficient() {
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return this.ring.coFac.getZERO();
        }
        return c;
    }

    public IExpr coefficient(ExpVectorSymbolic e) {
        IExpr c = (IExpr)this.val.get(e);
        if (c == null) {
            c = this.ring.coFac.getZERO();
        }
        return c;
    }

    public SymbolicPolynomial reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZero();
        }
        Iterator<ExpVectorSymbolic> ai = this.val.keySet().iterator();
        ExpVectorSymbolic lt = ai.next();
        lt = ai.next();
        SortedMap<ExpVectorSymbolic, IExpr> red = this.val.tailMap(lt);
        SymbolicPolynomial r = this.ring.getZero().copy();
        r.doPutToMap(red);
        return r;
    }

    public IExpr degree(int i) {
        if (this.val.size() == 0) {
            return F.C0;
        }
        int j = i >= 0 ? this.ring.nvar - 1 - i : this.ring.nvar + i;
        IExpr deg = F.C0;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            IExpr d = e.getVal(j);
            if (!S.Greater.ofQ(d, deg)) continue;
            deg = d;
        }
        return deg;
    }

    public IExpr degree() {
        if (this.val.size() == 0) {
            return F.C0;
        }
        IExpr deg = F.C0;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            IExpr d = e.maxDeg();
            if (!S.Greater.ofQ(d, deg)) continue;
            deg = d;
        }
        return deg;
    }

    public IExpr totalDegree() {
        if (this.val.size() == 0) {
            return F.C0;
        }
        IExpr deg = F.C0;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            IExpr d = e.totalDeg();
            if (!S.Greater.ofQ(d, deg)) continue;
            deg = d;
        }
        return deg;
    }

    public IExpr weightDegree() {
        IExpr[][] w = this.ring.tord.getWeight();
        if (w == null || w.length == 0) {
            return this.totalDegree();
        }
        if (this.val.isEmpty()) {
            return F.CN1;
        }
        IExpr deg = F.C0;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            IExpr d = e.weightDeg(w);
            if (!S.Greater.ofQ(d, deg)) continue;
            deg = d;
        }
        return deg;
    }

    public SymbolicPolynomial leadingWeightPolynomial() {
        if (this.val.isEmpty()) {
            return this.ring.getZero();
        }
        IExpr[][] w = this.ring.tord.getWeight();
        IExpr maxw = w == null || w.length == 0 ? this.totalDegree() : this.weightDegree();
        SymbolicPolynomial wp = new SymbolicPolynomial(this.ring);
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            ExpVectorSymbolic e = m.getKey();
            IExpr d = e.weightDeg(w);
            if (!S.GreaterEqual.ofQ(d, maxw)) continue;
            wp.val.put(e, m.getValue());
        }
        return wp;
    }

    public boolean isWeightHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        IExpr[][] w = this.ring.tord.getWeight();
        if (w == null || w.length == 0) {
            return this.isHomogeneous();
        }
        IExpr deg = F.CN1;
        for (ExpVectorSymbolic e : this.val.keySet()) {
            if (deg.isNegativeResult()) {
                deg = e.weightDeg(w);
                continue;
            }
            if (deg.equals(e.weightDeg(w))) continue;
            return false;
        }
        return true;
    }

    public ExpVectorSymbolic degreeVector() {
        ExpVectorSymbolic deg = this.ring.evzero;
        if (this.val.size() == 0) {
            return deg;
        }
        for (ExpVectorSymbolic e : this.val.keySet()) {
            deg = deg.lcm(e);
        }
        return deg;
    }

    public IExpr maxNorm() {
        IExpr n = this.ring.getZEROCoefficient();
        for (IExpr c : this.val.values()) {
            IExpr x = c.abs();
            if (n.compareTo(x) >= 0) continue;
            n = x;
        }
        return n;
    }

    public IExpr sumNorm() {
        IExpr n = this.ring.getZEROCoefficient();
        for (IExpr c : this.val.values()) {
            IExpr x = c.abs();
            n = n.add(x);
        }
        return n;
    }

    public SymbolicPolynomial sum(SymbolicPolynomial S2) {
        if (S2 == null) {
            return this;
        }
        if (S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.add(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
        return n;
    }

    public SymbolicPolynomial sum(IExpr a, ExpVectorSymbolic e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.add(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
        return n;
    }

    public SymbolicPolynomial sum(IExpr a) {
        return this.sum(a, this.ring.evzero);
    }

    public void doAddTo(SymbolicPolynomial S2) {
        if (S2 == null || S2.isZERO()) {
            return;
        }
        if (this.isZERO()) {
            this.val.putAll(S2.val);
            return;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SortedMap<ExpVectorSymbolic, IExpr> nv = this.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.add(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
    }

    public void doAddTo(IExpr a, ExpVectorSymbolic e) {
        if (a == null || a.isZERO()) {
            return;
        }
        SortedMap<ExpVectorSymbolic, IExpr> nv = this.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.add(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
    }

    public void doAddTo(IExpr a) {
        this.doAddTo(a, this.ring.evzero);
    }

    public SymbolicPolynomial subtract(SymbolicPolynomial S2) {
        if (S2 == null) {
            return this;
        }
        if (S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.negate();
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial subtract(IExpr a, ExpVectorSymbolic e) {
        if (a == null || a.isZERO()) {
            return this;
        }
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.subtract(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a.negate());
        }
        return n;
    }

    public SymbolicPolynomial subtract(IExpr a) {
        return this.subtract(a, this.ring.evzero);
    }

    public SymbolicPolynomial subtractMultiple(IExpr a, SymbolicPolynomial S2) {
        if (a == null || a.isZERO()) {
            return this;
        }
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.multiply(a.negate());
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic f = me.getKey();
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial subtractMultiple(IExpr a, ExpVectorSymbolic e, SymbolicPolynomial S2) {
        if (a == null || a.isZERO()) {
            return this;
        }
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial scaleSubtractMultiple(IExpr b, IExpr a, SymbolicPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate());
        }
        if (b.isOne()) {
            return this.subtractMultiple(a, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.multiply(b);
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic f = me.getKey();
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial scaleSubtractMultiple(IExpr b, IExpr a, ExpVectorSymbolic e, SymbolicPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        if (b.isOne()) {
            return this.subtractMultiple(a, e, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.multiply(b);
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial scaleSubtractMultiple(IExpr b, ExpVectorSymbolic g, IExpr a, ExpVectorSymbolic e, SymbolicPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b, g);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b, g);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        if (b.isOne() && g.isZERO()) {
            return this.subtractMultiple(a, e, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial n = this.multiply(b, g);
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        SortedMap<ExpVectorSymbolic, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> me : sv.entrySet()) {
            ExpVectorSymbolic f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public SymbolicPolynomial negate() {
        SymbolicPolynomial n = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> v = n.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            IExpr x = m.getValue();
            v.put(m.getKey(), x.negate());
        }
        return n;
    }

    public SymbolicPolynomial multiplyByMinimumNegativeExponents() {
        IExpr[] result = new IExpr[this.numberOfVariables()];
        boolean negativeExponents = false;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            IExpr[] k = m.getKey().getVal();
            for (int i = 0; i < k.length; ++i) {
                if (!k[i].isNegativeResult() || !S.Less.ofQ(k[i], result[i])) continue;
                result[i] = k[i];
                negativeExponents = true;
            }
        }
        if (negativeExponents) {
            for (int i = 0; i < result.length; ++i) {
                if (!result[i].isNegativeResult()) continue;
                result[i] = result[i].negate();
            }
            return this.multiply(new ExpVectorSymbolic(result));
        }
        return this;
    }

    public SymbolicPolynomial abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public SymbolicPolynomial multiply(SymbolicPolynomial S2) {
        if (S2 == null) {
            return this.ring.getZero();
        }
        if (S2.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SymbolicPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorSymbolic e1 = m1.getKey();
            for (Map.Entry<ExpVectorSymbolic, IExpr> m2 : S2.val.entrySet()) {
                IExpr c2 = m2.getValue();
                ExpVectorSymbolic e2 = m2.getKey();
                IExpr c = c1.multiply(c2);
                if (c.isZERO()) continue;
                ExpVectorSymbolic e = e1.sum(e2);
                IExpr c0 = (IExpr)pv.get(e);
                if (c0 == null) {
                    pv.put(e, c);
                    continue;
                }
                if (!(c0 = c0.add(c)).isZERO()) {
                    pv.put(e, c0);
                    continue;
                }
                pv.remove(e);
            }
        }
        return p;
    }

    public SymbolicPolynomial multiply(IExpr s) {
        if (s == null) {
            return this.ring.getZero();
        }
        if (s.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        SymbolicPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorSymbolic e1 = m1.getKey();
            IExpr c = c1.multiply(s);
            if (c.isZERO()) continue;
            pv.put(e1, c);
        }
        return p;
    }

    public SymbolicPolynomial monic() {
        if (this.isZERO()) {
            return this;
        }
        IExpr lc = this.leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return this;
        }
        IExpr lm = lc.inverse();
        return this.multiply(lm);
    }

    public SymbolicPolynomial multiply(IExpr s, ExpVectorSymbolic e) {
        if (s == null) {
            return this.ring.getZero();
        }
        if (s.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        SymbolicPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorSymbolic e1 = m1.getKey();
            IExpr c = c1.multiply(s);
            if (c.isZERO()) continue;
            ExpVectorSymbolic e2 = e1.sum(e);
            pv.put(e2, c);
        }
        return p;
    }

    public SymbolicPolynomial multiply(ExpVectorSymbolic e) {
        if (this.isZERO()) {
            return this;
        }
        SymbolicPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorSymbolic e1 = m1.getKey();
            ExpVectorSymbolic e2 = e1.sum(e);
            pv.put(e2, c1);
        }
        return p;
    }

    public SymbolicPolynomial multiply(Map.Entry<ExpVectorSymbolic, IExpr> m) {
        if (m == null) {
            return this.ring.getZero();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    public SymbolicPolynomial divide(IExpr s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        SymbolicPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorSymbolic, IExpr> m : this.val.entrySet()) {
            ExpVectorSymbolic e = m.getKey();
            IExpr c1 = m.getValue();
            IExpr c = c1.divide(s);
            if (c.isZERO()) {
                throw new ArithmeticException("no exact division: " + c1 + "/" + s + ", in " + this);
            }
            pv.put(e, c);
        }
        return p;
    }

    public SymbolicPolynomial[] quotientRemainder(SymbolicPolynomial S2) {
        ExpVectorSymbolic f;
        if (S2 == null || S2.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        IExpr c = S2.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        IExpr ci = c.inverse();
        assert (this.ring.nvar == S2.ring.nvar);
        ExpVectorSymbolic e = S2.leadingExpVectorLong();
        SymbolicPolynomial q = this.ring.getZero().copy();
        SymbolicPolynomial r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVectorLong()).multipleOf(e)) {
            IExpr a = r.leadingBaseCoefficient();
            ExpVectorSymbolic g = f.subtract(e);
            if ((a = a.multiplyDistributed(ci)).isZERO()) {
                return null;
            }
            q = q.sum(a, g);
            SymbolicPolynomial h = S2.multiply(a, g);
            r = r.subtract(h);
        }
        return new SymbolicPolynomial[]{q, r};
    }

    @Deprecated
    private SymbolicPolynomial[] divideAndRemainder(SymbolicPolynomial S2) {
        return this.quotientRemainder(S2);
    }

    public SymbolicPolynomial divide(SymbolicPolynomial S2) {
        return this.quotientRemainder(S2)[0];
    }

    public SymbolicPolynomial remainder(SymbolicPolynomial S2) {
        ExpVectorSymbolic f;
        if (S2 == null || S2.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        IExpr c = S2.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbc not invertible " + c);
        }
        IExpr ci = c.inverse();
        assert (this.ring.nvar == S2.ring.nvar);
        ExpVectorSymbolic e = S2.leadingExpVectorLong();
        SymbolicPolynomial r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVectorLong()).multipleOf(e)) {
            IExpr a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiplyDistributed(ci);
            SymbolicPolynomial h = S2.multiply(a, f);
            r = r.subtract(h);
        }
        return r;
    }

    public SymbolicPolynomial gcd(SymbolicPolynomial S2) {
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("not univariate polynomials" + this.ring);
        }
        SymbolicPolynomial q = this;
        SymbolicPolynomial r = S2;
        while (!r.isZERO()) {
            SymbolicPolynomial x = q.remainder(r);
            q = r;
            r = x;
        }
        return q.monic();
    }

    public SymbolicPolynomial[] egcd(SymbolicPolynomial S2) {
        SymbolicPolynomial[] ret = new SymbolicPolynomial[]{null, null, null};
        if (S2 == null || S2.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getOne();
            ret[2] = this.ring.getZero();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S2;
            ret[1] = this.ring.getZero();
            ret[2] = this.ring.getOne();
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        if (this.isConstant() && S2.isConstant()) {
            IExpr t = this.leadingBaseCoefficient();
            IExpr s = S2.leadingBaseCoefficient();
            if (t.isInteger() && s.isInteger()) {
                IExpr[] gg = t.egcd(s);
                SymbolicPolynomial z = this.ring.getZero();
                ret[0] = z.sum(gg[0]);
                ret[1] = z.sum(gg[1]);
                ret[2] = z.sum(gg[2]);
                return ret;
            }
        }
        SymbolicPolynomial q = this;
        SymbolicPolynomial r = S2;
        SymbolicPolynomial c1 = this.ring.getOne().copy();
        SymbolicPolynomial d1 = this.ring.getZero().copy();
        SymbolicPolynomial c2 = this.ring.getZero().copy();
        SymbolicPolynomial d2 = this.ring.getOne().copy();
        while (!r.isZERO()) {
            SymbolicPolynomial[] qr = q.quotientRemainder(r);
            if (qr == null) {
                return null;
            }
            q = qr[0];
            SymbolicPolynomial x1 = c1.subtract(q.multiply(d1));
            SymbolicPolynomial x2 = c2.subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        IExpr g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            IExpr h = g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
            c2 = c2.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    public SymbolicPolynomial[] hegcd(SymbolicPolynomial S2) {
        SymbolicPolynomial[] ret = new SymbolicPolynomial[]{null, null};
        if (S2 == null || S2.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getOne();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S2;
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        SymbolicPolynomial q = this;
        SymbolicPolynomial r = S2;
        SymbolicPolynomial c1 = this.ring.getOne().copy();
        SymbolicPolynomial d1 = this.ring.getZero().copy();
        while (!r.isZERO()) {
            SymbolicPolynomial[] qr = q.quotientRemainder(r);
            q = qr[0];
            SymbolicPolynomial x1 = c1.subtract(q.multiply(d1));
            c1 = d1;
            d1 = x1;
            q = r;
            r = qr[1];
        }
        IExpr g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            IExpr h = g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    public SymbolicPolynomial inverse() {
        if (this.isUnit()) {
            IExpr c = this.leadingBaseCoefficient().inverse();
            return this.ring.getOne().multiply(c);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public SymbolicPolynomial modInverse(SymbolicPolynomial m) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        SymbolicPolynomial[] hegcd = this.hegcd(m);
        SymbolicPolynomial a = hegcd[0];
        if (!a.isUnit()) {
            throw new SymbolicAlgebraicNotInvertibleException("element not invertible, gcd != 1", m, a, m.divide(a));
        }
        SymbolicPolynomial b = hegcd[1];
        if (b.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return b;
    }

    public SymbolicPolynomial extend(SymbolicPolynomialRing pfac, int j, IExpr k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        SymbolicPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorSymbolic f = e.extend(i, j, k);
            C2.put(f, a);
        }
        return Cp;
    }

    public SymbolicPolynomial extendLower(SymbolicPolynomialRing pfac, int j, IExpr k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        SymbolicPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorSymbolic f = e.extendLower(i, j, k);
            C2.put(f, a);
        }
        return Cp;
    }

    public Map<ExpVectorSymbolic, SymbolicPolynomial> contract(SymbolicPolynomialRing pfac) {
        SymbolicPolynomial zero = pfac.getZero();
        SymbolicTermOrder t = SymbolicTermOrderByName.INVLEX;
        TreeMap<ExpVectorSymbolic, SymbolicPolynomial> B = new TreeMap<ExpVectorSymbolic, SymbolicPolynomial>(t.getAscendComparator());
        if (this.isZERO()) {
            return B;
        }
        int i = this.ring.nvar - pfac.nvar;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorSymbolic f = e.contract(0, i);
            ExpVectorSymbolic g = e.contract(i, e.length() - i);
            SymbolicPolynomial p = (SymbolicPolynomial)B.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            B.put(f, p);
        }
        return B;
    }

    public SymbolicPolynomial contractCoeff(SymbolicPolynomialRing pfac) {
        Map<ExpVectorSymbolic, SymbolicPolynomial> ms = this.contract(pfac);
        SymbolicPolynomial c = pfac.getZero();
        for (Map.Entry<ExpVectorSymbolic, SymbolicPolynomial> m : ms.entrySet()) {
            if (m.getKey().isZERO()) {
                c = m.getValue();
                continue;
            }
            throw new RuntimeException("wrong coefficient contraction " + m + ", pol =  " + c);
        }
        return c;
    }

    public SymbolicPolynomial extendUnivariate(SymbolicPolynomialRing pfac, int i) {
        if (i < 0 || pfac.nvar < i) {
            throw new IllegalArgumentException("index " + i + "out of range " + pfac.nvar);
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("polynomial not univariate " + this.ring.nvar);
        }
        if (this.isOne()) {
            return pfac.getOne();
        }
        int j = pfac.nvar - 1 - i;
        SymbolicPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr n = e.getVal(0);
            IExpr a = (IExpr)y.getValue();
            ExpVectorSymbolic f = new ExpVectorSymbolic(pfac.nvar, j, n);
            C2.put(f, a);
        }
        return Cp;
    }

    public SymbolicPolynomial homogenize(SymbolicPolynomialRing pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        SymbolicPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        IExpr deg = this.totalDegree();
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr a = (IExpr)y.getValue();
            IExpr d = S.Subtract.of(deg, e.totalDeg());
            ExpVectorSymbolic f = e.extend(1, 0, d);
            C2.put(f, a);
        }
        return Cp;
    }

    public SymbolicPolynomial deHomogenize(SymbolicPolynomialRing pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        SymbolicPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorSymbolic f = e.contract(1, pfac.nvar);
            C2.put(f, a);
        }
        return Cp;
    }

    public SymbolicPolynomial reverse(SymbolicPolynomialRing oring) {
        SymbolicPolynomial Cp = oring.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int k = -1;
        if (oring.tord.getEvord2() != 0 && oring.partial) {
            k = oring.tord.getSplit();
        }
        SortedMap<ExpVectorSymbolic, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorSymbolic, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorSymbolic e = (ExpVectorSymbolic)y.getKey();
            ExpVectorSymbolic f = k >= 0 ? e.reverse(k) : e.reverse();
            IExpr a = (IExpr)y.getValue();
            C2.put(f, a);
        }
        return Cp;
    }

    public Iterator<IExpr> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<ExpVectorSymbolic> exponentIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<SymbolicMonomial> iterator() {
        return new SymbolicPolyIterator(this.val);
    }

    public SymbolicPolynomial map(Function<IExpr, IExpr> f) {
        SymbolicPolynomial n = this.ring.getZero().copy();
        SortedMap<ExpVectorSymbolic, IExpr> nv = n.val;
        for (SymbolicMonomial m : this) {
            IExpr c = f.apply(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }

    public IAST coefficientRules() {
        IASTAppendable result = F.ListAlloc(this.val.size());
        for (Map.Entry<ExpVectorSymbolic, IExpr> monomial : this.val.entrySet()) {
            IASTAppendable ruleList;
            int len;
            IExpr coeff = monomial.getValue();
            ExpVectorSymbolic exp = monomial.getKey();
            IExpr[] vector = exp.getVal();
            boolean isRealVector = true;
            for (int i = 0; i < vector.length; ++i) {
                if (vector[i].isInteger() && !vector[i].isNegative()) continue;
                isRealVector = false;
                break;
            }
            if (isRealVector) {
                len = exp.length();
                ruleList = F.ListAlloc(len);
                for (int i = 0; i < len; ++i) {
                    ruleList.append(exp.getVal(len - i - 1));
                }
                result.append(F.Rule((IExpr)ruleList, coeff));
                continue;
            }
            len = exp.length();
            ruleList = F.ListAlloc(len);
            for (int j = 0; j < len; ++j) {
                ruleList.append(F.C0);
            }
            result.append(F.Rule((IExpr)ruleList, this.toExpr(coeff, exp, this.ring.getVars())));
        }
        return result;
    }

    public IAST monomialList() {
        IASTAppendable result = F.ListAlloc(this.val.size());
        for (Map.Entry<ExpVectorSymbolic, IExpr> monomial : this.val.entrySet()) {
            ExpVectorSymbolic exp = monomial.getKey();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            monomTimes.append((IExpr)this.val.get(exp));
            this.appendToExpr(monomTimes, exp, this.ring.vars);
            result.append(monomTimes);
        }
        return result;
    }

    private void appendToExpr(IASTAppendable times, ExpVectorSymbolic expArray, IAST variables) {
        IExpr[] arr = expArray.getVal();
        ExpVectorSymbolic leer = this.ring.evzero;
        for (int i = 0; i < arr.length; ++i) {
            int ix;
            if (arr[i].isZero() || (ix = leer.varIndex(i)) < 0) continue;
            if (arr[i].isOne()) {
                times.append(variables.get(ix + 1));
                continue;
            }
            times.append(F.Power(variables.get(ix + 1), arr[i]));
        }
    }

    private IExpr toExpr(IExpr coefficient, ExpVectorSymbolic expArray, IAST variables) {
        IExpr[] arr = expArray.getVal();
        IASTAppendable times = F.TimesAlloc(arr.length + 1);
        if (!coefficient.isOne()) {
            times.append(coefficient);
        }
        ExpVectorSymbolic leer = this.ring.evzero;
        for (int i = 0; i < arr.length; ++i) {
            int ix;
            if (arr[i].isZero() || (ix = leer.varIndex(i)) < 0) continue;
            if (arr[i].isOne()) {
                times.append(variables.get(ix + 1));
                continue;
            }
            times.append(F.Power(variables.get(ix + 1), arr[i]));
        }
        return times.oneIdentity1();
    }

    public SymbolicPolynomial derivativeUnivariate() {
        SymbolicPolynomial result = new SymbolicPolynomial(this.ring);
        for (Map.Entry<ExpVectorSymbolic, IExpr> entry : this.val.entrySet()) {
            ExpVectorSymbolic key = entry.getKey();
            IExpr exp = key.getVal(0);
            if (exp.isZero()) continue;
            ExpVectorSymbolic copy = key.copy();
            copy.val[0] = exp.dec();
            IExpr coefficient = entry.getValue().times(exp);
            result.doAddTo(coefficient, copy);
        }
        return result;
    }

    public IExpr getExpr() {
        if (this.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(this.length());
        IAST vars = this.ring.vars;
        for (SymbolicMonomial monomial : this) {
            IExpr coeff = monomial.coefficient();
            ExpVectorSymbolic exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            if (!coeff.isOne()) {
                monomTimes.append(coeff);
            }
            for (int i = 0; i < exp.length(); ++i) {
                IExpr lExp = exp.getVal(i);
                if (lExp.isZero()) continue;
                int ix = exp.varIndex(i);
                IExpr variable = vars.get(ix + 1);
                if (lExp.isOne()) {
                    monomTimes.append(variable);
                    continue;
                }
                monomTimes.append(F.Power(variable, lExp));
            }
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public class SymbolicPolyIterator
    implements Iterator<SymbolicMonomial> {
        protected final Iterator<Map.Entry<ExpVectorSymbolic, IExpr>> ms;

        public SymbolicPolyIterator(SortedMap<ExpVectorSymbolic, IExpr> m) {
            this.ms = m.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ms.hasNext();
        }

        @Override
        public SymbolicMonomial next() {
            return new SymbolicMonomial(this.ms.next());
        }

        @Override
        public void remove() {
            this.ms.remove();
        }
    }
}

