/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.symbolicexponent;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public final class ExpVectorSymbolic {
    final IExpr[] val;
    int hash;

    public ExpVectorSymbolic(int n) {
        this.val = new IExpr[n];
        for (int i = 0; i < n; ++i) {
            this.val[i] = F.C0;
        }
    }

    public ExpVectorSymbolic(int n, int i, IExpr e) {
        this(n);
        this.val[i] = e;
    }

    public ExpVectorSymbolic(IExpr[] v) {
        if (v == null) {
            throw new IllegalArgumentException("null val not allowed");
        }
        this.val = Arrays.copyOf(v, v.length);
    }

    public ExpVectorSymbolic copy() {
        IExpr[] w = new IExpr[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorSymbolic(w);
    }

    public static ExpVectorSymbolic create(Collection<IExpr> v) {
        IExpr[] w = new IExpr[v.size()];
        int i = 0;
        for (IExpr k : v) {
            w[i++] = k;
        }
        return new ExpVectorSymbolic(w);
    }

    public IExpr[] getVal() {
        return this.val;
    }

    public IExpr getVal(int i) {
        return this.val[i];
    }

    protected IExpr setVal(int i, IExpr e) {
        IExpr x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    public boolean isZERO() {
        return 0 == this.signum();
    }

    public boolean isFinite() {
        return true;
    }

    public IAST stdVars() {
        return ExpVectorSymbolic.STDVARS("x", this.length());
    }

    public IAST stdVars(String prefix) {
        return ExpVectorSymbolic.STDVARS(prefix, this.length());
    }

    public static IAST STDVARS(int n) {
        return ExpVectorSymbolic.STDVARS("x", n);
    }

    public static IAST STDVARS(String prefix, int n) {
        IASTAppendable vars = F.ListAlloc(n);
        if (prefix == null || prefix.length() == 0) {
            prefix = "x";
        }
        for (int i = 0; i < n; ++i) {
            vars.append(F.Dummy(prefix + i));
        }
        return vars;
    }

    public int length() {
        return this.val.length;
    }

    public ExpVectorSymbolic extend(int i, int j, IExpr e) {
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length + i);
        IExpr[] w = result.val;
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[j] = e;
        return result;
    }

    public ExpVectorSymbolic extendLower(int i, int j, IExpr e) {
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length + i);
        IExpr[] w = result.val;
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = e;
        return result;
    }

    public ExpVectorSymbolic contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(len);
        IExpr[] w = result.val;
        System.arraycopy(this.val, i, w, 0, len);
        return result;
    }

    public ExpVectorSymbolic reverse() {
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length);
        IExpr[] w = result.val;
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return result;
    }

    public ExpVectorSymbolic reverse(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length);
        IExpr[] w = result.val;
        for (i = 0; i < j; ++i) {
            w[i] = this.val[i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length + j - 1 - i];
        }
        return result;
    }

    public ExpVectorSymbolic reverseUpper(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length);
        IExpr[] w = result.val;
        for (i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[i];
        }
        return result;
    }

    public ExpVectorSymbolic combine(ExpVectorSymbolic V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorSymbolic Vl = V;
        if (this.val.length == 0) {
            return Vl;
        }
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length + Vl.val.length);
        IExpr[] w = result.val;
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vl.val, 0, w, this.val.length, Vl.val.length);
        return result;
    }

    public ExpVectorSymbolic permutation(List<Integer> P) {
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(this.val.length);
        IExpr[] w = result.val;
        int j = 0;
        for (Integer i : P) {
            w[j++] = this.val[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("(");
        for (int i = 0; i < this.length(); ++i) {
            s.append(this.getVal(i));
            if (i >= this.length() - 1) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    public String toString(IAST vars) {
        IExpr vi;
        StringBuilder s = new StringBuilder();
        int r = this.length();
        if (r != vars.argSize()) {
            return this.toString();
        }
        if (r == 0) {
            return s.toString();
        }
        for (int i = r - 1; i > 0; --i) {
            vi = this.getVal(i);
            if (vi.isZero()) continue;
            s.append(vars.get(r - i));
            if (!vi.isOne()) {
                s.append("^" + vi);
            }
            boolean pit = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j).isZero()) continue;
                pit = true;
            }
            if (!pit) continue;
            s.append(" * ");
        }
        vi = this.getVal(0);
        if (!vi.isZero()) {
            s.append(vars.get(r));
            if (!vi.isOne()) {
                s.append("^" + vi);
            }
        }
        return s.toString();
    }

    public static String varsToString(IAST vars) {
        if (vars == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        vars.forEach(vars.size(), (x, i) -> {
            s.append(x);
            if (i < vars.argSize()) {
                s.append(",");
            }
        });
        return s.toString();
    }

    public String toScript() {
        return this.toScript(this.stdVars());
    }

    public String toScript(IAST vars) {
        IExpr vi;
        int r = this.length();
        if (r != vars.argSize()) {
            return this.toString();
        }
        StringBuilder s = new StringBuilder();
        for (int i = r - 1; i > 0; --i) {
            vi = this.getVal(i);
            if (vi.isZero()) continue;
            s.append(vars.get(r - i));
            if (!vi.isOne()) {
                s.append("**" + vi);
            }
            boolean pit = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j).isZero()) continue;
                pit = true;
            }
            if (!pit) continue;
            s.append(" * ");
        }
        vi = this.getVal(0);
        if (!vi.isZero()) {
            s.append(vars.get(r));
            if (!vi.isOne()) {
                s.append("**" + vi);
            }
        }
        return s.toString();
    }

    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorSymbolic)) {
            return false;
        }
        IExpr[] u = this.val;
        IExpr[] v = ((ExpVectorSymbolic)B).val;
        if (u.length != v.length) {
            return false;
        }
        for (int i = 0; i < u.length; ++i) {
            if (u[i].equals(v[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < this.length(); ++i) {
                this.hash <<= 4 + this.getVal(i).hashCode();
            }
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    public ExpVectorSymbolic abs() {
        IExpr[] u = this.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i].isNegative() ? u[i].negative() : u[i];
        }
        return result;
    }

    public ExpVectorSymbolic negate() {
        IExpr[] u = this.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i].negate();
        }
        return result;
    }

    public ExpVectorSymbolic sum(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = S.Plus.of(u[i], v[i]);
        }
        return result;
    }

    public ExpVectorSymbolic subtract(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = S.Plus.of(u[i], v[i].negate());
        }
        return result;
    }

    public ExpVectorSymbolic subst(int i, IExpr d) {
        ExpVectorSymbolic V = this.copy();
        V.setVal(i, d);
        return V;
    }

    public int signum() {
        int t = 0;
        IExpr[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i].isNegativeResult()) {
                return -1;
            }
            if (!u[i].isPositiveResult()) continue;
            t = 1;
        }
        return t;
    }

    public IExpr totalDeg() {
        IExpr[] u = this.val;
        IASTAppendable t = F.PlusAlloc(u.length);
        for (int i = 0; i < u.length; ++i) {
            t.append(u[i]);
        }
        return EvalEngine.get().evaluate(t);
    }

    public IExpr maxDeg() {
        IExpr[] u = this.val;
        IExpr t = F.C0;
        for (int i = 0; i < u.length; ++i) {
            if (!S.Greater.ofQ(u[i], t)) continue;
            t = u[i];
        }
        return t;
    }

    public IExpr weightDeg(IExpr[][] w) {
        if (w == null || w.length == 0) {
            return this.totalDeg();
        }
        IExpr[] u = this.val;
        IASTAppendable t = F.PlusAlloc(w.length);
        for (int j = 0; j < w.length; ++j) {
            IExpr[] wj = w[j];
            for (int i = 0; i < u.length; ++i) {
                t.append(F.Times(wj[i], u[i]));
            }
        }
        return EvalEngine.get().evaluate(t);
    }

    public ExpVectorSymbolic lcm(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = S.GreaterEqual.ofQ(u[i], v[i]) ? u[i] : v[i];
        }
        return result;
    }

    public ExpVectorSymbolic gcd(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        ExpVectorSymbolic result = ExpVectorSymbolic.valueOf(u.length);
        IExpr[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = S.LessEqual.ofQ(u[i], v[i]) ? u[i] : v[i];
        }
        return result;
    }

    public int[] dependencyOnVariables() {
        IExpr[] u = this.val;
        int l = 0;
        for (int i = 0; i < u.length; ++i) {
            if (!u[i].isPositiveResult()) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (!u[i].isPositiveResult()) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    public boolean multipleOf(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (!S.Less.ofQ(u[i], v[i])) continue;
            return false;
        }
        return t;
    }

    public int compareTo(ExpVectorSymbolic V) {
        return this.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVectorSymbolic U, ExpVectorSymbolic V, int begin, int end) {
        return U.invLexCompareTo(V, begin, end);
    }

    public static int EVIGLC(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.invGradCompareTo(V);
    }

    public static int EVIGLC(ExpVectorSymbolic U, ExpVectorSymbolic V, int begin, int end) {
        return U.invGradCompareTo(V, begin, end);
    }

    public static int EVRILCP(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.revInvLexCompareTo(V);
    }

    public static int EVRILCP(ExpVectorSymbolic U, ExpVectorSymbolic V, int begin, int end) {
        return U.revInvLexCompareTo(V, begin, end);
    }

    public static int EVRIGLC(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.revInvGradCompareTo(V);
    }

    public static int EVRIGLC(ExpVectorSymbolic U, ExpVectorSymbolic V, int begin, int end) {
        return U.revInvGradCompareTo(V, begin, end);
    }

    public static int EVITDEGLC(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.invTdegCompareTo(V);
    }

    public static int EVRLITDEGC(ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.revLexInvTdegCompareTo(V);
    }

    public static int EVIWLC(IExpr[][] w, ExpVectorSymbolic U, ExpVectorSymbolic V) {
        return U.invWeightCompareTo(w, V);
    }

    public static int EVIWLC(IExpr[][] w, ExpVectorSymbolic U, ExpVectorSymbolic V, int begin, int end) {
        return U.invWeightCompareTo(w, V, begin, end);
    }

    public int invLexCompareTo(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                return 1;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            return -1;
        }
        return t;
    }

    public int invLexCompareTo(ExpVectorSymbolic V, int begin, int end) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                return 1;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            return -1;
        }
        return t;
    }

    public int invGradCompareTo(ExpVectorSymbolic V) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = 0; i < u.length; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(u.length - i);
        IASTAppendable vp = F.PlusAlloc(u.length - i);
        for (int j = i; j < u.length; ++j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int invGradCompareTo(ExpVectorSymbolic V, int begin, int end) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = begin; i < end; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(end - i);
        IASTAppendable vp = F.PlusAlloc(end - i);
        for (int j = i; j < end; ++j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int revInvLexCompareTo(ExpVectorSymbolic V) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                return 1;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            return -1;
        }
        return t;
    }

    public int revInvLexCompareTo(ExpVectorSymbolic V, int begin, int end) {
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                return 1;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            return -1;
        }
        return t;
    }

    public int revInvGradCompareTo(ExpVectorSymbolic V) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = u.length - 1; i >= 0; --i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(i + 1);
        IASTAppendable vp = F.PlusAlloc(i + 1);
        for (int j = i; j >= 0; --j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int revInvGradCompareTo(ExpVectorSymbolic V, int begin, int end) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = end - 1; i >= begin; --i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(i - begin + 1);
        IASTAppendable vp = F.PlusAlloc(i - begin + 1);
        for (int j = i; j >= begin; --j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int invTdegCompareTo(ExpVectorSymbolic V) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = 0; i < u.length; ++i) {
            if (S.Less.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Greater.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(u.length - i + 1);
        IASTAppendable vp = F.PlusAlloc(u.length - i + 1);
        for (int j = i; j < u.length; ++j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int revLexInvTdegCompareTo(ExpVectorSymbolic V) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = u.length - 1; i >= 0; --i) {
            if (S.Less.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Greater.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        IASTAppendable up = F.PlusAlloc(i + 1);
        IASTAppendable vp = F.PlusAlloc(i + 1);
        for (int j = i; j >= 0; --j) {
            up.append(u[j]);
            vp.append(v[j]);
        }
        IExpr upEvaled = EvalEngine.get().evaluate(up);
        IExpr vpEvaled = EvalEngine.get().evaluate(vp);
        if (S.Greater.ofQ(upEvaled, vpEvaled)) {
            t = 1;
        } else if (S.Less.ofQ(upEvaled, vpEvaled)) {
            t = -1;
        }
        return t;
    }

    public int invWeightCompareTo(IExpr[][] w, ExpVectorSymbolic V) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = 0; i < u.length; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            IExpr[] wk = w[k];
            IASTAppendable up = F.PlusAlloc(i + 1);
            IASTAppendable vp = F.PlusAlloc(i + 1);
            for (int j = i; j >= 0; --j) {
                up.append(F.Times(wk[j], u[j]));
                vp.append(F.Times(wk[j], v[j]));
            }
            IExpr upEvaled = EvalEngine.get().evaluate(up);
            IExpr vpEvaled = EvalEngine.get().evaluate(vp);
            if (S.Greater.ofQ(upEvaled, vpEvaled)) {
                return 1;
            }
            if (!S.Less.ofQ(upEvaled, vpEvaled)) continue;
            return -1;
        }
        return t;
    }

    public int invWeightCompareTo(IExpr[][] w, ExpVectorSymbolic V, int begin, int end) {
        int i;
        IExpr[] u = this.val;
        IExpr[] v = V.val;
        int t = 0;
        for (i = begin; i < end; ++i) {
            if (S.Greater.ofQ(u[i], v[i])) {
                t = 1;
                break;
            }
            if (!S.Less.ofQ(u[i], v[i])) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            IExpr[] wk = w[k];
            IASTAppendable up = F.PlusAlloc(i - end + 1);
            IASTAppendable vp = F.PlusAlloc(i - end + 1);
            for (int j = i; j < end; ++j) {
                up.append(F.Times(wk[j], u[j]));
                vp.append(F.Times(wk[j], v[j]));
            }
            IExpr upEvaled = EvalEngine.get().evaluate(up);
            IExpr vpEvaled = EvalEngine.get().evaluate(vp);
            if (S.Greater.ofQ(upEvaled, vpEvaled)) {
                return 1;
            }
            if (!S.Less.ofQ(upEvaled, vpEvaled)) continue;
            return -1;
        }
        return t;
    }

    public static ExpVectorSymbolic valueOf(int n) {
        return new ExpVectorSymbolic(n);
    }

    public int varIndex(int idx) {
        return this.length() - idx - 1;
    }

    public static int indexVar(IExpr x, IAST vars) {
        int len = vars.size();
        for (int i = 1; i < len; ++i) {
            if (!x.equals(vars.get(i))) continue;
            return len - i - 1;
        }
        return -1;
    }
}

