/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.longexponent;

import com.google.common.io.CharStreams;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;

public class ExprRingFactory
implements RingFactory<IExpr> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = -6146597389011632638L;
    public static final ExprRingFactory CONST = new ExprRingFactory();

    private ExprRingFactory() {
    }

    public boolean isField() {
        return false;
    }

    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    public IExpr fromInteger(long a) {
        return F.ZZ(a);
    }

    public static IExpr valueOf(long a) {
        return F.ZZ(a);
    }

    public IExpr getZERO() {
        return F.C0;
    }

    public IExpr copy(IExpr c) {
        return (IExpr)c.copy();
    }

    public IExpr fromInteger(BigInteger a) {
        return F.ZZ(a);
    }

    public List<IExpr> generators() {
        return null;
    }

    public boolean isFinite() {
        return false;
    }

    public IExpr parse(String s) {
        return EvalEngine.get().parse(s);
    }

    public IExpr parse(Reader r) {
        try {
            String s = CharStreams.toString((Readable)r);
            return EvalEngine.get().parse(s);
        }
        catch (IOException e) {
            LOGGER.error("ExprRingFactory.parse() failed", (Throwable)e);
            return S.Undefined;
        }
    }

    public IExpr random(int n) {
        return null;
    }

    public IExpr random(int n, Random random) {
        return null;
    }

    public String toScript() {
        return "ExprRingFactory";
    }

    public IExpr getONE() {
        return F.C1;
    }

    public boolean isAssociative() {
        return true;
    }

    public boolean isCommutative() {
        return true;
    }
}

