/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.longexponent;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.LongIterable;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.longexponent.ExpVectorLong;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.polynomials.longexponent.ExprTermOrder;
import org.matheclipse.core.polynomials.longexponent.ExprTermOrderByName;

public class ExprPolynomialRing
implements RingFactory<ExprPolynomial> {
    private static final long serialVersionUID = -6136386786501333693L;
    public final ExprRingFactory coFac;
    public final int nvar;
    public final ExprTermOrder tord;
    protected boolean partial;
    protected IAST vars;
    public final ExprPolynomial ZERO;
    public final ExprPolynomial ONE;
    public final ExpVectorLong evzero;
    protected static final ThreadLocalRandom random = ThreadLocalRandom.current();
    protected int isField = -1;
    final boolean numericFunction;

    public ExprPolynomialRing(IAST listOfVariables) {
        this(ExprRingFactory.CONST, listOfVariables, listOfVariables.argSize(), ExprTermOrderByName.Lexicographic);
    }

    public ExprPolynomialRing(IAST listOfVariables, ExprTermOrder t) {
        this(ExprRingFactory.CONST, listOfVariables, listOfVariables.argSize(), t);
    }

    public ExprPolynomialRing(ISymbol symbol) {
        this(ExprRingFactory.CONST, F.list(symbol), 1, ExprTermOrderByName.Lexicographic);
    }

    public ExprPolynomialRing(ISymbol symbol, ExprTermOrder t) {
        this(ExprRingFactory.CONST, F.list(symbol), 1, t);
    }

    public ExprPolynomialRing(ExprRingFactory cf, IAST listOfVariables) {
        this(cf, listOfVariables, listOfVariables.argSize(), ExprTermOrderByName.Lexicographic);
    }

    public ExprPolynomialRing(ExprRingFactory cf, IAST listOfVariables, ExprTermOrder t) {
        this(cf, listOfVariables, listOfVariables.argSize(), t);
    }

    private ExprPolynomialRing(ExprRingFactory cf, IAST listOfVariables, int n, ExprTermOrder t) {
        this(cf, listOfVariables, n, t, false);
    }

    public ExprPolynomialRing(ExprRingFactory cf, IAST listOfVariables, int n, ExprTermOrder t, boolean numericFunction) {
        this.coFac = cf;
        this.nvar = n;
        this.tord = t;
        this.partial = false;
        this.vars = listOfVariables.copyAppendable();
        this.ZERO = new ExprPolynomial(this);
        IExpr coeff = this.coFac.getONE();
        this.evzero = new ExpVectorLong(this.nvar);
        this.numericFunction = numericFunction;
        this.ONE = new ExprPolynomial(this, coeff, this.evzero);
        if (this.vars.argSize() != this.nvar) {
            throw new IllegalArgumentException("incompatible variable size " + this.vars.size() + ", " + this.nvar);
        }
    }

    public ExprPolynomialRing(ExprRingFactory cf, ExprPolynomialRing o) {
        this(cf, o.vars, o.nvar, o.tord);
    }

    public ExprPolynomialRing(ExprPolynomialRing o, ExprTermOrder to) {
        this(o.coFac, o.vars, o.nvar, to);
    }

    public ExprPolynomialRing copy() {
        return new ExprPolynomialRing(this.coFac, this);
    }

    public ExprPolynomial create(IExpr exprPoly) throws ArithmeticException, JASConversionException {
        return this.create(exprPoly, false, true, false);
    }

    public ExprPolynomial create(IExpr exprPoly, boolean coefficient, boolean checkNegativeExponents, boolean coefficientListMode) throws ArithmeticException, JASConversionException {
        int ix = ExpVectorLong.indexVar(exprPoly, this.getVars());
        if (ix >= 0) {
            ExpVectorLong e = new ExpVectorLong(this.vars.argSize(), ix, 1L);
            return this.getOne().multiply(e);
        }
        if (exprPoly instanceof IAST) {
            IExpr base;
            IAST ast = (IAST)exprPoly;
            if (ast.isDirectedInfinity()) {
                throw new JASConversionException();
            }
            ExprPolynomial result = this.getZero();
            ExprPolynomial p = this.getZero();
            if (ast.isPlus()) {
                IExpr expr = ast.arg1();
                result = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = ast.arg1();
                result = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.create(expr, coefficient, checkNegativeExponents, coefficientListMode);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower() && (ix = ExpVectorLong.indexVar(base = ast.base(), this.getVars())) >= 0) {
                int exponent = ast.exponent().toIntDefault();
                if (checkNegativeExponents && exponent < 0) {
                    throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.arg2().toString());
                }
                if (exponent < 0 && coefficientListMode) {
                    return new ExprPolynomial(this, ast);
                }
                if (exponent == Integer.MIN_VALUE) {
                    return new ExprPolynomial(this, ast);
                }
                ExpVectorLong e = new ExpVectorLong(this.vars.argSize(), ix, exponent);
                return this.getOne().multiply(e);
            }
            if (coefficient) {
                return new ExprPolynomial(this, ast);
            }
            if (this.numericFunction && ast.isNumericFunction(true)) {
                return new ExprPolynomial(this, ast);
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                if (exprPoly.isIndeterminate()) {
                    throw new JASConversionException();
                }
                if (coefficient) {
                    return new ExprPolynomial(this, exprPoly);
                }
                if (this.numericFunction) {
                    if (exprPoly.isNumericFunction(true)) {
                        return new ExprPolynomial(this, exprPoly);
                    }
                    throw new JASConversionException();
                }
                return new ExprPolynomial(this, exprPoly);
            }
            if (exprPoly.isNumber()) {
                return new ExprPolynomial(this, exprPoly);
            }
        }
        if (exprPoly.isFree(Predicates.in(this.vars), true) && !(exprPoly instanceof IDataExpr)) {
            return new ExprPolynomial(this, exprPoly);
        }
        throw new JASConversionException();
    }

    public static Map<IExpr, IExpr> create(IExpr exprPoly, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) throws ArithmeticException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr expr = ast.get(i);
                    coefficientMap = ExprPolynomialRing.create(expr, x, coefficientMap, restList);
                }
                return coefficientMap;
            }
            if (ast.isTimes()) {
                return ExprPolynomialRing.createTimesSub(ast, x, coefficientMap, restList);
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                IExpr exponent = ast.exponent();
                if (exponent.isFree(x)) {
                    if (base.equals(x)) {
                        return ExprPolynomialRing.addCoefficient(coefficientMap, exponent, F.C1);
                    }
                    if (base.isFree(x)) {
                        return ExprPolynomialRing.addCoefficient(coefficientMap, F.C0, ast);
                    }
                }
                restList.append(ast);
                return coefficientMap;
            }
        } else {
            if (exprPoly.equals(x)) {
                return ExprPolynomialRing.addCoefficient(coefficientMap, F.C1, F.C1);
            }
            if (exprPoly.isNumber()) {
                return ExprPolynomialRing.addCoefficient(coefficientMap, F.C0, exprPoly);
            }
        }
        if (exprPoly.isFree(x, true)) {
            return ExprPolynomialRing.addCoefficient(coefficientMap, F.C0, exprPoly);
        }
        restList.append(exprPoly);
        return coefficientMap;
    }

    private static Map<IExpr, IExpr> createTimesSub(IAST ast, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) {
        IExpr mainExponent = F.NIL;
        IASTAppendable times = F.TimesAlloc(ast.size());
        for (int i = 1; i < ast.size(); ++i) {
            IExpr exponent;
            IExpr expr = ast.get(i);
            if (expr.isFree(x, true)) {
                times.append(expr);
                continue;
            }
            if (expr.equals(x)) {
                exponent = F.C1;
                if (!mainExponent.isPresent()) {
                    mainExponent = exponent;
                    continue;
                }
            } else if (expr.isPower() && (exponent = expr.exponent()).isFree(x) && expr.base().equals(x) && !mainExponent.isPresent()) {
                mainExponent = exponent;
                continue;
            }
            restList.append(ast);
            return coefficientMap;
        }
        return ExprPolynomialRing.addCoefficient(coefficientMap, mainExponent, times.oneIdentity1());
    }

    public static Map<IExpr, IExpr> createTimes(IAST ast, IExpr x, Map<IExpr, IExpr> coefficientMap, IASTAppendable restList) {
        IExpr mainExponent = F.NIL;
        IASTAppendable times = F.TimesAlloc(ast.size());
        for (int i = 1; i < ast.size(); ++i) {
            IExpr expr = ast.get(i);
            if (expr.isFree(x, true)) {
                times.append(expr);
                continue;
            }
            if (expr.equals(x)) {
                if (!mainExponent.isPresent()) {
                    mainExponent = F.C1;
                    continue;
                }
            } else if (expr.isPower()) {
                IExpr base = expr.base();
                IExpr exponent = expr.exponent();
                if (exponent.isFree(x) && base.equals(x) && exponent.isInteger() && !mainExponent.isPresent()) {
                    mainExponent = exponent;
                    continue;
                }
            }
            restList.append(expr);
        }
        return ExprPolynomialRing.addCoefficient(coefficientMap, mainExponent, times.oneIdentity1());
    }

    private static Map<IExpr, IExpr> addCoefficient(Map<IExpr, IExpr> coefficientMap, IExpr exponent, IExpr coefficient) {
        if (exponent.isPresent()) {
            IExpr oldCoefficient = coefficientMap.get(exponent);
            if (oldCoefficient != null) {
                if (oldCoefficient.isTimes()) {
                    ((IASTAppendable)oldCoefficient).append(coefficient);
                } else {
                    IASTAppendable times = F.TimesAlloc(4);
                    times.append(oldCoefficient);
                    times.append(coefficient);
                    coefficientMap.put(exponent, times);
                }
            } else {
                coefficientMap.put(exponent, coefficient);
            }
        }
        return coefficientMap;
    }

    public boolean isPolynomial(IExpr expression) throws ArithmeticException, JASConversionException {
        return this.isPolynomial(expression, false);
    }

    public boolean isPolynomial(IExpr expression, boolean coefficient) throws ArithmeticException, JASConversionException {
        for (int i = 1; i < this.vars.size(); ++i) {
            IExpr expr;
            IExpr variable = this.vars.get(i);
            if (variable.equals(expression)) {
                return true;
            }
            if (!variable.isPower() || !variable.base().equals(expression) || !variable.exponent().isRational() || (expr = variable.exponent().reciprocal()).isZero()) continue;
            return expr.isInteger();
        }
        if (expression instanceof IAST) {
            IAST ast = (IAST)expression;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (this.isPolynomial(ast.get(i), coefficient)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (this.isPolynomial(ast.get(i), coefficient)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                for (int i = 1; i < this.vars.size(); ++i) {
                    IExpr expr;
                    IExpr variable = this.vars.get(i);
                    if (variable.equals(base)) {
                        int exponent = ast.exponent().toIntDefault();
                        return exponent >= 0;
                    }
                    if (!variable.isPower() || !variable.base().equals(ast.base()) || !variable.exponent().isRational() || (expr = variable.exponent().reciprocal().times(ast.exponent())).isZero()) continue;
                    return expr.isInteger();
                }
            }
            if (coefficient) {
                return true;
            }
            if (this.numericFunction && ast.isNumericFunction(true)) {
                return true;
            }
        } else {
            if (expression instanceof ISymbol) {
                if (coefficient) {
                    return true;
                }
                if (this.numericFunction) {
                    return expression.isNumericFunction(true);
                }
                return true;
            }
            if (expression.isNumber()) {
                return true;
            }
        }
        return expression.isFree(Predicates.in(this.vars), true);
    }

    public String toString() {
        Object res = null;
        if (PrettyPrint.isTrue()) {
            String scf = this.coFac.getClass().getSimpleName();
            if (res == null && ((String)(res = this.coFac.toString())).matches("[0-9].*")) {
                res = scf;
            }
            res = (String)res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ";
        } else {
            res = this.getClass().getSimpleName() + "[ " + this.coFac.toString() + " ";
            res = (String)res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ]";
        }
        return res;
    }

    public String toScript() {
        StringBuilder s = new StringBuilder();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("PolyRing.new(");
                break;
            }
            default: {
                s.append("PolyRing(");
            }
        }
        s.append(this.coFac.toScript().trim());
        s.append(",\"" + this.varsToString() + "\"");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = ",PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = ",PolyRing.grad";
        }
        s.append(to);
        s.append(")");
        return s.toString();
    }

    public String toScript(ExpVectorLong e) {
        if (this.vars != null) {
            return e.toScript(this.vars);
        }
        return e.toScript();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ExprPolynomialRing)) {
            return false;
        }
        ExprPolynomialRing oring = (ExprPolynomialRing)other;
        if (this.nvar != oring.nvar) {
            return false;
        }
        if (!this.coFac.equals(oring.coFac)) {
            return false;
        }
        if (!this.tord.equals(oring.tord)) {
            return false;
        }
        return this.vars.equals(oring.vars);
    }

    public int hashCode() {
        int h = this.nvar << 27;
        h += this.coFac.hashCode() << 11;
        return h += this.tord.hashCode();
    }

    public IAST getVars() {
        return this.vars;
    }

    public IAST setVars(IAST v) {
        if (v.argSize() != this.nvar) {
            throw new IllegalArgumentException("v not matching number of variables: " + v.toString() + ", nvar " + this.nvar);
        }
        IAST t = this.vars;
        this.vars = v.copyAppendable();
        return t;
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVectorLong.varsToString(this.vars);
    }

    public IExpr getZEROCoefficient() {
        return this.coFac.getZERO();
    }

    public IExpr getONECoefficient() {
        return this.coFac.getONE();
    }

    public ExprPolynomial getZero() {
        return this.ZERO;
    }

    public ExprPolynomial getOne() {
        return this.ONE;
    }

    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.nvar == 0) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public ExprPolynomial valueOf(IExpr a) {
        return new ExprPolynomial(this, a);
    }

    public ExprPolynomial valueOf(ExpVectorLong e) {
        return new ExprPolynomial(this, this.coFac.getONE(), e);
    }

    public ExprPolynomial valueOf(IExpr a, ExpVectorLong e) {
        return new ExprPolynomial(this, a, e);
    }

    public ExprPolynomial fromInteger(long a) {
        return new ExprPolynomial(this, this.coFac.fromInteger(a), this.evzero);
    }

    public ExprPolynomial fromInteger(BigInteger a) {
        return new ExprPolynomial(this, this.coFac.fromInteger(a), this.evzero);
    }

    public ExprPolynomial copy(ExprPolynomial c) {
        return new ExprPolynomial(this, c.val);
    }

    public ExprPolynomial univariate(int i) {
        return this.univariate(0, i, 1L);
    }

    public ExprPolynomial univariate(int i, long e) {
        return this.univariate(0, i, e);
    }

    public ExprPolynomial univariate(int modv, int i, long e) {
        ExprPolynomial p = this.getZero();
        int r = this.nvar - modv;
        if (0 <= i && i < r) {
            IExpr one = this.coFac.getONE();
            ExpVectorLong f = new ExpVectorLong(r, i, e);
            if (modv > 0) {
                f = f.extend(modv, 0, 0L);
            }
            p = p.sum(one, f);
        }
        return p;
    }

    public List<ExprPolynomial> getGenerators() {
        List<? extends ExprPolynomial> univs = this.univariateList();
        ArrayList<ExprPolynomial> gens = new ArrayList<ExprPolynomial>(univs.size() + 1);
        gens.add(this.getOne());
        gens.addAll(univs);
        return gens;
    }

    public List<ExprPolynomial> generators() {
        List<IExpr> cogens = this.coFac.generators();
        List<? extends ExprPolynomial> univs = this.univariateList();
        ArrayList<ExprPolynomial> gens = new ArrayList<ExprPolynomial>(univs.size() + cogens.size());
        for (IExpr c : cogens) {
            gens.add(this.getOne().multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    public List<ExprPolynomial> generators(int modv) {
        List<IExpr> cogens = this.coFac.generators();
        List<? extends ExprPolynomial> univs = this.univariateList(modv);
        ArrayList<ExprPolynomial> gens = new ArrayList<ExprPolynomial>(univs.size() + cogens.size());
        for (IExpr c : cogens) {
            gens.add(this.getOne().multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    public boolean isFinite() {
        return this.nvar == 0 && this.coFac.isFinite();
    }

    public List<? extends ExprPolynomial> univariateList() {
        return this.univariateList(0, 1L);
    }

    public List<? extends ExprPolynomial> univariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<? extends ExprPolynomial> univariateList(int modv, long e) {
        ArrayList<ExprPolynomial> pols = new ArrayList<ExprPolynomial>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            ExprPolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add(p);
        }
        return pols;
    }

    public ExprPolynomialRing extend(IAST vn) {
        if (vn == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int i = vn.argSize();
        IASTAppendable v = this.vars.copyAppendable();
        v.appendArgs(vn);
        ExprTermOrder to = this.tord.extend(this.nvar, i);
        ExprPolynomialRing pfac = new ExprPolynomialRing(this.coFac, v, this.nvar + i, to);
        return pfac;
    }

    public ExprPolynomialComparator getComparator() {
        return new ExprPolynomialComparator(this.tord, false);
    }

    public ExprPolynomialComparator getComparator(boolean rev) {
        return new ExprPolynomialComparator(this.tord, rev);
    }

    public static String[] permuteVars(List<Integer> P, String[] vars) {
        if (vars == null || vars.length <= 1) {
            return vars;
        }
        String[] b = new String[vars.length];
        int j = 0;
        for (Integer i : P) {
            b[j++] = vars[i];
        }
        return b;
    }

    public Iterator<ExprPolynomial> iterator() {
        if (this.coFac.isFinite()) {
            return new GenPolynomialIterator(this);
        }
        return new GenPolynomialMonomialIterator(this);
    }

    public ExprPolynomial getZERO() {
        return this.getZero();
    }

    public ExprPolynomial random(int n) {
        return null;
    }

    public ExprPolynomial random(int n, Random random) {
        return null;
    }

    public ExprPolynomial parse(String s) {
        return null;
    }

    public ExprPolynomial parse(Reader r) {
        return null;
    }

    public ExprPolynomial getONE() {
        return this.getOne();
    }

    private static class GenPolynomialIterator
    implements Iterator<ExprPolynomial> {
        final ExprPolynomialRing ring;
        final Iterator<List<Long>> eviter;
        final List<ExpVectorLong> powers;
        final List<Iterable<IExpr>> coeffiter;
        Iterator<List<IExpr>> itercoeff;
        ExprPolynomial current;

        public GenPolynomialIterator(ExprPolynomialRing fac) {
            this.ring = fac;
            LongIterable li = new LongIterable();
            li.setNonNegativeIterator();
            ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(this.ring.nvar);
            for (int i = 0; i < this.ring.nvar; ++i) {
                tlist.add(li);
            }
            CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
            this.eviter = ei.iterator();
            ExprRingFactory cf = this.ring.coFac;
            this.coeffiter = new ArrayList<Iterable<IExpr>>();
            if (!(cf instanceof Iterable) || !cf.isFinite()) {
                throw new IllegalArgumentException("only for finite iterable coefficients implemented");
            }
            Iterable cfi = (Iterable)((Object)cf);
            this.coeffiter.add(cfi);
            CartesianProduct tuples = new CartesianProduct(this.coeffiter);
            this.itercoeff = tuples.iterator();
            this.powers = new ArrayList<ExpVectorLong>();
            ExpVectorLong e = ExpVectorLong.create((Collection<Long>)this.eviter.next());
            this.powers.add(e);
            List<IExpr> c = this.itercoeff.next();
            this.current = new ExprPolynomial(this.ring, c.get(0), e);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public synchronized ExprPolynomial next() {
            ExprPolynomial res = this.current;
            if (!this.itercoeff.hasNext()) {
                ExpVectorLong e = ExpVectorLong.create((Collection<Long>)this.eviter.next());
                this.powers.add(0, e);
                if (this.coeffiter.size() == 1) {
                    this.coeffiter.add(this.coeffiter.get(0));
                    Iterable<IExpr> it = this.coeffiter.get(0);
                    ArrayList<IExpr> elms = new ArrayList<IExpr>();
                    for (IExpr elm : it) {
                        elms.add(elm);
                    }
                    elms.remove(0);
                    this.coeffiter.set(0, elms);
                } else {
                    this.coeffiter.add(this.coeffiter.get(1));
                }
                CartesianProduct tuples = new CartesianProduct(this.coeffiter);
                this.itercoeff = tuples.iterator();
            }
            List<IExpr> coeffs = this.itercoeff.next();
            ExprPolynomial pol = this.ring.getZero().copy();
            int i = 0;
            for (ExpVectorLong f : this.powers) {
                IExpr c;
                if ((c = coeffs.get(i++)).isZERO()) continue;
                if (pol.val.get(f) != null) {
                    throw new RuntimeException("error in iterator");
                }
                pol.doPutToMap(f, c);
            }
            this.current = pol;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannnot remove elements");
        }
    }

    private static class ExprPolynomialComparator
    implements Serializable,
    Comparator<ExprPolynomial> {
        private static final long serialVersionUID = -2427163728878196089L;
        public final ExprTermOrder tord;
        public final boolean reverse;

        public ExprPolynomialComparator(ExprTermOrder t, boolean reverse) {
            this.tord = t;
            this.reverse = reverse;
        }

        @Override
        public int compare(ExprPolynomial p1, ExprPolynomial p2) {
            int s = p1.compareTo(p2);
            if (this.reverse) {
                return -s;
            }
            return s;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ExprPolynomialComparator) {
                ExprPolynomialComparator pc = (ExprPolynomialComparator)o;
                return this.tord.equals(pc.tord);
            }
            return false;
        }

        public int hashCode() {
            return this.tord.hashCode();
        }

        public String toString() {
            return "PolynomialComparator(" + this.tord + ")";
        }
    }

    private static class GenPolynomialMonomialIterator
    implements Iterator<ExprPolynomial> {
        final ExprPolynomialRing ring;
        final Iterator<List<IExpr>> iter;
        ExprPolynomial current;

        public GenPolynomialMonomialIterator(ExprPolynomialRing fac) {
            Iterable cfi;
            this.ring = fac;
            LongIterable li = new LongIterable();
            li.setNonNegativeIterator();
            ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(this.ring.nvar);
            for (int i = 0; i < this.ring.nvar; ++i) {
                tlist.add(li);
            }
            CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
            ExprRingFactory cf = this.ring.coFac;
            if (!(cf instanceof Iterable) || cf.isFinite()) {
                throw new IllegalArgumentException("only for infinite iterable coefficients implemented");
            }
            Iterable coeffiter = cfi = (Iterable)((Object)cf);
            ArrayList<Object> eci = new ArrayList<Object>(2);
            eci.add(ei);
            eci.add(coeffiter);
            CartesianProductInfinite ecp = new CartesianProductInfinite(eci);
            this.iter = ecp.iterator();
            List<IExpr> ec = this.iter.next();
            List ecl = (List)((Object)ec.get(0));
            IExpr c = ec.get(1);
            ExpVectorLong e = ExpVectorLong.create(ecl);
            this.current = new ExprPolynomial(this.ring, c, e);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public synchronized ExprPolynomial next() {
            ExprPolynomial res = this.current;
            List<IExpr> ec = this.iter.next();
            IExpr c = ec.get(1);
            while (c.isZERO()) {
                ec = this.iter.next();
                c = ec.get(1);
            }
            List ecl = (List)((Object)ec.get(0));
            ExpVectorLong e = ExpVectorLong.create(ecl);
            this.current = new ExprPolynomial(this.ring, c, e);
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannnot remove elements");
        }
    }
}

