/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.longexponent;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.longexponent.AlgebraicNotInvertibleException;
import org.matheclipse.core.polynomials.longexponent.ExpVectorLong;
import org.matheclipse.core.polynomials.longexponent.ExprMonomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprTermOrder;
import org.matheclipse.core.polynomials.longexponent.ExprTermOrderByName;
import org.matheclipse.parser.trie.Trie;

public class ExprPolynomial
implements RingElem<ExprPolynomial>,
Iterable<ExprMonomial> {
    private static final long serialVersionUID = -3069278103478903325L;
    public final ExprPolynomialRing ring;
    protected final SortedMap<ExpVectorLong, IExpr> val;
    private final boolean debug = false;

    private ExprPolynomial(ExprPolynomialRing r, TreeMap<ExpVectorLong, IExpr> t) {
        this.ring = r;
        this.val = t;
    }

    public ExprPolynomial(ExprPolynomialRing r) {
        this(r, new TreeMap<ExpVectorLong, IExpr>(r.tord.getDescendComparator()));
    }

    public ExprPolynomial(ExprPolynomialRing r, IExpr c, ExpVectorLong e) {
        this(r);
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public ExprPolynomial(ExprPolynomialRing r, IExpr c) {
        this(r, c, r.evzero);
    }

    public ExprPolynomial(ExprPolynomialRing r, ExpVectorLong e) {
        this(r, r.coFac.getONE(), e);
    }

    protected ExprPolynomial(ExprPolynomialRing r, SortedMap<ExpVectorLong, IExpr> v) {
        this(r);
        if (v.size() > 0) {
            this.val.putAll(v);
        }
    }

    public ExprPolynomialRing factory() {
        return this.ring;
    }

    public ExprPolynomial copy() {
        return new ExprPolynomial(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<ExpVectorLong, IExpr> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(ExpVectorLong e, IExpr c) {
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public void doRemoveFromMap(ExpVectorLong e, IExpr c) {
        IExpr b = (IExpr)this.val.remove(e);
    }

    public void doPutToMap(SortedMap<ExpVectorLong, IExpr> vals) {
        for (Map.Entry<ExpVectorLong, IExpr> me : vals.entrySet()) {
            ExpVectorLong e = me.getKey();
            IExpr c = me.getValue();
            if (c.isZERO()) continue;
            this.val.put(e, c);
        }
    }

    public String toString() {
        if (this.ring.vars != null) {
            return this.toString(this.ring.vars);
        }
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName() + ":");
        s.append(this.ring.coFac.getClass().getSimpleName());
        if (this.ring.coFac.characteristic().signum() != 0) {
            s.append("(" + this.ring.coFac.characteristic() + ")");
        }
        s.append("[ ");
        boolean first = true;
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(m.getValue().toString());
            s.append(" ");
            s.append(m.getKey().toString());
        }
        s.append(" ] ");
        return s.toString();
    }

    public String toString(IAST v) {
        StringBuilder s = new StringBuilder();
        if (PrettyPrint.isTrue()) {
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
                    IExpr c = m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVectorLong e = m.getKey();
                    if (!c.isOne() || e.isZERO()) {
                        String cs = c.toString();
                        if (cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0) {
                            s.append("( ");
                            s.append(cs);
                            s.append(" )");
                        } else {
                            s.append(cs);
                        }
                        s.append(" ");
                    }
                    if (v != null) {
                        s.append(e.toString(v));
                        continue;
                    }
                    s.append(e);
                }
            }
        } else {
            s.append(this.getClass().getSimpleName() + "[ ");
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
                    IExpr c = m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVectorLong e = m.getKey();
                    if (!c.isOne() || e.isZERO()) {
                        s.append(c.toString());
                        s.append(" ");
                    }
                    s.append(e.toString(v));
                }
            }
            s.append(" ] ");
        }
        return s.toString();
    }

    public String toScript() {
        if (this.isZERO()) {
            return "0";
        }
        StringBuilder s = new StringBuilder();
        if (this.val.size() > 1) {
            s.append("( ");
        }
        IAST v = this.ring.vars;
        boolean first = true;
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            boolean parenthesis;
            IExpr c = m.getValue();
            if (first) {
                first = false;
            } else if (c.signum() < 0) {
                s.append(" - ");
                c = c.negate();
            } else {
                s.append(" + ");
            }
            ExpVectorLong e = m.getKey();
            String cs = c.toScript();
            boolean bl = parenthesis = cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0;
            if (!c.isOne() || e.isZERO()) {
                if (parenthesis) {
                    s.append("( ");
                }
                s.append(cs);
                if (parenthesis) {
                    s.append(" )");
                }
                if (!e.isZERO()) {
                    s.append(" * ");
                }
            }
            s.append(e.toScript(v));
        }
        if (this.val.size() > 1) {
            s.append(" )");
        }
        return s.toString();
    }

    public String toScriptFactory() {
        return this.factory().toScript();
    }

    public boolean isZero() {
        return this.val.size() == 0;
    }

    public boolean isZERO() {
        return this.isZero();
    }

    public boolean isOne() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isOne();
    }

    public boolean isONE() {
        return this.isOne();
    }

    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        return c != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long deg = -1L;
        for (ExpVectorLong e : this.val.keySet()) {
            if (deg < 0L) {
                deg = e.totalDeg();
                continue;
            }
            if (deg == e.totalDeg()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object B) {
        if (B == null) {
            return false;
        }
        if (!(B instanceof ExprPolynomial)) {
            return false;
        }
        ExprPolynomial a = (ExprPolynomial)B;
        return this.compareTo(a) == 0;
    }

    public int hashCode() {
        int h = this.ring.hashCode() << 27;
        return h += this.val.hashCode();
    }

    public int compareTo(ExprPolynomial b) {
        if (b == null) {
            return 1;
        }
        SortedMap<ExpVectorLong, IExpr> av = this.val;
        SortedMap<ExpVectorLong, IExpr> bv = b.val;
        Iterator<Map.Entry<ExpVectorLong, IExpr>> ai = av.entrySet().iterator();
        Iterator<Map.Entry<ExpVectorLong, IExpr>> bi = bv.entrySet().iterator();
        int s = 0;
        int c = 0;
        while (ai.hasNext() && bi.hasNext()) {
            ExpVectorLong be;
            Map.Entry<ExpVectorLong, IExpr> aie = ai.next();
            Map.Entry<ExpVectorLong, IExpr> bie = bi.next();
            ExpVectorLong ae = aie.getKey();
            s = ae.compareTo(be = bie.getKey());
            if (s != 0) {
                return s;
            }
            if (c != 0) continue;
            IExpr ac = aie.getValue();
            IExpr bc = bie.getValue();
            c = ac.compareTo(bc);
        }
        if (ai.hasNext()) {
            return 1;
        }
        if (bi.hasNext()) {
            return -1;
        }
        return c;
    }

    @Deprecated
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        ExpVectorLong t = this.val.firstKey();
        IExpr c = (IExpr)this.val.get(t);
        return c.signum();
    }

    public int numberOfVariables() {
        return this.ring.nvar;
    }

    public Map.Entry<ExpVectorLong, IExpr> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<ExpVectorLong, IExpr>> ai = this.val.entrySet().iterator();
        return ai.next();
    }

    public ExpVectorLong leadingExpVectorLong() {
        if (this.val.size() == 0) {
            return null;
        }
        return this.val.firstKey();
    }

    public ExpVectorLong trailingExpVectorLong() {
        if (this.val.size() == 0) {
            return this.ring.evzero;
        }
        return this.val.lastKey();
    }

    public IExpr leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return this.ring.coFac.getZERO();
        }
        return (IExpr)this.val.get(this.val.firstKey());
    }

    @Deprecated
    private IExpr trailingBaseCoefficient() {
        IExpr c = (IExpr)this.val.get(this.ring.evzero);
        if (c == null) {
            return this.ring.coFac.getZERO();
        }
        return c;
    }

    public IExpr coefficient(ExpVectorLong e) {
        IExpr c = (IExpr)this.val.get(e);
        if (c == null) {
            c = this.ring.coFac.getZERO();
        }
        return c;
    }

    public ExprPolynomial reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZero();
        }
        Iterator<ExpVectorLong> ai = this.val.keySet().iterator();
        ExpVectorLong lt = ai.next();
        lt = ai.next();
        SortedMap<ExpVectorLong, IExpr> red = this.val.tailMap(lt);
        ExprPolynomial r = this.ring.getZero().copy();
        r.doPutToMap(red);
        return r;
    }

    public long degree(int i) {
        if (this.val.size() == 0) {
            return 0L;
        }
        int j = i >= 0 ? this.ring.nvar - 1 - i : this.ring.nvar + i;
        long deg = 0L;
        for (ExpVectorLong e : this.val.keySet()) {
            long d = e.getVal(j);
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public long degree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long deg = 0L;
        for (ExpVectorLong e : this.val.keySet()) {
            long d = e.maxDeg();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public long totalDegree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long deg = 0L;
        for (ExpVectorLong e : this.val.keySet()) {
            long d = e.totalDeg();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public long weightDegree() {
        long[][] w = this.ring.tord.getWeight();
        if (w == null || w.length == 0) {
            return this.totalDegree();
        }
        if (this.val.isEmpty()) {
            return -1L;
        }
        long deg = 0L;
        for (ExpVectorLong e : this.val.keySet()) {
            long d = e.weightDeg(w);
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public ExprPolynomial leadingWeightPolynomial() {
        if (this.val.isEmpty()) {
            return this.ring.getZero();
        }
        long[][] w = this.ring.tord.getWeight();
        long maxw = w == null || w.length == 0 ? this.totalDegree() : this.weightDegree();
        ExprPolynomial wp = new ExprPolynomial(this.ring);
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            ExpVectorLong e = m.getKey();
            long d = e.weightDeg(w);
            if (d < maxw) continue;
            wp.val.put(e, m.getValue());
        }
        return wp;
    }

    public boolean isWeightHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long[][] w = this.ring.tord.getWeight();
        if (w == null || w.length == 0) {
            return this.isHomogeneous();
        }
        long deg = -1L;
        for (ExpVectorLong e : this.val.keySet()) {
            if (deg < 0L) {
                deg = e.weightDeg(w);
                continue;
            }
            if (deg == e.weightDeg(w)) continue;
            return false;
        }
        return true;
    }

    public ExpVectorLong degreeVector() {
        ExpVectorLong deg = this.ring.evzero;
        if (this.val.size() == 0) {
            return deg;
        }
        for (ExpVectorLong e : this.val.keySet()) {
            deg = deg.lcm(e);
        }
        return deg;
    }

    public IExpr maxNorm() {
        IExpr n = this.ring.getZEROCoefficient();
        for (IExpr c : this.val.values()) {
            IExpr x = c.abs();
            if (n.compareTo(x) >= 0) continue;
            n = x;
        }
        return n;
    }

    public IExpr sumNorm() {
        IExpr n = this.ring.getZEROCoefficient();
        for (IExpr c : this.val.values()) {
            IExpr x = c.abs();
            n = n.add(x);
        }
        return n;
    }

    public ExprPolynomial sum(ExprPolynomial S2) {
        if (S2 == null) {
            return this;
        }
        if (S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.add(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
        return n;
    }

    public ExprPolynomial sum(IExpr a, ExpVectorLong e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.add(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
        return n;
    }

    public ExprPolynomial sum(IExpr a) {
        return this.sum(a, this.ring.evzero);
    }

    public void doAddTo(ExprPolynomial S2) {
        if (S2 == null || S2.isZERO()) {
            return;
        }
        if (this.isZERO()) {
            this.val.putAll(S2.val);
            return;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        SortedMap<ExpVectorLong, IExpr> nv = this.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.add(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
    }

    public void doAddTo(IExpr a, ExpVectorLong e) {
        if (a == null || a.isZERO()) {
            return;
        }
        SortedMap<ExpVectorLong, IExpr> nv = this.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.add(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
    }

    public void doAddTo(IExpr a) {
        this.doAddTo(a, this.ring.evzero);
    }

    public ExprPolynomial subtract(ExprPolynomial S2) {
        if (S2 == null) {
            return this;
        }
        if (S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.negate();
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong e = me.getKey();
            IExpr y = me.getValue();
            IExpr x = (IExpr)nv.get(e);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y.negate());
        }
        return n;
    }

    public ExprPolynomial subtract(IExpr a, ExpVectorLong e) {
        if (a == null || a.isZERO()) {
            return this;
        }
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        IExpr x = (IExpr)nv.get(e);
        if (x != null) {
            if (!(x = x.subtract(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a.negate());
        }
        return n;
    }

    public ExprPolynomial subtract(IExpr a) {
        return this.subtract(a, this.ring.evzero);
    }

    public ExprPolynomial subtractMultiple(IExpr a, ExprPolynomial S2) {
        if (a == null || a.isZERO()) {
            return this;
        }
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.multiply(a.negate());
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong f = me.getKey();
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public ExprPolynomial subtractMultiple(IExpr a, ExpVectorLong e, ExprPolynomial S2) {
        if (a == null || a.isZERO()) {
            return this;
        }
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public ExprPolynomial scaleSubtractMultiple(IExpr b, IExpr a, ExprPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate());
        }
        if (b.isOne()) {
            return this.subtractMultiple(a, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.multiply(b);
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong f = me.getKey();
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public ExprPolynomial scaleSubtractMultiple(IExpr b, IExpr a, ExpVectorLong e, ExprPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        if (b.isOne()) {
            return this.subtractMultiple(a, e, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.multiply(b);
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public ExprPolynomial scaleSubtractMultiple(IExpr b, ExpVectorLong g, IExpr a, ExpVectorLong e, ExprPolynomial S2) {
        if (a == null || S2 == null) {
            return this.multiply(b, g);
        }
        if (a.isZERO() || S2.isZERO()) {
            return this.multiply(b, g);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S2.multiply(a.negate(), e);
        }
        if (b.isOne() && g.isZERO()) {
            return this.subtractMultiple(a, e, S2);
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial n = this.multiply(b, g);
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        SortedMap<ExpVectorLong, IExpr> sv = S2.val;
        for (Map.Entry<ExpVectorLong, IExpr> me : sv.entrySet()) {
            ExpVectorLong f = me.getKey();
            f = e.sum(f);
            IExpr y = me.getValue();
            y = a.multiply(y);
            IExpr x = (IExpr)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public ExprPolynomial negate() {
        ExprPolynomial n = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> v = n.val;
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            IExpr x = m.getValue();
            v.put(m.getKey(), x.negate());
        }
        return n;
    }

    public ExprPolynomial multiplyByMinimumNegativeExponents() {
        long[] result = new long[this.numberOfVariables()];
        boolean negativeExponents = false;
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            long[] k = m.getKey().getVal();
            for (int i = 0; i < k.length; ++i) {
                if (k[i] >= 0L || k[i] >= result[i]) continue;
                result[i] = k[i];
                negativeExponents = true;
            }
        }
        if (negativeExponents) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i] >= 0L) continue;
                int n = i;
                result[n] = result[n] * -1L;
            }
            return this.multiply(new ExpVectorLong(result));
        }
        return this;
    }

    public ExprPolynomial abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public ExprPolynomial multiply(ExprPolynomial S2) {
        if (S2 == null) {
            return this.ring.getZero();
        }
        if (S2.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == S2.ring.nvar);
        ExprPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorLong, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorLong e1 = m1.getKey();
            for (Map.Entry<ExpVectorLong, IExpr> m2 : S2.val.entrySet()) {
                IExpr c2 = m2.getValue();
                ExpVectorLong e2 = m2.getKey();
                IExpr c = c1.multiply(c2);
                if (c.isZERO()) continue;
                ExpVectorLong e = e1.sum(e2);
                IExpr c0 = (IExpr)pv.get(e);
                if (c0 == null) {
                    pv.put(e, c);
                    continue;
                }
                if (!(c0 = c0.add(c)).isZERO()) {
                    pv.put(e, c0);
                    continue;
                }
                pv.remove(e);
            }
        }
        return p;
    }

    public ExprPolynomial multiply(IExpr s) {
        if (s == null) {
            return this.ring.getZero();
        }
        if (s.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        ExprPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorLong, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorLong e1 = m1.getKey();
            IExpr c = c1.multiply(s);
            if (c.isZERO()) continue;
            pv.put(e1, c);
        }
        return p;
    }

    public ExprPolynomial monic() {
        if (this.isZERO()) {
            return this;
        }
        IExpr lc = this.leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return this;
        }
        IExpr lm = lc.inverse();
        return this.multiply(lm);
    }

    public ExprPolynomial multiply(IExpr s, ExpVectorLong e) {
        if (s == null) {
            return this.ring.getZero();
        }
        if (s.isZERO()) {
            return this.ring.getZero();
        }
        if (this.isZERO()) {
            return this;
        }
        ExprPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorLong, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorLong e1 = m1.getKey();
            IExpr c = c1.multiply(s);
            if (c.isZERO()) continue;
            ExpVectorLong e2 = e1.sum(e);
            pv.put(e2, c);
        }
        return p;
    }

    public ExprPolynomial multiply(ExpVectorLong e) {
        if (this.isZERO()) {
            return this;
        }
        ExprPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorLong, IExpr> m1 : this.val.entrySet()) {
            IExpr c1 = m1.getValue();
            ExpVectorLong e1 = m1.getKey();
            ExpVectorLong e2 = e1.sum(e);
            pv.put(e2, c1);
        }
        return p;
    }

    public ExprPolynomial multiply(Map.Entry<ExpVectorLong, IExpr> m) {
        if (m == null) {
            return this.ring.getZero();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    public ExprPolynomial divide(IExpr s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        ExprPolynomial p = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> pv = p.val;
        for (Map.Entry<ExpVectorLong, IExpr> m : this.val.entrySet()) {
            ExpVectorLong e = m.getKey();
            IExpr c1 = m.getValue();
            IExpr c = c1.divide(s);
            if (c.isZERO()) {
                throw new ArithmeticException("no exact division: " + c1 + "/" + s + ", in " + this);
            }
            pv.put(e, c);
        }
        return p;
    }

    public ExprPolynomial[] quotientRemainder(ExprPolynomial S2) {
        ExpVectorLong f;
        if (S2 == null || S2.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        IExpr c = S2.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        IExpr ci = c.inverse();
        assert (this.ring.nvar == S2.ring.nvar);
        ExpVectorLong e = S2.leadingExpVectorLong();
        ExprPolynomial q = this.ring.getZero().copy();
        ExprPolynomial r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVectorLong()).multipleOf(e)) {
            IExpr a = r.leadingBaseCoefficient();
            ExpVectorLong g = f.subtract(e);
            if ((a = a.multiplyDistributed(ci)).isZERO()) {
                return null;
            }
            q = q.sum(a, g);
            ExprPolynomial h = S2.multiply(a, g);
            r = r.subtract(h);
        }
        return new ExprPolynomial[]{q, r};
    }

    @Deprecated
    private ExprPolynomial[] divideAndRemainder(ExprPolynomial S2) {
        return this.quotientRemainder(S2);
    }

    public ExprPolynomial divide(ExprPolynomial S2) {
        return this.quotientRemainder(S2)[0];
    }

    public ExprPolynomial remainder(ExprPolynomial S2) {
        ExpVectorLong f;
        if (S2 == null || S2.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        IExpr c = S2.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbc not invertible " + c);
        }
        IExpr ci = c.inverse();
        assert (this.ring.nvar == S2.ring.nvar);
        ExpVectorLong e = S2.leadingExpVectorLong();
        ExprPolynomial r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVectorLong()).multipleOf(e)) {
            IExpr a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiplyDistributed(ci);
            ExprPolynomial h = S2.multiply(a, f);
            r = r.subtract(h);
        }
        return r;
    }

    public ExprPolynomial gcd(ExprPolynomial S2) {
        if (S2 == null || S2.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S2;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("not univariate polynomials" + this.ring);
        }
        ExprPolynomial q = this;
        ExprPolynomial r = S2;
        while (!r.isZERO()) {
            ExprPolynomial x = q.remainder(r);
            q = r;
            r = x;
        }
        return q.monic();
    }

    public ExprPolynomial[] egcd(ExprPolynomial S2) {
        ExprPolynomial[] ret = new ExprPolynomial[]{null, null, null};
        if (S2 == null || S2.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getOne();
            ret[2] = this.ring.getZero();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S2;
            ret[1] = this.ring.getZero();
            ret[2] = this.ring.getOne();
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        if (this.isConstant() && S2.isConstant()) {
            IExpr t = this.leadingBaseCoefficient();
            IExpr s = S2.leadingBaseCoefficient();
            if (t.isInteger() && s.isInteger()) {
                IExpr[] gg = t.egcd(s);
                ExprPolynomial z = this.ring.getZero();
                ret[0] = z.sum(gg[0]);
                ret[1] = z.sum(gg[1]);
                ret[2] = z.sum(gg[2]);
                return ret;
            }
        }
        ExprPolynomial q = this;
        ExprPolynomial r = S2;
        ExprPolynomial c1 = this.ring.getOne().copy();
        ExprPolynomial d1 = this.ring.getZero().copy();
        ExprPolynomial c2 = this.ring.getZero().copy();
        ExprPolynomial d2 = this.ring.getOne().copy();
        while (!r.isZERO()) {
            ExprPolynomial[] qr = q.quotientRemainder(r);
            if (qr == null) {
                return null;
            }
            q = qr[0];
            ExprPolynomial x1 = c1.subtract(q.multiply(d1));
            ExprPolynomial x2 = c2.subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        IExpr g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            IExpr h = g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
            c2 = c2.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    public ExprPolynomial[] hegcd(ExprPolynomial S2) {
        ExprPolynomial[] ret = new ExprPolynomial[]{null, null};
        if (S2 == null || S2.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getOne();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S2;
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        ExprPolynomial q = this;
        ExprPolynomial r = S2;
        ExprPolynomial c1 = this.ring.getOne().copy();
        ExprPolynomial d1 = this.ring.getZero().copy();
        while (!r.isZERO()) {
            ExprPolynomial[] qr = q.quotientRemainder(r);
            q = qr[0];
            ExprPolynomial x1 = c1.subtract(q.multiply(d1));
            c1 = d1;
            d1 = x1;
            q = r;
            r = qr[1];
        }
        IExpr g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            IExpr h = g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    public ExprPolynomial inverse() {
        if (this.isUnit()) {
            IExpr c = this.leadingBaseCoefficient().inverse();
            return this.ring.getOne().multiply(c);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public ExprPolynomial modInverse(ExprPolynomial m) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        ExprPolynomial[] hegcd = this.hegcd(m);
        ExprPolynomial a = hegcd[0];
        if (!a.isUnit()) {
            throw new AlgebraicNotInvertibleException("element not invertible, gcd != 1", m, a, m.divide(a));
        }
        ExprPolynomial b = hegcd[1];
        if (b.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return b;
    }

    public ExprPolynomial extend(ExprPolynomialRing pfac, int j, long k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        ExprPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorLong f = e.extend(i, j, k);
            C2.put(f, a);
        }
        return Cp;
    }

    public ExprPolynomial extendLower(ExprPolynomialRing pfac, int j, long k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        ExprPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorLong f = e.extendLower(i, j, k);
            C2.put(f, a);
        }
        return Cp;
    }

    public Map<ExpVectorLong, ExprPolynomial> contract(ExprPolynomialRing pfac) {
        ExprPolynomial zero = pfac.getZero();
        ExprTermOrder t = ExprTermOrderByName.INVLEX;
        TreeMap<ExpVectorLong, ExprPolynomial> B = new TreeMap<ExpVectorLong, ExprPolynomial>(t.getAscendComparator());
        if (this.isZERO()) {
            return B;
        }
        int i = this.ring.nvar - pfac.nvar;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorLong f = e.contract(0, i);
            ExpVectorLong g = e.contract(i, e.length() - i);
            ExprPolynomial p = (ExprPolynomial)B.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            B.put(f, p);
        }
        return B;
    }

    public ExprPolynomial contractCoeff(ExprPolynomialRing pfac) {
        Map<ExpVectorLong, ExprPolynomial> ms = this.contract(pfac);
        ExprPolynomial c = pfac.getZero();
        for (Map.Entry<ExpVectorLong, ExprPolynomial> m : ms.entrySet()) {
            if (m.getKey().isZERO()) {
                c = m.getValue();
                continue;
            }
            throw new RuntimeException("wrong coefficient contraction " + m + ", pol =  " + c);
        }
        return c;
    }

    public ExprPolynomial extendUnivariate(ExprPolynomialRing pfac, int i) {
        if (i < 0 || pfac.nvar < i) {
            throw new IllegalArgumentException("index " + i + "out of range " + pfac.nvar);
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("polynomial not univariate " + this.ring.nvar);
        }
        if (this.isOne()) {
            return pfac.getOne();
        }
        int j = pfac.nvar - 1 - i;
        ExprPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            long n = e.getVal(0);
            IExpr a = (IExpr)y.getValue();
            ExpVectorLong f = new ExpVectorLong(pfac.nvar, j, n);
            C2.put(f, a);
        }
        return Cp;
    }

    public ExprPolynomial homogenize(ExprPolynomialRing pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        ExprPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        long deg = this.totalDegree();
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            IExpr a = (IExpr)y.getValue();
            long d = deg - e.totalDeg();
            ExpVectorLong f = e.extend(1, 0, d);
            C2.put(f, a);
        }
        return Cp;
    }

    public ExprPolynomial deHomogenize(ExprPolynomialRing pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        ExprPolynomial Cp = pfac.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            IExpr a = (IExpr)y.getValue();
            ExpVectorLong f = e.contract(1, pfac.nvar);
            C2.put(f, a);
        }
        return Cp;
    }

    public ExprPolynomial reverse(ExprPolynomialRing oring) {
        ExprPolynomial Cp = oring.getZero().copy();
        if (this.isZERO()) {
            return Cp;
        }
        int k = -1;
        if (oring.tord.getEvord2() != 0 && oring.partial) {
            k = oring.tord.getSplit();
        }
        SortedMap<ExpVectorLong, IExpr> C2 = Cp.val;
        SortedMap<ExpVectorLong, IExpr> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVectorLong e = (ExpVectorLong)y.getKey();
            ExpVectorLong f = k >= 0 ? e.reverse(k) : e.reverse();
            IExpr a = (IExpr)y.getValue();
            C2.put(f, a);
        }
        return Cp;
    }

    public Iterator<IExpr> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<ExpVectorLong> exponentIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<ExprMonomial> iterator() {
        return new ExprPolyIterator(this.val);
    }

    public ExprPolynomial map(Function<IExpr, IExpr> f) {
        ExprPolynomial n = this.ring.getZero().copy();
        SortedMap<ExpVectorLong, IExpr> nv = n.val;
        for (ExprMonomial m : this) {
            IExpr c = f.apply(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }

    public IAST coefficientRules() {
        IASTAppendable result = F.ListAlloc(this.val.size());
        for (Map.Entry<ExpVectorLong, IExpr> monomial : this.val.entrySet()) {
            IExpr coeff = monomial.getValue();
            ExpVectorLong exp = monomial.getKey();
            int len = exp.length();
            IASTAppendable ruleList = F.ListAlloc(len);
            for (int i = 0; i < len; ++i) {
                ruleList.append(exp.getVal(len - i - 1));
            }
            result.append(F.Rule((IExpr)ruleList, coeff));
        }
        return result;
    }

    @Deprecated
    public IAST coefficientArrays(int degree) {
        int numberOfVariables = this.ring.nvar;
        IASTAppendable result = F.ListAlloc(degree + 1);
        result.append(F.C0);
        for (int i = 0; i < degree; ++i) {
            int[] dimension = new int[i + 1];
            for (int j = 0; j < dimension.length; ++j) {
                dimension[j] = numberOfVariables;
            }
            SparseArrayExpr sparse = SparseArrayExpr.newArrayRules(F.List(), dimension, i + 1, F.C0);
            result.append(sparse);
        }
        block2: for (Map.Entry<ExpVectorLong, IExpr> monomial : this.val.entrySet()) {
            IExpr coeff = monomial.getValue();
            ExpVectorLong exp = monomial.getKey();
            int maxDegree = (int)exp.maxDeg();
            if (maxDegree == 0) {
                result.set(1, coeff);
                continue;
            }
            for (int i = exp.length() - 1; i >= 0; --i) {
                if (exp.getVal(i) == 0L) continue;
                SparseArrayExpr sparse = (SparseArrayExpr)result.get(maxDegree + 1);
                int[] positions = new int[maxDegree];
                positions[0] = exp.length() - i;
                Trie data = (Trie)sparse.toData();
                data.put((Object)positions, (Object)coeff);
                continue block2;
            }
        }
        return result;
    }

    public IAST monomialList() {
        IASTAppendable result = F.ListAlloc(this.val.size());
        for (Map.Entry<ExpVectorLong, IExpr> monomial : this.val.entrySet()) {
            ExpVectorLong exp = monomial.getKey();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            monomTimes.append((IExpr)this.val.get(exp));
            this.appendToExpr(monomTimes, exp, this.ring.vars);
            result.append(monomTimes);
        }
        return result;
    }

    private void appendToExpr(IASTAppendable times, ExpVectorLong expArray, IAST variables) {
        long[] arr = expArray.getVal();
        ExpVectorLong leer = this.ring.evzero;
        for (int i = 0; i < arr.length; ++i) {
            int ix;
            if (arr[i] == 0L || (ix = leer.varIndex(i)) < 0) continue;
            if (arr[i] == 1L) {
                times.append(variables.get(ix + 1));
                continue;
            }
            times.append(F.Power(variables.get(ix + 1), arr[i]));
        }
    }

    public IAST coefficientList() {
        int argsSize = this.ring.getVars().size() - 1;
        if (argsSize == 1) {
            if (this.ring.tord.getEvord() == 4 || this.ring.tord.getEvord() == 6) {
                long lastDegree = this.degree();
                IExpr[] exprs = new IExpr[(int)lastDegree + 1];
                for (int i = 0; i < exprs.length; ++i) {
                    exprs[i] = F.C0;
                }
                for (Map.Entry<ExpVectorLong, IExpr> entry : this.val.entrySet()) {
                    long exp = entry.getKey().getVal(0);
                    exprs[(int)exp] = entry.getValue();
                }
                return F.function(S.List, exprs);
            }
            long lastDegree = 0L;
            IASTAppendable result = F.ListAlloc(this.val.size());
            for (Map.Entry<ExpVectorLong, IExpr> entry : this.val.entrySet()) {
                long exp = entry.getKey().getVal(0);
                while (lastDegree < exp) {
                    result.append(F.C0);
                    ++lastDegree;
                }
                if (lastDegree != exp) continue;
                result.append(entry.getValue());
                ++lastDegree;
            }
            return result;
        }
        if (argsSize > 1) {
            int[] arr = new int[argsSize];
            for (int j = 0; j < argsSize; ++j) {
                arr[j] = (int)this.degree(j) + 1;
            }
            IASTAppendable constantArray = F.C0.constantArray(S.List, 0, arr);
            for (ExpVectorLong expArray : this.val.keySet()) {
                int[] positions = new int[argsSize];
                for (int i = 0; i < expArray.length(); ++i) {
                    long exp = expArray.getVal(i);
                    positions[expArray.varIndex((int)i)] = (int)exp + 1;
                }
                constantArray.setPart((IExpr)this.val.get(expArray), positions);
            }
            return constantArray;
        }
        return F.NIL;
    }

    public ExprPolynomial derivativeUnivariate() {
        ExprPolynomial result = new ExprPolynomial(this.ring);
        for (ExpVectorLong expArray : this.val.keySet()) {
            long exp = expArray.getVal(0);
            if (exp == 0L) continue;
            ExpVectorLong copy = expArray.copy();
            copy.val[0] = exp - 1L;
            IExpr coefficient = ((IExpr)this.val.get(expArray)).times(F.ZZ(exp));
            result.doAddTo(coefficient, copy);
        }
        return result;
    }

    public IExpr getExpr() {
        if (this.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(this.length());
        IAST vars = this.ring.vars;
        for (ExprMonomial monomial : this) {
            IExpr coeff = monomial.coefficient();
            ExpVectorLong exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            if (!coeff.isOne()) {
                monomTimes.append(coeff);
            }
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                int ix = exp.varIndex(i);
                IExpr variable = vars.get(ix + 1);
                if (lExp == 1L) {
                    monomTimes.append(variable);
                    continue;
                }
                monomTimes.append(F.Power(variable, F.ZZ(lExp)));
            }
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    private static class ExprPolyIterator
    implements Iterator<ExprMonomial> {
        protected final Iterator<Map.Entry<ExpVectorLong, IExpr>> ms;

        public ExprPolyIterator(SortedMap<ExpVectorLong, IExpr> m) {
            this.ms = m.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ms.hasNext();
        }

        @Override
        public ExprMonomial next() {
            return new ExprMonomial(this.ms.next());
        }

        @Override
        public void remove() {
            this.ms.remove();
        }
    }
}

