/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials.longexponent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public final class ExpVectorLong {
    final long[] val;
    int hash;

    public ExpVectorLong(int n) {
        this.val = new long[n];
    }

    public ExpVectorLong(int n, int i, long e) {
        this(new long[n]);
        this.val[i] = e;
    }

    public ExpVectorLong(long[] v) {
        if (v == null) {
            throw new IllegalArgumentException("null val not allowed");
        }
        this.val = Arrays.copyOf(v, v.length);
    }

    public ExpVectorLong(String s) throws NumberFormatException {
        ArrayList<Long> exps = new ArrayList<Long>();
        s = s.trim();
        int b = s.indexOf(40);
        int e = s.indexOf(41, b + 1);
        if (b >= 0 && e >= 0) {
            long a;
            String teil;
            int k;
            ++b;
            while ((k = s.indexOf(44, b)) >= 0) {
                teil = s.substring(b, k);
                a = Long.parseLong(teil);
                exps.add(a);
                b = k + 1;
            }
            if (b <= e) {
                teil = s.substring(b, e);
                a = Long.parseLong(teil);
                exps.add(a);
            }
            int length = exps.size();
            this.val = new long[length];
            for (int j = 0; j < length; ++j) {
                this.val[j] = (Long)exps.get(j);
            }
        } else {
            this.val = null;
        }
    }

    public ExpVectorLong copy() {
        long[] w = new long[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorLong(w);
    }

    public static ExpVectorLong create(Collection<Long> v) {
        long[] w = new long[v.size()];
        int i = 0;
        for (Long k : v) {
            w[i++] = k;
        }
        return new ExpVectorLong(w);
    }

    public long[] getVal() {
        return this.val;
    }

    public long getVal(int i) {
        return this.val[i];
    }

    protected long setVal(int i, long e) {
        long x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    public boolean isZERO() {
        return 0 == this.signum();
    }

    public boolean isFinite() {
        return true;
    }

    public IAST stdVars() {
        return ExpVectorLong.STDVARS("x", this.length());
    }

    public IAST stdVars(String prefix) {
        return ExpVectorLong.STDVARS(prefix, this.length());
    }

    public static IAST STDVARS(int n) {
        return ExpVectorLong.STDVARS("x", n);
    }

    public static IAST STDVARS(String prefix, int n) {
        IASTAppendable vars = F.ListAlloc(n);
        if (prefix == null || prefix.length() == 0) {
            prefix = "x";
        }
        for (int i = 0; i < n; ++i) {
            vars.append(F.Dummy(prefix + i));
        }
        return vars;
    }

    public int length() {
        return this.val.length;
    }

    public ExpVectorLong extend(int i, int j, long e) {
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length + i);
        long[] w = result.val;
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[j] = e;
        return result;
    }

    public ExpVectorLong extendLower(int i, int j, long e) {
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length + i);
        long[] w = result.val;
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = e;
        return result;
    }

    public ExpVectorLong contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        ExpVectorLong result = ExpVectorLong.valueOf(len);
        long[] w = result.val;
        System.arraycopy(this.val, i, w, 0, len);
        return result;
    }

    public ExpVectorLong reverse() {
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length);
        long[] w = result.val;
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return result;
    }

    public ExpVectorLong reverse(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length);
        long[] w = result.val;
        for (i = 0; i < j; ++i) {
            w[i] = this.val[i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length + j - 1 - i];
        }
        return result;
    }

    public ExpVectorLong reverseUpper(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length);
        long[] w = result.val;
        for (i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[i];
        }
        return result;
    }

    public ExpVectorLong combine(ExpVectorLong V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorLong Vl = V;
        if (this.val.length == 0) {
            return Vl;
        }
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length + Vl.val.length);
        long[] w = result.val;
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vl.val, 0, w, this.val.length, Vl.val.length);
        return result;
    }

    public ExpVectorLong permutation(List<Integer> P) {
        ExpVectorLong result = ExpVectorLong.valueOf(this.val.length);
        long[] w = result.val;
        int j = 0;
        for (Integer i : P) {
            w[j++] = this.val[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("(");
        for (int i = 0; i < this.length(); ++i) {
            s.append(this.getVal(i));
            if (i >= this.length() - 1) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    public String toString(IAST vars) {
        long vi;
        StringBuilder s = new StringBuilder();
        int r = this.length();
        if (r != vars.argSize()) {
            return this.toString();
        }
        if (r == 0) {
            return s.toString();
        }
        for (int i = r - 1; i > 0; --i) {
            vi = this.getVal(i);
            if (vi == 0L) continue;
            s.append(vars.get(r - i));
            if (vi != 1L) {
                s.append("^" + vi);
            }
            boolean pit = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j) == 0L) continue;
                pit = true;
            }
            if (!pit) continue;
            s.append(" * ");
        }
        vi = this.getVal(0);
        if (vi != 0L) {
            s.append(vars.get(r));
            if (vi != 1L) {
                s.append("^" + vi);
            }
        }
        return s.toString();
    }

    public static String varsToString(IAST vars) {
        if (vars == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        vars.forEach(vars.size(), (x, i) -> {
            s.append(x);
            if (i < vars.argSize()) {
                s.append(",");
            }
        });
        return s.toString();
    }

    public String toScript() {
        return this.toScript(this.stdVars());
    }

    public String toScript(IAST vars) {
        long vi;
        int r = this.length();
        if (r != vars.argSize()) {
            return this.toString();
        }
        StringBuilder s = new StringBuilder();
        for (int i = r - 1; i > 0; --i) {
            vi = this.getVal(i);
            if (vi == 0L) continue;
            s.append(vars.get(r - i));
            if (vi != 1L) {
                s.append("**" + vi);
            }
            boolean pit = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j) == 0L) continue;
                pit = true;
            }
            if (!pit) continue;
            s.append(" * ");
        }
        vi = this.getVal(0);
        if (vi != 0L) {
            s.append(vars.get(r));
            if (vi != 1L) {
                s.append("**" + vi);
            }
        }
        return s.toString();
    }

    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorLong)) {
            return false;
        }
        ExpVectorLong b = (ExpVectorLong)B;
        long[] u = this.val;
        long[] v = b.val;
        if (u.length != v.length) {
            return false;
        }
        for (int i = 0; i < u.length; ++i) {
            if (u[i] == v[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < this.length(); ++i) {
                this.hash <<= (int)(4L + this.getVal(i));
            }
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    public ExpVectorLong abs() {
        long[] u = this.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= 0L ? u[i] : -u[i];
        }
        return result;
    }

    public ExpVectorLong negate() {
        long[] u = this.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return result;
    }

    public ExpVectorLong sum(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] + v[i];
        }
        return result;
    }

    public ExpVectorLong subtract(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] - v[i];
        }
        return result;
    }

    public ExpVectorLong subst(int i, long d) {
        ExpVectorLong V = this.copy();
        V.setVal(i, d);
        return V;
    }

    public int signum() {
        int t = 0;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] < 0L) {
                return -1;
            }
            if (u[i] <= 0L) continue;
            t = 1;
        }
        return t;
    }

    public long totalDeg() {
        long t = 0L;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            t += u[i];
        }
        return t;
    }

    public long maxDeg() {
        long t = 0L;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= t) continue;
            t = u[i];
        }
        return t;
    }

    public long weightDeg(long[][] w) {
        if (w == null || w.length == 0) {
            return this.totalDeg();
        }
        long t = 0L;
        long[] u = this.val;
        for (int j = 0; j < w.length; ++j) {
            long[] wj = w[j];
            for (int i = 0; i < u.length; ++i) {
                t += wj[i] * u[i];
            }
        }
        return t;
    }

    public ExpVectorLong lcm(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return result;
    }

    public ExpVectorLong gcd(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        ExpVectorLong result = ExpVectorLong.valueOf(u.length);
        long[] w = result.val;
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return result;
    }

    public int[] dependencyOnVariables() {
        long[] u = this.val;
        int l = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0L) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0L) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    public boolean multipleOf(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    public int compareTo(ExpVectorLong V) {
        return this.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVectorLong U, ExpVectorLong V) {
        return U.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVectorLong U, ExpVectorLong V, int begin, int end) {
        return U.invLexCompareTo(V, begin, end);
    }

    public static int EVIGLC(ExpVectorLong U, ExpVectorLong V) {
        return U.invGradCompareTo(V);
    }

    public static int EVIGLC(ExpVectorLong U, ExpVectorLong V, int begin, int end) {
        return U.invGradCompareTo(V, begin, end);
    }

    public static int EVRILCP(ExpVectorLong U, ExpVectorLong V) {
        return U.revInvLexCompareTo(V);
    }

    public static int EVRILCP(ExpVectorLong U, ExpVectorLong V, int begin, int end) {
        return U.revInvLexCompareTo(V, begin, end);
    }

    public static int EVRIGLC(ExpVectorLong U, ExpVectorLong V) {
        return U.revInvGradCompareTo(V);
    }

    public static int EVRIGLC(ExpVectorLong U, ExpVectorLong V, int begin, int end) {
        return U.revInvGradCompareTo(V, begin, end);
    }

    public static int EVITDEGLC(ExpVectorLong U, ExpVectorLong V) {
        return U.invTdegCompareTo(V);
    }

    public static int EVRLITDEGC(ExpVectorLong U, ExpVectorLong V) {
        return U.revLexInvTdegCompareTo(V);
    }

    public static int EVIWLC(long[][] w, ExpVectorLong U, ExpVectorLong V) {
        return U.invWeightCompareTo(w, V);
    }

    public static int EVIWLC(long[][] w, ExpVectorLong U, ExpVectorLong V, int begin, int end) {
        return U.invWeightCompareTo(w, V, begin, end);
    }

    public int invLexCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    public int invLexCompareTo(ExpVectorLong V, int begin, int end) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    public int invGradCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int invGradCompareTo(ExpVectorLong V, int begin, int end) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int revInvLexCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    public int revInvLexCompareTo(ExpVectorLong V, int begin, int end) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    public int revInvGradCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int revInvGradCompareTo(ExpVectorLong V, int begin, int end) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int invTdegCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] < v[i]) {
                t = 1;
                break;
            }
            if (u[i] <= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int revLexInvTdegCompareTo(ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] < v[i]) {
                t = 1;
                break;
            }
            if (u[i] <= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    public int invWeightCompareTo(long[][] w, ExpVectorLong V) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * u[j];
                vp += wk[j] * v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }

    public int invWeightCompareTo(long[][] w, ExpVectorLong V, int begin, int end) {
        long[] u = this.val;
        long[] v = V.val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < end; ++j) {
                up += wk[j] * u[j];
                vp += wk[j] * v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }

    public static ExpVectorLong valueOf(int n) {
        return new ExpVectorLong(n);
    }

    public int varIndex(int idx) {
        return this.length() - idx - 1;
    }

    public static int indexVar(IExpr x, IAST vars) {
        int len = vars.size();
        for (int i = 1; i < len; ++i) {
            if (!x.equals(vars.get(i))) continue;
            return len - i - 1;
        }
        return -1;
    }
}

