/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.TreeSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class QuarticSolver {
    public static IASTMutable solve(IExpr exprPoly, IExpr x) throws ArithmeticException {
        IExpr[] coefficients = new IExpr[]{F.C0, F.C0, F.C0, F.C0, F.C0};
        if (QuarticSolver.convert2Coefficients(exprPoly, x, coefficients)) {
            return QuarticSolver.quarticSolve(coefficients[4], coefficients[3], coefficients[2], coefficients[1], coefficients[0]);
        }
        return F.NIL;
    }

    private static boolean convert2Coefficients(IExpr exprPoly, IExpr x, IExpr[] coefficients) {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (QuarticSolver.convertTerm2Coefficients(ast.get(i), x, coefficients)) continue;
                    return false;
                }
                return true;
            }
            if (QuarticSolver.convertTerm2Coefficients(ast, x, coefficients)) {
                return true;
            }
        } else if (QuarticSolver.convertTerm2Coefficients(exprPoly, x, coefficients)) {
            return true;
        }
        return false;
    }

    private static boolean convertTerm2Coefficients(IExpr exprPoly, IExpr x, IExpr[] coefficients) {
        if (exprPoly.isFree(x, true)) {
            coefficients[0] = F.eval(F.Plus(coefficients[0], exprPoly));
            return true;
        }
        if (exprPoly instanceof IAST) {
            IExpr temp;
            IAST ast = (IAST)exprPoly;
            if (ast.isTimes()) {
                int exponent = -1;
                IASTAppendable coeff = ast.copyAppendable();
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr arg = ast.get(i);
                    if (arg.isPower()) {
                        IExpr base = arg.base();
                        if (!x.equals(base)) continue;
                        exponent = arg.exponent().toIntDefault();
                        if (exponent < 0 || exponent > 4) {
                            return false;
                        }
                        coeff.remove(i);
                        coefficients[exponent] = F.eval(F.Plus(coefficients[exponent], (IExpr)coeff));
                        return true;
                    }
                    if (!x.equals(arg)) continue;
                    coeff.remove(i);
                    coefficients[1] = F.eval(F.Plus(coefficients[1], (IExpr)coeff));
                    return true;
                }
                return true;
            }
            if (ast.isPower() && x.equals(temp = ast.arg1())) {
                int exponent = ast.exponent().toIntDefault();
                if (exponent < 0 || exponent > 4) {
                    return false;
                }
                coefficients[exponent] = F.eval(F.Plus(coefficients[exponent], (IExpr)F.C1));
                return true;
            }
        } else if (exprPoly instanceof ISymbol && x.equals(exprPoly)) {
            coefficients[1] = F.eval(F.Plus(coefficients[1], (IExpr)F.C1));
            return true;
        }
        return false;
    }

    public static IAST quarticSolveN(IExpr a, IExpr b, IExpr c, IExpr d, IExpr e) {
        return (IAST)F.evaln(QuarticSolver.quarticSolve(a, b, c, d, e));
    }

    public static IASTAppendable quarticSolve(IExpr a, IExpr b, IExpr c, IExpr d, IExpr e) {
        if (a.isPossibleZero(false)) {
            return QuarticSolver.cubicSolve(b, c, d, e, null);
        }
        if (e.isPossibleZero(false)) {
            return QuarticSolver.cubicSolve(a, b, c, d, F.C0);
        }
        if (b.isPossibleZero(false) && d.isPossibleZero(false)) {
            return QuarticSolver.biQuadraticSolve(a, c, e, null);
        }
        IExpr temp = a.subtract(e);
        if (temp.isPossibleZero(false) && (temp = b.subtract(d)).isPossibleZero(false)) {
            return QuarticSolver.quasiSymmetricQuarticSolve(a, b, c);
        }
        IExpr alpha = F.eval(F.Plus((IExpr)F.Times((IExpr)F.CN3, (IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C2)), F.CN1)), (IExpr)F.Times(c, (IExpr)F.Power(a, F.CN1))));
        IExpr beta = F.eval(F.Plus((IExpr)F.Times((IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C3)), F.CN1)), (IExpr)F.Times(F.CN1, b, c, F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), (IExpr)F.Times(d, (IExpr)F.Power(a, F.CN1))));
        IExpr gamma = F.eval(F.Plus(F.Times((IExpr)F.CN3, (IExpr)F.Power(b, F.C4), (IExpr)F.Power((IExpr)F.Times((IExpr)F.ZZ(256L), (IExpr)F.Power(a, F.C4)), F.CN1)), F.Times((IExpr)F.Power(b, F.C2), c, (IExpr)F.Power((IExpr)F.Times((IExpr)F.ZZ(16L), (IExpr)F.Power(a, F.C3)), F.CN1)), F.Times(F.CN1, b, d, F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(e, (IExpr)F.Power(a, F.CN1))));
        if (beta.isPossibleZero(false)) {
            return QuarticSolver.biQuadraticSolve(F.C1, alpha, gamma, F.Times((IExpr)F.CN1D4, b, (IExpr)F.Power(a, F.CN1)));
        }
        IASTAppendable result = F.ListAlloc(6);
        IExpr delta0 = F.eval(F.Plus((IExpr)F.Power(c, F.C2), (IExpr)F.Times(F.CN1, F.C3, b, d), (IExpr)F.Times((IExpr)F.ZZ(12L), a, e)));
        IExpr delta1 = F.eval(F.Plus(F.Times((IExpr)F.C2, (IExpr)F.Power(c, F.C3)), F.Times(F.CN1, F.ZZ(9L), b, c, d), F.Times((IExpr)F.ZZ(27L), a, (IExpr)F.Power(d, F.C2)), F.Times((IExpr)F.ZZ(27L), (IExpr)F.Power(b, F.C2), e), F.Times(F.CN1, F.ZZ(72L), a, c, e)));
        IExpr delta3 = F.eval(F.Power((IExpr)F.Plus(delta1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(delta1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4, (IExpr)F.Power(delta0, F.C3))))), F.C1D3));
        result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times((IExpr)F.CN1, delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Power(a, F.C3), F.CN1)), (IExpr)F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), (IExpr)F.Times(F.CN1, F.ZZ(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times((IExpr)F.CN1, delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Power(a, F.C3), F.CN1)), (IExpr)F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), (IExpr)F.Times(F.CN1, F.ZZ(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times((IExpr)F.CN1, delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Power(a, F.C3), F.CN1)), (IExpr)F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), (IExpr)F.Times(F.CN1, F.ZZ(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times((IExpr)F.CN1, delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Power(a, F.C3), F.CN1)), (IExpr)F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), (IExpr)F.Times(F.CN1, F.ZZ(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        return QuarticSolver.createSet(result);
    }

    public static IASTAppendable cubicSolve(IExpr a, IExpr b, IExpr c, IExpr d, IExpr additionalSolution) {
        if (a.isPossibleZero(false)) {
            return QuarticSolver.quadraticSolve(b, c, d, additionalSolution, null);
        }
        if (d.isPossibleZero(false)) {
            return QuarticSolver.quadraticSolve(a, b, c, additionalSolution, F.C0);
        }
        IASTAppendable result = F.ListAlloc(4);
        if (additionalSolution != null) {
            result.append(additionalSolution);
        }
        IExpr discriminant = F.eval(F.Plus(F.Times(F.ZZ(18L), a, b, c, d), F.Times((IExpr)F.CN4, (IExpr)F.Power(b, F.C3), d), F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power(c, F.C2)), F.Times((IExpr)F.CN4, a, (IExpr)F.Power(c, F.C3)), F.Times((IExpr)F.ZZ(-27L), (IExpr)F.Power(a, F.C2), (IExpr)F.Power(d, F.C2))));
        IExpr delta0 = F.eval(F.Plus((IExpr)F.Power(b, F.C2), (IExpr)F.Times(F.CN1, F.C3, a, c)));
        IExpr delta1 = F.eval(F.Plus((IExpr)F.Times((IExpr)F.ZZ(-2L), (IExpr)F.Power(b, F.C3)), (IExpr)F.Times(F.ZZ(9L), a, b, c), (IExpr)F.Times(F.CN1, F.ZZ(27L), F.Power(a, F.C2), d)));
        IExpr argDelta3 = F.eval(F.Plus(delta1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(delta1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4, (IExpr)F.Power(delta0, F.C3))))));
        IExpr delta3 = F.eval(F.Power(argDelta3, F.C1D3));
        if (discriminant.isPossibleZero(false)) {
            if (delta0.isPossibleZero(false)) {
                result.append(F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)));
            } else {
                result.append(F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.ZZ(9L), a, d), (IExpr)F.Times((IExpr)F.CN1, b, c)), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, delta0), F.CN1)));
                result.append(F.Times((IExpr)F.Plus((IExpr)F.Times(F.C4, a, b, c), (IExpr)F.Times(F.CN1, F.ZZ(9L), F.Power(a, F.C2), d), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3))), (IExpr)F.Power((IExpr)F.Times(a, delta0), F.CN1)));
            }
        } else {
            result.append(F.Plus(b.negate().times(F.C3.times(a).power(F.CN1)), (IExpr)F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), delta0, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a, delta3), F.CN1)), (IExpr)F.Times((IExpr)F.Power(argDelta3.timesDistributed(F.C1D2), F.C1D3), F.C3.times(a).power(F.CN1))));
            result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), (IExpr)F.Times(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), F.CN1, delta0, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.fraction(2L, 3L)), a, delta3), F.CN1)), (IExpr)F.Times(F.CN1, F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), delta3, F.Power((IExpr)F.Times((IExpr)F.ZZ(6L), (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))));
            result.append(F.Plus((IExpr)F.Times((IExpr)F.CN1, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), (IExpr)F.Times(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), F.CN1, delta0, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.fraction(2L, 3L)), a, delta3), F.CN1)), (IExpr)F.Times(F.CN1, F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), delta3, F.Power((IExpr)F.Times((IExpr)F.ZZ(6L), (IExpr)F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))));
        }
        return QuarticSolver.createSet(result);
    }

    public static IASTAppendable createSet(IASTAppendable result) {
        TreeSet<IExpr> set1 = new TreeSet<IExpr>();
        for (int i = 1; i < result.size(); ++i) {
            IExpr temp = result.get(i);
            if (temp.isPlus() || temp.isTimes() || temp.isPower()) {
                temp = F.evalExpandAll(temp);
            }
            if (temp.isAtom() && !temp.isIndeterminate()) {
                set1.add(temp);
                continue;
            }
            if ((temp = F.eval(temp)).isAtom() && !temp.isIndeterminate()) {
                set1.add(temp);
                continue;
            }
            if ((temp = F.evalExpandAll(temp)).isIndeterminate()) continue;
            set1.add(temp);
        }
        result = F.ListAlloc(set1.size());
        for (IExpr e : set1) {
            result.append(e);
        }
        return result;
    }

    public static IASTAppendable quadraticSolve(IExpr a, IExpr b, IExpr c) {
        return QuarticSolver.quadraticSolve(a, b, c, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IASTAppendable quadraticSolve(IExpr a, IExpr b, IExpr c, IExpr solution1, IExpr solution2) {
        IASTAppendable result = F.ListAlloc(5);
        if (solution1 != null) {
            result.append(solution1);
        }
        if (solution2 != null) {
            result.append(solution2);
        }
        if (a.isPossibleZero(false)) {
            if (b.isPossibleZero(false)) return result;
            result.append(F.Times((IExpr)F.CN1, c, F.Power(b, -1L)));
            return result;
        }
        if (c.isPossibleZero(false)) {
            result.append(F.C0);
            if (b.isZero()) return result;
            result.append(F.Times((IExpr)F.CN1, b, F.Power(a, -1L)));
            return result;
        }
        if (!b.isPossibleZero(false)) {
            IExpr discriminant = F.evalExpand(F.Plus((IExpr)F.Sqr(b), a.times(c).times(F.C4).negate()));
            discriminant = discriminant.sqrt();
            result.append(F.Times((IExpr)F.Plus(b.negate(), discriminant), F.Power(a.times(F.C2), -1L)));
            result.append(F.Times((IExpr)F.Plus(b.negate(), discriminant.negate()), F.Power(a.times(F.C2), -1L)));
            return result;
        }
        IExpr rhs = S.Divide.of(F.Negate(c), a);
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(rhs);
        if (negExpr.isPresent()) {
            IExpr numerator = QuarticSolver.surdSqrt(S.Numerator.of(negExpr));
            IExpr denominator = QuarticSolver.surdSqrt(S.Denominator.of(negExpr));
            result.append(F.Times.of(F.CNI, F.Divide(numerator, denominator)));
            result.append(F.Times.of(F.CI, F.Divide(numerator, denominator)));
            return result;
        }
        IExpr numerator = QuarticSolver.surdSqrt(S.Numerator.of(rhs));
        IExpr denominator = QuarticSolver.surdSqrt(S.Denominator.of(rhs));
        result.append(F.Times.of(F.CN1, F.Divide(numerator, denominator)));
        result.append(S.Divide.of(numerator, denominator));
        return result;
    }

    private static IExpr surdSqrt(IExpr arg) {
        IAST x;
        if (arg.isTimes()) {
            IAST times = (IAST)arg;
            for (int i = 1; i < times.size(); ++i) {
                IExpr x2 = times.get(i);
                if (!x2.isPower() || !x2.exponent().isReal() || !x2.exponent().isEvenResult()) continue;
                IASTAppendable res1 = F.TimesAlloc(times.size());
                res1.appendArgs(times, i);
                IASTAppendable res2 = F.Times();
                res2.append(F.Power(x2.base(), F.Divide(x2.exponent(), F.C2)));
                for (int j = i + 1; j < times.size(); ++j) {
                    x2 = times.get(j);
                    if (x2.isPower() && x2.exponent().isReal() && x2.exponent().isEvenResult()) {
                        res2.append(F.Power(x2.base(), F.Divide(x2.exponent(), F.C2)));
                        continue;
                    }
                    res1.append(x2);
                }
                return F.Times((IExpr)res2, (IExpr)F.Sqrt(res1));
            }
        } else if (arg.isPower() && arg.exponent().isReal() && (x = (IAST)arg).exponent().isEvenResult()) {
            return F.Power(x.base(), F.Divide(x.exponent(), F.C2));
        }
        return F.Sqrt(arg);
    }

    public static IASTAppendable biQuadraticSolve(IExpr a, IExpr c, IExpr e, IExpr sum) {
        IASTAppendable result = F.ListAlloc(4);
        IExpr sqrt = F.eval(F.Sqrt(F.Plus((IExpr)F.Power(c, F.C2), (IExpr)F.Times(F.CN1, F.C4, a, e))));
        IASTMutable y1 = F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, c), sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        IAST y2 = F.Times((IExpr)F.CN1, (IExpr)F.Plus(c, sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        if (sum == null) {
            result.append(F.Sqrt(y1));
            result.append(F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y1)));
            result.append(F.Sqrt(y2));
            result.append(F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y2)));
        } else {
            result.append(F.Plus(sum, (IExpr)F.Sqrt(y1)));
            result.append(F.Plus(sum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y1))));
            result.append(F.Plus(sum, (IExpr)F.Sqrt(y2)));
            result.append(F.Plus(sum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y2))));
        }
        return QuarticSolver.createSet(result);
    }

    public static IASTAppendable quasiSymmetricQuarticSolve(IExpr a, IExpr b, IExpr c) {
        IASTAppendable result = F.ListAlloc(4);
        IExpr sqrt = F.eval(F.Sqrt(F.Plus((IExpr)F.Power(b, F.C2), (IExpr)F.Times(F.CN1, F.C4, a, c), (IExpr)F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C2)))));
        IASTMutable y1 = F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, b), sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        IAST y2 = F.Times((IExpr)F.CN1, (IExpr)F.Plus(b, sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        result.append(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4))))));
        result.append(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4)))))));
        result.append(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y2, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y2, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4))))));
        result.append(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y2, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y2, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4)))))));
        return QuarticSolver.createSet(result);
    }

    public static IASTMutable sortASTArguments(IASTMutable resultList) {
        if (resultList.isList()) {
            EvalEngine engine = EvalEngine.get();
            IASTAppendable result = F.ListAlloc(resultList.size());
            for (int i = 1; i < resultList.size(); ++i) {
                IExpr temp = resultList.get(i);
                if ((temp = engine.evaluate(temp)).isList()) {
                    EvalAttributes.sort((IASTMutable)temp);
                    result.append(temp);
                    continue;
                }
                result.append(resultList.get(i));
            }
            EvalAttributes.sort(result);
            return result;
        }
        return resultList;
    }
}

