/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class PolynomialHomogenization {
    private Map<ISymbol, IExpr> substitutedVariables = new IdentityHashMap<ISymbol, IExpr>();
    private Map<ISymbol, IASTAppendable> variablesLCMAST = null;
    private Map<ISymbol, IInteger> variablesLCM = null;
    private HashMap<IExpr, ISymbol> substitutedExpr = new HashMap();
    private EvalEngine engine;

    public PolynomialHomogenization(IAST listOfVariables, EvalEngine engine) {
        this.engine = engine;
    }

    private Map<ISymbol, IASTAppendable> getSymbol2IntegerAST() {
        if (this.variablesLCMAST == null) {
            this.variablesLCMAST = new IdentityHashMap<ISymbol, IASTAppendable>();
        }
        return this.variablesLCMAST;
    }

    private Map<ISymbol, IInteger> getSymbol2LCM() {
        if (this.variablesLCM == null) {
            this.variablesLCM = new IdentityHashMap<ISymbol, IInteger>();
        }
        return this.variablesLCM;
    }

    public IInteger getLCM(IExpr x) {
        if (this.variablesLCM == null) {
            return F.C1;
        }
        IInteger i = this.variablesLCM.get(x);
        if (i == null) {
            return F.C1;
        }
        return i;
    }

    public IExpr replaceForward(IExpr expression) {
        this.determineLCM(expression);
        if (this.variablesLCMAST != null) {
            for (Map.Entry<ISymbol, IASTAppendable> entry : this.variablesLCMAST.entrySet()) {
                IASTAppendable denominatorLCMAST = entry.getValue();
                IInteger denominatorLCM = F.C1;
                if (!denominatorLCMAST.isAST0()) {
                    denominatorLCM = denominatorLCMAST.isAST1() ? (IInteger)denominatorLCMAST.arg1() : (IInteger)this.engine.evaluate(denominatorLCMAST);
                }
                if (denominatorLCM.isOne()) continue;
                this.getSymbol2LCM().put(entry.getKey(), denominatorLCM);
            }
        }
        return this.replaceForwardRecursive(expression);
    }

    public IExpr[] replaceForward(IExpr numerator, IExpr denominator) {
        this.determineLCM(numerator);
        this.determineLCM(denominator);
        if (this.variablesLCMAST != null) {
            for (Map.Entry<ISymbol, IASTAppendable> entry : this.variablesLCMAST.entrySet()) {
                IASTAppendable denominatorLCMAST = entry.getValue();
                IInteger denominatorLCM = F.C1;
                if (!denominatorLCMAST.isAST0()) {
                    denominatorLCM = denominatorLCMAST.isAST1() ? (IInteger)denominatorLCMAST.arg1() : (IInteger)this.engine.evaluate(denominatorLCMAST);
                }
                if (denominatorLCM.isOne()) continue;
                this.getSymbol2LCM().put(entry.getKey(), denominatorLCM);
            }
        }
        IExpr[] result = new IExpr[]{this.replaceForwardRecursive(numerator), this.replaceForwardRecursive(denominator)};
        return result;
    }

    private void determineLCM(IExpr expression) {
        if (expression instanceof IAST) {
            IAST ast = (IAST)expression;
            if (ast.isPlus() || ast.isTimes()) {
                for (int i = 1; i < ast.size(); ++i) {
                    this.determineLCM(ast.get(i));
                }
                return;
            }
            if (ast.isPower()) {
                IAST plusAST;
                IExpr exp = ast.exponent();
                IExpr base = ast.base();
                if (exp.isReal()) {
                    IInteger lcm = F.C1;
                    IRational rat = ((ISignedNumber)exp).rationalFactor();
                    if (rat == null) {
                        return;
                    }
                    if (!rat.isInteger()) {
                        IInteger denominator = rat.denominator();
                        if (denominator.isNegative()) {
                            denominator = denominator.negate();
                        }
                        lcm = denominator;
                    }
                    this.replaceExpressionLCM(base, lcm);
                    return;
                }
                if (exp.isTimes()) {
                    this.determineTimes(ast, base, (IAST)exp);
                    return;
                }
                if (exp.isPlus() && (plusAST = (IAST)exp).first().isInteger()) {
                    this.determineLCM(S.Power.of(base, plusAST.first()));
                    this.determineLCM(S.Power.of(base, plusAST.rest().oneIdentity0()));
                    return;
                }
                this.replaceExpressionLCM(ast, F.C1);
                return;
            }
            this.replaceExpressionLCM(expression, F.C1);
            return;
        }
        if (expression instanceof ISymbol) {
            this.replaceExpressionLCM(expression, F.C1);
        }
    }

    private void determineTimes(IAST ast, IExpr base, IAST timesExponent) {
        IExpr first = timesExponent.first();
        if (first.isComplex() && ((IComplex)first).reRational().isZero()) {
            IRational pureImPart = ((IComplex)first).imRational();
            int exponent = pureImPart.toIntDefault();
            if (exponent == Integer.MIN_VALUE) {
                this.replaceExpressionLCM(ast, F.C1);
                return;
            }
            if (exponent > 0) {
                IASTMutable restExponent = timesExponent.setAtCopy(1, F.CI);
                this.replaceExpressionLCM(base.power(restExponent), F.C1);
                return;
            }
            this.replaceExpressionLCM(ast, F.C1);
            return;
        }
        int exponent = first.toIntDefault();
        if (exponent == Integer.MIN_VALUE) {
            this.replaceExpressionLCM(ast, F.C1);
            return;
        }
        if (exponent > 0) {
            IExpr rest = timesExponent.rest().oneIdentity1();
            this.replaceExpressionLCM(base.power(rest), F.C1);
            return;
        }
        this.replaceExpressionLCM(ast, F.C1);
    }

    private IExpr replaceForwardRecursive(IExpr expression) throws ArithmeticException, ClassCastException {
        if (expression instanceof IAST) {
            IAST ast = (IAST)expression;
            if (ast.isPlus() || ast.isTimes()) {
                IASTAppendable newAST = F.ast(ast.head(), ast.size());
                IExpr temp = ast.arg1();
                newAST.append(this.replaceForwardRecursive(temp));
                for (int i = 2; i < ast.size(); ++i) {
                    temp = ast.get(i);
                    newAST.append(this.replaceForwardRecursive(temp));
                }
                return newAST;
            }
            if (ast.isPower()) {
                IAST plusAST;
                IExpr base;
                IExpr power = this.replaceExpression(ast);
                if (power.isPresent()) {
                    return power;
                }
                IExpr b = ast.base();
                IExpr exp = ast.exponent();
                if (exp.isReal() && (base = this.replacePower(b, (ISignedNumber)exp)).isPresent()) {
                    return base;
                }
                base = b;
                if (exp.isTimes()) {
                    return this.replaceTimes(ast, base, exp);
                }
                if (exp.isPlus() && (plusAST = (IAST)exp).first().isInteger()) {
                    IExpr coefficient = S.Power.of(base, plusAST.first());
                    return F.Times(this.replaceForwardRecursive(coefficient), this.replaceForwardRecursive(F.Power(base, plusAST.rest().oneIdentity0())));
                }
                return ast;
            }
            return this.replaceExpression(expression);
        }
        if (expression.isSymbol()) {
            return this.replaceExpression(expression).orElse(expression);
        }
        return expression;
    }

    private IExpr replaceTimes(IAST ast, IExpr base, IExpr exp) {
        IExpr first = exp.first();
        if (first.isComplex() && ((IComplex)first).reRational().isZero()) {
            IRational imPart = ((IComplex)first).imRational();
            int exponent = imPart.toIntDefault();
            if (exponent == Integer.MIN_VALUE) {
                return this.replaceExpression(ast).orElse(ast);
            }
            if (exponent > 0) {
                IASTMutable restExponent = ((IAST)exp).setAtCopy(1, F.CI);
                return F.Power(this.replaceExpression(base.power(restExponent)), exponent);
            }
            return this.replaceExpression(ast);
        }
        int exponent = first.toIntDefault();
        if (exponent == Integer.MIN_VALUE) {
            return this.replaceExpression(ast);
        }
        if (exponent > 0) {
            IExpr rest = exp.rest().oneIdentity1();
            return F.Power(this.replaceExpression(base.power(rest)), exponent);
        }
        return this.replaceExpression(ast).orElse(ast);
    }

    private IExpr replaceExpressionLCM(IExpr exprPoly, IInteger lcm) {
        if (exprPoly.isAST() || exprPoly.isSymbol()) {
            ISymbol newSymbol = this.substitutedExpr.get(exprPoly);
            if (newSymbol != null) {
                if (!lcm.isOne()) {
                    IASTAppendable ast = this.getSymbol2IntegerAST().get(newSymbol);
                    if (ast == null) {
                        IASTAppendable list = F.ast(S.LCM);
                        list.append(lcm);
                        this.getSymbol2IntegerAST().put(newSymbol, list);
                    } else {
                        ast.append(lcm);
                    }
                }
                return newSymbol;
            }
            newSymbol = F.Dummy(EvalEngine.uniqueName("jas$"));
            this.substitutedVariables.put(newSymbol, exprPoly);
            this.substitutedExpr.put(exprPoly, newSymbol);
            if (!lcm.isOne()) {
                IASTAppendable list = F.ast(S.LCM);
                list.append(lcm);
                this.getSymbol2IntegerAST().put(newSymbol, list);
            }
            return newSymbol;
        }
        return exprPoly;
    }

    private IExpr replaceExpression(IExpr exprPoly) {
        ISymbol symbol = this.substitutedExpr.get(exprPoly);
        if (symbol != null) {
            IInteger lcm = this.getLCM(symbol);
            if (lcm.isOne()) {
                return symbol;
            }
            return F.Power((IExpr)symbol, lcm);
        }
        return F.NIL;
    }

    private IExpr replacePower(IExpr exprPoly, ISignedNumber exp) {
        ISymbol symbol = this.substitutedExpr.get(exprPoly);
        if (symbol != null) {
            IInteger intExp;
            int exponent;
            IInteger lcm = this.getLCM(symbol);
            if (lcm.isOne()) {
                lcm = F.C1;
            }
            if (lcm.isOne() && exp.isInteger()) {
                return F.Power((IExpr)symbol, exp);
            }
            IRational rat = exp.rationalFactor();
            if (rat != null && (exponent = (intExp = rat.multiply(lcm).numerator()).toIntDefault()) != Integer.MIN_VALUE) {
                if (exponent == 1) {
                    return symbol;
                }
                return F.Power((IExpr)symbol, exponent);
            }
            return F.Power((IExpr)symbol, F.Times((IExpr)lcm, (IExpr)exp));
        }
        return F.NIL;
    }

    public IExpr replaceBackward(IExpr expression) {
        IExpr temp = F.subst(expression, x -> {
            IExpr t;
            if (x.isSymbol() && (t = this.substitutedVariables.get(x)) != null) {
                IInteger denominatorLCM = this.getLCM((IExpr)x);
                if (denominatorLCM.isOne()) {
                    return t;
                }
                return F.Power(t, F.fraction(F.C1, denominatorLCM));
            }
            return F.NIL;
        });
        return this.engine.evaluate(temp);
    }

    public Map<ISymbol, IExpr> substitutedVariables() {
        return this.substitutedVariables;
    }

    public Set<ISymbol> substitutedVariablesSet() {
        return this.substitutedVariables.keySet();
    }

    public int size() {
        return this.substitutedVariables.size();
    }

    public IASTAppendable listOfBackwardSubstitutions() {
        Map<ISymbol, IExpr> map = this.substitutedVariables();
        IASTAppendable list = F.ListAlloc(this.size());
        for (Map.Entry<ISymbol, IExpr> x : map.entrySet()) {
            IExpr value = x.getValue();
            if (value == null) continue;
            IExpr key = x.getKey();
            IInteger denominatorLCM = this.getLCM(key);
            if (denominatorLCM.isOne()) {
                list.append(F.Rule(key, value));
                continue;
            }
            list.append(F.Rule(key, (IExpr)F.Power(value, F.fraction(F.C1, denominatorLCM))));
        }
        return list;
    }
}

