/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.RingElem;
import java.math.BigInteger;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;

public class PartialFractionIntegrateGenerator
implements IPartialFractionGenerator {
    IASTAppendable result = null;
    JASConvert<BigRational> jas;
    IExpr x;

    public PartialFractionIntegrateGenerator(IExpr x) {
        this.x = x;
    }

    @Override
    public void allocPlus(int size) {
        this.result = F.PlusAlloc(size);
    }

    @Override
    public void setJAS(JASConvert<BigRational> jas) {
        this.jas = jas;
    }

    @Override
    public IExpr getResult() {
        IExpr temp = this.result.oneIdentity0();
        if (temp.head().equals(S.Integrate)) {
            return F.NIL;
        }
        return temp;
    }

    @Override
    public void addNonFractionalPart(GenPolynomial<BigRational> genPolynomial) {
        IExpr temp = F.eval(this.jas.rationalPoly2Expr(genPolynomial, false));
        if (temp.isAST()) {
            ((IAST)temp).addEvalFlags(128);
        }
        this.result.append(F.Integrate(temp, this.x));
    }

    @Override
    public void addSinglePartialFraction(GenPolynomial<BigRational> genPolynomial, GenPolynomial<BigRational> Di_1, int j) {
        if (!genPolynomial.isZERO()) {
            boolean isDegreeLE2;
            BigRational[] numer = new BigRational[3];
            BigRational[] denom = new BigRational[3];
            boolean bl = isDegreeLE2 = Di_1.degree() <= 2L;
            if (isDegreeLE2 && (long)j == 1L) {
                Object[] objects = this.jas.factorTerms(genPolynomial);
                BigInteger gcd = (BigInteger)objects[0];
                BigInteger lcm = (BigInteger)objects[1];
                GenPolynomial genPolynomial2 = ((GenPolynomial)objects[2]).multiply((RingElem)edu.jas.arith.BigInteger.valueOf((BigInteger)gcd));
                if (genPolynomial2.isONE()) {
                    GenPolynomial newDi_1 = Di_1.multiply((RingElem)BigRational.valueOf((BigInteger)lcm));
                    PartialFractionIntegrateGenerator.isQuadratic((GenPolynomial<BigRational>)newDi_1, denom);
                    IFraction a = F.fraction(denom[2].numerator(), denom[2].denominator());
                    IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                    IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                    if (a.isZero()) {
                        this.result.append(F.Times((IExpr)F.Log(F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, this.x))), (IExpr)F.Power((IExpr)b, F.CN1)));
                    } else {
                        BigRational cmp = denom[1].multiply(denom[1]).subtract(BigRational.valueOf((long)4L).multiply(denom[2]).multiply(denom[0]));
                        int cmpTo = cmp.compareTo(BigRational.ZERO);
                        IAST ax2Plusb = F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)a, this.x), (IExpr)b);
                        if (cmpTo == 0) {
                            this.result.append(F.Times((IExpr)F.CN2, (IExpr)F.Power((IExpr)ax2Plusb, F.CN1)));
                        } else if (cmpTo > 0) {
                            IExpr temp = F.eval(F.Power((IExpr)F.Subtract(F.Sqr(b), F.Times((IExpr)F.C4, (IExpr)a, (IExpr)c)), F.C1D2));
                            this.result.append(F.Times((IExpr)F.Power(temp, F.CN1), (IExpr)F.Log(F.Times((IExpr)F.Subtract(ax2Plusb, temp), (IExpr)F.Power((IExpr)F.Plus((IExpr)ax2Plusb, temp), F.CN1)))));
                        } else {
                            IExpr temp = F.eval(F.Power((IExpr)F.Subtract(F.Times((IExpr)F.C4, (IExpr)a, (IExpr)c), F.Sqr(b)), F.CN1D2));
                            this.result.append(F.Times((IExpr)F.C2, temp, (IExpr)F.ArcTan(F.Times((IExpr)ax2Plusb, temp))));
                        }
                    }
                } else {
                    PartialFractionIntegrateGenerator.isQuadratic(genPolynomial, numer);
                    IFraction A = F.fraction(numer[1].numerator(), numer[1].denominator());
                    IFraction B = F.fraction(numer[0].numerator(), numer[0].denominator());
                    PartialFractionIntegrateGenerator.isQuadratic(Di_1, denom);
                    IFraction p = F.fraction(denom[1].numerator(), denom[1].denominator());
                    IFraction q = F.fraction(denom[0].numerator(), denom[0].denominator());
                    IAST temp = A.isZero() && !p.isZero() ? (q.isNegative() ? F.Times((IExpr)B, (IExpr)F.Log(F.Plus((IExpr)q.negate(), (IExpr)F.Times((IExpr)p.negate(), this.x))), (IExpr)F.Power((IExpr)p, F.CN1)) : F.Times((IExpr)B, (IExpr)F.Log(F.Plus((IExpr)q, (IExpr)F.Times((IExpr)p, this.x))), (IExpr)F.Power((IExpr)p, F.CN1))) : F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)A, (IExpr)F.Log(F.Plus((IExpr)q, (IExpr)F.Times((IExpr)p, this.x), (IExpr)F.Power(this.x, F.C2)))), (IExpr)F.Times((IExpr)F.ArcTan(F.Times((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.C2, this.x)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2))), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)B), (IExpr)F.Times((IExpr)F.CN1, (IExpr)A, (IExpr)p)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2)));
                    this.result.append(F.eval(temp));
                }
            } else if (isDegreeLE2 && (long)j > 1L) {
                PartialFractionIntegrateGenerator.isQuadratic(genPolynomial, numer);
                IFraction A = F.fraction(numer[1].numerator(), numer[1].denominator());
                IFraction B = F.fraction(numer[0].numerator(), numer[0].denominator());
                PartialFractionIntegrateGenerator.isQuadratic(Di_1, denom);
                IFraction a = F.fraction(denom[2].numerator(), denom[2].denominator());
                IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                IInteger k = F.ZZ(j);
                IAST temp = A.isZero() ? F.Times((IExpr)B, (IExpr)F.Plus((IExpr)F.Times(F.Integrate(F.Power((IExpr)F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, this.x), (IExpr)F.Times((IExpr)a, (IExpr)F.Power(this.x, F.C2))), F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)k))), this.x), F.Plus((IExpr)F.Times((IExpr)F.ZZ(-6L), (IExpr)a), (IExpr)F.Times((IExpr)F.C4, (IExpr)a, (IExpr)k)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)a, (IExpr)c)), F.CN1)), (IExpr)F.Times(F.Plus((IExpr)b, (IExpr)F.Times((IExpr)F.C2, (IExpr)a, this.x)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)a, (IExpr)c)), F.CN1), F.Power((IExpr)F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, this.x), (IExpr)F.Times((IExpr)a, (IExpr)F.Power(this.x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))))) : F.Plus((IExpr)F.Times((IExpr)F.Integrate(F.Power((IExpr)F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, this.x), (IExpr)F.Times((IExpr)a, (IExpr)F.Power(this.x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)k)), this.x), (IExpr)F.Plus((IExpr)B, (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), b))), (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, this.x), (IExpr)F.Times((IExpr)a, (IExpr)F.Power(this.x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))));
                this.result.append(F.eval(temp));
            } else {
                IExpr temp = F.eval(F.Times((IExpr)this.jas.rationalPoly2Expr(genPolynomial, false), (IExpr)F.Power((IExpr)this.jas.rationalPoly2Expr(Di_1, false), F.ZZ((long)j * -1L))));
                if (!temp.isZero()) {
                    if (temp.isAST()) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    this.result.append(F.Integrate(temp, this.x));
                }
            }
        }
    }

    public static boolean isQuadratic(GenPolynomial<BigRational> poly, BigRational[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = BigRational.ZERO;
            result[1] = BigRational.ZERO;
            result[2] = BigRational.ZERO;
            for (Monomial monomial : poly) {
                BigRational coeff = (BigRational)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isQuadratic(GenPolynomial<edu.jas.arith.BigInteger> poly, edu.jas.arith.BigInteger[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = edu.jas.arith.BigInteger.ZERO;
            result[1] = edu.jas.arith.BigInteger.ZERO;
            result[2] = edu.jas.arith.BigInteger.ZERO;
            for (Monomial monomial : poly) {
                edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }
}

