/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.math.BigInteger;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;

public class PartialFractionGenerator
implements IPartialFractionGenerator {
    IASTAppendable result = null;
    JASConvert<BigRational> jas;

    @Override
    public void allocPlus(int size) {
        this.result = F.PlusAlloc(size);
    }

    @Override
    public void setJAS(JASConvert<BigRational> jas) {
        this.jas = jas;
    }

    @Override
    public IAST getResult() {
        return this.result;
    }

    @Override
    public void addNonFractionalPart(GenPolynomial<BigRational> genPolynomial) {
        IExpr temp = F.eval(this.jas.rationalPoly2Expr(genPolynomial, false));
        if (temp.isAST()) {
            ((IAST)temp).addEvalFlags(128);
        }
        this.result.append(temp);
    }

    @Override
    public void addSinglePartialFraction(GenPolynomial<BigRational> genPolynomial, GenPolynomial<BigRational> Di_1, int j) {
        Object[] objects = this.jas.factorTerms(genPolynomial);
        BigInteger gcd = (BigInteger)objects[0];
        BigInteger lcm = (BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        IExpr temp = j == 1 ? F.eval(F.Times((IExpr)F.integer(gcd), this.jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly), (IExpr)F.Power((IExpr)this.jas.rationalPoly2Expr((GenPolynomial<BigRational>)Di_1.multiply((RingElem)BigRational.valueOf((BigInteger)lcm)), true), F.CN1))) : F.eval(F.Times(F.integer(gcd), this.jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly), F.Power((IExpr)F.ZZ(lcm), F.CN1), F.Power((IExpr)this.jas.rationalPoly2Expr(Di_1, true), F.ZZ((long)j * -1L))));
        if (!temp.isZERO()) {
            if (temp.isAST()) {
                ((IAST)temp).addEvalFlags(128);
            }
            this.result.append(temp);
        }
    }
}

