/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class HornerScheme {
    private TreeMap<ISignedNumber, IASTAppendable> map;

    public HornerScheme() {
        Comparator<ISignedNumber> comp = new Comparator<ISignedNumber>(){

            @Override
            public int compare(ISignedNumber arg0, ISignedNumber arg1) {
                if (arg0.isGT(arg1)) {
                    return 1;
                }
                if (arg0.isLT(arg1)) {
                    return -1;
                }
                return 0;
            }
        };
        this.map = new TreeMap(comp);
    }

    public IAST generate(boolean numericMode, IAST poly, IExpr sym) {
        IASTAppendable result;
        if (numericMode) {
            IASTAppendable result2;
            poly.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.collectTermN(sym, (IExpr)x)));
            IASTAppendable startResult = result2 = F.PlusAlloc(16);
            ISignedNumber start = F.CD0;
            for (ISignedNumber exponent : this.map.keySet()) {
                IExpr coefficient = this.getCoefficient(exponent);
                if (exponent.isLT(F.CD1)) {
                    if (exponent.compareTo(F.CD0) == 0) {
                        result2.append(coefficient);
                        continue;
                    }
                    result2.append(F.Times(coefficient, (IExpr)F.Power(sym, exponent)));
                    continue;
                }
                IASTAppendable temp = F.TimesAlloc(2);
                ISignedNumber currentExponent = exponent.subtractFrom(start);
                if (currentExponent.equals(F.CD1)) {
                    temp.append(sym);
                } else {
                    temp.append(F.Power(sym, currentExponent));
                }
                result2.append(temp);
                result2 = F.PlusAlloc(16);
                temp.append(result2);
                result2.append(coefficient);
                start = exponent;
            }
            return startResult;
        }
        poly.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.collectTerm(sym, (IExpr)x)));
        IASTAppendable startResult = result = F.PlusAlloc(16);
        ISignedNumber start = F.C0;
        for (ISignedNumber exponent : this.map.keySet()) {
            IExpr coefficient = this.getCoefficient(exponent);
            if (exponent.isLT(F.C1)) {
                if (exponent.compareTo(F.C0) == 0) {
                    result.append(coefficient);
                    continue;
                }
                result.append(F.Times(coefficient, (IExpr)F.Power(sym, exponent)));
                continue;
            }
            IASTAppendable temp = F.TimesAlloc(2);
            ISignedNumber currentExponent = exponent.subtractFrom(start);
            if (currentExponent.equals(F.C1)) {
                temp.append(sym);
            } else {
                temp.append(F.Power(sym, currentExponent));
            }
            result.append(temp);
            result = F.PlusAlloc(16);
            temp.append(result);
            result.append(coefficient);
            start = exponent;
        }
        return startResult;
    }

    private IExpr getCoefficient(ISignedNumber key) {
        IExpr coefficient;
        IAST value = this.map.get(key);
        if (value.isAST(S.Plus, 2)) {
            coefficient = value.arg1();
            if (coefficient.isAST(S.Times, 2)) {
                coefficient = coefficient.first();
            }
        } else {
            coefficient = value;
        }
        return coefficient;
    }

    private void collectTerm(IExpr sym, IExpr expr) {
        if (expr instanceof IAST) {
            IAST term = (IAST)expr;
            if (term.isTimes()) {
                for (int i = 1; i < term.size(); ++i) {
                    IAST pow;
                    if (sym.equals(term.get(i))) {
                        IAST temp = F.ast(term, S.Times, false, i, i + 1);
                        this.addToMap(F.C1, temp);
                        return;
                    }
                    if (!term.get(i).isAST(S.Power, 3) || !(pow = (IAST)term.get(i)).arg1().equals(sym) || !(pow.arg2() instanceof ISignedNumber)) continue;
                    IAST temp = F.ast(term, S.Times, false, i, i + 1);
                    this.addToMap((ISignedNumber)pow.arg2(), temp);
                    return;
                }
            } else if (term.isAST(S.Power, 3) && term.arg1().equals(sym) && term.arg2() instanceof ISignedNumber) {
                this.addToMap((ISignedNumber)term.arg2(), F.C1);
                return;
            }
        } else if (expr instanceof ISymbol && expr.equals(sym)) {
            this.addToMap(F.C1, F.C1);
            return;
        }
        this.addToMap(F.C0, expr);
    }

    private void collectTermN(IExpr sym, IExpr expr) {
        if (expr instanceof IAST) {
            IAST term = (IAST)expr;
            if (term.isTimes()) {
                for (int i = 1; i < term.size(); ++i) {
                    IAST pow;
                    if (sym.equals(term.get(i))) {
                        IAST temp = F.ast(term, S.Times, false, i, i + 1);
                        this.addToMap(F.CD1, temp);
                        return;
                    }
                    if (!term.get(i).isAST(S.Power, 3) || !(pow = (IAST)term.get(i)).arg1().equals(sym) || !pow.arg2().isReal()) continue;
                    IAST temp = F.ast(term, S.Times, false, i, i + 1);
                    this.addToMap((ISignedNumber)pow.arg2(), temp);
                    return;
                }
            } else if (term.isAST(S.Power, 3) && term.arg1().equals(sym) && term.arg2().isReal()) {
                this.addToMap((ISignedNumber)term.arg2(), F.CD1);
                return;
            }
        } else if (expr instanceof ISymbol && expr.equals(sym)) {
            this.addToMap(F.CD1, F.CD1);
            return;
        }
        this.addToMap(F.CD0, expr);
    }

    public IAST addToMap(ISignedNumber key, IExpr value) {
        IASTAppendable temp = this.map.get(key);
        if (temp == null) {
            temp = F.PlusAlloc(8);
            temp.append(value);
            this.map.put(key, temp);
        } else {
            temp.append(value);
        }
        return temp;
    }
}

