/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching.hash;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.patternmatching.hash.AbstractHashedPatternRules;

public class HashedPatternRules
extends AbstractHashedPatternRules {
    final IExpr fCondition;
    final IExpr fRHS;
    final boolean fLHS2Negate;

    public HashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, IExpr rhsResult, boolean lhs2Negate, IExpr condition, boolean defaultHashCode) {
        super(lhsPattern1, lhsPattern2, defaultHashCode);
        this.fCondition = condition;
        this.fRHS = rhsResult;
        this.fLHS2Negate = lhs2Negate;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        boolean test = super.equals(obj);
        if (test && obj instanceof HashedPatternRules) {
            HashedPatternRules other = (HashedPatternRules)obj;
            if (this.fCondition == null ? other.fCondition != null : !this.fCondition.equals(other.fCondition)) {
                return false;
            }
            return !(this.fRHS == null ? other.fRHS != null : !this.fRHS.equals(other.fRHS));
        }
        return false;
    }

    public IExpr getRHS() {
        return IExpr.ofNullable(this.fRHS);
    }

    public IExpr getCondition() {
        return this.fCondition;
    }

    public RulesData getRulesData() {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
            if (this.fCondition != null) {
                this.fRulesData.putDownRule(2, false, F.list(this.fLHSPattern1, this.fLHSPattern2), F.Condition(this.fRHS, this.fCondition));
            } else {
                this.fRulesData.putDownRule(2, false, F.list(this.fLHSPattern1, this.fLHSPattern2), this.fRHS);
            }
        }
        return this.fRulesData;
    }

    @Override
    public IExpr evalDownRule(IExpr arg1, IExpr num1, IExpr arg2, IExpr num2, EvalEngine engine) {
        return this.getRulesData().evalDownRule(F.list(arg1, arg2), engine);
    }

    @Override
    public boolean isLHS2Negate() {
        return this.fLHS2Negate;
    }

    public String toString() {
        return "[" + this.fLHSPattern1 + "," + this.fLHSPattern2 + "] => [" + this.fRHS + " /; " + this.fCondition + "]";
    }
}

