/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching.hash;

import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.util.OpenIntToList;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.hash.AbstractHashedPatternRules;
import org.matheclipse.core.patternmatching.hash.HashedPatternRules;
import org.matheclipse.core.visit.HashValueVisitor;

public class HashedOrderlessMatcher {
    private static int MAX_AST_SIZE_ARGUMENT = 4;
    protected OpenIntToList<AbstractHashedPatternRules> fHashRuleMap = new OpenIntToList();
    protected OpenIntToList<AbstractHashedPatternRules> fPatternHashRuleMap = new OpenIntToList();

    public void defineHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs) {
        this.defineHashRule(lhs1, lhs2, rhs, null);
    }

    public void defineHashRule(AbstractHashedPatternRules hashRule) {
        this.fHashRuleMap.put(hashRule.hashCode(), hashRule);
    }

    public void defineHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, false, condition, true);
        this.fHashRuleMap.put(((AbstractHashedPatternRules)hashRule).hashCode(), hashRule);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs) {
        this.definePatternHashRule(lhs1, lhs2, rhs, null);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, boolean lhsNegate) {
        this.definePatternHashRule(lhs1, lhs2, rhs, lhsNegate, null);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, false, condition, false);
        this.fPatternHashRuleMap.put(((AbstractHashedPatternRules)hashRule).hashCode(), hashRule);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, boolean lhsNegate, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, lhsNegate, condition, false);
        this.fPatternHashRuleMap.put(((AbstractHashedPatternRules)hashRule).hashCode(), hashRule);
    }

    public IAST evaluateRepeated(IAST orderlessAST, EvalEngine engine) {
        if (orderlessAST.isEvalFlagOn(16384)) {
            return F.NIL;
        }
        if (HashedOrderlessMatcher.exists2ASTArguments(orderlessAST)) {
            int[] hashValues;
            IAST result;
            IAST temp = orderlessAST;
            boolean evaled = false;
            if (!this.fPatternHashRuleMap.isEmpty()) {
                IExpr head = orderlessAST.head();
                result = F.NIL;
                while (temp.isPresent()) {
                    int size = temp.argSize();
                    hashValues = new int[size];
                    this.createSpecialHashValues(temp, hashValues);
                    result = this.evaluateHashedValues(temp, this.fPatternHashRuleMap, hashValues, engine);
                    if (!result.isPresent()) break;
                    temp = result;
                    evaled = true;
                    if (temp.head().equals(head)) continue;
                    return HashedOrderlessMatcher.setIsHashEvaledFlag(temp);
                }
            }
            if (!this.fHashRuleMap.isEmpty()) {
                int size = temp.argSize();
                hashValues = new int[size];
                this.createHashValues(temp, hashValues);
                result = this.evaluateHashedValues(temp, this.fHashRuleMap, hashValues, engine);
                if (result.isPresent()) {
                    return HashedOrderlessMatcher.setIsHashEvaledFlag(result);
                }
            }
            if (evaled) {
                return HashedOrderlessMatcher.setIsHashEvaledFlag(temp);
            }
        }
        orderlessAST.addEvalFlags(16384);
        return F.NIL;
    }

    protected static IAST setIsHashEvaledFlag(IAST ast) {
        ast.setEvalFlags(16384);
        return ast;
    }

    protected static boolean exists2ASTArguments(IAST ast) {
        int[] counter = new int[]{0};
        return ast.exists(x -> x.size() < MAX_AST_SIZE_ARGUMENT && (counter[0] = counter[0] + 1) == 2);
    }

    public IAST evaluate(IAST orderlessAST, EvalEngine engine) {
        int[] hashValues = new int[orderlessAST.argSize()];
        if (!this.fPatternHashRuleMap.isEmpty()) {
            this.createSpecialHashValues(orderlessAST, hashValues);
            IAST result = this.evaluateHashedValues(orderlessAST, this.fPatternHashRuleMap, hashValues, engine);
            if (result.isPresent()) {
                return result;
            }
        }
        if (!this.fHashRuleMap.isEmpty()) {
            this.createHashValues(orderlessAST, hashValues);
            return this.evaluateHashedValues(orderlessAST, this.fHashRuleMap, hashValues, engine);
        }
        return F.NIL;
    }

    protected void createHashValues(IAST orderlessAST, int[] hashValues) {
        for (int i = 0; i < hashValues.length; ++i) {
            hashValues[i] = orderlessAST.get(i + 1).head().hashCode();
        }
    }

    protected void createSpecialHashValues(IAST orderlessAST, int[] hashValues) {
        for (int i = 0; i < hashValues.length; ++i) {
            hashValues[i] = orderlessAST.get(i + 1).accept(HashValueVisitor.HASH_VALUE_VISITOR);
        }
    }

    protected IAST evaluateHashedValues(IAST orderlessAST, OpenIntToList<AbstractHashedPatternRules> hashRuleMap, int[] hashValues, EvalEngine engine) {
        int i;
        boolean evaled = false;
        IASTAppendable result = orderlessAST.copyHead();
        block0: for (i = 0; i < hashValues.length - 1; ++i) {
            if (hashValues[i] == 0 || orderlessAST.get(i + 1).size() >= MAX_AST_SIZE_ARGUMENT) continue;
            for (int j = i + 1; j < hashValues.length; ++j) {
                List<AbstractHashedPatternRules> hashRuleList;
                if (hashValues[j] == 0 || orderlessAST.get(j + 1).size() >= MAX_AST_SIZE_ARGUMENT || (hashRuleList = hashRuleMap.get(AbstractHashedPatternRules.calculateHashcode(hashValues[i], hashValues[j]))) == null) continue;
                for (AbstractHashedPatternRules hashRule : hashRuleList) {
                    if (!hashRule.isPattern1() && !hashRule.isPattern2()) {
                        if (hashValues[i] != hashRule.getHash1() || hashValues[j] != hashRule.getHash2()) {
                            if (hashValues[i] != hashRule.getHash2() || hashValues[j] != hashRule.getHash1() || !this.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i, engine)) continue;
                            evaled = true;
                            continue block0;
                        }
                        if (this.updateHashValues(result, orderlessAST, hashRule, hashValues, i, j, engine)) {
                            evaled = true;
                            continue block0;
                        }
                        if (hashValues[i] != hashRule.getHash2() || hashValues[j] != hashRule.getHash1() || !this.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i, engine)) continue;
                        evaled = true;
                        continue block0;
                    }
                    if (this.updateHashValues(result, orderlessAST, hashRule, hashValues, i, j, engine)) {
                        evaled = true;
                        continue block0;
                    }
                    if (!this.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i, engine)) continue;
                    evaled = true;
                    continue block0;
                }
            }
        }
        if (evaled) {
            for (i = 0; i < hashValues.length; ++i) {
                if (hashValues[i] == 0) continue;
                result.append(orderlessAST.get(i + 1));
            }
            return result;
        }
        return F.NIL;
    }

    protected boolean updateHashValues(IASTAppendable result, IAST orderlessAST, AbstractHashedPatternRules hashRule, int[] hashValues, int i, int j, EvalEngine engine) {
        IExpr temp = hashRule.evalDownRule(orderlessAST.get(i + 1), null, orderlessAST.get(j + 1), null, engine);
        if (temp.isPresent()) {
            hashValues[i] = 0;
            hashValues[j] = 0;
            result.append(temp);
            return true;
        }
        return false;
    }
}

