/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching.hash;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.patternmatching.hash.HashedPatternRules;
import org.matheclipse.core.visit.HashValueVisitor;

public abstract class AbstractHashedPatternRules {
    protected final IExpr fLHSPattern1;
    protected final IExpr fLHSPattern2;
    protected int hash1;
    protected int hash2;
    protected int hashSum;
    protected RulesData fRulesData = null;

    public AbstractHashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, boolean defaultHashCode) {
        this.fLHSPattern1 = lhsPattern1;
        this.fLHSPattern2 = lhsPattern2;
        this.hashValues(lhsPattern1, lhsPattern2, defaultHashCode);
    }

    public void hashValues(IExpr lhsPattern1, IExpr lhsPattern2, boolean defaultHashCode) {
        if (defaultHashCode) {
            this.hash1 = lhsPattern1.head().hashCode();
            this.hash2 = lhsPattern2.head().hashCode();
        } else {
            this.hash1 = lhsPattern1.accept(HashValueVisitor.HASH_VALUE_VISITOR);
            this.hash2 = lhsPattern2.accept(HashValueVisitor.HASH_VALUE_VISITOR);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractHashedPatternRules) {
            HashedPatternRules other = (HashedPatternRules)obj;
            if (this.hash1 != other.hash1) {
                return false;
            }
            if (this.hash2 != other.hash2) {
                return false;
            }
            if (this.fLHSPattern1 == null ? other.fLHSPattern1 != null : !this.fLHSPattern1.equals(other.fLHSPattern1)) {
                return false;
            }
            return !(this.fLHSPattern2 == null ? other.fLHSPattern2 != null : !this.fLHSPattern2.equals(other.fLHSPattern2));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashSum == 0) {
            this.hashSum = AbstractHashedPatternRules.calculateHashcode(this.hash1, this.hash2);
        }
        return this.hashSum;
    }

    public static int calculateHashcode(int h1, int h2) {
        return 31 * (h1 + h2);
    }

    public int getHash1() {
        return this.hash1;
    }

    public int getHash2() {
        return this.hash2;
    }

    public boolean isPattern1() {
        return this.fLHSPattern1.isPattern();
    }

    public boolean isPattern2() {
        return this.fLHSPattern2.isPattern();
    }

    public boolean isLHS2Negate() {
        return false;
    }

    public abstract IExpr evalDownRule(IExpr var1, IExpr var2, IExpr var3, IExpr var4, EvalEngine var5);
}

