/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.util.OpenIntToIExprHashMap;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.PatternMatcherEquals;
import org.matheclipse.core.visit.AbstractVisitor;
import org.matheclipse.parser.trie.TrieMatch;

public final class RulesData
implements Serializable {
    private static final long serialVersionUID = -7747268035549814899L;
    private static final Logger LOGGER = LogManager.getLogger();
    static boolean showSteps = false;
    public static final int DEFAULT_VALUE_INDEX = Integer.MIN_VALUE;
    private OpenIntToIExprHashMap<IExpr> fDefaultValues;
    private Map<String, IStringX> fMessages;
    private Map<IExpr, PatternMatcherEquals> fEqualDownRules;
    private List<IPatternMatcher> fPatternDownRules;
    private IntArrayList fPriorityDownRules;
    private Map<IExpr, PatternMatcherEquals> fEqualUpRules;
    private List<IPatternMatcher> fSimplePatternUpRules;

    public static boolean isComplicatedPatternRule(IExpr lhs) {
        if (lhs.isASTOrAssociation()) {
            IAST lhsAST = (IAST)lhs;
            if (lhsAST.size() > 1) {
                if (lhsAST.topHead().hasOrderlessAttribute()) {
                    return true;
                }
                IExpr a1 = lhsAST.arg1();
                if (RulesData.isComplicatedPatternExpr(a1) || !a1.head().isFreeOfPatterns()) {
                    return true;
                }
                if (lhsAST.exists(x -> x.isPatternDefault() || x.isPatternSequence(false))) {
                    return true;
                }
            }
            return !lhs.head().isFreeOfPatterns();
        }
        return RulesData.isComplicatedPatternExpr(lhs);
    }

    private static boolean isComplicatedPatternExpr(IExpr a1) {
        if (a1 instanceof IPatternObject) {
            return true;
        }
        if (a1.isASTOrAssociation()) {
            if (a1.isPatternMatchingFunction()) {
                return true;
            }
            IAST arg1 = (IAST)a1;
            IExpr head = arg1.head();
            if (!head.isSymbol() && RulesData.isComplicatedPatternExpr(head)) {
                return true;
            }
            return arg1.exists(x -> x.isPatternDefault(), 1);
        }
        return false;
    }

    public RulesData() {
        this.clear();
    }

    public RulesData(int[] sizes) {
        this.clear();
        if (sizes.length > 0 && sizes[0] > 0) {
            int capacity = sizes[0];
            if (capacity < 8) {
                capacity = 8;
            }
            this.fEqualDownRules = new HashMap<IExpr, PatternMatcherEquals>(capacity);
        }
    }

    public void accept(AbstractVisitor visitor) {
        IAST ast;
        PatternMatcherAndEvaluator pmEvaluator;
        PatternMatcherEquals pmEquals;
        if (this.fEqualUpRules != null && this.fEqualUpRules.size() > 0) {
            for (IExpr key : this.fEqualUpRules.keySet()) {
                pmEquals = this.fEqualUpRules.get(key);
                if (key.isASTOrAssociation()) {
                    key.accept(visitor);
                }
                if (!pmEquals.getRHS().isASTOrAssociation()) continue;
                pmEquals.getRHS().accept(visitor);
            }
        }
        if (this.fSimplePatternUpRules != null && this.fSimplePatternUpRules.size() > 0) {
            List<IPatternMatcher> upRules = this.fSimplePatternUpRules;
            for (int i = 0; i < upRules.size(); ++i) {
                IPatternMatcher elem;
                if (upRules.get(i) == null || !((elem = upRules.get(i)) instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                if (pmEvaluator.getLHS().isASTOrAssociation()) {
                    pmEvaluator.getLHS().accept(visitor);
                }
                if (!pmEvaluator.getRHS().isASTOrAssociation()) continue;
                pmEvaluator.getRHS().accept(visitor);
            }
        }
        if (this.fEqualDownRules != null && this.fEqualDownRules.size() > 0) {
            for (IExpr key : this.fEqualDownRules.keySet()) {
                pmEquals = this.fEqualDownRules.get(key);
                ast = pmEquals.getAsAST();
                if (key.isASTOrAssociation()) {
                    key.accept(visitor);
                }
                ast.accept(visitor);
            }
        }
        if (this.fPatternDownRules != null && this.fPatternDownRules.size() > 0) {
            IPatternMatcher[] list = this.fPatternDownRules.toArray(new IPatternMatcher[0]);
            int length = list.length;
            for (int i = 0; i < length; ++i) {
                if (!(list[i] instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)list[i];
                ast = pmEvaluator.getAsAST();
                ast.accept(visitor);
            }
        }
    }

    private PatternMatcher addSimplePatternUpRule(IExpr leftHandSide, PatternMatcher pmEvaluator) {
        int indx;
        IExpr head = ((IAST)leftHandSide).head();
        if (head.isFreeOfPatterns()) {
            int indx2;
            int hash = ((IAST)leftHandSide).topHead().hashCode();
            if (F.isSystemInitialized() && (indx2 = this.fSimplePatternUpRules.indexOf(pmEvaluator)) >= 0) {
                this.fSimplePatternUpRules.remove(indx2);
            }
            this.fSimplePatternUpRules.add(pmEvaluator);
            return pmEvaluator;
        }
        if (F.isSystemInitialized() && (indx = this.fSimplePatternUpRules.indexOf(pmEvaluator)) >= 0) {
            this.fSimplePatternUpRules.remove(indx);
        }
        this.fSimplePatternUpRules.add(pmEvaluator);
        return pmEvaluator;
    }

    public void clear() {
        this.fEqualDownRules = null;
        this.fPatternDownRules = null;
        this.fPriorityDownRules = null;
        this.fEqualUpRules = null;
        this.fSimplePatternUpRules = null;
    }

    public void clearAll() {
        this.clear();
        this.fMessages = null;
    }

    public List<IAST> definition() {
        PatternMatcherAndEvaluator pmEvaluator;
        PatternMatcherEquals pmEquals;
        ArrayList<IAST> definitionList = new ArrayList<IAST>();
        if (this.fEqualUpRules != null && this.fEqualUpRules.size() > 0) {
            for (IExpr key : this.fEqualUpRules.keySet()) {
                pmEquals = this.fEqualUpRules.get(key);
                definitionList.add(pmEquals.getAsAST());
            }
        }
        if (this.fSimplePatternUpRules != null) {
            for (int i = 0; i < this.fSimplePatternUpRules.size(); ++i) {
                IPatternMatcher elem = this.fSimplePatternUpRules.get(i);
                if (!(elem instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                definitionList.add(pmEvaluator.getAsAST());
            }
        }
        if (this.fEqualDownRules != null && this.fEqualDownRules.size() > 0) {
            for (IExpr key : this.fEqualDownRules.keySet()) {
                pmEquals = this.fEqualDownRules.get(key);
                definitionList.add(pmEquals.getAsAST());
            }
        }
        if (this.fPatternDownRules != null && this.fPatternDownRules.size() > 0) {
            IPatternMatcher[] list = this.fPatternDownRules.toArray(new IPatternMatcher[0]);
            int length = list.length;
            for (int i = 0; i < length; ++i) {
                if (!(list[i] instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)list[i];
                definitionList.add(pmEvaluator.getAsAST());
            }
        }
        return definitionList;
    }

    public IAST downValues() {
        int size = 1;
        if (this.fEqualDownRules != null) {
            size += this.fEqualDownRules.size();
        }
        if (this.fPatternDownRules != null) {
            size += this.fPatternDownRules.size();
        }
        IASTAppendable result = F.ListAlloc(size);
        if (this.fEqualDownRules != null) {
            for (Map.Entry<IExpr, PatternMatcherEquals> entry : this.fEqualDownRules.entrySet()) {
                PatternMatcherEquals value = entry.getValue();
                result.append(F.RuleDelayed(F.HoldPattern(value.getLHS()), value.getRHS()));
            }
        }
        if (this.fPatternDownRules != null) {
            for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
                IPatternMatcher matcher = this.fPatternDownRules.get(i);
                result.append(F.RuleDelayed(F.HoldPattern(matcher.getLHS()), matcher.getRHS()));
            }
        }
        return result;
    }

    public IAST upValues() {
        int size = 1;
        if (this.fEqualUpRules != null) {
            size += this.fEqualUpRules.size();
        }
        if (this.fSimplePatternUpRules != null) {
            size += this.fSimplePatternUpRules.size();
        }
        IASTAppendable result = F.ListAlloc(size);
        if (this.fEqualUpRules != null) {
            for (Map.Entry<IExpr, PatternMatcherEquals> entry : this.fEqualUpRules.entrySet()) {
                PatternMatcherEquals value = entry.getValue();
                result.append(F.RuleDelayed(F.HoldPattern(value.getLHS()), value.getRHS()));
            }
        }
        if (this.fSimplePatternUpRules != null) {
            for (int i = 0; i < this.fSimplePatternUpRules.size(); ++i) {
                IPatternMatcher matcher = this.fSimplePatternUpRules.get(i);
                result.append(F.RuleDelayed(F.HoldPattern(matcher.getLHS()), matcher.getRHS()));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RulesData other = (RulesData)obj;
        if (this.fEqualDownRules == null ? other.fEqualDownRules != null : !this.fEqualDownRules.equals(other.fEqualDownRules)) {
            return false;
        }
        if (this.fEqualUpRules == null ? other.fEqualUpRules != null : !this.fEqualUpRules.equals(other.fEqualUpRules)) {
            return false;
        }
        if (this.fPatternDownRules == null ? other.fPatternDownRules != null : !this.fPatternDownRules.equals(other.fPatternDownRules)) {
            return false;
        }
        return !(this.fSimplePatternUpRules == null ? other.fSimplePatternUpRules != null : !this.fSimplePatternUpRules.equals(other.fSimplePatternUpRules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evalDownRule(IExpr expr, EvalEngine engine) {
        PatternMatcherEquals res;
        if (this.fEqualDownRules != null && (res = this.fEqualDownRules.get(expr)) != null) {
            if (showSteps) {
                LOGGER.info("\n  >>>> {}", (Object)res.getRHS());
            }
            return res.getRHS();
        }
        if (!expr.isASTOrAssociation()) {
            return F.NIL;
        }
        boolean evalRHSMode = engine.isEvalRHSMode();
        try {
            engine.setEvalRHSMode(true);
            if (this.fPatternDownRules != null) {
                int patternHash = 0;
                if (expr.isASTOrAssociation()) {
                    patternHash = ((IAST)expr).patternHashCode();
                }
                for (IPatternMatcher patternEvaluator : this.fPatternDownRules) {
                    IExpr result;
                    IExpr rhs;
                    if (!patternEvaluator.isPatternHashAllowed(patternHash)) continue;
                    IPatternMatcher pmEvaluator = (IPatternMatcher)patternEvaluator.clone();
                    if (showSteps && this.isShowSteps(pmEvaluator)) {
                        rhs = pmEvaluator.getRHS().orElse(S.Null);
                        LOGGER.info(" COMPLEX: {} := {}", (Object)pmEvaluator.getLHS(), (Object)rhs);
                    }
                    if (LOGGER.isDebugEnabled() && this.isShowPriority(pmEvaluator)) {
                        LOGGER.debug("try: {} - ", (Object)pmEvaluator.getLHSPriority());
                    }
                    if ((result = pmEvaluator.eval(expr, engine)).isPresent()) {
                        if (LOGGER.isDebugEnabled() && this.isShowPriority(pmEvaluator)) {
                            LOGGER.debug("matched: {}: {}", (Object)pmEvaluator.getLHSPriority(), (Object)pmEvaluator);
                        }
                        if (showSteps && this.isShowSteps(pmEvaluator)) {
                            rhs = pmEvaluator.getRHS();
                            if (!rhs.isPresent()) {
                                rhs = S.Null;
                            }
                            LOGGER.info("\nCOMPLEX: {} := {}", (Object)pmEvaluator.getLHS(), (Object)rhs);
                            LOGGER.info(" >>> {}  >>>>  {}", (Object)expr, (Object)result);
                        }
                        IExpr iExpr = result;
                        return iExpr;
                    }
                    if (!LOGGER.isDebugEnabled() || !this.isShowPriority(pmEvaluator)) continue;
                    LOGGER.debug("not matched: {}", (Object)pmEvaluator.getLHSPriority());
                }
            }
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.error("RulesData.evalDownRule() failed", (Throwable)cnse);
        }
        finally {
            engine.setEvalRHSMode(evalRHSMode);
        }
        return F.NIL;
    }

    private boolean isShowSteps(IPatternMatcher pmEvaluator) {
        IExpr head = pmEvaluator.getLHS().head();
        if (head.isSymbol() && ((ISymbol)head).isContext(Context.RUBI)) {
            return true;
        }
        return head.equals(S.Integrate);
    }

    private boolean isShowPriority(IPatternMatcher pmEvaluator) {
        IExpr head = pmEvaluator.getLHS().head();
        return head.equals(S.Integrate);
    }

    public IExpr evalUpRule(IExpr expression, EvalEngine engine) {
        PatternMatcherEquals res;
        if (this.fEqualUpRules != null && (res = this.fEqualUpRules.get(expression)) != null) {
            return res.getRHS();
        }
        try {
            if (this.fSimplePatternUpRules != null && expression.isASTOrAssociation()) {
                for (int i = 0; i < this.fSimplePatternUpRules.size(); ++i) {
                    IPatternMatcher pmEvaluator = (IPatternMatcher)this.fSimplePatternUpRules.get(i).clone();
                    IExpr result = pmEvaluator.eval(expression, engine);
                    if (!result.isPresent()) continue;
                    return result;
                }
            }
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.error("RulesData.evalUpRule() failed", (Throwable)cnse);
        }
        return F.NIL;
    }

    public final IExpr getDefaultValue(int pos) {
        if (this.fDefaultValues == null) {
            return null;
        }
        return this.fDefaultValues.get(pos);
    }

    public final Map<String, IStringX> getMessages() {
        if (this.fMessages == null) {
            this.fMessages = Config.TRIE_STRING2STRINGX_BUILDER.withMatch(TrieMatch.EXACT).build();
        }
        return this.fMessages;
    }

    public final Map<IExpr, PatternMatcherEquals> getEqualDownRules() {
        if (this.fEqualDownRules == null) {
            this.fEqualDownRules = new HashMap<IExpr, PatternMatcherEquals>();
        }
        return this.fEqualDownRules;
    }

    public final Map<IExpr, PatternMatcherEquals> getEqualUpRules() {
        if (this.fEqualUpRules == null) {
            this.fEqualUpRules = new HashMap<IExpr, PatternMatcherEquals>();
        }
        return this.fEqualUpRules;
    }

    private List<IPatternMatcher> getSimplePatternUpRules() {
        if (this.fSimplePatternUpRules == null) {
            this.fSimplePatternUpRules = new ArrayList<IPatternMatcher>();
        }
        return this.fSimplePatternUpRules;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fEqualDownRules == null ? 0 : this.fEqualDownRules.hashCode());
        result = 31 * result + (this.fEqualUpRules == null ? 0 : this.fEqualUpRules.hashCode());
        result = 31 * result + (this.fPatternDownRules == null ? 0 : this.fPatternDownRules.hashCode());
        result = 31 * result + (this.fSimplePatternUpRules == null ? 0 : this.fSimplePatternUpRules.hashCode());
        return result;
    }

    public final IPatternMatcher putDownRule(IExpr leftHandSide, IExpr rightHandSide) {
        return this.putDownRule(2, false, leftHandSide, rightHandSide, Integer.MAX_VALUE);
    }

    public final IPatternMatcher putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide) {
        return this.putDownRule(2, false, leftHandSide, rightHandSide, Integer.MAX_VALUE);
    }

    public final IPatternMatcher putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, int priority) {
        PatternMatcherAndEvaluator pmEvaluator;
        if (equalRule || leftHandSide.isSymbol()) {
            this.fEqualDownRules = this.getEqualDownRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualDownRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        int patternHash = 0;
        if (!RulesData.isComplicatedPatternRule(leftHandSide) && !leftHandSide.isCondition()) {
            patternHash = ((IAST)leftHandSide).patternHashCode();
        }
        if ((pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, leftHandSide, rightHandSide, true, patternHash)).isRuleWithoutPatterns()) {
            this.fEqualDownRules = this.getEqualDownRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualDownRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        if (Integer.MAX_VALUE != priority) {
            pmEvaluator.setLHSPriority(priority);
        }
        return this.insertMatcher(pmEvaluator);
    }

    public final IPatternMatcher integrate(IExpr leftHandSide, IExpr rightHandSide, int priority) {
        int patternHash = 0;
        if (!RulesData.isComplicatedPatternRule(leftHandSide)) {
            patternHash = ((IAST)leftHandSide).patternHashCode();
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(2, leftHandSide, rightHandSide, false, patternHash);
        pmEvaluator.setLHSPriority(priority);
        if (this.fPatternDownRules == null) {
            this.fPatternDownRules = new ArrayList<IPatternMatcher>(7000);
            this.fPriorityDownRules = new IntArrayList(7000);
        }
        this.fPatternDownRules.add(pmEvaluator);
        this.fPriorityDownRules.add(priority);
        return pmEvaluator;
    }

    public final PatternMatcher insertMatcher(PatternMatcher newPatternMatcher) {
        if (this.fPatternDownRules == null) {
            this.fPatternDownRules = new ArrayList<IPatternMatcher>();
            this.fPriorityDownRules = new IntArrayList();
            this.fPatternDownRules.add(newPatternMatcher);
            this.fPriorityDownRules.add(newPatternMatcher.getLHSPriority());
            return newPatternMatcher;
        }
        int size = this.fPatternDownRules.size();
        int patternHash = newPatternMatcher.getPatternHash();
        int lhsPriority = newPatternMatcher.getLHSPriority();
        IPatternMap pmSlotValuesMap = null;
        IExpr pmRHS = null;
        IExpr pmSlotValuesLHS = null;
        for (int i = 0; i < size; ++i) {
            IPatternMatcher matcher;
            int priority = this.fPriorityDownRules.getInt(i);
            if (priority > lhsPriority) {
                this.fPatternDownRules.add(i, newPatternMatcher);
                this.fPriorityDownRules.add(i, lhsPriority);
                return newPatternMatcher;
            }
            if (priority != lhsPriority || !(matcher = this.fPatternDownRules.get(i)).isPatternHashAllowed(patternHash) || IPatternMatcher.EQUIVALENCE_COMPARATOR.compare(newPatternMatcher, matcher) != 0) continue;
            if (pmSlotValuesMap == null) {
                pmSlotValuesMap = newPatternMatcher.getPatternMap().copy();
                pmSlotValuesMap.initSlotValues();
                pmRHS = pmSlotValuesMap.substituteSymbols(newPatternMatcher.getRHS(), F.NIL);
                pmSlotValuesLHS = pmSlotValuesMap.substitutePatternOrSymbols(newPatternMatcher.getLHS(), true);
            }
            if (!RulesData.equivalentSlots(matcher, pmSlotValuesMap.size(), pmSlotValuesLHS, pmRHS)) continue;
            this.fPatternDownRules.set(i, newPatternMatcher);
            this.fPriorityDownRules.set(i, lhsPriority);
            return newPatternMatcher;
        }
        this.fPatternDownRules.add(newPatternMatcher);
        this.fPriorityDownRules.add(lhsPriority);
        return newPatternMatcher;
    }

    private static boolean equivalentSlots(IPatternMatcher matcher, int newNumberOfPatterns, IExpr newSlotValuesLHS, IExpr newSlotValuesRHS) {
        IPatternMap oldMap = matcher.getPatternMap();
        if (oldMap.size() != newNumberOfPatterns) {
            return false;
        }
        oldMap = oldMap.copy();
        oldMap.initSlotValues();
        IExpr oldSlotValuesLHS = oldMap.substitutePatternOrSymbols(matcher.getLHS(), true);
        if (oldSlotValuesLHS.equals(newSlotValuesLHS)) {
            IExpr rhs = matcher.getRHS();
            if (newSlotValuesRHS.isCondition() && rhs.isCondition()) {
                IExpr oldSlotValuesRHS = oldMap.substituteSymbols(rhs.second(), F.NIL);
                return newSlotValuesRHS.second().equals(oldSlotValuesRHS);
            }
            return !rhs.isCondition() && !newSlotValuesRHS.isCondition();
        }
        return false;
    }

    public void putfDefaultValues(IExpr expr) {
        this.putfDefaultValues(Integer.MIN_VALUE, expr);
    }

    public void putfDefaultValues(int pos, IExpr expr) {
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new OpenIntToIExprHashMap();
        }
        this.fDefaultValues.put(pos, expr);
    }

    public IPatternMatcher putUpRule(int setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide) {
        if (equalRule) {
            this.fEqualUpRules = this.getEqualUpRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualUpRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, (IExpr)leftHandSide, rightHandSide);
        if (pmEvaluator.isRuleWithoutPatterns()) {
            this.fEqualUpRules = this.getEqualUpRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualUpRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        this.fSimplePatternUpRules = this.getSimplePatternUpRules();
        return this.addSimplePatternUpRule(leftHandSide, pmEvaluator);
    }

    public boolean removeRule(int setSymbol, boolean equalRule, IExpr leftHandSide) {
        if (equalRule && this.fEqualDownRules != null) {
            return this.fEqualDownRules.remove(leftHandSide) != null;
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, leftHandSide, null);
        if (pmEvaluator.isRuleWithoutPatterns() && this.fEqualDownRules != null) {
            return this.fEqualDownRules.remove(leftHandSide) != null;
        }
        boolean evaled = false;
        if (this.fPatternDownRules != null) {
            int i = 0;
            while (i < this.fPatternDownRules.size()) {
                IPatternMatcher pm = this.fPatternDownRules.get(i);
                if (pm.equivalentLHS(pmEvaluator) == 0) {
                    this.fPatternDownRules.remove(i);
                    this.fPriorityDownRules.removeInt(i);
                    evaled = true;
                    continue;
                }
                ++i;
            }
        }
        return evaled;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        List<IAST> list = this.definition();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            buf.append(list.get(i).toString());
            if (i >= size - 1) continue;
            buf.append(",\n ");
        }
        return buf.toString();
    }
}

