/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;

public class PatternMatcherEquals
extends IPatternMatcher
implements Externalizable {
    private static final long serialVersionUID = 3566534441225675728L;
    protected IExpr fRightHandSide;
    private int fSetFlags;

    public PatternMatcherEquals() {
    }

    public PatternMatcherEquals(int setSymbol, IExpr leftHandSide, IExpr rightHandSide) {
        super(leftHandSide);
        this.fSetFlags = setSymbol;
        this.fRightHandSide = rightHandSide;
    }

    @Override
    public boolean test(IExpr lhsEvalExpr) {
        return this.fLhsPatternExpr.equals(lhsEvalExpr);
    }

    @Override
    public boolean test(IExpr lhsEvalExpr, EvalEngine engine) {
        return this.fLhsPatternExpr.equals(lhsEvalExpr);
    }

    @Override
    public IPatternMatcher clone() {
        return new PatternMatcherEquals(this.fSetFlags, this.fLhsPatternExpr, this.fRightHandSide);
    }

    @Override
    public IExpr eval(IExpr leftHandSide, EvalEngine engine) {
        if (this.test(leftHandSide)) {
            return this.fRightHandSide;
        }
        return F.NIL;
    }

    @Override
    public void getPatterns(List<IExpr> resultList, IExpr patternExpr) {
    }

    @Override
    public IExpr getRHS() {
        return IExpr.ofNullable(this.fRightHandSide);
    }

    public ISymbol getSetSymbol() {
        if (this.isFlagOn(2)) {
            return S.SetDelayed;
        }
        if (this.isFlagOn(1)) {
            return S.Set;
        }
        if (this.isFlagOn(32)) {
            return S.UpSetDelayed;
        }
        if (this.isFlagOn(16)) {
            return S.UpSet;
        }
        if (this.isFlagOn(8)) {
            return S.TagSetDelayed;
        }
        if (this.isFlagOn(4)) {
            return S.TagSet;
        }
        return null;
    }

    public final boolean isFlagOff(int flags) {
        return (this.fSetFlags & flags) == 0;
    }

    public final boolean isFlagOn(int flags) {
        return (this.fSetFlags & flags) == flags;
    }

    @Override
    public boolean isPatternHashAllowed(int patternHash) {
        return true;
    }

    @Override
    public boolean isRuleWithoutPatterns() {
        return true;
    }

    public void setRHS(IExpr rightHandSide) {
        this.fRightHandSide = rightHandSide;
    }

    @Override
    public int equivalentTo(IPatternMatcher o) {
        if (this.getLHSPriority() < o.getLHSPriority()) {
            return -1;
        }
        if (this.getLHSPriority() > o.getLHSPriority()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPatternHash() {
        return 0;
    }

    @Override
    public int getLHSPriority() {
        return 0;
    }

    public IAST getAsAST() {
        ISymbol setSymbol = this.getSetSymbol();
        IASTMutable temp = F.binaryAST2((IExpr)setSymbol, this.getLHS(), this.getRHS());
        if (this.isFlagOn(8192)) {
            return F.HoldPattern(temp);
        }
        if (this.isFlagOn(4096)) {
            return F.Literal(temp);
        }
        return temp;
    }

    public String toString() {
        return this.getAsAST().toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fSetFlags);
        objectOutput.writeObject(this.fLhsPatternExpr);
        objectOutput.writeObject(this.fRightHandSide);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fSetFlags = objectInput.readShort();
        this.fLhsPatternExpr = (IExpr)objectInput.readObject();
        this.fRightHandSide = (IExpr)objectInput.readObject();
    }

    @Override
    public int equivalentLHS(IPatternMatcher obj) {
        return this.equivalentTo(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fSetFlags;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PatternMatcherEquals) {
            if (!super.equals(obj)) {
                return false;
            }
            return this.fSetFlags == ((PatternMatcherEquals)obj).fSetFlags;
        }
        return false;
    }
}

