/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class PatternMatcherAndInvoker
extends PatternMatcher {
    private static final long serialVersionUID = -2448717771259975643L;
    private static final Logger LOGGER = LogManager.getLogger();
    private transient Method fMethod;
    private transient Type[] fTypes;
    private transient IFunctionEvaluator fInstance;

    @Override
    public Object clone() throws CloneNotSupportedException {
        PatternMatcherAndInvoker v = (PatternMatcherAndInvoker)super.clone();
        v.fMethod = this.fMethod;
        v.fTypes = this.fTypes;
        v.fInstance = this.fInstance;
        return v;
    }

    private PatternMatcherAndInvoker() {
        super(null);
    }

    public PatternMatcherAndInvoker(IExpr leftHandSide, IFunctionEvaluator instance, String methodName) {
        super(leftHandSide);
        this.fInstance = instance;
        this.initInvoker(instance, methodName);
    }

    public PatternMatcherAndInvoker(String leftHandSide, IFunctionEvaluator instance, String methodName) {
        IExpr lhs;
        this.fInstance = instance;
        ExprParser parser = new ExprParser(EvalEngine.get());
        this.fLhsPatternExpr = lhs = parser.parse(leftHandSide);
        int[] priority = new int[]{Integer.MAX_VALUE};
        this.determinePatterns(priority);
        this.fLHSPriority = priority[0];
        this.initInvoker(instance, methodName);
    }

    private void initInvoker(IFunctionEvaluator instance, String methodName) {
        Class<?> c = instance.getClass();
        Method[] declaredMethods = c.getDeclaredMethods();
        ArrayList<Method> namedMethods = new ArrayList<Method>();
        for (Method method : declaredMethods) {
            if (!method.getName().equals(methodName)) continue;
            namedMethods.add(method);
        }
        if (namedMethods.size() == 1) {
            this.fMethod = (Method)namedMethods.get(0);
            this.fTypes = this.fMethod.getGenericParameterTypes();
        }
    }

    @Override
    public IExpr eval(IExpr leftHandSide, EvalEngine engine) {
        if (this.isRuleWithoutPatterns() && this.fLhsPatternExpr.equals(leftHandSide)) {
            if (this.fTypes.length != 0) {
                return F.NIL;
            }
            IExpr result = F.NIL;
            try {
                result = (IExpr)this.fMethod.invoke((Object)this.fInstance, new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | ValidateException e) {
                LOGGER.debug("PatternMatcherAndInvoker.eval() failed", (Throwable)e);
            }
            return result != null ? result : F.NIL;
        }
        IPatternMap patternMap = this.createPatternMap();
        if (this.fTypes.length != patternMap.size()) {
            return F.NIL;
        }
        patternMap.initPattern();
        if (this.matchExpr(this.fLhsPatternExpr, leftHandSide, engine)) {
            List<IExpr> args = patternMap.getValuesAsList();
            try {
                if (args != null) {
                    IExpr result = (IExpr)this.fMethod.invoke((Object)this.fInstance, args.toArray());
                    return result != null ? result : F.NIL;
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                LOGGER.debug("PatternMatcherAndInvoker.eval() failed", (Throwable)e);
            }
        }
        return F.NIL;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcherAndInvoker) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 47;
    }
}

