/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IEvalStepListener;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.RulesData;

public class PatternMatcherAndEvaluator
extends PatternMatcher
implements Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 2241135467123931061L;
    protected IExpr fRightHandSide;
    protected transient IExpr fReturnResult = F.NIL;

    public PatternMatcherAndEvaluator() {
    }

    public PatternMatcherAndEvaluator(IExpr leftHandSide, IExpr rightHandSide) {
        this(2, leftHandSide, rightHandSide);
    }

    public PatternMatcherAndEvaluator(int setSymbol, IExpr leftHandSide, IExpr rightHandSide) {
        this(setSymbol, leftHandSide, rightHandSide, true, 0);
    }

    public PatternMatcherAndEvaluator(int setSymbol, IExpr leftHandSide, IExpr rightHandSide, boolean initAll, int patternHash) {
        super(setSymbol, leftHandSide, initAll);
        this.fRightHandSide = rightHandSide;
        this.fPatterHash = patternHash;
    }

    @Override
    public boolean isPatternHashAllowed(int patternHash) {
        return this.fPatterHash == 0 || this.fPatterHash == patternHash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PatternMatcherAndEvaluator v = (PatternMatcherAndEvaluator)super.clone();
        v.fRightHandSide = this.fRightHandSide;
        v.fReturnResult = F.NIL;
        return v;
    }

    private static int equivalentRHS(IExpr patternExpr1, IExpr patternExpr2, IPatternMap pm1, IPatternMap pm2) {
        if (patternExpr1.isCondition()) {
            IExpr p1 = patternExpr1.second();
            if (patternExpr2.isCondition()) {
                IExpr p2 = patternExpr2.second();
                if (PatternMatcherAndEvaluator.equivalent(p1, p2, pm1, pm2)) {
                    return 0;
                }
                return p1.compareTo(p2);
            }
            if (patternExpr2.isModuleOrWithCondition()) {
                IExpr p2 = patternExpr2.last().second();
                if (PatternMatcherAndEvaluator.equivalent(p1, p2, pm1, pm2)) {
                    return 0;
                }
                return p1.compareTo(p2);
            }
        } else if (patternExpr1.isModuleOrWithCondition()) {
            IExpr p1 = patternExpr1.last().second();
            if (patternExpr2.isCondition()) {
                IExpr p2 = patternExpr2.second();
                if (PatternMatcherAndEvaluator.equivalent(p1, p2, pm1, pm2)) {
                    return 0;
                }
                return p1.compareTo(p2);
            }
            if (patternExpr2.isModuleOrWithCondition()) {
                IExpr p2 = patternExpr2.last().second();
                if (PatternMatcherAndEvaluator.equivalent(p1, p2, pm1, pm2)) {
                    return 0;
                }
                return p1.compareTo(p2);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRHSCondition(EvalEngine engine) {
        IPatternMap patternMap = this.createPatternMap();
        if (patternMap.getRHSEvaluated()) {
            return true;
        }
        if (!this.fRightHandSide.isCondition() && !this.fRightHandSide.isModuleOrWithCondition()) {
            return true;
        }
        if (!patternMap.isAllPatternsAssigned()) {
            return true;
        }
        boolean matched = false;
        IExpr rhs = patternMap.substituteSymbols(this.fRightHandSide, F.CEmptySequence);
        engine.pushOptionsStack();
        IEvalStepListener stepListener = engine.getStepListener();
        try {
            engine.setOptionsPattern(this.fLhsPatternExpr.topHead(), patternMap);
            if (Config.TRACE_REWRITE_RULE && stepListener != null) {
                IExpr lhs = this.getLHSExprToMatch();
                if (lhs.isPresent()) {
                    stepListener.setUp(lhs, 0);
                    this.fReturnResult = engine.addEvaluatedTraceStep(lhs, rhs, lhs.topHead(), F.$str("RewriteRule"));
                } else {
                    this.fReturnResult = engine.evaluate(rhs);
                }
            } else {
                this.fReturnResult = engine.evaluate(rhs);
            }
            matched = true;
        }
        catch (ConditionException e) {
            matched = false;
        }
        catch (ReturnException e) {
            this.fReturnResult = e.getValue();
            matched = true;
        }
        finally {
            engine.popOptionsStack();
        }
        if (Config.TRACE_REWRITE_RULE && stepListener != null) {
            stepListener.tearDown(0, matched);
        }
        patternMap.setRHSEvaluated(matched);
        return matched;
    }

    @Override
    public IExpr eval(IExpr leftHandSide, EvalEngine engine) {
        return this.replace(leftHandSide, engine, true);
    }

    public IExpr replace(IExpr leftHandSide, EvalEngine engine, boolean evaluate) {
        IPatternMap patternMap = null;
        if (this.isRuleWithoutPatterns()) {
            if (this.fLhsPatternExpr.equals(leftHandSide)) {
                return this.replaceEqualMatch(leftHandSide, engine, evaluate);
            }
            if (!(this.fLhsPatternExpr.isOrderlessAST() && leftHandSide.isOrderlessAST() || this.fLhsPatternExpr.isFlatAST() && leftHandSide.isFlatAST())) {
                return F.NIL;
            }
            if (this.fLhsPatternExpr.size() == leftHandSide.size()) {
                return F.NIL;
            }
        } else {
            patternMap = this.createPatternMap();
            patternMap.initPattern();
            this.setLHSExprToMatch(leftHandSide);
            if (this.matchExpr(this.fLhsPatternExpr, leftHandSide, engine, new PatternMatcher.StackMatcher(engine))) {
                return this.replacePatternMatch(leftHandSide, patternMap, engine, evaluate);
            }
        }
        if (this.fLhsPatternExpr.isASTOrAssociation() && leftHandSide.isASTOrAssociation()) {
            return this.replaceSubExpressionOrderlessFlat((IAST)this.fLhsPatternExpr, (IAST)leftHandSide, this.fRightHandSide, engine);
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpr replacePatternMatch(IExpr leftHandSide, IPatternMap patternMap, EvalEngine engine, boolean evaluate) {
        if (RulesData.showSteps && this.fLhsPatternExpr.head().equals(S.Integrate)) {
            IExpr rhs = this.fRightHandSide.orElse(S.Null);
            LOGGER.info("COMPLEX: {} := {}", (Object)this.fLhsPatternExpr, (Object)rhs);
            LOGGER.info(">>>>> {}", (Object)this);
        }
        if (this.fReturnResult.isPresent()) {
            return this.fReturnResult;
        }
        engine.pushOptionsStack();
        try {
            engine.setOptionsPattern(this.fLhsPatternExpr.topHead(), patternMap);
            IExpr result = patternMap.substituteSymbols(this.fRightHandSide, F.CEmptySequence);
            if (evaluate) {
                if (Config.TRACE_REWRITE_RULE) {
                    IExpr iExpr = engine.addEvaluatedTraceStep(leftHandSide, result, leftHandSide.topHead(), F.$str("RewriteRule"));
                    return iExpr;
                }
                IExpr iExpr = engine.evaluate(result);
                return iExpr;
            }
            IExpr iExpr = result;
            return iExpr;
        }
        catch (ConditionException e) {
            if (LOGGER.isDebugEnabled()) {
                this.logConditionFalse(leftHandSide, this.fLhsPatternExpr, this.fRightHandSide);
            }
            IAssociation iAssociation = F.NIL;
            return iAssociation;
        }
        catch (ReturnException e) {
            IExpr result = e.getValue();
            if (evaluate) {
                if (Config.TRACE_REWRITE_RULE) {
                    IExpr iExpr = engine.addEvaluatedTraceStep(leftHandSide, result, leftHandSide.topHead(), F.$str("RewriteRule"));
                    return iExpr;
                }
                IExpr iExpr = engine.evaluate(result);
                return iExpr;
            }
            IExpr iExpr = result;
            return iExpr;
        }
        finally {
            engine.popOptionsStack();
        }
    }

    private IExpr replaceEqualMatch(IExpr leftHandSide, EvalEngine engine, boolean evaluate) {
        IExpr result = this.fRightHandSide;
        try {
            if (evaluate) {
                if (Config.TRACE_REWRITE_RULE) {
                    return engine.addEvaluatedTraceStep(leftHandSide, result, leftHandSide.topHead(), F.$str("RewriteRule"));
                }
                return engine.evaluate(result);
            }
            return result;
        }
        catch (ConditionException e) {
            if (LOGGER.isDebugEnabled()) {
                this.logConditionFalse(leftHandSide, this.fLhsPatternExpr, this.fRightHandSide);
            }
            return F.NIL;
        }
        catch (ReturnException e) {
            result = e.getValue();
            if (Config.TRACE_REWRITE_RULE) {
                return engine.addEvaluatedTraceStep(leftHandSide, result, leftHandSide.topHead(), F.$str("RewriteRule"));
            }
            return engine.evaluate(result);
        }
    }

    @Override
    public IExpr getRHS() {
        return IExpr.ofNullable(this.fRightHandSide);
    }

    public IAST getAsAST() {
        ISymbol setSymbol = this.getSetSymbol();
        IASTMutable temp = F.binaryAST2((IExpr)setSymbol, this.getLHS(), this.getRHS());
        if (this.isFlagOn(8192)) {
            return F.HoldPattern(temp);
        }
        if (this.isFlagOn(4096)) {
            return F.Literal(temp);
        }
        return temp;
    }

    public ISymbol getSetSymbol() {
        if (this.isFlagOn(2)) {
            return S.SetDelayed;
        }
        if (this.isFlagOn(1)) {
            return S.Set;
        }
        if (this.isFlagOn(32)) {
            return S.UpSetDelayed;
        }
        if (this.isFlagOn(16)) {
            return S.UpSet;
        }
        if (this.isFlagOn(8)) {
            return S.TagSetDelayed;
        }
        if (this.isFlagOn(4)) {
            return S.TagSet;
        }
        return null;
    }

    public String toString() {
        if (this.fPatternMap == null) {
            return this.getAsAST().toString();
        }
        return this.fPatternMap.toString() + "\n" + this.getAsAST().toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort((short)this.fSetFlags);
        objectOutput.writeObject(this.fLhsPatternExpr);
        objectOutput.writeObject(this.fRightHandSide);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fSetFlags = objectInput.readShort();
        this.fLhsPatternExpr = (IExpr)objectInput.readObject();
        this.fRightHandSide = (IExpr)objectInput.readObject();
        if (this.fLhsPatternExpr != null) {
            int[] priority = new int[]{Integer.MAX_VALUE};
            this.fPatternMap = IPatternMap.determinePatterns(this.fLhsPatternExpr, priority, null);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fRightHandSide == null ? 0 : this.fRightHandSide.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternMatcherAndEvaluator other = (PatternMatcherAndEvaluator)obj;
        return !(this.fRightHandSide == null ? other.fRightHandSide != null : !this.fRightHandSide.equals(other.fRightHandSide));
    }
}

