/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.combinatoric.MultisetPartitionsIterator;
import org.matheclipse.core.combinatoric.NumberPartitionsIterator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ResultException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.PatternNested;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.FlatOrderlessStepVisitor;
import org.matheclipse.core.patternmatching.FlatStepVisitor;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.OrderlessStepVisitor;

public class PatternMatcher
extends IPatternMatcher
implements Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IASTAppendable[] UNEVALED = new IASTAppendable[0];
    private static final long serialVersionUID = -6708462090303928690L;
    protected transient int fLHSPriority;
    protected transient int fPatterHash = 0;
    protected transient IPatternMap fPatternMap;
    protected transient boolean fThrowIfTrue;
    protected int fSetFlags;

    public static boolean equivalent(IExpr patternExpr1, IExpr patternExpr2, IPatternMap pm1, IPatternMap pm2) {
        if (!patternExpr1.isPatternExpr()) {
            if (!patternExpr2.isPatternExpr()) {
                return patternExpr1.equals(patternExpr2);
            }
            return false;
        }
        if (patternExpr1.isASTOrAssociation()) {
            if (patternExpr2.isASTOrAssociation()) {
                IAST l1 = (IAST)patternExpr1;
                IAST l2 = (IAST)patternExpr2;
                if (l1.size() != l2.size()) {
                    return false;
                }
                return l1.forAll((temp1, i) -> {
                    IExpr temp2 = l2.get(i);
                    if (temp1 == temp2) {
                        return true;
                    }
                    if (temp1.hashCode() != temp2.hashCode()) {
                        if (temp1.isPatternExpr() && temp2.isPatternExpr()) {
                            return PatternMatcher.equivalent(temp1, temp2, pm1, pm2);
                        }
                        return false;
                    }
                    if (!(temp1.isPatternExpr() && temp2.isPatternExpr() || temp1.equals(temp2))) {
                        return false;
                    }
                    return PatternMatcher.equivalent(temp1, temp2, pm1, pm2);
                }, 0);
            }
            return false;
        }
        if (patternExpr1 instanceof IPatternObject) {
            if (patternExpr2 instanceof IPatternObject) {
                return ((IPatternObject)patternExpr1).equivalent((IPatternObject)patternExpr2, pm1, pm2);
            }
            return false;
        }
        return patternExpr1.equals(patternExpr2);
    }

    private static IAST[] removeFlat(IAST lhsPattern, IAST lhsEval) {
        IExpr temp;
        IExpr temp2;
        IASTAppendable lhsPatternAST = lhsPattern.copyAppendable();
        IASTAppendable lhsEvalAST = lhsEval.copyAppendable();
        int iIndex = 1;
        while (iIndex < lhsPatternAST.size() && !((temp2 = lhsPatternAST.get(iIndex)) instanceof IPatternObject) && temp2.isFreeOfPatterns()) {
            if (iIndex < lhsEvalAST.size() && lhsEvalAST.get(iIndex).equals(temp2)) {
                lhsPatternAST.remove(iIndex);
                lhsEvalAST.remove(iIndex);
                continue;
            }
            return null;
        }
        iIndex = lhsPatternAST.size() - 1;
        int jIndex = lhsEvalAST.size() - 1;
        while (iIndex > 0 && !((temp = lhsPatternAST.get(iIndex)) instanceof IPatternObject) && temp.isFreeOfPatterns()) {
            if (jIndex < lhsEvalAST.size() && lhsEvalAST.get(jIndex).equals(temp)) {
                lhsPatternAST.remove(iIndex--);
                lhsEvalAST.remove(jIndex--);
                continue;
            }
            return null;
        }
        return new IASTAppendable[]{lhsPatternAST, lhsEvalAST};
    }

    private static IAST[] removeOrderless(IAST lhsPattern, IAST lhsEval) {
        int iIndex;
        int jIndex = -1;
        for (iIndex = 1; iIndex < lhsPattern.size(); ++iIndex) {
            IExpr temp = lhsPattern.get(iIndex);
            if (temp instanceof IPatternObject || !temp.isFreeOfPatterns()) continue;
            jIndex = lhsEval.indexOf(temp);
            if (jIndex > 0) break;
            return null;
        }
        if (jIndex > 0) {
            IASTAppendable lhsPatternAST = lhsPattern.copyAppendable();
            IASTAppendable lhsEvalAST = lhsEval.copyAppendable();
            lhsPatternAST.remove(iIndex);
            lhsEvalAST.remove(jIndex);
            while (iIndex < lhsPatternAST.size()) {
                IExpr temp = lhsPatternAST.get(iIndex);
                if (!(temp instanceof IPatternObject) && temp.isFreeOfPatterns()) {
                    int indx = lhsEvalAST.indexOf(temp);
                    if (indx > 0) {
                        lhsPatternAST.remove(iIndex);
                        lhsEvalAST.remove(indx);
                        continue;
                    }
                    return null;
                }
                ++iIndex;
            }
            return new IAST[]{lhsPatternAST, lhsEvalAST};
        }
        return new IAST[]{lhsPattern, lhsEval};
    }

    public final boolean isFlagOff(int flags) {
        return (this.fSetFlags & flags) == 0;
    }

    public final boolean isFlagOn(int flags) {
        return (this.fSetFlags & flags) == flags;
    }

    public final void addFlags(int i) {
        this.fSetFlags |= i;
    }

    public int getFlags() {
        return this.fSetFlags;
    }

    public void setFlags(int i) {
        this.fSetFlags = i;
    }

    public PatternMatcher() {
        super(null);
        this.fSetFlags = 0;
        this.fLHSPriority = Integer.MAX_VALUE;
        this.fThrowIfTrue = false;
        this.fLhsPatternExpr = null;
        this.fPatternMap = null;
    }

    public PatternMatcher(IExpr patternExpr) {
        this(0, patternExpr, true);
    }

    public PatternMatcher(int setSymbol, IExpr patternExpr, boolean initAll) {
        super(patternExpr);
        this.fSetFlags = setSymbol;
        this.fLHSPriority = Integer.MAX_VALUE;
        this.fThrowIfTrue = false;
        if (initAll) {
            int[] priority = new int[]{Integer.MAX_VALUE};
            this.fPatternMap = this.determinePatterns(priority);
            this.fLHSPriority = priority[0];
            if (this.fLhsPatternExpr.isEvalFlagOn(2)) {
                this.fLHSPriority = Integer.MAX_VALUE;
            }
            if (patternExpr.isCondition()) {
                this.fLHSPriority -= 100;
            }
        }
    }

    public boolean checkRHSCondition(EvalEngine engine) {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PatternMatcher v = (PatternMatcher)super.clone();
        IPatternMap patternMap = this.createPatternMap();
        v.fPatternMap = patternMap.copy();
        v.fLHSPriority = this.fLHSPriority;
        v.fSetFlags = this.fSetFlags;
        return v;
    }

    public IPatternMap createPatternMap() {
        if (this.fPatternMap == null) {
            int[] priority = new int[]{Integer.MAX_VALUE};
            this.fPatternMap = IPatternMap.determinePatterns(this.fLhsPatternExpr, priority, null);
        }
        return this.fPatternMap;
    }

    public IPatternMap determinePatterns(int[] priority) {
        return IPatternMap.determinePatterns(this.fLhsPatternExpr, priority, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.fSetFlags == ((PatternMatcher)obj).fSetFlags;
    }

    int equivalent(IPatternMatcher obj) {
        if (this == obj) {
            return 0;
        }
        if (obj instanceof PatternMatcher) {
            return this.equivalentLHS(obj);
        }
        return this.fLhsPatternExpr.compareTo(obj.fLhsPatternExpr);
    }

    @Override
    public int equivalentLHS(IPatternMatcher obj) {
        PatternMatcher pm = (PatternMatcher)obj;
        if (this.fPatternMap.size() != pm.fPatternMap.size()) {
            return this.fPatternMap.size() < pm.fPatternMap.size() ? -1 : 1;
        }
        if (this.isRuleWithoutPatterns()) {
            return this.fLhsPatternExpr.compareTo(pm.fLhsPatternExpr);
        }
        if (PatternMatcher.equivalent(this.fLhsPatternExpr, pm.fLhsPatternExpr, this.fPatternMap, pm.fPatternMap)) {
            return 0;
        }
        return this.fLhsPatternExpr.compareTo(obj.fLhsPatternExpr);
    }

    @Override
    public int equivalentTo(IPatternMatcher patternMatcher) {
        if (this.fLHSPriority < patternMatcher.getLHSPriority()) {
            return -1;
        }
        if (this.fLHSPriority > patternMatcher.getLHSPriority()) {
            return 1;
        }
        return this.equivalent(patternMatcher);
    }

    @Override
    public IExpr eval(IExpr leftHandSide, EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public int getLHSPriority() {
        return this.fLHSPriority;
    }

    @Override
    public int getPatternHash() {
        return this.fPatterHash;
    }

    @Override
    public IPatternMap getPatternMap() {
        return this.fPatternMap;
    }

    @Override
    public void getPatterns(List<IExpr> resultList, IExpr pExpr) {
        if (pExpr.isASTOrAssociation()) {
            ((IAST)pExpr).forEach(x -> this.getPatterns(resultList, (IExpr)x), 0);
        } else if (pExpr.isPattern()) {
            resultList.add(this.fPatternMap.getValue((IPattern)pExpr));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fSetFlags;
        return result;
    }

    @Override
    public boolean isPatternHashAllowed(int patternHash) {
        return true;
    }

    @Override
    public final boolean isRuleWithoutPatterns() {
        return this.createPatternMap().isRuleWithoutPatterns();
    }

    public boolean isThrowIfTrue() {
        return this.fThrowIfTrue;
    }

    protected void logConditionFalse(IExpr lhsEvalAST, IExpr lhsPatternAST, IExpr rhsAST) {
    }

    protected boolean matchAST(IAST lhsPatternAST, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        if (lhsEvalExpr instanceof IAST) {
            if (lhsPatternAST.isFreeOfPatterns() && lhsPatternAST.equals(lhsEvalExpr)) {
                return stackMatcher.matchRest();
            }
            IAST lhsEvalAST = (IAST)lhsEvalExpr;
            ISymbol sym = lhsPatternAST.topHead();
            if (lhsPatternAST.size() <= lhsEvalAST.size()) {
                IAST[] removed;
                IExpr temp;
                if (lhsPatternAST.isOrderlessAST()) {
                    temp = this.fPatternMap.substituteASTPatternOrSymbols(lhsPatternAST, false).orElse(lhsPatternAST);
                    if (temp.isAST(lhsPatternAST.head())) {
                        lhsPatternAST = (IAST)temp;
                        removed = PatternMatcher.removeOrderless(lhsPatternAST, lhsEvalAST);
                        if (removed == null) {
                            return false;
                        }
                        lhsPatternAST = removed[0];
                        lhsEvalAST = removed[1];
                    }
                } else if (lhsPatternAST.isFlatAST() && (temp = this.fPatternMap.substituteASTPatternOrSymbols(lhsPatternAST, false).orElse(lhsPatternAST)).isAST(lhsPatternAST.head())) {
                    removed = PatternMatcher.removeFlat((IAST)temp, lhsEvalAST);
                    if (removed == null) {
                        return false;
                    }
                    lhsPatternAST = removed[0];
                    lhsEvalAST = removed[1];
                }
                if (lhsPatternAST.isFlatAST() && sym.equals(lhsEvalAST.topHead()) && (!lhsPatternAST.isOrderlessAST() || lhsPatternAST.size() != lhsEvalAST.size())) {
                    if (!this.matchHeads(lhsPatternAST, lhsEvalAST, engine)) {
                        return false;
                    }
                    if (lhsPatternAST.size() == 1 && lhsEvalAST.size() == 1) {
                        return stackMatcher.matchRest();
                    }
                    return this.matchFlatAndFlatOrderless(sym, lhsPatternAST, lhsEvalAST, engine, stackMatcher);
                }
            }
            int lhsEvalSize = lhsEvalAST.size();
            if (lhsPatternAST.isEvalFlagOn(2)) {
                if (!this.matchHeads(lhsPatternAST, lhsEvalAST, engine)) {
                    return false;
                }
                if (lhsPatternAST.isEmpty() && lhsEvalAST.isEmpty()) {
                    return stackMatcher.matchRest();
                }
                int lastPosition = lhsPatternAST.argSize();
                if (lastPosition == 1 && lhsPatternAST.get(lastPosition).isAST(S.PatternTest, 3)) {
                    IAST patternTest;
                    if (lhsPatternAST.size() <= lhsEvalSize && (patternTest = (IAST)lhsPatternAST.get(lastPosition)).arg1().isPatternSequence(false)) {
                        IASTAppendable seq = F.Sequence();
                        seq.appendAll(lhsEvalAST, lastPosition, lhsEvalSize);
                        if (((IPatternSequence)patternTest.arg1()).matchPatternSequence(seq, this.fPatternMap, lhsPatternAST.topHead())) {
                            if (this.matchAST(lhsPatternAST.removeFromEnd(lastPosition), lhsEvalAST.removeFromEnd(lastPosition), engine, stackMatcher)) {
                                return this.fPatternMap.isPatternTest(patternTest.arg1(), patternTest.arg2(), engine);
                            }
                            return false;
                        }
                    }
                } else {
                    if (lhsPatternAST.size() > 1 && lhsPatternAST.arg1().isPatternSequence(false)) {
                        IPatternSequence patternSequence = (IPatternSequence)lhsPatternAST.arg1();
                        return this.matchBlankSequence(patternSequence, lhsPatternAST, 1, lhsEvalAST, engine, stackMatcher);
                    }
                    if (lhsPatternAST.size() > 1 && lhsEvalSize > 1 && this.matchExpr(lhsPatternAST.arg1(), lhsEvalAST.arg1(), engine)) {
                        return this.matchAST(lhsPatternAST.rest().addEvalFlags(2), lhsEvalAST.rest(), engine, stackMatcher);
                    }
                }
                return false;
            }
            if (lhsPatternAST.size() != lhsEvalSize || !this.matchHeads(lhsPatternAST, lhsEvalAST, engine)) {
                return false;
            }
            if (lhsPatternAST.isOrderlessAST() && lhsPatternAST.size() > 2) {
                OrderlessStepVisitor visitor = new OrderlessStepVisitor(sym, lhsPatternAST, lhsEvalAST, stackMatcher, this.fPatternMap, sym.hasOneIdentityAttribute() || sym.hasFlatAttribute() || lhsPatternAST.size() == lhsEvalSize && !sym.hasFlatAttribute());
                MultisetPartitionsIterator iter = new MultisetPartitionsIterator(visitor, lhsPatternAST.argSize());
                return !iter.execute();
            }
            return this.matchASTSequence(lhsPatternAST, lhsEvalAST, 0, engine, stackMatcher);
        }
        return false;
    }

    private boolean matchHeads(IAST patternAST, IAST evaledAST, EvalEngine engine) {
        IExpr patternHead = patternAST.head();
        IExpr evaledHead = evaledAST.head();
        if (patternHead.isSymbol()) {
            return patternHead.equals(evaledHead);
        }
        return this.matchExpr(patternHead, evaledHead, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchASTExpr(IAST lhsPatternAST, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        try {
            matched = this.matchAST(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
            if (!matched) {
                this.fPatternMap.resetPattern(patternValues);
                if ((lhsPatternAST.getEvalFlags() & 4) == 4) {
                    if (lhsEvalExpr.isASTOrAssociation() && lhsPatternAST.hasOptionalArgument() && !lhsPatternAST.isOrderlessAST()) {
                        IExpr temp = this.matchOptionalArgumentsAST(lhsPatternAST.topHead(), lhsPatternAST, (IAST)lhsEvalExpr, engine);
                        if (temp.isPresent()) {
                            matched = this.matchExpr(temp, lhsEvalExpr, engine, stackMatcher);
                        }
                    } else {
                        IExpr temp = this.matchDefaultArgumentsAST(lhsPatternAST.topHead(), lhsPatternAST, engine);
                        if (temp.isPresent()) {
                            matched = this.matchExpr(temp, lhsEvalExpr, engine, stackMatcher);
                        }
                    }
                }
            }
        }
        finally {
            if (!matched) {
                this.fPatternMap.resetPattern(patternValues);
            }
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchASTSequence(IAST lhsPatternAST, IAST lhsEvalAST, int lhsEvalOffset, EvalEngine engine, StackMatcher stackMatcher) {
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        int lastStackSize = stackMatcher.size();
        boolean matched = false;
        try {
            if (lhsPatternAST.size() == lhsEvalAST.size()) {
                IAST[] removed = this.remove(lhsPatternAST, lhsEvalAST, engine, stackMatcher);
                if (removed == null) {
                    boolean bl = false;
                    return bl;
                }
                if (removed.length > 0) {
                    lhsPatternAST = removed[0];
                    lhsEvalAST = removed[1];
                    if (lhsPatternAST.size() == 2) {
                        matched = this.matchExpr(lhsPatternAST.arg1(), lhsEvalAST.arg1(), engine, stackMatcher);
                        if (!matched) {
                            boolean bl = false;
                            return bl;
                        }
                        boolean bl = matched = stackMatcher.matchRest();
                        return bl;
                    }
                    if (lhsPatternAST.isEmpty()) {
                        boolean bl = matched = stackMatcher.matchRest();
                        return bl;
                    }
                }
            }
            for (int i = 1; i < lhsPatternAST.size(); ++i) {
                if (stackMatcher.push(lhsPatternAST.get(i), lhsEvalAST.get(lhsEvalOffset + i))) continue;
                matched = false;
                boolean bl = false;
                return bl;
            }
            boolean bl = matched = stackMatcher.matchRest();
            return bl;
        }
        finally {
            if (!matched) {
                stackMatcher.removeFrom(lastStackSize);
                this.fPatternMap.resetPattern(patternValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchASTSpecialBuiltIn(IAST lhsPatternAST, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        block56: {
            block54: {
                boolean matched;
                int functionID;
                block55: {
                    functionID = lhsPatternAST.headID();
                    if (functionID < 107 || functionID > 1413) break block54;
                    matched = false;
                    if (lhsPatternAST.size() != 2) break block55;
                    switch (functionID) {
                        case 107: {
                            IExpr[] patternValues = this.fPatternMap.copyPattern();
                            try {
                                if (lhsEvalExpr.isAssociation()) {
                                    IAST lhsPatternAssociation = lhsPatternAST;
                                    IASTMutable lhsPatternList = (IASTMutable)lhsPatternAssociation.normal(false);
                                    lhsPatternList.set(0, S.Association);
                                    IAssociation lhsEvalAssociation = (IAssociation)lhsEvalExpr;
                                    IASTMutable lhsEvalList = lhsEvalAssociation.normal(false);
                                    lhsEvalList.set(0, S.Association);
                                    boolean bl = matched = this.matchExpr(lhsPatternList, lhsEvalList, engine, stackMatcher);
                                    return bl;
                                }
                                matched = this.matchASTExpr(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                            }
                            finally {
                                if (!matched) {
                                    this.fPatternMap.resetPattern(patternValues);
                                }
                            }
                            return matched;
                        }
                        case 438: {
                            IExpr[] patternValues = this.fPatternMap.copyPattern();
                            try {
                                matched = !this.matchExpr(lhsPatternAST.arg1(), lhsEvalExpr, engine, stackMatcher);
                            }
                            finally {
                                if (!matched) {
                                    this.fPatternMap.resetPattern(patternValues);
                                }
                            }
                            return matched;
                        }
                        case 604: 
                        case 797: {
                            IExpr[] patternValues = this.fPatternMap.copyPattern();
                            try {
                                matched = this.matchExpr(lhsPatternAST.arg1(), lhsEvalExpr, engine, stackMatcher);
                            }
                            finally {
                                if (!matched) {
                                    this.fPatternMap.resetPattern(patternValues);
                                }
                            }
                            return matched;
                        }
                        case 955: {
                            return this.matchOptional(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                        }
                        case 1413: {
                            return lhsPatternAST.arg1().equals(lhsEvalExpr);
                        }
                    }
                    break block56;
                }
                if (lhsPatternAST.size() != 3 || functionID < 257 || functionID > 1096) break block56;
                switch (functionID) {
                    case 257: {
                        IExpr[] patternValues = this.fPatternMap.copyPattern();
                        try {
                            if (lhsEvalExpr.isNumber()) {
                                INumber number = (INumber)lhsEvalExpr;
                                boolean lhsPatternList = matched = this.matchExpr(lhsPatternAST.arg1(), number.re(), engine, stackMatcher) && this.matchExpr(lhsPatternAST.arg2(), number.im(), engine, stackMatcher);
                                return lhsPatternList;
                            }
                            matched = this.matchASTExpr(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                        }
                        finally {
                            if (!matched) {
                                this.fPatternMap.resetPattern(patternValues);
                            }
                        }
                        return matched;
                    }
                    case 267: {
                        return this.matchCondition(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                    }
                    case 438: {
                        IExpr[] patternValues = this.fPatternMap.copyPattern();
                        try {
                            matched = !this.matchExpr(lhsPatternAST.arg1(), lhsEvalExpr, engine, stackMatcher) && this.matchExpr(lhsPatternAST.arg2(), lhsEvalExpr, engine, stackMatcher);
                        }
                        finally {
                            if (!matched) {
                                this.fPatternMap.resetPattern(patternValues);
                            }
                        }
                        return matched;
                    }
                    case 955: {
                        return this.matchOptional(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                    }
                    case 986: {
                        IExpr[] patternValues = this.fPatternMap.copyPattern();
                        try {
                            IExpr lhsPatternExpr = lhsPatternAST.arg1();
                            IExpr patternTest = lhsPatternAST.arg2();
                            if (lhsPatternExpr instanceof IPatternObject && patternTest.isFreeOfPatterns()) {
                                if (this.matchPattern((IPatternObject)lhsPatternExpr, lhsEvalExpr, engine, stackMatcher) && this.fPatternMap.isPatternTest(lhsPatternExpr, patternTest, engine)) {
                                    matched = stackMatcher.matchRest();
                                }
                            } else if (this.matchExpr(lhsPatternExpr, lhsEvalExpr, engine, stackMatcher)) {
                                matched = this.fPatternMap.isPatternTest(lhsPatternExpr, patternTest, engine);
                            }
                        }
                        finally {
                            if (!matched) {
                                this.fPatternMap.resetPattern(patternValues);
                            }
                        }
                        return matched;
                    }
                    case 1096: {
                        IExpr[] patternValues = this.fPatternMap.copyPattern();
                        try {
                            if (lhsEvalExpr.isFraction()) {
                                IFraction rational = (IFraction)lhsEvalExpr;
                                boolean bl = matched = this.matchExpr(lhsPatternAST.arg1(), rational.numerator(), engine, stackMatcher) && this.matchExpr(lhsPatternAST.arg2(), rational.denominator(), engine, stackMatcher);
                                return bl;
                            }
                            boolean bl = matched = this.matchASTExpr(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
                            return bl;
                        }
                        finally {
                            if (!matched) {
                                this.fPatternMap.resetPattern(patternValues);
                            }
                        }
                    }
                }
                break block56;
            }
            if (lhsPatternAST.isAlternatives()) {
                return this.matchAlternatives(lhsPatternAST, lhsEvalExpr, engine);
            }
        }
        return this.matchASTExpr(lhsPatternAST, lhsEvalExpr, engine, stackMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchAlternatives(IAST lhsPatternAlternatives, IExpr lhsEvalExpr, EvalEngine engine) {
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        try {
            boolean bl = matched = lhsPatternAlternatives.exists(x -> this.matchExpr((IExpr)x, lhsEvalExpr, engine));
            return bl;
        }
        finally {
            if (!matched) {
                this.fPatternMap.resetPattern(patternValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchCondition(IAST lhsPatternCondition, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        try {
            stackMatcher.push(new Entry(lhsPatternCondition.second()));
            boolean bl = matched = this.matchExpr(lhsPatternCondition.first(), lhsEvalExpr, engine, stackMatcher);
            return bl;
        }
        finally {
            if (!matched) {
                this.fPatternMap.resetPattern(patternValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchOptional(IAST lhsPatternOptional, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        try {
            matched = this.matchExpr(lhsPatternOptional.arg1(), lhsEvalExpr, engine, stackMatcher);
        }
        finally {
            if (!matched) {
                this.fPatternMap.resetPattern(patternValues);
            }
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchBlankSequence(IPatternSequence patternSequence, IAST lhsPatternAST, int position, IAST lhsEvalAST, EvalEngine engine, StackMatcher stackMatcher) {
        boolean isNullSequence = patternSequence.isNullSequence();
        if (position == lhsPatternAST.argSize()) {
            boolean matched = false;
            IExpr[] patternValues = this.fPatternMap.copyPattern();
            try {
                IASTAppendable seq = F.Sequence();
                seq.appendAll(lhsEvalAST, 1, lhsEvalAST.size());
                if (patternSequence.matchPatternSequence(seq, this.fPatternMap, lhsPatternAST.topHead()) && (matched = stackMatcher.matchRest())) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (!matched) {
                    this.fPatternMap.resetPattern(patternValues);
                }
            }
        }
        int lhsEvalIndex = 2;
        IAST reducedLHSPatternAST = lhsPatternAST.removeFromStart(position + 1).addEvalFlags(2);
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        int lhsEvalSize = lhsEvalAST.size();
        int startPosition = 1;
        if (isNullSequence) {
            startPosition = 1;
            lhsEvalIndex = 1;
        }
        while (lhsEvalIndex <= lhsEvalSize) {
            try {
                IASTAppendable seq = F.ast((IExpr)S.Sequence, lhsEvalIndex - startPosition);
                seq.appendAll(lhsEvalAST, startPosition, lhsEvalIndex);
                if (patternSequence.matchPatternSequence(seq, this.fPatternMap, lhsPatternAST.topHead()) && (matched = this.matchAST(reducedLHSPatternAST, lhsEvalAST.copyFrom(lhsEvalIndex), engine, stackMatcher))) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!matched) {
                    this.fPatternMap.resetPattern(patternValues);
                }
            }
            ++lhsEvalIndex;
        }
        return false;
    }

    private IExpr matchDefaultArgumentsAST(ISymbol symbolWithDefaultValue, IAST lhsPatternAST, EvalEngine engine) {
        IASTAppendable cloned = F.ast(lhsPatternAST.head(), lhsPatternAST.size());
        boolean[] defaultValueMatched = new boolean[]{false};
        if (lhsPatternAST.exists((temp, i) -> {
            if (temp.isPatternDefault()) {
                if (temp.isOptional()) {
                    IExpr optionalValue;
                    IAST optional = (IAST)temp;
                    IExpr iExpr = optionalValue = optional.isAST2() ? optional.arg2() : symbolWithDefaultValue.getDefaultValue();
                    if (optionalValue.isPresent()) {
                        if (!this.matchExpr(temp.first(), optionalValue, engine)) {
                            return true;
                        }
                        defaultValueMatched[0] = true;
                    }
                    return false;
                }
                IExpr positionDefaultValue = symbolWithDefaultValue.getDefaultValue(i);
                if (positionDefaultValue.isPresent()) {
                    if (!((IPatternObject)temp).matchPattern(positionDefaultValue, this.fPatternMap)) {
                        return true;
                    }
                    defaultValueMatched[0] = true;
                    return false;
                }
                IExpr commonDefaultValue = symbolWithDefaultValue.getDefaultValue();
                if (commonDefaultValue.isPresent()) {
                    if (!((IPatternObject)temp).matchPattern(commonDefaultValue, this.fPatternMap)) {
                        return true;
                    }
                    defaultValueMatched[0] = true;
                    return false;
                }
            }
            cloned.append((IExpr)temp);
            return false;
        })) {
            return F.NIL;
        }
        if (defaultValueMatched[0]) {
            if (cloned.isOneIdentityAST1()) {
                return cloned.arg1();
            }
            return cloned;
        }
        return F.NIL;
    }

    protected boolean matchExpr(IExpr lhsPatternExpr, IExpr lhsEvalExpr, EvalEngine engine) {
        return this.matchExpr(lhsPatternExpr, lhsEvalExpr, engine, new StackMatcher(engine));
    }

    protected boolean matchExpr(IExpr lhsPatternExpr, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        boolean matched = false;
        if (lhsPatternExpr.isASTOrAssociation()) {
            return this.matchASTSpecialBuiltIn((IAST)lhsPatternExpr, lhsEvalExpr, engine, stackMatcher);
        }
        matched = lhsPatternExpr instanceof IPatternObject ? this.matchPattern((IPatternObject)lhsPatternExpr, lhsEvalExpr, engine, stackMatcher) : lhsPatternExpr.equals(lhsEvalExpr);
        if (matched) {
            return stackMatcher.matchRest();
        }
        return false;
    }

    private boolean matchTrue(IExpr lhsPatternExpr, EvalEngine engine, StackMatcher stackMatcher) {
        IExpr lhsTest = this.fPatternMap.substituteSymbols(lhsPatternExpr, F.NIL);
        if (engine.evalTrue(lhsTest)) {
            return stackMatcher.matchRest();
        }
        return false;
    }

    private boolean matchFlatAndFlatOrderless(ISymbol sym, IAST lhsPattern, IAST lhsEval, EvalEngine engine, StackMatcher stackMatcher) {
        if (sym.hasOrderlessAttribute()) {
            return this.matchFlatOrderless(sym, lhsPattern, lhsEval, engine, stackMatcher);
        }
        return this.matchFlat(sym, lhsPattern, lhsEval, engine, stackMatcher);
    }

    private boolean matchFlat(ISymbol sym, IAST lhsPattern, IAST lhsEval, EvalEngine engine, StackMatcher stackMatcher) {
        if (lhsPattern.isAST1()) {
            int lhsEvalSize = lhsEval.size();
            if (lhsPattern.arg1().isPatternSequence(false)) {
                IASTAppendable seq = F.Sequence();
                seq.appendAll(lhsEval, 1, lhsEvalSize);
                if (((IPatternSequence)lhsPattern.arg1()).matchPatternSequence(seq, this.fPatternMap, lhsPattern.topHead())) {
                    return true;
                }
            }
            if (lhsPattern.size() == lhsEval.size()) {
                return this.matchASTSequence(lhsPattern, lhsEval, 0, engine, stackMatcher);
            }
            return false;
        }
        IAST lhsPatternAST = lhsPattern;
        IAST lhsEvalAST = lhsEval;
        FlatStepVisitor visitor = new FlatStepVisitor(sym, lhsPatternAST, lhsEvalAST, stackMatcher, this.fPatternMap);
        NumberPartitionsIterator iter = new NumberPartitionsIterator(visitor, lhsEvalAST.argSize(), lhsPatternAST.argSize());
        return !iter.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchFlatOrderless(ISymbol sym, IAST lhsPattern, IAST lhsEval, EvalEngine engine, StackMatcher stackMatcher) {
        if (lhsPattern.isAST1()) {
            return this.matchExpr(lhsPattern.arg1(), lhsEval, engine, stackMatcher);
        }
        IAST lhsPatternAST = lhsPattern;
        IAST lhsEvalAST = lhsEval;
        boolean matched = false;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        if (lhsPatternAST.size() <= 2) {
            try {
                if (lhsPatternAST.isAST1()) {
                    boolean bl = matched = this.matchExpr(lhsPatternAST.arg1(), lhsEvalAST, engine, stackMatcher);
                    return bl;
                }
                if (lhsPatternAST.isEmpty() && lhsEvalAST.size() > 1) {
                    boolean bl = matched = false;
                    return bl;
                }
                boolean bl = matched = stackMatcher.matchRest();
                return bl;
            }
            finally {
                if (!matched) {
                    this.fPatternMap.resetPattern(patternValues);
                }
            }
        }
        lhsPattern = lhsPatternAST;
        lhsEval = lhsEvalAST;
        IAST lhsPatternFinal = lhsPattern;
        IAST lhsEvalFinal = lhsEval;
        for (int i = 1; i < lhsPatternFinal.size(); ++i) {
            IExpr patternArg = lhsPatternFinal.get(i);
            if (patternArg instanceof IPatternObject) continue;
            int index = i;
            IAST reduced = lhsPatternFinal.splice(index);
            boolean evaled = false;
            for (int k = 1; k < lhsEvalFinal.size(); ++k) {
                try {
                    IExpr evalArg = lhsEvalFinal.get(k);
                    if (patternArg.head() instanceof IPatternObject || patternArg.isASTOrAssociation() && (((IAST)patternArg).getEvalFlags() & 4) == 4) continue;
                    if (patternArg.head().equals(evalArg.head()) && patternArg.isFree(x -> x.isOrderlessAST(), true)) {
                        evaled = true;
                        matched = this.matchExpr(patternArg, evalArg, engine, stackMatcher);
                    }
                    if (!matched || !(matched = this.matchFlatAndFlatOrderless(sym, reduced, lhsEvalFinal.removeAtCopy(k), engine, stackMatcher))) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (!matched) {
                        this.fPatternMap.resetPattern(patternValues);
                    }
                }
            }
            if (!evaled) continue;
            return false;
        }
        FlatOrderlessStepVisitor visitor = new FlatOrderlessStepVisitor(sym, lhsPatternFinal, lhsEvalFinal, stackMatcher, this.fPatternMap, sym.hasFlatAttribute());
        MultisetPartitionsIterator iter = new MultisetPartitionsIterator(visitor, lhsPattern.argSize());
        return !iter.execute();
    }

    private IExpr matchOptionalArgumentsAST(ISymbol symbolWithDefaultValue, IAST lhsPatternAST, IAST lhsEvalAST, EvalEngine engine) {
        int lhsSize = lhsEvalAST.size();
        IASTAppendable cloned = F.ast(lhsPatternAST.head(), lhsPatternAST.size());
        boolean defaultValueMatched = false;
        for (int i = 1; i < lhsPatternAST.size(); ++i) {
            IExpr temp = lhsPatternAST.get(i);
            if (temp.isPatternDefault()) {
                if (temp.isOptional()) {
                    IExpr optionalValue;
                    IAST optional = (IAST)temp;
                    if (i < lhsSize) {
                        cloned.append(optional.arg1());
                        continue;
                    }
                    IExpr iExpr = optionalValue = optional.isAST2() ? optional.arg2() : symbolWithDefaultValue.getDefaultValue();
                    if (optionalValue.isPresent()) {
                        if (!this.matchExpr(optional.arg1(), optionalValue, engine)) {
                            return F.NIL;
                        }
                        defaultValueMatched = true;
                        continue;
                    }
                } else {
                    IPattern pattern = (IPattern)temp;
                    IExpr positionDefaultValue = symbolWithDefaultValue.getDefaultValue(i);
                    if (positionDefaultValue.isPresent()) {
                        if (!((IPatternObject)temp).matchPattern(positionDefaultValue, this.fPatternMap)) {
                            return F.NIL;
                        }
                        defaultValueMatched = true;
                        continue;
                    }
                    if (i < lhsSize) {
                        cloned.append(pattern);
                        continue;
                    }
                    IExpr commonDefaultValue = symbolWithDefaultValue.getDefaultValue();
                    if (commonDefaultValue.isPresent()) {
                        if (!((IPatternObject)temp).matchPattern(commonDefaultValue, this.fPatternMap)) {
                            return F.NIL;
                        }
                        defaultValueMatched = true;
                        continue;
                    }
                }
            }
            cloned.append(temp);
        }
        if (defaultValueMatched) {
            if (cloned.isOneIdentityAST1()) {
                return cloned.arg1();
            }
            return cloned;
        }
        return F.NIL;
    }

    private boolean matchPattern(IPatternObject lhsPatternExpr, IExpr lhsEvalExpr, EvalEngine engine, StackMatcher stackMatcher) {
        if (lhsPatternExpr instanceof PatternNested) {
            PatternNested pattern2 = (PatternNested)lhsPatternExpr;
            IExpr patternExpr = pattern2.getPatternExpr();
            if (this.matchExpr(patternExpr, lhsEvalExpr, engine, stackMatcher)) {
                return pattern2.matchPattern(lhsEvalExpr, this.fPatternMap);
            }
            return false;
        }
        return lhsPatternExpr.matchPattern(lhsEvalExpr, this.fPatternMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fSetFlags = objectInput.readShort();
        this.fLhsPatternExpr = (IExpr)objectInput.readObject();
        if (this.fLhsPatternExpr != null) {
            int[] priority = new int[]{Integer.MAX_VALUE};
            this.fPatternMap = IPatternMap.determinePatterns(this.fLhsPatternExpr, priority, null);
            this.fLHSPriority = priority[0];
        }
    }

    private IAST[] remove(IAST lhsPattern, IAST lhsEval, EvalEngine engine, StackMatcher stackMatcher) {
        IASTAppendable lhsPatternAST = F.NIL;
        IASTAppendable lhsEvalAST = F.NIL;
        int i = 1;
        int iIndex = 1;
        boolean evaled = false;
        boolean matched = false;
        while (i < lhsPattern.size()) {
            IExpr lhs = lhsPattern.get(i);
            IExpr rhs = lhsEval.get(i);
            ++i;
            if (lhs instanceof IPatternObject) {
                if (lhs instanceof IPatternSequence) {
                    return UNEVALED;
                }
                IPatternObject pattern = (IPatternObject)lhs;
                if (pattern.getSymbol() != null && !pattern.isPatternOptional()) {
                    matched = this.matchPattern((IPatternObject)lhs, rhs, engine, stackMatcher);
                    if (matched) {
                        if (!evaled) {
                            lhsPatternAST = lhsPattern.copyAppendable();
                            lhsEvalAST = lhsEval.copyAppendable();
                        }
                        lhsPatternAST.remove(iIndex);
                        lhsEvalAST.remove(iIndex);
                        evaled = true;
                        continue;
                    }
                    return null;
                }
            } else if (lhs.isFreeOfPatterns()) {
                if (lhs.equals(rhs)) {
                    if (!evaled) {
                        lhsPatternAST = lhsPattern.copyAppendable();
                        lhsEvalAST = lhsEval.copyAppendable();
                    }
                    lhsPatternAST.remove(iIndex);
                    lhsEvalAST.remove(iIndex);
                    evaled = true;
                    continue;
                }
                return null;
            }
            ++iIndex;
        }
        if (!evaled) {
            return UNEVALED;
        }
        return new IAST[]{lhsPatternAST, lhsEvalAST};
    }

    protected IExpr replaceSubExpressionOrderlessFlat(IAST lhsPatternAST, IAST lhsEvalAST, IExpr rhsExpr, EvalEngine engine) {
        if (lhsPatternAST.size() < lhsEvalAST.size()) {
            if (lhsPatternAST.isOrderlessAST() && lhsPatternAST.isFlatAST()) {
                if (!this.matchHeads(lhsPatternAST, lhsEvalAST, engine)) {
                    return F.NIL;
                }
                OrderlessMatcher foMatcher = new OrderlessMatcher(lhsPatternAST, lhsEvalAST);
                boolean matched = foMatcher.matchOrderlessAST(1, new StackMatcher(engine), engine);
                if (matched) {
                    IASTAppendable lhsResultAST = lhsEvalAST.copyAppendable();
                    foMatcher.filterResult(lhsResultAST);
                    IExpr result = this.fPatternMap.substituteSymbols(rhsExpr, F.NIL);
                    try {
                        result = engine.evaluate(result);
                        lhsResultAST.append(result);
                        return lhsResultAST;
                    }
                    catch (ConditionException e) {
                        if (LOGGER.isDebugEnabled()) {
                            this.logConditionFalse(lhsEvalAST, lhsPatternAST, rhsExpr);
                        }
                    }
                    catch (ReturnException e) {
                        lhsResultAST.append(e.getValue());
                        return lhsResultAST;
                    }
                }
                return F.NIL;
            }
            if (lhsPatternAST.isFlatAST()) {
                if (!this.matchHeads(lhsPatternAST, lhsEvalAST, engine)) {
                    return F.NIL;
                }
                return this.matchFlatSequenceFromIndex(lhsPatternAST, lhsEvalAST, rhsExpr, engine);
            }
        }
        return F.NIL;
    }

    private IExpr matchFlatSequenceFromIndex(IAST lhsPatternFlatAST, IAST lhsEvalFlatAST, IExpr rhsExpr, EvalEngine engine) {
        int len = lhsEvalFlatAST.size() - lhsPatternFlatAST.size() + 1;
        for (int i = 0; i < len; ++i) {
            if (!this.matchASTSequence(lhsPatternFlatAST, lhsEvalFlatAST, i, engine, new StackMatcher(engine))) continue;
            IASTAppendable lhsResultAST = lhsEvalFlatAST.copyAppendable();
            for (int j = 1; j < lhsPatternFlatAST.size(); ++j) {
                lhsResultAST.remove(i + 1);
            }
            try {
                IExpr result = this.fPatternMap.substituteSymbols(rhsExpr, F.CEmptySequence);
                result = engine.evaluate(result);
                lhsResultAST.append(i + 1, result);
                return lhsResultAST;
            }
            catch (ConditionException e) {
                if (LOGGER.isDebugEnabled()) {
                    this.logConditionFalse(lhsEvalFlatAST, lhsPatternFlatAST, rhsExpr);
                }
            }
            catch (ReturnException e) {
                lhsResultAST.append(i + 1, e.getValue());
                return lhsResultAST;
            }
            return F.NIL;
        }
        return F.NIL;
    }

    public void setLHSPriority(int priority) {
        this.fLHSPriority = priority;
    }

    @Override
    public void throwExceptionArgIfMatched(boolean throwIfMatched) {
        this.fThrowIfTrue = throwIfMatched;
    }

    @Override
    public boolean test(IExpr leftHandSide) {
        return this.test(leftHandSide, EvalEngine.get());
    }

    @Override
    public boolean test(IExpr leftHandSide, EvalEngine engine) {
        boolean matched = false;
        if (this.isRuleWithoutPatterns()) {
            matched = this.fLhsPatternExpr.equals(leftHandSide);
        } else {
            this.fPatternMap.initPattern();
            matched = this.matchExpr(this.fLhsPatternExpr, leftHandSide, engine);
        }
        if (matched && this.fThrowIfTrue) {
            throw new ResultException(leftHandSide);
        }
        return matched;
    }

    @Override
    public boolean testBlank(IExpr leftHandSide, EvalEngine engine) {
        if (this.isRuleWithoutPatterns()) {
            return this.fLhsPatternExpr.equals(leftHandSide);
        }
        this.fPatternMap.initPatternBlank();
        return this.matchExpr(this.fLhsPatternExpr, leftHandSide, engine);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort((short)this.fSetFlags);
        objectOutput.writeObject(this.fLhsPatternExpr);
    }

    final class StackMatcher
    extends ArrayDeque<Entry> {
        private static final long serialVersionUID = 6051475896607762506L;
        final EvalEngine fEngine;

        public StackMatcher(EvalEngine engine) {
            this.fEngine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matchRest() {
            if (this.isEmpty()) {
                return PatternMatcher.this.checkRHSCondition(this.fEngine);
            }
            boolean matched = true;
            Entry entry = (Entry)this.pop();
            try {
                IExpr evalExpr = entry.fEvalExpr;
                matched = evalExpr.isPresent() ? PatternMatcher.this.matchExpr(entry.fPatternExpr, evalExpr, this.fEngine, this) : PatternMatcher.this.matchTrue(entry.fPatternExpr, this.fEngine, this);
                boolean bl = matched;
                return bl;
            }
            finally {
                if (!matched) {
                    this.push(entry);
                }
            }
        }

        public boolean push(IExpr patternExpr, IExpr evalExpr) {
            if (patternExpr == evalExpr) {
                return true;
            }
            if (patternExpr.isASTOrAssociation()) {
                if (!patternExpr.isFreeOfPatterns()) {
                    this.push(new Entry(patternExpr, evalExpr));
                    return true;
                }
            } else if (patternExpr instanceof IPatternObject) {
                return PatternMatcher.this.matchPattern((IPatternObject)patternExpr, evalExpr, this.fEngine, this);
            }
            return patternExpr.equals(evalExpr);
        }

        public void removeFrom(int fromPosition) {
            for (int len = this.size(); len > fromPosition; --len) {
                this.pop();
            }
        }
    }

    private final class OrderlessMatcher {
        private IAST fLHSPatternAST;
        private IAST fLHSEvalAST;
        private int[] fUsedIndex;

        public OrderlessMatcher(IAST lhsPatternAST, IAST lhsEvalAST) {
            this.fLHSPatternAST = lhsPatternAST;
            this.fLHSEvalAST = lhsEvalAST;
            this.fUsedIndex = new int[this.fLHSPatternAST.argSize()];
            for (int l = 0; l < this.fUsedIndex.length; ++l) {
                this.fUsedIndex[l] = -1;
            }
        }

        public void filterResult(IASTAppendable result) {
            for (int i = 0; i < this.fUsedIndex.length; ++i) {
                result.set(this.fUsedIndex[i], null);
            }
            int indx = 1;
            while (indx < result.size()) {
                if (result.get(indx) == null) {
                    result.remove(indx);
                    continue;
                }
                ++indx;
            }
        }

        public boolean matchOrderlessAST(int lhsPosition, StackMatcher stackMatcher, EvalEngine engine) {
            if (lhsPosition >= this.fLHSPatternAST.size()) {
                return stackMatcher.matchRest();
            }
            IExpr subPattern = this.fLHSPatternAST.get(lhsPosition);
            IExpr[] patternValues = PatternMatcher.this.fPatternMap.copyPattern();
            return this.fLHSEvalAST.exists((temp, j) -> {
                if (this.fLHSPatternAST.forAll((x, i) -> this.fUsedIndex[i - 1] != j)) {
                    boolean matched = false;
                    StackMatcher localStackMatcher = stackMatcher == null ? new StackMatcher(engine) : stackMatcher;
                    int lastStackSize = localStackMatcher.size();
                    try {
                        if (localStackMatcher.push(subPattern, (IExpr)temp)) {
                            this.fUsedIndex[lhsPosition - 1] = j;
                            if (this.matchOrderlessAST(lhsPosition + 1, localStackMatcher, engine)) {
                                matched = true;
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                    finally {
                        if (!matched) {
                            PatternMatcher.this.fPatternMap.resetPattern(patternValues);
                            this.fUsedIndex[lhsPosition - 1] = -1;
                        }
                        localStackMatcher.removeFrom(lastStackSize);
                    }
                }
                return false;
            });
        }
    }

    private static final class Entry {
        final IExpr fPatternExpr;
        final IExpr fEvalExpr;

        public Entry(IExpr patternExpr) {
            this.fPatternExpr = patternExpr;
            this.fEvalExpr = F.NIL;
        }

        public Entry(IExpr patternExpr, IExpr evalExpr) {
            this.fPatternExpr = patternExpr;
            this.fEvalExpr = evalExpr;
        }
    }
}

