/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.AbstractPatternMatcherMethod;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMethod;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.AbstractVisitor;

public class Matcher
implements Function<IExpr, IExpr> {
    private RulesData rules = new RulesData();

    @Override
    public IExpr apply(IExpr expression) {
        return this.rules.evalDownRule(expression, EvalEngine.get());
    }

    public void caseBoole(IExpr patternMatchingRule, BiPredicate<IExpr, IExpr> predicate) {
        this.rules.insertMatcher(new PatternMatcherBiPredicateMethod(patternMatchingRule, predicate));
    }

    public void caseBoole(IExpr patternMatchingRule, Predicate<IExpr> predicate) {
        this.rules.insertMatcher(new PatternMatcherPredicateMethod(patternMatchingRule, predicate));
    }

    public void caseMethod(IExpr patternMatchingRule, IPatternMethod method) {
        this.rules.insertMatcher(new PatternMatcherMapMethod(patternMatchingRule, method));
    }

    public void caseOf(IExpr patternMatchingRule, BiFunction<IExpr, IExpr, IExpr> function) {
        this.rules.insertMatcher(new PatternMatcherBiFunctionMethod(patternMatchingRule, function));
    }

    public void caseOf(IExpr patternMatchingRule, Function<IExpr, IExpr> function) {
        this.rules.insertMatcher(new PatternMatcherFunctionMethod(patternMatchingRule, function));
    }

    public void caseOf(IExpr patternMatchingRule, IExpr resultExpr) {
        if (patternMatchingRule.isPresent()) {
            this.rules.putDownRule(patternMatchingRule, resultExpr);
            return;
        }
        String str = IOFunctions.getMessage("nil", F.CEmptyList, EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public IExpr replaceAll(IExpr expression) {
        return this.replaceAll(expression, null);
    }

    public IExpr replaceAll(IExpr expression, Function<IAST, IExpr> function) {
        return expression.accept(new MatcherVisitor(this, function));
    }

    private static class PatternMatcherPredicateMethod
    extends AbstractPatternMatcherMethod {
        Predicate<IExpr> fRightHandSide;

        public PatternMatcherPredicateMethod(IExpr leftHandSide, Predicate<IExpr> rightHandSide) {
            super(leftHandSide);
            this.fRightHandSide = rightHandSide;
        }

        @Override
        IExpr evalMethod() {
            IPatternMap pm = this.createPatternMap();
            IExpr arg1 = pm.getValue(0);
            return this.fRightHandSide.test(arg1) ? S.True : S.False;
        }
    }

    private static class PatternMatcherMapMethod
    extends AbstractPatternMatcherMethod {
        final IPatternMethod fRightHandSide;

        public PatternMatcherMapMethod(IExpr leftHandSide, IPatternMethod rightHandSide) {
            super(leftHandSide);
            this.fRightHandSide = rightHandSide;
        }

        @Override
        IExpr evalMethod() {
            IPatternMap pm = this.createPatternMap();
            return this.fRightHandSide.eval(pm);
        }
    }

    private static class PatternMatcherFunctionMethod
    extends AbstractPatternMatcherMethod {
        Function<IExpr, IExpr> fRightHandSide;

        public PatternMatcherFunctionMethod(IExpr leftHandSide, Function<IExpr, IExpr> rightHandSide) {
            super(leftHandSide);
            this.fRightHandSide = rightHandSide;
        }

        @Override
        IExpr evalMethod() {
            IPatternMap pm = this.createPatternMap();
            IExpr arg1 = pm.getValue(0);
            return this.fRightHandSide.apply(arg1);
        }
    }

    private static class PatternMatcherBiPredicateMethod
    extends AbstractPatternMatcherMethod {
        BiPredicate<IExpr, IExpr> fRightHandSide;

        public PatternMatcherBiPredicateMethod(IExpr leftHandSide, BiPredicate<IExpr, IExpr> rightHandSide) {
            super(leftHandSide);
            this.fRightHandSide = rightHandSide;
        }

        @Override
        IExpr evalMethod() {
            IExpr arg2;
            IPatternMap pm = this.createPatternMap();
            IExpr arg1 = pm.getValue(0);
            return this.fRightHandSide.test(arg1, arg2 = pm.getValue(1)) ? S.True : S.False;
        }
    }

    private static class PatternMatcherBiFunctionMethod
    extends AbstractPatternMatcherMethod {
        BiFunction<IExpr, IExpr, IExpr> fRightHandSide;

        public PatternMatcherBiFunctionMethod(IExpr leftHandSide, BiFunction<IExpr, IExpr, IExpr> rightHandSide) {
            super(leftHandSide);
            this.fRightHandSide = rightHandSide;
        }

        @Override
        IExpr evalMethod() {
            IPatternMap pm = this.createPatternMap();
            IExpr arg1 = pm.getValue(0);
            IExpr arg2 = pm.getValue(1);
            return this.fRightHandSide.apply(arg1, arg2);
        }
    }

    private static class MatcherVisitor
    extends AbstractVisitor {
        final Matcher matcher;
        final Function<IAST, IExpr> function;

        public MatcherVisitor(Matcher matcher, Function<IAST, IExpr> function) {
            this.matcher = matcher;
            this.function = function;
        }

        @Override
        public IExpr visit(IASTMutable ast) {
            int i;
            IExpr temp;
            IAST list = ast;
            if (this.function != null && (temp = this.function.apply(list)).isPresent()) {
                return temp;
            }
            boolean evaled = false;
            IExpr temp2 = this.matcher.apply(list);
            if (temp2.isPresent()) {
                if (temp2.isASTOrAssociation()) {
                    list = (IAST)temp2;
                    evaled = true;
                } else {
                    return temp2;
                }
            }
            IASTAppendable result = F.NIL;
            for (i = 1; i < list.size(); ++i) {
                temp2 = list.get(i).accept(this);
                if (!temp2.isPresent()) continue;
                result = list.copyAppendable();
                for (int j = 1; j < i; ++j) {
                    result.set(j, list.get(j));
                }
                result.set(i++, temp2);
                break;
            }
            if (result.isPresent()) {
                while (i < list.size()) {
                    temp2 = list.get(i).accept(this);
                    if (temp2.isPresent()) {
                        result.set(i, temp2);
                    } else {
                        result.set(i, list.get(i));
                    }
                    ++i;
                }
            }
            if (result.isPresent()) {
                return result;
            }
            if (evaled) {
                return list;
            }
            return F.NIL;
        }

        @Override
        public IExpr visit(IPattern element) {
            return this.matcher.apply(element);
        }

        @Override
        public IExpr visit(IPatternSequence element) {
            return this.matcher.apply(element);
        }

        @Override
        public IExpr visit(ISymbol element) {
            return this.matcher.apply(element);
        }
    }
}

