/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ThrowException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.IPatternMap;

public abstract class IPatternMatcher
implements Cloneable,
Predicate<IExpr>,
Serializable {
    public static final int NOFLAG = 0;
    public static final int SET = 1;
    public static final int SET_DELAYED = 2;
    public static final int TAGSET = 4;
    public static final int TAGSET_DELAYED = 8;
    public static final int UPSET = 16;
    public static final int UPSET_DELAYED = 32;
    public static final int THROW_IF_TRUE = 4097;
    public static final int LITERAL = 4096;
    public static final int HOLDPATTERN = 8192;
    public static final int SERIALIZATION_MASK = 32768;
    public static final EquivalenceComparator EQUIVALENCE_COMPARATOR = new EquivalenceComparator();
    public static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator();
    private static final long serialVersionUID = 2841686297882535691L;
    protected IExpr fLhsPatternExpr;
    protected transient IExpr fLhsExprToMatch;

    protected IPatternMatcher() {
        this.fLhsPatternExpr = null;
        this.fLhsExprToMatch = F.NIL;
    }

    public IPatternMatcher(IExpr lhsPatternExpr) {
        this.fLhsPatternExpr = lhsPatternExpr;
        this.fLhsExprToMatch = F.NIL;
    }

    public Object clone() throws CloneNotSupportedException {
        IPatternMatcher v = (IPatternMatcher)super.clone();
        v.fLhsPatternExpr = this.fLhsPatternExpr;
        v.fLhsExprToMatch = this.fLhsExprToMatch;
        return v;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPatternMatcher other = (IPatternMatcher)obj;
        return !(this.fLhsPatternExpr == null ? other.fLhsPatternExpr != null : !this.fLhsPatternExpr.equals(other.fLhsPatternExpr));
    }

    public abstract int equivalentLHS(IPatternMatcher var1);

    public abstract int equivalentTo(IPatternMatcher var1);

    public abstract IExpr eval(IExpr var1, EvalEngine var2);

    public IExpr getLHS() {
        return this.fLhsPatternExpr;
    }

    public IExpr getLHSExprToMatch() {
        return this.fLhsExprToMatch;
    }

    public abstract int getLHSPriority();

    public abstract int getPatternHash();

    public IPatternMap getPatternMap() {
        return null;
    }

    public abstract void getPatterns(List<IExpr> var1, IExpr var2);

    public IExpr getRHS() {
        return F.NIL;
    }

    public int hashCode() {
        return this.fLhsPatternExpr.hashCode();
    }

    public abstract boolean isPatternHashAllowed(int var1);

    public abstract boolean isRuleWithoutPatterns();

    public void setLHSExprToMatch(IExpr lhsExprToMatch) {
        this.fLhsExprToMatch = lhsExprToMatch;
    }

    @Override
    public abstract boolean test(IExpr var1) throws ThrowException;

    public abstract boolean test(IExpr var1, EvalEngine var2) throws ThrowException;

    public boolean testBlank(IExpr expr, EvalEngine engine) {
        return this.test(expr, engine);
    }

    public void throwExceptionArgIfMatched(boolean throwIfMatched) {
    }

    public static class PriorityComparator
    implements Comparator<IPatternMatcher> {
        @Override
        public int compare(IPatternMatcher o1, IPatternMatcher o2) {
            return o1.getLHSPriority() < o2.getLHSPriority() ? -1 : (o1.getLHSPriority() > o2.getLHSPriority() ? 1 : 0);
        }
    }

    public static class EquivalenceComparator
    implements Comparator<IPatternMatcher>,
    Serializable {
        private static final long serialVersionUID = 8357661139299702326L;

        @Override
        public int compare(IPatternMatcher o1, IPatternMatcher o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.equivalentTo(o2);
        }
    }
}

