/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hipparchus.util.Pair;
import org.matheclipse.core.builtin.PatternMatching;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.OptionsPattern;
import org.matheclipse.core.expression.Pattern;
import org.matheclipse.core.expression.PatternNested;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorReplaceAllWithPatternFlags;

public interface IPatternMap {
    public static final int DEFAULT_RULE_PRIORITY = Integer.MAX_VALUE;

    public static void addPattern(List<Pair<IExpr, IPatternObject>> patternIndexMap, IPatternObject pattern) {
        ISymbol sym = pattern.getSymbol();
        if (sym != null) {
            for (int i = 0; i < patternIndexMap.size(); ++i) {
                if (patternIndexMap.get(i).getKey() != sym) continue;
                return;
            }
            patternIndexMap.add((Pair<IExpr, IPatternObject>)new Pair((Object)sym, (Object)pattern));
            return;
        }
        patternIndexMap.add((Pair<IExpr, IPatternObject>)new Pair((Object)pattern, (Object)pattern));
    }

    public static IPatternMap determinePatterns(IExpr lhsPatternExpr, int[] priority, PatternNested p2) {
        if (lhsPatternExpr instanceof IAST) {
            ArrayList<Pair<IExpr, IPatternObject>> patternIndexMap = new ArrayList<Pair<IExpr, IPatternObject>>();
            boolean[] ruleWithoutPattern = new boolean[]{true};
            if (p2 != null) {
                ruleWithoutPattern[0] = false;
                int[] result = p2.addPattern(patternIndexMap);
                priority[0] = priority[0] - result[1];
            }
            IPatternMap.determinePatternsRecursive(patternIndexMap, (IAST)lhsPatternExpr, priority, ruleWithoutPattern, 1);
            int size = patternIndexMap.size();
            switch (size) {
                case 1: {
                    PatternMap1 patternMap1 = new PatternMap1();
                    patternMap1.fSymbol1 = (IExpr)((Pair)patternIndexMap.get(0)).getFirst();
                    patternMap1.fPatternObject1 = (IPatternObject)((Pair)patternIndexMap.get(0)).getSecond();
                    return patternMap1;
                }
                case 2: {
                    PatternMap2 patternMap2 = new PatternMap2();
                    patternMap2.fSymbol1 = (IExpr)((Pair)patternIndexMap.get(0)).getFirst();
                    patternMap2.fPatternObject1 = (IPatternObject)((Pair)patternIndexMap.get(0)).getSecond();
                    patternMap2.fSymbol2 = (IExpr)((Pair)patternIndexMap.get(1)).getFirst();
                    patternMap2.fPatternObject2 = (IPatternObject)((Pair)patternIndexMap.get(1)).getSecond();
                    return patternMap2;
                }
                case 3: {
                    PatternMap3 patternMap3 = new PatternMap3();
                    patternMap3.fSymbol1 = (IExpr)((Pair)patternIndexMap.get(0)).getFirst();
                    patternMap3.fPatternObject1 = (IPatternObject)((Pair)patternIndexMap.get(0)).getSecond();
                    patternMap3.fSymbol2 = (IExpr)((Pair)patternIndexMap.get(1)).getFirst();
                    patternMap3.fPatternObject2 = (IPatternObject)((Pair)patternIndexMap.get(1)).getSecond();
                    patternMap3.fSymbol3 = (IExpr)((Pair)patternIndexMap.get(2)).getFirst();
                    patternMap3.fPatternObject3 = (IPatternObject)((Pair)patternIndexMap.get(2)).getSecond();
                    return patternMap3;
                }
            }
            PatternMap patternMap = new PatternMap();
            patternMap.fRuleWithoutPattern = ruleWithoutPattern[0];
            patternMap.fSymbolsOrPattern = new IExpr[size];
            patternMap.fSymbolsOrPatternValues = new IExpr[size];
            patternMap.fPatternObjects = new IPatternObject[size];
            int i = 0;
            for (Pair pair : patternIndexMap) {
                patternMap.fSymbolsOrPattern[i] = (IExpr)pair.getFirst();
                patternMap.fPatternObjects[i] = (IPatternObject)pair.getSecond();
                ++i;
            }
            return patternMap;
        }
        if (lhsPatternExpr instanceof PatternNested) {
            PatternNested pattern2 = (PatternNested)lhsPatternExpr;
            return IPatternMap.determinePatterns(pattern2.getPatternExpr(), priority, pattern2);
        }
        if (lhsPatternExpr instanceof IPatternObject) {
            if (p2 != null) {
                PatternMap2 patternMap2 = new PatternMap2();
                patternMap2.fSymbol1 = p2.getSymbol();
                patternMap2.fPatternObject1 = p2;
                IPatternObject pattern = (IPatternObject)lhsPatternExpr;
                ISymbol sym = pattern.getSymbol();
                patternMap2.fSymbol2 = sym != null ? sym : pattern;
                patternMap2.fPatternObject2 = pattern;
                return patternMap2;
            }
            PatternMap1 patternMap1 = new PatternMap1();
            IPatternObject pattern = (IPatternObject)lhsPatternExpr;
            ISymbol sym = pattern.getSymbol();
            patternMap1.fSymbol1 = sym != null ? sym : pattern;
            patternMap1.fPatternObject1 = pattern;
            return patternMap1;
        }
        return new PatternMap0();
    }

    public static int determinePatternsRecursive(List<Pair<IExpr, IPatternObject>> patternIndexMap, IAST lhsPatternExpr, int[] priority, boolean[] ruleWithoutPattern, int treeLevel) {
        int[] listEvalFlags = new int[]{0};
        if (lhsPatternExpr.isAlternatives() || lhsPatternExpr.isExcept()) {
            ruleWithoutPattern[0] = false;
        }
        lhsPatternExpr.forEach(x -> {
            if (x.isASTOrAssociation()) {
                IAST lhsPatternAST = (IAST)x;
                if (lhsPatternAST.isPatternMatchingFunction()) {
                    listEvalFlags[0] = listEvalFlags[0] | 1;
                }
                listEvalFlags[0] = listEvalFlags[0] | IPatternMap.determinePatternsRecursive(patternIndexMap, lhsPatternAST, priority, ruleWithoutPattern, treeLevel + 1);
                priority[0] = priority[0] - 11;
                if (x.isPatternDefault()) {
                    listEvalFlags[0] = listEvalFlags[0] | 4;
                }
            } else if (x instanceof IPatternObject) {
                IExpr patternExpr;
                ruleWithoutPattern[0] = false;
                int[] result = ((IPatternObject)x).addPattern(patternIndexMap);
                listEvalFlags[0] = listEvalFlags[0] | result[0];
                priority[0] = priority[0] - result[1];
                if (x instanceof PatternNested && (patternExpr = ((PatternNested)x).getPatternExpr()).isASTOrAssociation()) {
                    listEvalFlags[0] = listEvalFlags[0] | IPatternMap.determinePatternsRecursive(patternIndexMap, (IAST)patternExpr, priority, ruleWithoutPattern, treeLevel + 1);
                    priority[0] = priority[0] - 11;
                    if (x.isPatternDefault()) {
                        listEvalFlags[0] = listEvalFlags[0] | 4;
                    }
                }
            } else {
                priority[0] = priority[0] - (50 - treeLevel);
            }
        }, 0);
        lhsPatternExpr.setEvalFlags(listEvalFlags[0]);
        return listEvalFlags[0];
    }

    public IPatternMap copy();

    public IExpr[] copyPattern();

    public void copyPatternValuesFromPatternMatcher(IPatternMap var1);

    public int get(IExpr var1);

    public boolean getRHSEvaluated();

    public IExpr getKey(int var1);

    public IExpr getValue(int var1);

    public IExpr getValue(IPatternObject var1);

    public List<IExpr> getValuesAsList();

    public void initPattern();

    default public void initPatternBlank() {
        this.initPattern();
    }

    public void initSlotValues();

    public boolean isAllPatternsAssigned();

    public boolean isFreeOfPatternSymbols(IExpr var1);

    default public boolean isPatternTest(IExpr expr, IExpr patternTest, EvalEngine engine) {
        IExpr temp = this.substitutePatternOrSymbols(expr, false).orElse(expr);
        if (temp.isSequence()) {
            return ((IAST)temp).forAll(x -> engine.evalTrue(patternTest, (IExpr)x));
        }
        return engine.evalTrue(patternTest, temp);
    }

    public boolean isRuleWithoutPatterns();

    public boolean isValueAssigned();

    public void resetPattern(IExpr[] var1);

    public void setRHSEvaluated(boolean var1);

    public boolean setValue(IPatternObject var1, IExpr var2);

    public boolean setValue(IPatternSequence var1, IAST var2);

    public int size();

    public IExpr substitute(IExpr var1);

    default public IExpr substitutePatternOrSymbols(IExpr lhsPatternExpr, boolean onlyNamedPatterns) {
        VisitorReplaceAllWithPatternFlags visitor = new VisitorReplaceAllWithPatternFlags(input -> {
            if (input instanceof IPatternObject) {
                if (onlyNamedPatterns && !(input instanceof Pattern)) {
                    return F.NIL;
                }
                IExpr symbolOrPatternObject = ((IPatternObject)input).getSymbol();
                if (symbolOrPatternObject == null) {
                    if (onlyNamedPatterns) {
                        return F.NIL;
                    }
                    symbolOrPatternObject = input;
                }
                return this.substitute(symbolOrPatternObject);
            }
            return F.NIL;
        }, onlyNamedPatterns);
        IExpr result = lhsPatternExpr.accept(visitor);
        if (result.isPresent()) {
            result.isFreeOfPatterns();
            return result;
        }
        return lhsPatternExpr;
    }

    default public IExpr substituteASTPatternOrSymbols(IAST lhsPatternExpr, boolean onlyNamedPatterns) {
        VisitorReplaceAllWithPatternFlags visitor = new VisitorReplaceAllWithPatternFlags(input -> {
            if (input instanceof IPatternObject) {
                if (onlyNamedPatterns && !(input instanceof Pattern)) {
                    return F.NIL;
                }
                IExpr symbolOrPatternObject = ((IPatternObject)input).getSymbol();
                if (symbolOrPatternObject == null) {
                    if (onlyNamedPatterns) {
                        return F.NIL;
                    }
                    symbolOrPatternObject = input;
                }
                return this.substitute(symbolOrPatternObject);
            }
            return F.NIL;
        }, onlyNamedPatterns);
        IASTMutable result = F.NIL;
        for (int i = 1; i < lhsPatternExpr.size(); ++i) {
            IExpr temp = lhsPatternExpr.get(i).accept(visitor);
            if (!temp.isPresent()) continue;
            if (!result.isPresent()) {
                result = lhsPatternExpr.setAtCopy(i, temp);
                continue;
            }
            result.set(i, temp);
        }
        if (result.isPresent()) {
            return EvalAttributes.simpleEval(result);
        }
        return F.NIL;
    }

    public IExpr substituteSymbols(IExpr var1, IExpr var2);

    public boolean setOptionsPattern(EvalEngine var1, ISymbol var2);

    public static void addOptionsPattern(OptionsPattern op, IExpr x, EvalEngine engine) {
        if (x.size() > 1 && (x.isSequence() || x.isList())) {
            ((IAST)x).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)arg -> IPatternMap.addOptionsPattern(op, arg, engine)));
        } else {
            engine.addOptionsPattern(op, (IAST)x);
        }
    }

    public static class PatternMap
    implements IPatternMap,
    Serializable {
        private static final IExpr[] EMPTY_ARRAY = new IExpr[0];
        private static final long serialVersionUID = -5384429232269800438L;
        boolean fRuleWithoutPattern = true;
        IExpr[] fSymbolsOrPattern;
        IExpr[] fSymbolsOrPatternValues;
        IPatternObject[] fPatternObjects;
        private transient boolean evaluatedRHS = false;

        public PatternMap() {
            this(EMPTY_ARRAY);
        }

        private PatternMap(IExpr[] exprArray) {
            this.fSymbolsOrPatternValues = exprArray;
        }

        @Override
        public IPatternMap copy() {
            PatternMap result = new PatternMap(null);
            result.evaluatedRHS = false;
            result.fSymbolsOrPattern = this.fSymbolsOrPattern;
            result.fPatternObjects = this.fPatternObjects;
            int length = this.fSymbolsOrPatternValues.length;
            result.fSymbolsOrPatternValues = new IExpr[length];
            System.arraycopy(this.fSymbolsOrPatternValues, 0, result.fSymbolsOrPatternValues, 0, length);
            result.fRuleWithoutPattern = this.fRuleWithoutPattern;
            return result;
        }

        @Override
        public IExpr[] copyPattern() {
            int length = this.fSymbolsOrPatternValues.length;
            IExpr[] patternValuesArray = new IExpr[length];
            System.arraycopy(this.fSymbolsOrPatternValues, 0, patternValuesArray, 0, length);
            return patternValuesArray;
        }

        @Override
        public void copyPatternValuesFromPatternMatcher(IPatternMap patternMap) {
            for (int i = 0; i < patternMap.size(); ++i) {
                for (int j = 0; j < this.fSymbolsOrPattern.length; ++j) {
                    if (this.fSymbolsOrPattern[j] != patternMap.getKey(i)) continue;
                    this.fSymbolsOrPatternValues[j] = patternMap.getValue(i);
                }
            }
        }

        @Override
        public int get(IExpr patternOrSymbol) {
            int length = this.fSymbolsOrPattern.length;
            for (int i = 0; i < length; ++i) {
                if (patternOrSymbol != this.fSymbolsOrPattern[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public final boolean getRHSEvaluated() {
            return this.evaluatedRHS;
        }

        @Override
        public IExpr getKey(int index) {
            if (index < this.fSymbolsOrPattern.length) {
                return this.fSymbolsOrPattern[index];
            }
            return null;
        }

        @Override
        public IExpr getValue(int index) {
            if (index < this.fSymbolsOrPatternValues.length) {
                return this.fSymbolsOrPatternValues[index];
            }
            return null;
        }

        @Override
        public IExpr getValue(IPatternObject pattern) {
            ISymbol sym = pattern.getSymbol();
            if (sym != null) {
                return this.getSymbolValue(sym);
            }
            IPatternObject temp = pattern;
            int indx = this.get(temp);
            return indx >= 0 ? this.fSymbolsOrPatternValues[indx] : null;
        }

        private final IExpr getSymbolValue(ISymbol symbol) {
            int indx = this.get(symbol);
            return indx >= 0 ? this.fSymbolsOrPatternValues[indx] : null;
        }

        @Override
        public List<IExpr> getValuesAsList() {
            int length = this.fSymbolsOrPatternValues.length;
            ArrayList<IExpr> args = new ArrayList<IExpr>(length);
            for (int i = 0; i < length; ++i) {
                IExpr arg = this.fSymbolsOrPatternValues[i];
                if (arg == null) {
                    return null;
                }
                args.add(arg);
            }
            return args;
        }

        @Override
        public final void initPattern() {
            this.evaluatedRHS = false;
            Arrays.fill(this.fSymbolsOrPatternValues, null);
        }

        @Override
        public void initPatternBlank() {
            this.evaluatedRHS = false;
            for (IExpr arg : this.fSymbolsOrPattern) {
                if (!(arg instanceof IPatternObject)) continue;
                this.fSymbolsOrPatternValues[i] = null;
            }
        }

        @Override
        public final void initSlotValues() {
            for (int i = 0; i < this.fSymbolsOrPatternValues.length; ++i) {
                this.fSymbolsOrPatternValues[i] = F.Slot(i + 1);
            }
        }

        @Override
        public boolean isAllPatternsAssigned() {
            if (this.fSymbolsOrPatternValues != null) {
                int length = this.fSymbolsOrPatternValues.length;
                for (int i = length - 1; i >= 0; --i) {
                    if (this.fSymbolsOrPatternValues[i] != null) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isValueAssigned() {
            if (this.fSymbolsOrPatternValues != null) {
                int length = this.fSymbolsOrPatternValues.length;
                for (int i = 0; i < length; ++i) {
                    if (this.fSymbolsOrPatternValues[i] == null || !(this.fSymbolsOrPattern[i] instanceof ISymbol)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isRuleWithoutPatterns() {
            return this.fRuleWithoutPattern;
        }

        @Override
        public boolean isFreeOfPatternSymbols(IExpr substitutedExpr) {
            if (this.isAllPatternsAssigned()) {
                return true;
            }
            if (this.fSymbolsOrPattern != null) {
                return substitutedExpr.isFree(x -> {
                    int length = this.fSymbolsOrPattern.length;
                    for (int i = 0; i < length; ++i) {
                        if (this.fSymbolsOrPattern[i] != x) continue;
                        return false;
                    }
                    return true;
                }, true);
            }
            return true;
        }

        @Override
        public final void resetPattern(IExpr[] patternValuesArray) {
            this.evaluatedRHS = false;
            System.arraycopy(patternValuesArray, 0, this.fSymbolsOrPatternValues, 0, this.fSymbolsOrPatternValues.length);
        }

        @Override
        public boolean setOptionsPattern(EvalEngine engine, ISymbol lhsHead) {
            boolean result = false;
            if (this.fSymbolsOrPatternValues != null) {
                for (int i = 0; i < this.fPatternObjects.length; ++i) {
                    if (!this.fPatternObjects[i].isOptionsPattern()) continue;
                    OptionsPattern op = (OptionsPattern)this.fPatternObjects[i];
                    IPatternMap.addOptionsPattern(op, this.fSymbolsOrPatternValues[i], engine);
                    if (lhsHead != op.getOptionsPatternHead()) continue;
                    result = true;
                }
            }
            return result;
        }

        @Override
        public final void setRHSEvaluated(boolean evaluated) {
            this.evaluatedRHS = evaluated;
        }

        @Override
        public boolean setValue(IPatternObject pattern, IExpr expr) {
            int indx;
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if ((indx = this.get(temp)) >= 0) {
                this.fSymbolsOrPatternValues[indx] = expr.isOneIdentityAST1() ? expr.first() : expr;
                return true;
            }
            return false;
        }

        @Override
        public boolean setValue(IPatternSequence pattern, IAST sequence) {
            int indx;
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if ((indx = this.get(temp)) >= 0) {
                this.fSymbolsOrPatternValues[indx] = sequence;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            if (this.fSymbolsOrPattern != null) {
                return this.fSymbolsOrPattern.length;
            }
            return 0;
        }

        @Override
        public IExpr substitute(IExpr symbolOrPatternObject) {
            int length = this.fSymbolsOrPattern.length;
            for (int i = 0; i < length; ++i) {
                if (symbolOrPatternObject != this.fSymbolsOrPattern[i]) continue;
                return this.fSymbolsOrPatternValues[i] != null ? this.fSymbolsOrPatternValues[i] : F.NIL;
            }
            return F.NIL;
        }

        @Override
        public IExpr substituteSymbols(IExpr rhsExpr, IExpr nilOrEmptySequence) {
            EvalEngine engine = EvalEngine.get();
            if (this.fSymbolsOrPatternValues != null) {
                return rhsExpr.replaceAll(input -> {
                    if (input.isSymbol()) {
                        ISymbol symbol = (ISymbol)input;
                        int length = this.fSymbolsOrPattern.length;
                        for (int i = 0; i < length; ++i) {
                            if (symbol != this.fSymbolsOrPattern[i]) continue;
                            return this.fSymbolsOrPatternValues[i] != null ? this.fSymbolsOrPatternValues[i] : nilOrEmptySequence;
                        }
                    } else if (input.isAST((IExpr)S.OptionValue, 2, 4)) {
                        int length = this.fSymbolsOrPattern.length;
                        return PatternMatching.optionValueReplace((IAST)input, true, engine);
                    }
                    return F.NIL;
                }).orElse(rhsExpr);
            }
            return rhsExpr;
        }

        public String toString() {
            if (this.fSymbolsOrPattern != null) {
                StringBuilder buf = new StringBuilder();
                buf.append("Patterns[");
                int length = this.fSymbolsOrPattern.length;
                for (int i = 0; i < length; ++i) {
                    buf.append(this.fSymbolsOrPattern[i].toString());
                    buf.append(" => ");
                    if (this.fSymbolsOrPatternValues[i] != null) {
                        buf.append(this.fSymbolsOrPatternValues[i].toString());
                    } else {
                        buf.append("?");
                    }
                    if (i >= length - 1) continue;
                    buf.append(", ");
                }
                buf.append("]");
                return buf.toString();
            }
            return "PatternMap[]";
        }

        public IExpr[] getSymbolsOrPattern() {
            return this.fSymbolsOrPattern;
        }

        public IExpr[] getSymbolsOrPatternValues() {
            return this.fSymbolsOrPatternValues;
        }
    }

    public static class PatternMap3
    implements IPatternMap {
        private static final int SIZE = 3;
        IExpr fSymbol1;
        IExpr fValue1;
        IPatternObject fPatternObject1;
        IExpr fSymbol2;
        IExpr fValue2;
        IPatternObject fPatternObject2;
        IExpr fSymbol3;
        IExpr fValue3;
        IPatternObject fPatternObject3;
        private transient boolean evaluatedRHS = false;

        @Override
        public IPatternMap copy() {
            PatternMap3 result = new PatternMap3();
            result.evaluatedRHS = false;
            result.fSymbol1 = this.fSymbol1;
            result.fValue1 = this.fValue1;
            result.fPatternObject1 = this.fPatternObject1;
            result.fSymbol2 = this.fSymbol2;
            result.fValue2 = this.fValue2;
            result.fPatternObject2 = this.fPatternObject2;
            result.fSymbol3 = this.fSymbol3;
            result.fValue3 = this.fValue3;
            result.fPatternObject3 = this.fPatternObject3;
            return result;
        }

        @Override
        public IExpr[] copyPattern() {
            return new IExpr[]{this.fValue1, this.fValue2, this.fValue3};
        }

        @Override
        public void copyPatternValuesFromPatternMatcher(IPatternMap patternMap) {
            for (int i = 0; i < patternMap.size(); ++i) {
                IExpr temp = this.getKey(i);
                if (this.fSymbol1 == temp) {
                    this.fValue1 = patternMap.getValue(i);
                    continue;
                }
                if (this.fSymbol2 == temp) {
                    this.fValue2 = patternMap.getValue(i);
                    continue;
                }
                if (this.fSymbol3 != temp) continue;
                this.fValue3 = patternMap.getValue(i);
            }
        }

        @Override
        public int get(IExpr patternOrSymbol) {
            return patternOrSymbol == this.fSymbol1 ? 0 : (patternOrSymbol == this.fSymbol2 ? 1 : (patternOrSymbol == this.fSymbol3 ? 2 : -1));
        }

        @Override
        public boolean getRHSEvaluated() {
            return this.evaluatedRHS;
        }

        @Override
        public IExpr getKey(int index) {
            if (index == 0) {
                return this.fSymbol1;
            }
            if (index == 1) {
                return this.fSymbol2;
            }
            if (index == 2) {
                return this.fSymbol3;
            }
            return null;
        }

        @Override
        public IExpr getValue(int index) {
            if (index == 0) {
                return this.fValue1;
            }
            if (index == 1) {
                return this.fValue2;
            }
            if (index == 2) {
                return this.fValue3;
            }
            return null;
        }

        @Override
        public IExpr getValue(IPatternObject pattern) {
            IExpr sym = pattern.getSymbol();
            if (sym == null) {
                sym = pattern;
            }
            if (sym == this.fSymbol1) {
                return this.fValue1;
            }
            if (sym == this.fSymbol2) {
                return this.fValue2;
            }
            if (sym == this.fSymbol3) {
                return this.fValue3;
            }
            return null;
        }

        @Override
        public List<IExpr> getValuesAsList() {
            if (this.isAllPatternsAssigned()) {
                ArrayList<IExpr> args = new ArrayList<IExpr>(2);
                args.add(this.fValue1);
                args.add(this.fValue2);
                args.add(this.fValue3);
                return args;
            }
            return null;
        }

        @Override
        public void initPattern() {
            this.evaluatedRHS = false;
            this.fValue1 = null;
            this.fValue2 = null;
            this.fValue3 = null;
        }

        @Override
        public void initPatternBlank() {
            this.evaluatedRHS = false;
            if (this.fSymbol1 instanceof IPatternObject) {
                this.fValue1 = null;
            }
            if (this.fSymbol2 instanceof IPatternObject) {
                this.fValue2 = null;
            }
            if (this.fSymbol3 instanceof IPatternObject) {
                this.fValue3 = null;
            }
        }

        @Override
        public final void initSlotValues() {
            this.fValue1 = F.Slot1;
            this.fValue2 = F.Slot2;
            this.fValue3 = F.Slot3;
        }

        @Override
        public boolean isAllPatternsAssigned() {
            return this.fValue1 != null && this.fValue2 != null && this.fValue3 != null;
        }

        @Override
        public boolean isValueAssigned() {
            if (this.fValue1 != null && this.fSymbol1 instanceof ISymbol) {
                return true;
            }
            if (this.fValue2 != null && this.fSymbol2 instanceof ISymbol) {
                return true;
            }
            return this.fValue3 != null && this.fSymbol3 instanceof ISymbol;
        }

        @Override
        public boolean isFreeOfPatternSymbols(IExpr substitutedExpr) {
            if (this.isAllPatternsAssigned()) {
                return true;
            }
            return substitutedExpr.isFree(x -> this.fSymbol1 != x && this.fSymbol2 != x && this.fSymbol3 != x, true);
        }

        @Override
        public boolean isRuleWithoutPatterns() {
            return false;
        }

        @Override
        public void resetPattern(IExpr[] patternValuesArray) {
            this.evaluatedRHS = false;
            this.fValue1 = patternValuesArray[0];
            this.fValue2 = patternValuesArray[1];
            this.fValue3 = patternValuesArray[2];
        }

        @Override
        public boolean setOptionsPattern(EvalEngine engine, ISymbol lhsHead) {
            OptionsPattern op;
            boolean result = false;
            if (this.fPatternObject1.isOptionsPattern()) {
                op = (OptionsPattern)this.fPatternObject1;
                IPatternMap.addOptionsPattern(op, this.fValue1, engine);
                if (lhsHead == op.getOptionsPatternHead()) {
                    result = true;
                }
            }
            if (this.fPatternObject2.isOptionsPattern()) {
                op = (OptionsPattern)this.fPatternObject2;
                IPatternMap.addOptionsPattern(op, this.fValue2, engine);
                if (lhsHead == op.getOptionsPatternHead()) {
                    result = true;
                }
            }
            if (this.fPatternObject3.isOptionsPattern()) {
                op = (OptionsPattern)this.fPatternObject3;
                IPatternMap.addOptionsPattern(op, this.fValue3, engine);
                if (lhsHead == op.getOptionsPatternHead()) {
                    result = true;
                }
            }
            return result;
        }

        @Override
        public void setRHSEvaluated(boolean evaluated) {
            this.evaluatedRHS = evaluated;
        }

        @Override
        public boolean setValue(IPatternObject pattern, IExpr expr) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = expr;
                if (this.fValue1.isOneIdentityAST1()) {
                    this.fValue1 = this.fValue1.first();
                }
                return true;
            }
            if (temp == this.fSymbol2) {
                this.fValue2 = expr;
                if (this.fValue2.isOneIdentityAST1()) {
                    this.fValue2 = this.fValue2.first();
                }
                return true;
            }
            if (temp == this.fSymbol3) {
                this.fValue3 = expr;
                if (this.fValue3.isOneIdentityAST1()) {
                    this.fValue3 = this.fValue3.first();
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean setValue(IPatternSequence pattern, IAST sequence) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = sequence;
                return true;
            }
            if (temp == this.fSymbol2) {
                this.fValue2 = sequence;
                return true;
            }
            if (temp == this.fSymbol3) {
                this.fValue3 = sequence;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public IExpr substitute(IExpr symbolOrPatternObject) {
            if (symbolOrPatternObject == this.fSymbol1) {
                return this.fValue1 != null ? this.fValue1 : F.NIL;
            }
            if (symbolOrPatternObject == this.fSymbol2) {
                return this.fValue2 != null ? this.fValue2 : F.NIL;
            }
            if (symbolOrPatternObject == this.fSymbol3) {
                return this.fValue3 != null ? this.fValue3 : F.NIL;
            }
            return F.NIL;
        }

        @Override
        public IExpr substituteSymbols(IExpr rhsExpr, IExpr nilOrEmptySequence) {
            EvalEngine engine = EvalEngine.get();
            return rhsExpr.replaceAll(input -> {
                if (input.isSymbol()) {
                    if ((ISymbol)input == this.fSymbol1) {
                        return this.fValue1 != null ? this.fValue1 : nilOrEmptySequence;
                    }
                    if ((ISymbol)input == this.fSymbol2) {
                        return this.fValue2 != null ? this.fValue2 : nilOrEmptySequence;
                    }
                    if ((ISymbol)input == this.fSymbol3) {
                        return this.fValue3 != null ? this.fValue3 : nilOrEmptySequence;
                    }
                } else if (input.isAST((IExpr)S.OptionValue, 2, 4)) {
                    return PatternMatching.optionValueReplace((IAST)input, true, engine);
                }
                return F.NIL;
            }).orElse(rhsExpr);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Patterns[");
            buf.append(this.fSymbol1.toString());
            buf.append(" => ");
            if (this.fValue1 != null) {
                buf.append(this.fValue1.toString());
            } else {
                buf.append("?");
            }
            buf.append(", ");
            buf.append(this.fSymbol2.toString());
            buf.append(" => ");
            if (this.fValue2 != null) {
                buf.append(this.fValue2.toString());
            } else {
                buf.append("?");
            }
            buf.append(", ");
            buf.append(this.fSymbol3.toString());
            buf.append(" => ");
            if (this.fValue3 != null) {
                buf.append(this.fValue3.toString());
            } else {
                buf.append("?");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class PatternMap2
    implements IPatternMap {
        private static final int SIZE = 2;
        IExpr fSymbol1;
        IExpr fValue1;
        IPatternObject fPatternObject1;
        IExpr fSymbol2;
        IExpr fValue2;
        IPatternObject fPatternObject2;
        private transient boolean evaluatedRHS = false;

        @Override
        public IPatternMap copy() {
            PatternMap2 result = new PatternMap2();
            result.evaluatedRHS = false;
            result.fSymbol1 = this.fSymbol1;
            result.fValue1 = this.fValue1;
            result.fPatternObject1 = this.fPatternObject1;
            result.fSymbol2 = this.fSymbol2;
            result.fValue2 = this.fValue2;
            result.fPatternObject2 = this.fPatternObject2;
            return result;
        }

        @Override
        public IExpr[] copyPattern() {
            return new IExpr[]{this.fValue1, this.fValue2};
        }

        @Override
        public void copyPatternValuesFromPatternMatcher(IPatternMap patternMap) {
            for (int i = 0; i < patternMap.size(); ++i) {
                IExpr temp = this.getKey(i);
                if (this.fSymbol1 == temp) {
                    this.fValue1 = patternMap.getValue(i);
                    continue;
                }
                if (this.fSymbol2 != temp) continue;
                this.fValue2 = patternMap.getValue(i);
            }
        }

        @Override
        public int get(IExpr patternOrSymbol) {
            return patternOrSymbol == this.fSymbol1 ? 0 : (patternOrSymbol == this.fSymbol2 ? 1 : -1);
        }

        @Override
        public boolean getRHSEvaluated() {
            return this.evaluatedRHS;
        }

        @Override
        public IExpr getKey(int index) {
            if (index == 0) {
                return this.fSymbol1;
            }
            if (index == 1) {
                return this.fSymbol2;
            }
            return null;
        }

        @Override
        public IExpr getValue(int index) {
            if (index == 0) {
                return this.fValue1;
            }
            if (index == 1) {
                return this.fValue2;
            }
            return null;
        }

        @Override
        public IExpr getValue(IPatternObject pattern) {
            IExpr sym = pattern.getSymbol();
            if (sym == null) {
                sym = pattern;
            }
            if (sym == this.fSymbol1) {
                return this.fValue1;
            }
            if (sym == this.fSymbol2) {
                return this.fValue2;
            }
            return null;
        }

        @Override
        public List<IExpr> getValuesAsList() {
            if (this.fValue1 == null || this.fValue2 == null) {
                return null;
            }
            ArrayList<IExpr> args = new ArrayList<IExpr>(2);
            args.add(this.fValue1);
            args.add(this.fValue2);
            return args;
        }

        @Override
        public void initPattern() {
            this.evaluatedRHS = false;
            this.fValue1 = null;
            this.fValue2 = null;
        }

        @Override
        public void initPatternBlank() {
            this.evaluatedRHS = false;
            if (this.fSymbol1 instanceof IPatternObject) {
                this.fValue1 = null;
            }
            if (this.fSymbol2 instanceof IPatternObject) {
                this.fValue2 = null;
            }
        }

        @Override
        public final void initSlotValues() {
            this.fValue1 = F.Slot1;
            this.fValue2 = F.Slot2;
        }

        @Override
        public boolean isAllPatternsAssigned() {
            return this.fValue1 != null && this.fValue2 != null;
        }

        @Override
        public boolean isValueAssigned() {
            if (this.fValue1 != null && this.fSymbol1 instanceof ISymbol) {
                return true;
            }
            return this.fValue2 != null && this.fSymbol2 instanceof ISymbol;
        }

        @Override
        public boolean isFreeOfPatternSymbols(IExpr substitutedExpr) {
            if (this.isAllPatternsAssigned()) {
                return true;
            }
            return substitutedExpr.isFree(x -> this.fSymbol1 != x && this.fSymbol2 != x, true);
        }

        @Override
        public boolean isRuleWithoutPatterns() {
            return false;
        }

        @Override
        public void resetPattern(IExpr[] patternValuesArray) {
            this.evaluatedRHS = false;
            this.fValue1 = patternValuesArray[0];
            this.fValue2 = patternValuesArray[1];
        }

        @Override
        public boolean setOptionsPattern(EvalEngine engine, ISymbol lhsHead) {
            OptionsPattern op;
            boolean result = false;
            if (this.fPatternObject1.isOptionsPattern()) {
                op = (OptionsPattern)this.fPatternObject1;
                IPatternMap.addOptionsPattern(op, this.fValue1, engine);
                if (lhsHead == op.getOptionsPatternHead()) {
                    result = true;
                }
            }
            if (this.fPatternObject2.isOptionsPattern()) {
                op = (OptionsPattern)this.fPatternObject2;
                IPatternMap.addOptionsPattern(op, this.fValue2, engine);
                if (lhsHead == op.getOptionsPatternHead()) {
                    result = true;
                }
            }
            return result;
        }

        @Override
        public void setRHSEvaluated(boolean evaluated) {
            this.evaluatedRHS = evaluated;
        }

        @Override
        public boolean setValue(IPatternObject pattern, IExpr expr) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = expr;
                if (this.fValue1.isOneIdentityAST1()) {
                    this.fValue1 = this.fValue1.first();
                }
                return true;
            }
            if (temp == this.fSymbol2) {
                this.fValue2 = expr;
                if (this.fValue2.isOneIdentityAST1()) {
                    this.fValue2 = this.fValue2.first();
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean setValue(IPatternSequence pattern, IAST sequence) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = sequence;
                return true;
            }
            if (temp == this.fSymbol2) {
                this.fValue2 = sequence;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public IExpr substitute(IExpr symbolOrPatternObject) {
            if (symbolOrPatternObject == this.fSymbol1) {
                return this.fValue1 != null ? this.fValue1 : F.NIL;
            }
            if (symbolOrPatternObject == this.fSymbol2) {
                return this.fValue2 != null ? this.fValue2 : F.NIL;
            }
            return F.NIL;
        }

        @Override
        public IExpr substituteSymbols(IExpr rhsExpr, IExpr nilOrEmptySequence) {
            EvalEngine engine = EvalEngine.get();
            return rhsExpr.replaceAll(input -> {
                if (input.isSymbol()) {
                    if ((ISymbol)input == this.fSymbol1) {
                        return this.fValue1 != null ? this.fValue1 : nilOrEmptySequence;
                    }
                    if ((ISymbol)input == this.fSymbol2) {
                        return this.fValue2 != null ? this.fValue2 : nilOrEmptySequence;
                    }
                } else if (input.isAST((IExpr)S.OptionValue, 2, 4)) {
                    return PatternMatching.optionValueReplace((IAST)input, true, engine);
                }
                return F.NIL;
            }).orElse(rhsExpr);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Patterns[");
            buf.append(this.fSymbol1.toString());
            buf.append(" => ");
            if (this.fValue1 != null) {
                buf.append(this.fValue1.toString());
            } else {
                buf.append("?");
            }
            buf.append(", ");
            buf.append(this.fSymbol2.toString());
            buf.append(" => ");
            if (this.fValue2 != null) {
                buf.append(this.fValue2.toString());
            } else {
                buf.append("?");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static final class PatternMap1
    implements IPatternMap {
        private static final int SIZE = 1;
        IExpr fSymbol1;
        IExpr fValue1;
        IPatternObject fPatternObject1;
        private transient boolean evaluatedRHS = false;

        @Override
        public IPatternMap copy() {
            PatternMap1 result = new PatternMap1();
            result.evaluatedRHS = false;
            result.fSymbol1 = this.fSymbol1;
            result.fValue1 = this.fValue1;
            result.fPatternObject1 = this.fPatternObject1;
            return result;
        }

        @Override
        public IExpr[] copyPattern() {
            return new IExpr[]{this.fValue1};
        }

        @Override
        public void copyPatternValuesFromPatternMatcher(IPatternMap patternMap) {
            for (int i = 0; i < patternMap.size(); ++i) {
                if (this.fSymbol1 != this.getKey(i)) continue;
                this.fValue1 = patternMap.getValue(i);
            }
        }

        @Override
        public int get(IExpr patternOrSymbol) {
            return patternOrSymbol == this.fSymbol1 ? 0 : -1;
        }

        @Override
        public boolean getRHSEvaluated() {
            return this.evaluatedRHS;
        }

        @Override
        public IExpr getKey(int index) {
            if (index == 0) {
                return this.fSymbol1;
            }
            return null;
        }

        @Override
        public IExpr getValue(int index) {
            if (index == 0) {
                return this.fValue1;
            }
            return null;
        }

        @Override
        public IExpr getValue(IPatternObject pattern) {
            IExpr sym = pattern.getSymbol();
            if (sym == null) {
                sym = pattern;
            }
            return sym == this.fSymbol1 ? this.fValue1 : null;
        }

        @Override
        public List<IExpr> getValuesAsList() {
            if (this.fValue1 == null) {
                return null;
            }
            ArrayList<IExpr> args = new ArrayList<IExpr>(1);
            args.add(this.fValue1);
            return args;
        }

        @Override
        public void initPattern() {
            this.evaluatedRHS = false;
            this.fValue1 = null;
        }

        @Override
        public void initPatternBlank() {
            this.evaluatedRHS = false;
            if (this.fSymbol1 instanceof IPatternObject) {
                this.fValue1 = null;
            }
        }

        @Override
        public final void initSlotValues() {
            this.fValue1 = F.Slot1;
        }

        @Override
        public boolean isAllPatternsAssigned() {
            return this.fValue1 != null;
        }

        @Override
        public boolean isValueAssigned() {
            return this.fValue1 != null && this.fSymbol1 instanceof ISymbol;
        }

        @Override
        public boolean isFreeOfPatternSymbols(IExpr substitutedExpr) {
            if (this.isAllPatternsAssigned()) {
                return true;
            }
            return substitutedExpr.isFree(x -> this.fSymbol1 != x, true);
        }

        @Override
        public boolean isRuleWithoutPatterns() {
            return false;
        }

        @Override
        public void resetPattern(IExpr[] patternValuesArray) {
            this.evaluatedRHS = false;
            this.fValue1 = patternValuesArray[0];
        }

        @Override
        public void setRHSEvaluated(boolean evaluated) {
            this.evaluatedRHS = evaluated;
        }

        @Override
        public boolean setOptionsPattern(EvalEngine engine, ISymbol lhsHead) {
            if (this.fPatternObject1.isOptionsPattern()) {
                OptionsPattern op = (OptionsPattern)this.fPatternObject1;
                IPatternMap.addOptionsPattern(op, this.fValue1, engine);
                return lhsHead == op.getOptionsPatternHead();
            }
            return false;
        }

        @Override
        public boolean setValue(IPatternObject pattern, IExpr expr) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = expr;
                if (this.fValue1.isOneIdentityAST1()) {
                    this.fValue1 = this.fValue1.first();
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean setValue(IPatternSequence pattern, IAST sequence) {
            ISymbol sym = pattern.getSymbol();
            IExpr temp = pattern;
            if (sym != null) {
                temp = sym;
            }
            if (temp == this.fSymbol1) {
                this.fValue1 = sequence;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public IExpr substitute(IExpr symbolOrPatternObject) {
            if (symbolOrPatternObject == this.fSymbol1) {
                return this.fValue1 != null ? this.fValue1 : F.NIL;
            }
            return F.NIL;
        }

        @Override
        public IExpr substituteSymbols(IExpr rhsExpr, IExpr nilOrEmptySequence) {
            EvalEngine engine = EvalEngine.get();
            return rhsExpr.replaceAll(input -> {
                if (input.isSymbol()) {
                    if ((ISymbol)input == this.fSymbol1) {
                        return this.fValue1 != null ? this.fValue1 : nilOrEmptySequence;
                    }
                } else if (input.isAST((IExpr)S.OptionValue, 2, 4)) {
                    return PatternMatching.optionValueReplace((IAST)input, true, engine);
                }
                return F.NIL;
            }).orElse(rhsExpr);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Patterns[");
            buf.append(this.fSymbol1.toString());
            buf.append(" => ");
            if (this.fValue1 != null) {
                buf.append(this.fValue1.toString());
            } else {
                buf.append("?");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static final class PatternMap0
    implements IPatternMap {
        private static final int SIZE = 0;

        @Override
        public IPatternMap copy() {
            return new PatternMap0();
        }

        @Override
        public IExpr[] copyPattern() {
            return new IExpr[0];
        }

        @Override
        public void copyPatternValuesFromPatternMatcher(IPatternMap patternMap) {
        }

        @Override
        public int get(IExpr patternOrSymbol) {
            return -1;
        }

        @Override
        public boolean getRHSEvaluated() {
            return false;
        }

        @Override
        public IExpr getKey(int index) {
            return null;
        }

        @Override
        public IExpr getValue(int index) {
            return null;
        }

        @Override
        public IExpr getValue(IPatternObject pattern) {
            return null;
        }

        @Override
        public List<IExpr> getValuesAsList() {
            return new ArrayList<IExpr>(1);
        }

        @Override
        public void initPattern() {
        }

        @Override
        public final void initSlotValues() {
        }

        @Override
        public boolean isAllPatternsAssigned() {
            return true;
        }

        @Override
        public boolean isValueAssigned() {
            return false;
        }

        @Override
        public boolean isFreeOfPatternSymbols(IExpr substitutedExpr) {
            return true;
        }

        @Override
        public boolean isRuleWithoutPatterns() {
            return true;
        }

        @Override
        public void resetPattern(IExpr[] patternValuesArray) {
        }

        @Override
        public void setRHSEvaluated(boolean evaluated) {
        }

        @Override
        public boolean setValue(IPatternObject pattern, IExpr expr) {
            return false;
        }

        @Override
        public boolean setValue(IPatternSequence pattern, IAST sequence) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public IExpr substitute(IExpr symbolOrPatternObject) {
            return F.NIL;
        }

        @Override
        public IExpr substitutePatternOrSymbols(IExpr lhsPatternExpr, boolean onlyNamedPatterns) {
            return lhsPatternExpr;
        }

        @Override
        public IExpr substituteSymbols(IExpr rhsExpr, IExpr nilOrEmptySequence) {
            return rhsExpr;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Patterns[");
            buf.append("]");
            return buf.toString();
        }

        @Override
        public boolean setOptionsPattern(EvalEngine engine, ISymbol lhsHead) {
            return false;
        }
    }
}

