/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.combinatoric.AbstractListStepVisitor;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class FlatStepVisitor
extends AbstractListStepVisitor<IExpr> {
    protected ISymbol fSymbol;
    protected PatternMatcher.StackMatcher stackMatcher;
    protected IPatternMap fPatternMap;
    protected IAST fLhsPatternAST;
    protected final boolean fOneIdentity;

    public FlatStepVisitor(ISymbol sym, IAST lhsPatternAST, IAST lhsEvalAST, PatternMatcher.StackMatcher stackMatcher, IPatternMap patternMap) {
        this(sym, lhsPatternAST, lhsEvalAST, stackMatcher, patternMap, sym.hasOneIdentityAttribute());
    }

    public FlatStepVisitor(ISymbol sym, IAST lhsPatternAST, IAST lhsEvalAST, PatternMatcher.StackMatcher stackMatcher, IPatternMap patternMap, boolean oneIdentity) {
        super(lhsEvalAST);
        this.fSymbol = sym;
        this.stackMatcher = stackMatcher;
        this.fPatternMap = patternMap;
        this.fLhsPatternAST = lhsPatternAST;
        this.fOneIdentity = oneIdentity;
    }

    @Override
    public boolean visit(int[][] result) {
        return !this.matchSinglePartition(result, this.stackMatcher);
    }

    public void initPatternMap() {
        this.fPatternMap.initPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchSinglePartition(int[][] result, PatternMatcher.StackMatcher stackMatcher) {
        int lastStackSize = stackMatcher.size();
        boolean matched = true;
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        try {
            boolean bl;
            for (int j = 0; j < result.length; ++j) {
                int n = result[j].length;
                IExpr lhsPatternExpr = this.fLhsPatternAST.get(j + 1);
                if (n == 1 && this.fOneIdentity) {
                    if (stackMatcher.push(lhsPatternExpr, this.array[result[j][0]])) continue;
                    matched = false;
                    boolean bl2 = false;
                    return bl2;
                }
                ISymbol head = this.fSymbol;
                if (lhsPatternExpr.isPatternSequence(false)) {
                    head = S.Sequence;
                }
                IASTAppendable partitionElement = F.ast((IExpr)head, n);
                for (int i = 0; i < n; ++i) {
                    partitionElement.append(this.array[result[j][i]]);
                }
                if (stackMatcher.push(lhsPatternExpr, partitionElement)) continue;
                matched = false;
                boolean bl3 = false;
                return bl3;
            }
            if (!stackMatcher.matchRest()) {
                matched = false;
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (!matched) {
                stackMatcher.removeFrom(lastStackSize);
                this.fPatternMap.resetPattern(patternValues);
            }
        }
    }

    public String toString(int[][] result) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == null) {
                buf.append("[null]");
                continue;
            }
            buf.append("[");
            buf.append(this.fLhsPatternAST.get(i + 1).toString());
            buf.append(" -> ");
            for (int j = 0; j < result[i].length; ++j) {
                buf.append(this.list.get(result[i][j] + 1).toString());
                if (j >= result[i].length - 1) continue;
                buf.append(",");
            }
            buf.append("]");
        }
        buf.append('\n');
        return buf.toString();
    }
}

