/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;

public abstract class AbstractPatternMatcherMethod
extends PatternMatcher {
    public AbstractPatternMatcherMethod(IExpr leftHandSide) {
        super(leftHandSide);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractPatternMatcherMethod v = (AbstractPatternMatcherMethod)super.clone();
        return v;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractPatternMatcherMethod) {
            AbstractPatternMatcherMethod pm = (AbstractPatternMatcherMethod)obj;
            return super.equals(pm);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 73;
    }

    abstract IExpr evalMethod();

    @Override
    public IExpr eval(IExpr leftHandSide, EvalEngine engine) {
        if (this.isRuleWithoutPatterns()) {
            if (this.fLhsPatternExpr.equals(leftHandSide)) {
                try {
                    return this.evalMethod();
                }
                catch (ConditionException e) {
                    return F.NIL;
                }
                catch (ReturnException e) {
                    return e.getValue();
                }
            }
            if (!(this.fLhsPatternExpr.isOrderlessAST() && leftHandSide.isOrderlessAST() || this.fLhsPatternExpr.isFlatAST() && leftHandSide.isFlatAST())) {
                return F.NIL;
            }
        }
        IPatternMap patternMap = this.createPatternMap();
        patternMap.initPattern();
        if (this.matchExpr(this.fLhsPatternExpr, leftHandSide, engine)) {
            try {
                return this.evalMethod();
            }
            catch (ConditionException e) {
                return F.NIL;
            }
            catch (ReturnException e) {
                return e.getValue();
            }
        }
        return F.NIL;
    }

    @Override
    public IExpr getRHS() {
        return F.NIL;
    }
}

