/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.parser;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.PatternNested;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.parser.InfixExprOperator;
import org.matheclipse.core.parser.PostfixExprOperator;
import org.matheclipse.core.parser.PrefixExprOperator;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.Scanner;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieMatch;

public class ExprParserFactory
implements IParserFactory {
    public static CharMatcher OPERATOR_MATCHER = null;
    public static final InformationOperator INFORMATION_SHORT = new InformationOperator("?", "Information", 720);
    public static final InformationOperator INFORMATION_LONG = new InformationOperator("??", "Information", 720);
    public static final ApplyOperator APPLY_HEAD_OPERATOR = new ApplyOperator("@", "Apply", 621, 1);
    public static final ApplyOperator APPLY_OPERATOR = new ApplyOperator("@@", "Apply", 620, 1);
    public static final ApplyOperator APPLY_LEVEL_OPERATOR = new ApplyOperator("@@@", "Apply", 620, 1);
    public static final InfixExprOperator EQUAL_OPERATOR = new InfixExprOperator("==", "Equal", 290, 0);
    public static final InfixExprOperator NON_COMMUTATIVE_MULTIPLY_OPERATOR = new InfixExprOperator("**", "NonCommutativeMultiply", 510, 0);
    public static final InfixExprOperator POWER_OPERATOR = new InfixExprOperator("^", "Power", 590, 1);
    public static final InfixExprOperator SET_OPERATOR = new InfixExprOperator("=", "Set", 40, 1);
    public static final TagSetOperator TAG_SET_OPERATOR = new TagSetOperator("/:", "TagSet", 40, 0);
    static final String[] HEADER_STRINGS = new String[]{"MessageName", "Information", "Information", "Get", "PatternTest", "MapAll", "TimesBy", "Plus", "UpSet", "CompoundExpression", "Apply", "Map", "Unset", "Apply", "Apply", "ReplaceRepeated", "Less", "And", "Divide", "Set", "Increment", "Factorial2", "LessEqual", "NonCommutativeMultiply", "Factorial", "Times", "Power", "Dot", "Not", "PreMinus", "SameQ", "RuleDelayed", "GreaterEqual", "Condition", "//", "DivideBy", "Or", "Span", "Equal", "StringJoin", "Unequal", "Decrement", "SubtractFrom", "PrePlus", "RepeatedNull", "UnsameQ", "Rule", "UpSetDelayed", "PreIncrement", "Function", "Function", "Greater", "PreDecrement", "Subtract", "SetDelayed", "Alternatives", "AddTo", "Repeated", "ReplaceAll", "TagSet", "Composition", "RightComposition", "StringExpression", "Pattern", "TwoWayRule", "TwoWayRule", "DirectedEdge", "UndirectedEdge", "CenterDot", "CircleDot", "CircleTimes", "Distributed", "Element", "Intersection", "NotEqual", "Wedge", "TensorProduct", "Equivalent", "Implies", "\u00a7TILDE\u00a7"};
    static final String[] OPERATOR_STRINGS = new String[]{"::", "<<", "?", "??", "?", "//@", "*=", "+", "^=", ";", "@", "/@", "=.", "@@", "@@@", "//.", "<", "&&", "/", "=", "++", "!!", "<=", "**", "!", "*", "^", ".", "!", "-", "===", ":>", ">=", "/;", "//", "/=", "||", ";;", "==", "<>", "!=", "--", "-=", "+", "...", "=!=", "->", "^:=", "++", "|->", "&", ">", "--", "-", ":=", "|", "+=", "..", "/.", "/:", "@*", "/*", "~~", ":", "<->", "\uf120", "\uf3d5", "\uf3d4", "\u00b7", "\u2299", "\u2297", "\uf3d2", "\u2208", "\u22c2", "\u2260", "\u22c0", "\uf3da", "\u29e6", "\uf523", "~"};
    private static Operator[] OPERATORS;
    public static final ExprParserFactory MMA_STYLE_FACTORY;
    public static final ExprParserFactory RELAXED_STYLE_FACTORY;
    private static Trie<String, Operator> fOperatorMap;
    private static Trie<String, ArrayList<Operator>> fOperatorTokenStartSet;

    public boolean isOperatorChar(char ch) {
        return OPERATOR_MATCHER.matches(ch);
    }

    public static void initialize() {
        Initializer.init();
    }

    public static void addOperator(Map<String, Operator> operatorMap, Map<String, ArrayList<Operator>> operatorTokenStartSet, String operatorStr, String headStr, Operator oper) {
        operatorMap.put(headStr, oper);
        ArrayList<Object> list = operatorTokenStartSet.get(operatorStr);
        if (list == null) {
            list = new ArrayList(2);
            list.add(oper);
            operatorTokenStartSet.put(operatorStr, list);
        } else {
            list.add(oper);
        }
    }

    public Operator get(String identifier) {
        return (Operator)fOperatorMap.get((Object)identifier);
    }

    public Map<String, Operator> getIdentifier2OperatorMap() {
        return fOperatorMap;
    }

    public Map<String, ArrayList<Operator>> getOperator2ListMap() {
        return fOperatorTokenStartSet;
    }

    public List<Operator> getOperatorList(String key) {
        return (List)fOperatorTokenStartSet.get((Object)key);
    }

    public boolean isValidIdentifier(String identifier) {
        return true;
    }

    static {
        MMA_STYLE_FACTORY = new ExprParserFactory();
        RELAXED_STYLE_FACTORY = new ExprParserFactory();
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            OPERATORS = new Operator[]{new InfixExprOperator("::", "MessageName", 750, 0), new PrefixExprOperator("<<", "Get", 720), INFORMATION_SHORT, INFORMATION_LONG, new InfixExprOperator("?", "PatternTest", 680, 0), new InfixExprOperator("//@", "MapAll", 620, 1), new InfixExprOperator("*=", "TimesBy", 100, 1), new InfixExprOperator("+", "Plus", 310, 0), new InfixExprOperator("^=", "UpSet", 40, 1), new InfixExprOperator(";", "CompoundExpression", 10, 0), APPLY_HEAD_OPERATOR, new InfixExprOperator("/@", "Map", 620, 1), new PostfixExprOperator("=.", "Unset", 670), APPLY_OPERATOR, APPLY_LEVEL_OPERATOR, new InfixExprOperator("//.", "ReplaceRepeated", 110, 2), new InfixExprOperator("<", "Less", 290, 0), new InfixExprOperator("&&", "And", 215, 0), new DivideExprOperator("/", "Divide", 470, 2), SET_OPERATOR, new PostfixExprOperator("++", "Increment", 660), new PostfixExprOperator("!!", "Factorial2", 610), new InfixExprOperator("<=", "LessEqual", 290, 0), NON_COMMUTATIVE_MULTIPLY_OPERATOR, new PostfixExprOperator("!", "Factorial", 610), new InfixExprOperator("*", "Times", 400, 0), POWER_OPERATOR, new InfixExprOperator(".", "Dot", 490, 0), new PrefixExprOperator("!", "Not", 230), new PreMinusExprOperator("-", "PreMinus", 485), new InfixExprOperator("===", "SameQ", 290, 0), new InfixExprOperator(":>", "RuleDelayed", 120, 1), new InfixExprOperator(">=", "GreaterEqual", 290, 0), new InfixExprOperator("/;", "Condition", 130, 2), new InfixExprOperator("//", "//", 70, 2), new InfixExprOperator("/=", "DivideBy", 100, 1), new InfixExprOperator("||", "Or", 213, 0), new InfixExprOperator(";;", "Span", 305, 0), EQUAL_OPERATOR, new InfixExprOperator("<>", "StringJoin", 600, 0), new InfixExprOperator("!=", "Unequal", 290, 0), new PostfixExprOperator("--", "Decrement", 660), new InfixExprOperator("-=", "SubtractFrom", 100, 1), new PrePlusExprOperator("+", "PrePlus", 670), new PostfixExprOperator("...", "RepeatedNull", 170), new InfixExprOperator("=!=", "UnsameQ", 290, 0), new InfixExprOperator("->", "Rule", 120, 1), new InfixExprOperator("^:=", "UpSetDelayed", 40, 1), new PrefixExprOperator("++", "PreIncrement", 660), new InfixExprOperator("|->", "Function", 90, 1), new PostfixExprOperator("&", "Function", 90), new InfixExprOperator(">", "Greater", 290, 0), new PrefixExprOperator("--", "PreDecrement", 660), new SubtractExprOperator("-", "Subtract", 310, 2), new InfixExprOperator(":=", "SetDelayed", 40, 1), new InfixExprOperator("|", "Alternatives", 160, 0), new InfixExprOperator("+=", "AddTo", 100, 1), new PostfixExprOperator("..", "Repeated", 170), new InfixExprOperator("/.", "ReplaceAll", 110, 2), TAG_SET_OPERATOR, new InfixExprOperator("@*", "Composition", 625, 0), new InfixExprOperator("/*", "RightComposition", 648, 0), new InfixExprOperator("~~", "StringExpression", 135, 0), new PatternExprOperator(":", "Pattern", 150, 0), new InfixExprOperator("<->", "TwoWayRule", 125, 1), new InfixExprOperator("\uf120", "TwoWayRule", 125, 1), new InfixExprOperator("\uf3d5", "DirectedEdge", 120, 1), new InfixExprOperator("\uf3d4", "UndirectedEdge", 120, 1), new InfixExprOperator("\u00b7", "CenterDot", 410, 0), new InfixExprOperator("\u2299", "CircleDot", 520, 0), new InfixExprOperator("\u2297", "CircleTimes", 420, 0), new InfixExprOperator("\uf3d2", "Distributed", 250, 0), new InfixExprOperator("\u2208", "Element", 250, 0), new InfixExprOperator("\u22c2", "Intersection", 305, 0), new InfixExprOperator("\u2260", "Unequal", 290, 0), new InfixExprOperator("\u22c0", "Wedge", 440, 0), new InfixExprOperator("\uf3da", "TensorProduct", 495, 0), new InfixExprOperator("\u29e6", "Equivalent", 205, 0), new InfixExprOperator("\uf523", "Implies", 200, 1), new TildeExprOperator("~", "\u00a7TILDE\u00a7", 630, 0)};
            StringBuilder buf = new StringBuilder(".-:=<>*+;!^|&/@?~");
            fOperatorMap = ParserConfig.TRIE_STRING2OPERATOR_BUILDER.withMatch(TrieMatch.EXACT).build();
            fOperatorTokenStartSet = ParserConfig.TRIE_STRING2OPERATORLIST_BUILDER.withMatch(TrieMatch.EXACT).build();
            for (int i = 0; i < HEADER_STRINGS.length; ++i) {
                ExprParserFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, OPERATOR_STRINGS[i], HEADER_STRINGS[i], OPERATORS[i]);
                String unicodeChar = (String)Characters.NamedCharactersMap.get(HEADER_STRINGS[i]);
                if (unicodeChar == null) continue;
                ExprParserFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, unicodeChar, HEADER_STRINGS[i], OPERATORS[i]);
                buf.append(unicodeChar);
            }
            OPERATOR_MATCHER = CharMatcher.anyOf((CharSequence)buf.toString());
        }
    }

    private static class SubtractExprOperator
    extends InfixExprOperator {
        public SubtractExprOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTMutable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            if (rhs.isNumber()) {
                return (IASTMutable)F.Plus(lhs, rhs.negate());
            }
            if (rhs.isTimes() && rhs.first().isNumber()) {
                return (IASTMutable)F.Plus(lhs, (IExpr)((IAST)rhs).setAtCopy(1, rhs.first().negate()));
            }
            return (IASTMutable)F.Plus(lhs, (IExpr)F.Times((IExpr)F.CN1, rhs));
        }
    }

    private static class PrePlusExprOperator
    extends PrefixExprOperator {
        public PrePlusExprOperator(String oper, String functionName, int precedence) {
            super(oper, functionName, precedence);
        }

        @Override
        public IExpr createFunction(IParserFactory factory, IExpr argument) {
            return argument;
        }
    }

    private static class PreMinusExprOperator
    extends PrefixExprOperator {
        public PreMinusExprOperator(String oper, String functionName, int precedence) {
            super(oper, functionName, precedence);
        }

        @Override
        public IExpr createFunction(IParserFactory factory, IExpr argument) {
            return F.Times((IExpr)F.CN1, argument);
        }
    }

    private static class PatternExprOperator
    extends InfixExprOperator {
        public PatternExprOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTMutable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            if (lhs.isSymbol()) {
                PatternNested pn;
                IExpr subPattern;
                if (rhs instanceof PatternNested && (subPattern = (pn = (PatternNested)rhs).getPatternExpr()) instanceof PatternNested && pn.getSymbol() != null) {
                    return F.binaryAST2((IExpr)S.Optional, F.binaryAST2((IExpr)S.Pattern, lhs, (IExpr)pn.getSymbol()), subPattern);
                }
                return F.binaryAST2((IExpr)S.Pattern, lhs, rhs);
            }
            return F.binaryAST2((IExpr)S.Optional, lhs, rhs);
        }
    }

    private static class DivideExprOperator
    extends InfixExprOperator {
        public DivideExprOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTMutable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            if (rhs.isInteger() && !rhs.isZero()) {
                if (lhs.isInteger() && !parser.isHoldOrHoldFormOrDefer()) {
                    return (IASTMutable)F.Rational(lhs, rhs);
                }
                return F.Times((IExpr)F.fraction(F.C1, (IInteger)rhs), lhs);
            }
            if (lhs.equals(F.C1)) {
                return (IASTMutable)F.Power(rhs, F.CN1);
            }
            if (rhs.isPower() && rhs.exponent().isNumber()) {
                return F.Times(lhs, (IExpr)F.Power(rhs.base(), rhs.exponent().negate()));
            }
            return F.Times(lhs, (IExpr)F.Power(rhs, F.CN1));
        }
    }

    private static class TildeExprOperator
    extends InfixExprOperator {
        public TildeExprOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTAppendable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            IASTAppendable result = F.ast(F.NIL);
            result.append(lhs);
            result.append(rhs);
            return result;
        }

        @Override
        public IAST endFunction(IParserFactory factory, IAST function, Scanner scanner) {
            int size = function.size();
            if (size < 4 || (size & 1) != 0) {
                scanner.throwSyntaxError("Operator ~ requires even number of arguments");
            }
            IASTMutable result = F.binaryAST2(function.arg2(), function.arg1(), function.arg3());
            for (int i = 4; i < size; i += 2) {
                IASTMutable temp;
                result = temp = F.binaryAST2(function.get(i), result, function.get(i + 1));
            }
            return result;
        }
    }

    private static class TagSetOperator
    extends InfixExprOperator {
        public TagSetOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTMutable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            if (rhs.isAST()) {
                IAST r = (IAST)rhs;
                if (r.isAST(S.Set, 3)) {
                    return F.TagSet(lhs, r.arg1(), r.arg2());
                }
                if (r.isAST(S.SetDelayed, 3)) {
                    return F.TagSetDelayed(lhs, r.arg1(), r.arg2());
                }
            }
            return F.binaryAST2((IExpr)S.TagSet, lhs, rhs);
        }
    }

    private static class ApplyOperator
    extends InfixExprOperator {
        public ApplyOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public IASTMutable createFunction(IParserFactory factory, ExprParser parser, IExpr lhs, IExpr rhs) {
            if (this.fOperatorString.equals("@")) {
                return F.unaryAST1(lhs, rhs);
            }
            if (this.fOperatorString.equals("@@")) {
                return F.Apply(lhs, rhs);
            }
            return F.ApplyListC1(lhs, rhs);
        }
    }

    private static class InformationOperator
    extends PrefixExprOperator {
        public InformationOperator(String oper, String functionName, int precedence) {
            super(oper, functionName, precedence);
        }

        @Override
        public IExpr createFunction(IParserFactory factory, IExpr argument) {
            if (this.fOperatorString.equals("?")) {
                return F.Information(argument, F.Rule((IExpr)S.LongForm, (IExpr)S.False));
            }
            return F.Information(argument);
        }
    }
}

