/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.parser;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.PatternMatching;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumStr;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParserFactory;
import org.matheclipse.core.parser.InfixExprOperator;
import org.matheclipse.core.parser.PostfixExprOperator;
import org.matheclipse.core.parser.PrefixExprOperator;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.Scanner;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.operator.Operator;

public class ExprParser
extends Scanner {
    public static final ISymbol DERIVATIVE;
    private boolean fHoldExpression;
    private final boolean fRelaxedSyntax;
    private final EvalEngine fEngine;
    protected IParserFactory fFactory;

    public static int syntaxLength(String str, EvalEngine engine) throws SyntaxError {
        try {
            ExprParser parser = new ExprParser(engine);
            parser.parse(str);
        }
        catch (SyntaxError e) {
            return e.getStartOffset();
        }
        return str.length();
    }

    public static boolean test(String str, EvalEngine engine) {
        try {
            ExprParser fParser = new ExprParser(engine);
            IExpr parsedExpression = fParser.parse(str);
            if (parsedExpression != null) {
                return true;
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        return false;
    }

    public ExprParser(EvalEngine engine) {
        this(engine, ExprParserFactory.MMA_STYLE_FACTORY, engine.isRelaxedSyntax(), false, ParserConfig.EXPLICIT_TIMES_OPERATOR);
    }

    public ExprParser(EvalEngine engine, boolean relaxedSyntax) {
        this(engine, ExprParserFactory.MMA_STYLE_FACTORY, relaxedSyntax);
    }

    public ExprParser(EvalEngine engine, IParserFactory factory, boolean relaxedSyntax) {
        this(engine, factory, relaxedSyntax, false, ParserConfig.EXPLICIT_TIMES_OPERATOR);
    }

    public ExprParser(EvalEngine engine, IParserFactory factory, boolean relaxedSyntax, boolean packageMode, boolean explicitTimes) {
        super(packageMode, explicitTimes);
        this.fRelaxedSyntax = relaxedSyntax;
        this.fFactory = factory;
        this.fEngine = engine;
    }

    private IExpr convert(IASTMutable ast) {
        int headID = ast.headID();
        if (headID >= 166) {
            IExpr expr = F.NIL;
            switch (headID) {
                case 551: {
                    if (!ast.isAST1() || !ast.arg1().isString()) break;
                    return S.Get.of(ast.arg1());
                }
                case 639: {
                    if (!ast.isAST1() || !ast.arg1().isString()) break;
                    return S.Import.of(ast.arg1());
                }
                case 441: {
                    if (!ast.isAST1()) break;
                    return F.Power((IExpr)S.E, ast.getUnevaluated(1));
                }
                case 598: 
                case 603: {
                    return ast;
                }
                case 1218: {
                    if (!ast.isAST1()) break;
                    return F.Power(ast.getUnevaluated(1), F.C1D2);
                }
                case 1036: {
                    IAST arg1Power;
                    if (!ast.isPower() || !ast.base().isPower() || !ast.exponent().isMinusOne() || !(arg1Power = (IAST)ast.base()).exponent().isNumber()) break;
                    return F.Power(arg1Power.getUnevaluated(1), arg1Power.getUnevaluated(2).negate());
                }
                case 166: {
                    expr = PatternMatching.Blank.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 168: {
                    expr = PatternMatching.BlankSequence.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 167: {
                    expr = PatternMatching.BlankNullSequence.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 984: {
                    expr = PatternMatching.Pattern.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 955: {
                    expr = PatternMatching.Optional.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 1122: {
                    expr = PatternMatching.Repeated.CONST.evaluate(ast, this.fEngine);
                    break;
                }
                case 257: {
                    expr = Arithmetic.CONST_COMPLEX.evaluate(ast, this.fEngine);
                    break;
                }
                case 1096: {
                    expr = Arithmetic.CONST_RATIONAL.evaluate(ast, this.fEngine);
                }
            }
            return expr.orElse(ast);
        }
        return ast;
    }

    protected IExpr convertSymbolOnInput(String nodeStr, String context) {
        if (this.fRelaxedSyntax) {
            if (nodeStr.length() == 1) {
                if (nodeStr.equals("I")) {
                    return F.CI;
                }
                return F.symbol(nodeStr, context, null, this.fEngine);
            }
            String lowercaseStr = nodeStr.toLowerCase(Locale.ENGLISH);
            if (lowercaseStr.equals("infinity")) {
                return F.CInfinity;
            }
            if (lowercaseStr.equals("complexinfinity")) {
                return F.CComplexInfinity;
            }
            String temp = AST2Expr.PREDEFINED_ALIASES_MAP.get(lowercaseStr);
            if (temp != null) {
                return F.symbol(temp, context, null, this.fEngine);
            }
            return F.symbol(lowercaseStr, context, null, this.fEngine);
        }
        String lowercaseStr = nodeStr;
        if (Config.RUBI_CONVERT_SYMBOLS) {
            Integer num = AST2Expr.RUBI_STATISTICS_MAP.get(lowercaseStr);
            if (num == null) {
                AST2Expr.RUBI_STATISTICS_MAP.put(lowercaseStr, 1);
            } else {
                AST2Expr.RUBI_STATISTICS_MAP.put(lowercaseStr, num + 1);
            }
        }
        if (lowercaseStr.equals("I")) {
            return F.CI;
        }
        if (lowercaseStr.equals("Infinity")) {
            return F.CInfinity;
        }
        return F.symbol(lowercaseStr, context, null, this.fEngine);
    }

    private IExpr createInfixFunction(InfixExprOperator infixOperator, IExpr lhs, IExpr rhs) {
        IASTMutable temp = infixOperator.createFunction(this.fFactory, this, lhs, rhs);
        if (temp.isAST()) {
            return this.convert(temp);
        }
        return temp;
    }

    private InfixExprOperator determineBinaryOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof InfixExprOperator)) continue;
            return (InfixExprOperator)oper;
        }
        return null;
    }

    private PostfixExprOperator determinePostfixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PostfixExprOperator)) continue;
            return (PostfixExprOperator)oper;
        }
        return null;
    }

    private PrefixExprOperator determinePrefixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PrefixExprOperator)) continue;
            return (PrefixExprOperator)oper;
        }
        return null;
    }

    private void getArguments(IASTAppendable function) throws SyntaxError {
        block1: {
            do {
                function.append(this.parseExpression());
                if (this.fToken != 134) break block1;
                this.getNextToken();
            } while (this.fToken != 15 && this.fToken != 13);
            function.append(S.Null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpr getFactor(int min_precedence) throws SyntaxError {
        IExpr temp = null;
        switch (this.fToken) {
            case 137: {
                temp = this.getSymbol();
                if (temp.isSymbol()) {
                    ISymbol symbol = (ISymbol)temp;
                    if (this.fToken >= 142 && this.fToken <= 146) {
                        temp = this.getBlankPatterns(symbol);
                    }
                }
                return this.parseArguments(temp);
            }
            case 14: {
                ++this.fRecursionDepth;
                try {
                    this.getNextToken();
                    temp = this.parseExpression();
                    if (this.fToken != 15) {
                        this.throwSyntaxError("')' expected.");
                    }
                }
                finally {
                    --this.fRecursionDepth;
                }
                this.getNextToken();
                if (this.fToken == 14 && !this.fExplicitTimes) {
                    Operator oper = this.fFactory.get("Times");
                    if (ParserConfig.DOMINANT_IMPLICIT_TIMES || oper.getPrecedence() >= min_precedence) {
                        return this.getTimesImplicit(temp);
                    }
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(temp);
                }
                return temp;
            }
            case 16: {
                ++this.fRecursionDepth;
                try {
                    IExpr oper = this.parseArguments(this.getList());
                    return oper;
                }
                finally {
                    --this.fRecursionDepth;
                }
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                return this.getBlanks(temp);
            }
            case 138: {
                return this.getNumber(false);
            }
            case 136: {
                IStringX str = this.getString();
                return this.parseArguments(str);
            }
            case 135: {
                IASTAppendable out = F.ast(S.Out);
                int countPercent = 1;
                this.getNextToken();
                if (this.fToken == 138) {
                    countPercent = this.getJavaInt();
                    out.append(countPercent);
                    return out;
                }
                while (this.fToken == 135) {
                    ++countPercent;
                    this.getNextToken();
                }
                out.append(-countPercent);
                return this.parseArguments(out);
            }
            case 140: {
                this.getNextToken();
                if (this.fToken == 138) {
                    int slotNumber = this.getJavaInt();
                    if (slotNumber == 1) {
                        return this.parseArguments(F.Slot1);
                    }
                    if (slotNumber == 2) {
                        return this.parseArguments(F.Slot2);
                    }
                    IASTAppendable slot = F.ast(S.Slot);
                    slot.append(slotNumber);
                    return this.parseArguments(slot);
                }
                if (this.fToken == 137) {
                    String[] identifierContext = this.getIdentifier();
                    IASTAppendable slot = F.ast(S.Slot);
                    slot.append(identifierContext[0]);
                    this.getNextToken();
                    return this.parseArguments(slot);
                }
                if (this.fToken == 136) {
                    IASTAppendable slot = F.ast(S.Slot);
                    slot.append(this.getString());
                    return this.parseArguments(slot);
                }
                return this.parseArguments(F.Slot1);
            }
            case 141: {
                this.getNextToken();
                IASTAppendable slotSequencce = F.ast(S.SlotSequence);
                if (this.fToken == 138) {
                    slotSequencce.append(this.getNumber(false));
                } else {
                    slotSequencce.append(F.C1);
                }
                return this.parseArguments(slotSequencce);
            }
            case 10: {
                IASTAppendable function = F.ListAlloc(31);
                ++this.fRecursionDepth;
                try {
                    IExpr iExpr;
                    this.getNextToken();
                    if (this.fToken != 11) {
                        while (true) {
                            function.append(this.parseExpression());
                            if (this.fToken != 134) break;
                            this.getNextToken();
                        }
                        if (this.fToken != 11) {
                            this.throwSyntaxError("'|>' expected.");
                        }
                    }
                    function.set(0, S.Association);
                    temp = function;
                    this.getNextToken();
                    if (this.fToken == 14 && !this.fExplicitTimes) {
                        Operator oper = this.fFactory.get("Times");
                        if (ParserConfig.DOMINANT_IMPLICIT_TIMES || oper.getPrecedence() >= min_precedence) {
                            IExpr iExpr2 = this.getTimesImplicit(temp);
                            return iExpr2;
                        }
                    }
                    if (this.fToken == 12) {
                        iExpr = this.getFunctionArguments(temp);
                        return iExpr;
                    }
                    iExpr = temp;
                    return iExpr;
                }
                finally {
                    --this.fRecursionDepth;
                }
            }
            case 15: {
                this.throwSyntaxError("Too much closing ) in factor.");
                break;
            }
            case 17: {
                this.throwSyntaxError("Too much closing } in factor.");
                break;
            }
            case 13: {
                this.throwSyntaxError("Too much closing ] in factor.");
                break;
            }
            case 11: {
                this.throwSyntaxError("Too much closing |> in factor.");
            }
        }
        this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (Token:" + this.fToken + " \\u" + Integer.toHexString(this.fCurrentChar | 0x10000).substring(1) + ")");
        return null;
    }

    private IExpr getBlanks(IExpr temp) {
        IExpr defaultValue;
        switch (this.fToken) {
            case 142: {
                IExpr check;
                if (this.isWhitespace()) {
                    this.getNextToken();
                    temp = F.$b();
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$b(check);
                    break;
                }
                temp = F.$b();
                break;
            }
            case 143: {
                IExpr check;
                if (this.isWhitespace()) {
                    this.getNextToken();
                    temp = F.$ps(null, null);
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$ps(null, check);
                    break;
                }
                temp = F.$ps(null, null);
                break;
            }
            case 144: {
                IExpr check;
                if (this.isWhitespace()) {
                    this.getNextToken();
                    temp = F.$ps(null, null, false, true);
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$ps(null, check, false, true);
                    break;
                }
                temp = F.$ps(null, null, false, true);
                break;
            }
            case 145: {
                IExpr check;
                if (this.isWhitespace()) {
                    this.getNextToken();
                    temp = F.$b(null, true);
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$b(check, true);
                    break;
                }
                temp = F.$b(null, true);
                break;
            }
            case 146: {
                this.getNextToken();
                defaultValue = this.parseExpression();
                temp = F.Optional(F.$b(), defaultValue);
            }
        }
        if (this.fToken == 31 && this.fOperatorString.equals(":")) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            temp = F.Optional(temp, defaultValue);
        }
        return this.parseArguments(temp);
    }

    private IExpr getBlankPatterns(IExpr head) {
        IExpr defaultValue;
        IExpr temp = head;
        ISymbol symbol = (ISymbol)head;
        switch (this.fToken) {
            case 142: {
                IExpr check;
                if (this.isWhitespace()) {
                    temp = F.$p(symbol, null);
                    this.getNextToken();
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$p(symbol, check);
                    break;
                }
                temp = F.$p(symbol, null);
                break;
            }
            case 143: {
                IExpr check;
                if (this.isWhitespace()) {
                    temp = F.$ps(symbol, null);
                    this.getNextToken();
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$ps(symbol, check);
                    break;
                }
                temp = F.$ps(symbol, null);
                break;
            }
            case 144: {
                IExpr check;
                if (this.isWhitespace()) {
                    temp = F.$ps(symbol, null, false, true);
                    this.getNextToken();
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$ps(symbol, check, false, true);
                    break;
                }
                temp = F.$ps(symbol, null, false, true);
                break;
            }
            case 145: {
                IExpr check;
                if (this.isWhitespace()) {
                    temp = F.$p(symbol, null, true);
                    this.getNextToken();
                    break;
                }
                this.getNextToken();
                if (this.fToken == 137) {
                    check = this.getSymbol();
                    temp = F.$p(symbol, check, true);
                    break;
                }
                temp = F.$p(symbol, null, true);
                break;
            }
            case 146: {
                this.getNextToken();
                defaultValue = this.parseExpression();
                temp = F.Optional(F.$p(symbol), defaultValue);
            }
        }
        if (this.fToken == 31 && this.fOperatorString.equals(":")) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            temp = F.Optional(temp, defaultValue);
        }
        return temp;
    }

    public IParserFactory getFactory() {
        return this.fFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IASTMutable getFunction(IExpr head) throws SyntaxError {
        this.getNextToken();
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return F.headAST0(head);
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(F.headAST0(head));
                }
                return F.headAST0(head);
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(F.headAST0(head));
            }
            return F.headAST0(head);
        }
        int size = ExprParser.determineSize(head, 10);
        IASTAppendable function = F.ast(head, size);
        ++this.fRecursionDepth;
        try {
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    ExprParser.reduceAST(function);
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(ExprParser.reduceAST(function));
                }
                return ExprParser.reduceAST(function);
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(ExprParser.reduceAST(function));
            }
            return ExprParser.reduceAST(function);
        }
        this.throwSyntaxError(this.fRelaxedSyntax ? "')' expected." : "']' expected.");
        return null;
    }

    private static int determineSize(IExpr head, int defaultSize) {
        int[] args;
        IEvaluator eval;
        if (head.isBuiltInSymbol() && (eval = ((IBuiltInSymbol)head).getEvaluator()) instanceof IFunctionEvaluator && (args = ((IFunctionEvaluator)eval).expectedArgSize(F.NIL)) != null && args[1] < 10) {
            defaultSize = args[1] + 1;
        }
        return defaultSize;
    }

    private static IASTMutable reduceAST(IASTMutable function) {
        int size = function.size();
        switch (size) {
            case 1: {
                return F.headAST0(function.head());
            }
            case 2: {
                return F.unaryAST1(function.head(), function.arg1());
            }
            case 3: {
                return F.binaryAST2(function.head(), function.arg1(), function.arg2());
            }
            case 4: {
                return F.ternaryAST3(function.head(), function.arg1(), function.arg2(), function.arg3());
            }
        }
        return function;
    }

    IASTMutable getFunctionArguments(IExpr head) throws SyntaxError {
        ++this.fRecursionDepth;
        this.getNextToken();
        if (this.fToken == 13) {
            --this.fRecursionDepth;
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(F.headAST0(head));
            }
            return F.headAST0(head);
        }
        IASTAppendable function = F.ast(head);
        this.getArguments(function);
        --this.fRecursionDepth;
        if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(ExprParser.reduceAST(function));
            }
            return ExprParser.reduceAST(function);
        }
        this.throwSyntaxError("']' expected.");
        return null;
    }

    private IExpr getList() throws SyntaxError {
        ++this.fRecursionDepth;
        IASTAppendable function = null;
        try {
            this.getNextToken();
            if (this.fToken == 17) {
                this.getNextToken();
                IAST iAST = F.CEmptyList;
                return iAST;
            }
            function = F.ListAlloc(31);
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        this.throwSyntaxError("'}' expected.");
        return null;
    }

    private IExpr getNumber(boolean negative) throws SyntaxError {
        IExpr temp;
        block18: {
            temp = null;
            Object[] result = this.getNumberString();
            Object numberStr = (String)result[0];
            int numFormat = (Integer)result[1];
            String exponentStr = (String)result[2];
            try {
                if (negative) {
                    numberStr = "-" + (String)numberStr;
                }
                if (numFormat == 10 && this.fCurrentChar == '`') {
                    numFormat = -1;
                }
                if (numFormat < 0) {
                    if (this.fCurrentChar == '`' && this.isValidPosition()) {
                        ++this.fCurrentPosition;
                        if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '*') {
                            ++this.fCurrentPosition;
                            if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '^') {
                                this.fCurrentPosition += 2;
                                long exponent = this.getJavaLong();
                                Double d = Double.valueOf((String)numberStr + "E" + exponent);
                                return F.num(d);
                            }
                        } else {
                            if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '`') {
                                this.fCurrentPosition += 2;
                                long precision = this.getJavaLong();
                                if (precision < 16L) {
                                    precision = 16L;
                                }
                                return F.num((String)numberStr, precision);
                            }
                            if (this.isValidPosition() && Character.isDigit(this.fInputString[this.fCurrentPosition])) {
                                ++this.fCurrentPosition;
                                long precision = this.getJavaLong();
                                if (precision < 16L) {
                                    precision = 16L;
                                }
                                return F.num((String)numberStr, precision);
                            }
                            this.getNextToken();
                            return F.num((String)numberStr);
                        }
                        this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
                    }
                    temp = new NumStr((String)numberStr);
                    break block18;
                }
                if (exponentStr == null || exponentStr.equals("1")) {
                    temp = F.ZZ((String)numberStr, numFormat);
                    break block18;
                }
                if (numFormat == 10) {
                    try {
                        int exponent = Integer.parseInt(exponentStr, numFormat);
                        if (exponent < 0) {
                            exponent = -exponent;
                            StringBuilder buf = ExprParser.createPowersOf10((int)exponent);
                            temp = F.Times((IExpr)F.ZZ((String)numberStr, numFormat), (IExpr)F.Power((IExpr)F.ZZ(buf.toString(), numFormat), F.CN1));
                            break block18;
                        }
                        StringBuilder buf = ExprParser.createPowersOf10((int)exponent);
                        temp = F.Times((IExpr)F.ZZ((String)numberStr, numFormat), (IExpr)F.ZZ(buf.toString(), numFormat));
                    }
                    catch (NumberFormatException e) {
                        this.throwSyntaxError("Number format error (not an int type): " + exponentStr, exponentStr.length());
                    }
                    break block18;
                }
                this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
            }
            catch (RuntimeException rex) {
                this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
            }
        }
        this.getNextToken();
        return temp;
    }

    protected boolean isOperatorCharacters() {
        return this.fFactory.isOperatorChar(this.fCurrentChar);
    }

    protected boolean isOperatorCharacters(char ch) {
        return this.fFactory.isOperatorChar(ch);
    }

    protected final List<Operator> getOperator() {
        char lastChar = this.fCurrentChar;
        int startPosition = this.fCurrentPosition - 1;
        this.fOperatorString = new String(this.fInputString, startPosition, this.fCurrentPosition - startPosition);
        List list = this.fFactory.getOperatorList(this.fOperatorString);
        List lastList = null;
        int lastOperatorPosition = -1;
        if (list != null) {
            lastList = list;
            lastOperatorPosition = this.fCurrentPosition;
        }
        this.getChar();
        while (!(!this.fFactory.isOperatorChar(this.fCurrentChar) || this.fCurrentChar == '.' && this.isValidPosition() && Character.isDigit(this.charAtPosition()))) {
            lastChar = this.fCurrentChar;
            this.fOperatorString = new String(this.fInputString, startPosition, this.fCurrentPosition - startPosition);
            list = this.fFactory.getOperatorList(this.fOperatorString);
            if (list != null) {
                lastList = list;
                lastOperatorPosition = this.fCurrentPosition;
            }
            this.getChar();
            if (lastChar != ';' || this.fCurrentChar == ';') continue;
        }
        if (lastOperatorPosition > 0) {
            this.fCurrentPosition = lastOperatorPosition;
            return lastList;
        }
        int endPosition = this.fCurrentPosition--;
        this.fCurrentPosition = startPosition;
        this.throwSyntaxError("Operator token not found: " + new String(this.fInputString, startPosition, endPosition - 1 - startPosition));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpr getPart(int min_precedence) throws SyntaxError {
        IASTAppendable function = null;
        IExpr temp = this.getFactor(min_precedence);
        if (this.fToken != 18) {
            return temp;
        }
        do {
            function = function == null ? F.Part(2, temp) : F.Part(2, function);
            ++this.fRecursionDepth;
            try {
                do {
                    this.getNextToken();
                    if (this.fToken == 13) {
                        this.skipWhitespace();
                        if (this.fInputString.length > this.fCurrentPosition && this.fInputString[this.fCurrentPosition] == ']') {
                            ++this.fCurrentPosition;
                            this.getNextToken();
                            IASTAppendable iASTAppendable = function;
                            return iASTAppendable;
                        }
                    }
                    temp = this.parseExpression();
                    function.append(temp);
                } while (this.fToken == 134);
                if (this.fToken == 13) {
                    this.skipWhitespace();
                    if (this.fInputString.length > this.fCurrentPosition && this.fInputString[this.fCurrentPosition] == ']') {
                        ++this.fCurrentPosition;
                        this.fToken = 19;
                    }
                }
                if (this.fToken != 19) {
                    this.throwSyntaxError("']]' expected.");
                }
            }
            finally {
                --this.fRecursionDepth;
            }
            this.getNextToken();
        } while (this.fToken == 18);
        return this.parseArguments(function);
    }

    private IStringX getString() throws SyntaxError {
        StringBuilder ident = this.getStringBuilder();
        this.getNextToken();
        return F.stringx(ident);
    }

    private IExpr getSymbol() throws SyntaxError {
        String[] identifierContext = this.getIdentifier();
        if (!this.fFactory.isValidIdentifier(identifierContext[0])) {
            this.throwSyntaxError("Invalid identifier: " + identifierContext[0] + " detected.");
        }
        IExpr symbol = this.convertSymbolOnInput(identifierContext[0], identifierContext[1]);
        this.getNextToken();
        return symbol;
    }

    private IExpr getTimesImplicit(IExpr temp) throws SyntaxError {
        IASTAppendable func = F.TimesAlloc(8);
        func.append(temp);
        do {
            this.getNextToken();
            temp = this.parseExpression();
            func.append(temp);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
        } while (this.fToken == 14);
        func.addEvalFlags(0x200000);
        return func;
    }

    public boolean isHoldOrHoldFormOrDefer() {
        return this.fHoldExpression;
    }

    public IExpr parse(String expression) throws SyntaxError {
        long precision;
        this.initialize(expression);
        if (this.fToken == 0) {
            return F.Null;
        }
        IExpr temp = this.parseExpression();
        if (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            this.throwSyntaxError("End-of-file not reached.");
        }
        if ((precision = temp.determinePrecision()) > this.fEngine.getNumericPrecision()) {
            this.fEngine.setNumericPrecision(precision);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpr parseArguments(IExpr head) {
        boolean localHoldExpression = this.fHoldExpression;
        try {
            if (head.isHoldOrHoldFormOrDefer()) {
                this.fHoldExpression = true;
            }
            if (this.fRelaxedSyntax) {
                if (this.fToken == 12) {
                    IASTMutable ast = this.getFunctionArguments(head);
                    IExpr iExpr = this.convert(ast);
                    return iExpr;
                }
                if (this.fToken == 14) {
                    IASTMutable ast = this.getFunction(head);
                    IExpr iExpr = this.convert(ast);
                    return iExpr;
                }
            } else if (this.fToken == 12) {
                IASTMutable ast = this.getFunctionArguments(head);
                IExpr iExpr = this.convert(ast);
                return iExpr;
            }
            IExpr iExpr = head;
            return iExpr;
        }
        finally {
            this.fHoldExpression = localHoldExpression;
        }
    }

    private IExpr parseCompoundExpressionNull(InfixExprOperator infixOperator, IExpr lhs) {
        if (infixOperator.isOperator(";") && (this.fToken == 0 || this.fToken == 13 || this.fToken == 17 || this.fToken == 15 || this.fToken == 134)) {
            return this.createInfixFunction(infixOperator, lhs, S.Null);
        }
        return null;
    }

    protected IExpr parseExpression() {
        if (this.fToken == 30) {
            IASTAppendable span = F.ast(S.Span);
            span.append(F.C1);
            this.getNextToken();
            if (this.fToken == 30) {
                span.append(S.All);
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
            } else {
                InfixExprOperator infixOperator;
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    span.append(S.All);
                    return span;
                }
                if (this.fToken == 31 && (infixOperator = this.determineBinaryOperator()) != null && infixOperator.getOperatorString().equals(";")) {
                    span.append(S.All);
                    this.getNextToken();
                    IExpr compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, span);
                    if (compoundExpressionNull != null) {
                        return compoundExpressionNull;
                    }
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    return this.parseInfixOperator(span, infixOperator);
                }
            }
            span.append(this.parseExpression());
            return span;
        }
        IExpr temp = this.parseExpression(this.parsePrimary(0), 0);
        if (this.fToken == 30) {
            IASTAppendable span = F.ast(S.Span);
            span.append(temp);
            this.getNextToken();
            if (this.fToken == 30) {
                span.append(S.All);
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
                if (this.fToken == 31) {
                    return this.parseExpression(F.Times((IExpr)span, (IExpr)F.Span(F.C1, S.All)), 0);
                }
            } else {
                InfixExprOperator infixOperator;
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    span.append(S.All);
                    return span;
                }
                if (this.fToken == 31 && (infixOperator = this.determineBinaryOperator()) != null && infixOperator.getOperatorString().equals(";")) {
                    span.append(S.All);
                    this.getNextToken();
                    IExpr compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, span);
                    if (compoundExpressionNull != null) {
                        return compoundExpressionNull;
                    }
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    return this.parseInfixOperator(span, infixOperator);
                }
            }
            if (this.fToken == 150 || this.fToken == 0) {
                span.append(S.All);
                this.getNextToken();
            } else {
                span.append(this.parseExpression(this.parsePrimary(0), 0));
            }
            if (this.fToken == 30) {
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
                span.append(this.parseExpression(this.parsePrimary(0), 0));
            }
            return span;
        }
        return temp;
    }

    private IExpr parseExpression(IExpr lhs, int min_precedence) {
        IExpr rhs = null;
        while (true) {
            if (this.fToken == 150) {
                return lhs;
            }
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 10 || this.fToken == 137 || this.fToken == 136 || this.fToken == 138 || this.fToken == 140 || this.fToken == 141) {
                if (this.fExplicitTimes) break;
                Operator oper = this.fFactory.get("Times");
                if (!ParserConfig.DOMINANT_IMPLICIT_TIMES && oper.getPrecedence() < min_precedence) break;
                rhs = this.parseLookaheadOperator(oper.getPrecedence());
                lhs = F.$(S.Times, lhs, rhs);
                ((IAST)lhs).addEvalFlags(0x200000);
                continue;
            }
            if (this.fToken == 147) {
                lhs = this.parseDerivative(lhs);
            }
            if (this.fToken != 31) break;
            InfixExprOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() < min_precedence) break;
                this.getNextToken();
                IExpr compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, lhs);
                if (compoundExpressionNull != null) {
                    return compoundExpressionNull;
                }
                while (this.fToken == 150) {
                    this.getNextToken();
                }
                lhs = this.parseInfixOperator(lhs, infixOperator);
                continue;
            }
            PostfixExprOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() < min_precedence) break;
            lhs = this.parsePostfixOperator(lhs, postfixOperator);
        }
        return lhs;
    }

    private final IExpr parseInfixOperator(IExpr lhs, InfixExprOperator infixOperator) {
        IExpr rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
        if ((lhs = this.createInfixFunction(infixOperator, lhs, rhs)) instanceof IASTAppendable) {
            IASTAppendable ast = (IASTAppendable)lhs;
            int headID = ast.headID();
            if (headID >= 423 && headID <= 1381 && (headID == 423 || headID == 571 || headID == 572 || headID == 753 || headID == 754 || headID == 1381)) {
                while (this.fToken == 31 && infixOperator.getGrouping() == 0 && ExprParser.isComparatorOperator((String)this.fOperatorString)) {
                    if (!infixOperator.isOperator(this.fOperatorString)) {
                        return this.parseInequality(ast, infixOperator);
                    }
                    this.getNextToken();
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                    ast.append(rhs);
                }
                return ast;
            }
            while (this.fToken == 31 && infixOperator.getGrouping() == 0 && infixOperator.isOperator(this.fOperatorString)) {
                this.getNextToken();
                if (infixOperator.isOperator(";") && (this.fToken == 0 || this.fToken == 13 || this.fToken == 17 || this.fToken == 15 || this.fToken == 134)) {
                    ast.append(S.Null);
                    break;
                }
                while (this.fToken == 150) {
                    this.getNextToken();
                }
                rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                ast.append(rhs);
            }
            return infixOperator.endFunction(this.fFactory, ast, this);
        }
        if (this.fToken == 31 && infixOperator.getGrouping() == 0 && infixOperator.isOperator(this.fOperatorString)) {
            this.throwSyntaxError("Operator: '" + this.fOperatorString + "' not created properly (no grouping defined)");
        }
        return lhs;
    }

    private IExpr parseInequality(IAST ast, InfixExprOperator infixOperator) {
        IBuiltInSymbol head = (IBuiltInSymbol)ast.head();
        IASTAppendable result = F.ast((IExpr)S.Inequality, ast.size() + 8);
        ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
            result.append((IExpr)x);
            result.append(head);
        }));
        InfixExprOperator compareOperator = this.determineBinaryOperator();
        result.set(result.size() - 1, F.$s(compareOperator.getFunctionName()));
        this.getNextToken();
        while (this.fToken == 150) {
            this.getNextToken();
        }
        int precedence = infixOperator.getPrecedence();
        result.append(this.parseLookaheadOperator(precedence));
        while (this.fToken == 31 && ExprParser.isComparatorOperator((String)this.fOperatorString)) {
            compareOperator = this.determineBinaryOperator();
            result.append(F.$s(compareOperator.getFunctionName()));
            this.getNextToken();
            while (this.fToken == 150) {
                this.getNextToken();
            }
            result.append(this.parseLookaheadOperator(precedence));
        }
        return result;
    }

    private final IExpr parsePostfixOperator(IExpr lhs, PostfixExprOperator postfixOperator) {
        this.getNextToken();
        lhs = this.convert(postfixOperator.createFunction(this.fFactory, lhs));
        lhs = this.parseArguments(lhs);
        if (this.fToken == 12) {
            return this.getFunctionArguments(lhs);
        }
        return lhs;
    }

    private IExpr parseLookaheadOperator(int min_precedence) {
        IExpr rhs = this.parsePrimary(min_precedence);
        while (true) {
            int lookahead = this.fToken;
            if (this.fToken == 150) break;
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 10 || this.fToken == 137 || this.fToken == 136 || this.fToken == 138 || this.fToken == 140) {
                if (this.fExplicitTimes) break;
                InfixExprOperator timesOperator = (InfixExprOperator)this.fFactory.get("Times");
                if (ParserConfig.DOMINANT_IMPLICIT_TIMES || timesOperator.getPrecedence() > min_precedence) {
                    rhs = this.parseExpression(rhs, timesOperator.getPrecedence());
                    continue;
                }
                if (timesOperator.getPrecedence() != min_precedence || timesOperator.getGrouping() != 1) break;
                rhs = this.parseExpression(rhs, timesOperator.getPrecedence());
                continue;
            }
            if (this.fToken == 147) {
                rhs = this.parseDerivative(rhs);
            }
            if (lookahead != 31) break;
            InfixExprOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() <= min_precedence && (!this.fOperatorString.equals(":") || !rhs.isSymbol()) && (infixOperator.getPrecedence() != min_precedence || infixOperator.getGrouping() != 1)) break;
                rhs = this.parseExpression(rhs, infixOperator.getPrecedence());
                continue;
            }
            PostfixExprOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() < min_precedence) break;
            this.getNextToken();
            rhs = this.convert(postfixOperator.createFunction(this.fFactory, rhs));
        }
        if (this.fToken == 12) {
            rhs = this.parseArguments(rhs);
        }
        return rhs;
    }

    private IExpr parseDerivative(IExpr expr) {
        int derivativeCounter = 1;
        this.getNextToken();
        while (this.fToken == 147) {
            ++derivativeCounter;
            this.getNextToken();
        }
        IASTMutable deriv = F.$(DERIVATIVE, F.ZZ(derivativeCounter));
        expr = F.$(deriv, expr);
        expr = this.parseArguments(expr);
        return expr;
    }

    public void parsePackage(String expression) throws SyntaxError {
        this.initialize(expression);
        while (this.fToken == 150) {
            this.getNextToken();
        }
        IExpr temp = this.parseExpression();
        this.fEngine.evaluate(temp);
        while (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            while (this.fToken == 150) {
                this.getNextToken();
            }
            if (this.fToken == 0) {
                return;
            }
            temp = this.parseExpression();
            this.fEngine.evaluate(temp);
        }
    }

    private IExpr parsePrimary(int min_precedence) {
        if (this.fToken == 31) {
            if (this.fOperatorString.equals(".")) {
                this.fCurrentChar = (char)46;
                return this.getNumber(false);
            }
            PrefixExprOperator prefixOperator = this.determinePrefixOperator();
            if (prefixOperator != null) {
                return this.parsePrefixOperator(prefixOperator);
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no prefix operator.");
        }
        return this.getPart(min_precedence);
    }

    private final IExpr parsePrefixOperator(PrefixExprOperator prefixOperator) {
        this.getNextToken();
        IExpr temp = this.parseLookaheadOperator(prefixOperator.getPrecedence());
        if (prefixOperator.getFunctionName().equals("PreMinus") && temp.isNumber()) {
            return temp.negate();
        }
        return prefixOperator.createFunction(this.fFactory, temp);
    }

    public void setFactory(IParserFactory factory) {
        this.fFactory = factory;
    }

    static {
        F.initSymbols();
        DERIVATIVE = F.Derivative;
    }
}

